/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl.http.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.HttpContentDecompressor;
import org.opensearch.security.filter.NettyAttribute;
import org.opensearch.security.http.SecurityHttpServerTransport;

@ChannelHandler.Sharable
public class Netty4ConditionalDecompressor
extends HttpContentDecompressor {
    protected EmbeddedChannel newContentDecoder(String contentEncoding) throws Exception {
        boolean hasAnEarlyReponse = NettyAttribute.peekFrom(this.ctx, SecurityHttpServerTransport.EARLY_RESPONSE).isPresent();
        boolean shouldDecompress = NettyAttribute.popFrom(this.ctx, SecurityHttpServerTransport.SHOULD_DECOMPRESS).orElse(false);
        if (hasAnEarlyReponse || !shouldDecompress) {
            return super.newContentDecoder("identity");
        }
        return super.newContentDecoder(contentEncoding);
    }
}

