/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StringUtils {
    public static final Gson gson = new Gson();

    public static boolean isJson(String Json) {
        try {
            new JSONObject(Json);
        }
        catch (JSONException ex) {
            try {
                new JSONArray(Json);
            }
            catch (JSONException ex1) {
                return false;
            }
        }
        return true;
    }

    public static String toUTF8(String rawString) {
        ByteBuffer buffer = StandardCharsets.UTF_8.encode(rawString);
        String utf8EncodedString = StandardCharsets.UTF_8.decode(buffer).toString();
        return utf8EncodedString;
    }

    public static Map<String, Object> fromJson(String jsonStr, String defaultKey) {
        HashMap<String, List> result;
        JsonElement jsonElement = JsonParser.parseString((String)jsonStr);
        if (jsonElement.isJsonObject()) {
            result = (HashMap<String, List>)gson.fromJson(jsonElement, Map.class);
        } else if (jsonElement.isJsonArray()) {
            List list = (List)gson.fromJson(jsonElement, List.class);
            result = new HashMap<String, List>();
            result.put(defaultKey, list);
        } else {
            throw new IllegalArgumentException("Unsupported response type");
        }
        return result;
    }

    public static Map<String, String> getParameterMap(Map<String, ?> parameterObjs) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String key : parameterObjs.keySet()) {
            Object value = parameterObjs.get(key);
            try {
                AccessController.doPrivileged(() -> {
                    if (value instanceof String) {
                        parameters.put(key, (String)value);
                    } else {
                        parameters.put(key, gson.toJson(value));
                    }
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e);
            }
        }
        return parameters;
    }
}

