/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.ImpactsSource;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.ImpactsDISI;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.BytesRef;

public final class BoundedLinearFeatureQuery
extends Query {
    private final String fieldName;
    private final String featureName;
    private final Float scoreUpperBound;
    static final int MAX_FREQ = Float.floatToIntBits(Float.MAX_VALUE) >>> 15;

    public BoundedLinearFeatureQuery(String fieldName, String featureName, Float scoreUpperBound) {
        this.fieldName = Objects.requireNonNull(fieldName);
        this.featureName = Objects.requireNonNull(featureName);
        this.scoreUpperBound = Objects.requireNonNull(scoreUpperBound);
    }

    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        return super.rewrite(indexSearcher);
    }

    public boolean equals(Object obj) {
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        BoundedLinearFeatureQuery that = (BoundedLinearFeatureQuery)((Object)obj);
        return Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.featureName, that.featureName) && Objects.equals(this.scoreUpperBound, that.scoreUpperBound);
    }

    public int hashCode() {
        int h = ((Object)((Object)this)).getClass().hashCode();
        h = 31 * h + this.fieldName.hashCode();
        h = 31 * h + this.featureName.hashCode();
        h = 31 * h + this.scoreUpperBound.hashCode();
        return h;
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, final float boost) throws IOException {
        if (!scoreMode.needsScores()) {
            TermQuery tq = new TermQuery(new Term(this.fieldName, this.featureName));
            return searcher.rewrite((Query)tq).createWeight(searcher, scoreMode, boost);
        }
        return new Weight(this){

            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }

            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                String desc = "weight(" + this.getQuery() + " in " + doc + ") [\" BoundedLinearFeatureQuery \"]";
                Terms terms = context.reader().terms(BoundedLinearFeatureQuery.this.fieldName);
                if (terms == null) {
                    return Explanation.noMatch((String)(desc + ". Field " + BoundedLinearFeatureQuery.this.fieldName + " doesn't exist."), (Explanation[])new Explanation[0]);
                }
                TermsEnum termsEnum = terms.iterator();
                if (!termsEnum.seekExact(new BytesRef((CharSequence)BoundedLinearFeatureQuery.this.featureName))) {
                    return Explanation.noMatch((String)(desc + ". Feature " + BoundedLinearFeatureQuery.this.featureName + " doesn't exist."), (Explanation[])new Explanation[0]);
                }
                PostingsEnum postings = termsEnum.postings(null, 8);
                if (postings.advance(doc) != doc) {
                    return Explanation.noMatch((String)(desc + ". Feature " + BoundedLinearFeatureQuery.this.featureName + " isn't set."), (Explanation[])new Explanation[0]);
                }
                int freq = postings.freq();
                float featureValue = BoundedLinearFeatureQuery.this.decodeFeatureValue(freq);
                float score = boost * featureValue;
                return Explanation.match((Number)Float.valueOf(score), (String)("Linear function on the " + BoundedLinearFeatureQuery.this.fieldName + " field for the " + BoundedLinearFeatureQuery.this.featureName + " feature, computed as w * S from:"), (Explanation[])new Explanation[]{Explanation.match((Number)Float.valueOf(boost), (String)"w, weight of this function", (Explanation[])new Explanation[0]), Explanation.match((Number)Float.valueOf(featureValue), (String)"S, feature value", (Explanation[])new Explanation[0])});
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                Terms terms = Terms.getTerms((LeafReader)context.reader(), (String)BoundedLinearFeatureQuery.this.fieldName);
                TermsEnum termsEnum = terms.iterator();
                if (!termsEnum.seekExact(new BytesRef((CharSequence)BoundedLinearFeatureQuery.this.featureName))) {
                    return null;
                }
                final Similarity.SimScorer scorer = new Similarity.SimScorer(){

                    public float score(float freq, long norm) {
                        return boost * BoundedLinearFeatureQuery.this.decodeFeatureValue(freq);
                    }
                };
                final ImpactsEnum impacts = termsEnum.impacts(8);
                final ImpactsDISI impactsDisi = new ImpactsDISI((DocIdSetIterator)impacts, (ImpactsSource)impacts, scorer);
                return new Scorer(this){

                    public int docID() {
                        return impacts.docID();
                    }

                    public float score() throws IOException {
                        return scorer.score((float)impacts.freq(), 1L);
                    }

                    public DocIdSetIterator iterator() {
                        return impactsDisi;
                    }

                    public int advanceShallow(int target) throws IOException {
                        return impactsDisi.advanceShallow(target);
                    }

                    public float getMaxScore(int upTo) throws IOException {
                        return impactsDisi.getMaxScore(upTo);
                    }

                    public void setMinCompetitiveScore(float minScore) {
                        impactsDisi.setMinCompetitiveScore(minScore);
                    }
                };
            }
        };
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.fieldName)) {
            visitor.visitLeaf((Query)this);
        }
    }

    public String toString(String field) {
        return "BoundedLinearFeatureQuery(field=" + this.fieldName + ", feature=" + this.featureName + ", scoreUpperBound=" + this.scoreUpperBound + ")";
    }

    private float decodeFeatureValue(float freq) {
        if (freq > (float)MAX_FREQ) {
            return this.scoreUpperBound.floatValue();
        }
        int tf = (int)freq;
        int featureBits = tf << 15;
        return Math.min(Float.intBitsToFloat(featureBits), this.scoreUpperBound.floatValue());
    }
}

