/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.controlcenter.notification.filter.parser;

import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.admin.indices.open.OpenIndexRequest;
import org.opensearch.action.admin.indices.open.OpenIndexResponse;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.action.support.ActiveShardsObserver;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.indexmanagement.controlcenter.notification.filter.NotificationActionListener;
import org.opensearch.indexmanagement.controlcenter.notification.filter.OperationResult;
import org.opensearch.indexmanagement.controlcenter.notification.filter.parser.ActionRespParseResult;
import org.opensearch.indexmanagement.controlcenter.notification.filter.parser.ResponseParser;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ$\u0010\u0018\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u00022\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 H\u0016J*\u0010!\u001a\u00020\"2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00022\b\u0010#\u001a\u0004\u0018\u00010\u001b2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/opensearch/indexmanagement/controlcenter/notification/filter/parser/OpenIndexRespParser;", "Lorg/opensearch/indexmanagement/controlcenter/notification/filter/parser/ResponseParser;", "Lorg/opensearch/action/admin/indices/open/OpenIndexResponse;", "activeShardsObserver", "Lorg/opensearch/action/support/ActiveShardsObserver;", "request", "Lorg/opensearch/action/admin/indices/open/OpenIndexRequest;", "indexNameExpressionResolver", "Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "(Lorg/opensearch/action/support/ActiveShardsObserver;Lorg/opensearch/action/admin/indices/open/OpenIndexRequest;Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;Lorg/opensearch/cluster/service/ClusterService;)V", "getActiveShardsObserver", "()Lorg/opensearch/action/support/ActiveShardsObserver;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "getIndexNameExpressionResolver", "()Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;", "indexNameWithCluster", "", "getRequest", "()Lorg/opensearch/action/admin/indices/open/OpenIndexRequest;", "totalWaitTime", "Lorg/opensearch/common/unit/TimeValue;", "buildNotificationMessage", "response", "exception", "Ljava/lang/Exception;", "isTimeout", "", "buildNotificationTitle", "operationResult", "Lorg/opensearch/indexmanagement/controlcenter/notification/filter/OperationResult;", "parseAndSendNotification", "", "ex", "callback", "Ljava/util/function/Consumer;", "Lorg/opensearch/indexmanagement/controlcenter/notification/filter/parser/ActionRespParseResult;", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nOpenIndexRespParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenIndexRespParser.kt\norg/opensearch/indexmanagement/controlcenter/notification/filter/parser/OpenIndexRespParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1#2:140\n*E\n"})
public final class OpenIndexRespParser
implements ResponseParser<OpenIndexResponse> {
    @NotNull
    private final ActiveShardsObserver activeShardsObserver;
    @NotNull
    private final OpenIndexRequest request;
    @NotNull
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private TimeValue totalWaitTime;
    @Nullable
    private final String indexNameWithCluster;

    public OpenIndexRespParser(@NotNull ActiveShardsObserver activeShardsObserver, @NotNull OpenIndexRequest request, @NotNull IndexNameExpressionResolver indexNameExpressionResolver, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)activeShardsObserver, (String)"activeShardsObserver");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)indexNameExpressionResolver, (String)"indexNameExpressionResolver");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        this.activeShardsObserver = activeShardsObserver;
        this.request = request;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.clusterService = clusterService;
        this.totalWaitTime = NotificationActionListener.Companion.getMAX_WAIT_TIME();
        this.indexNameWithCluster = this.getIndexName((ActionRequest)this.request, this.clusterService);
    }

    @NotNull
    public final ActiveShardsObserver getActiveShardsObserver() {
        return this.activeShardsObserver;
    }

    @NotNull
    public final OpenIndexRequest getRequest() {
        return this.request;
    }

    @NotNull
    public final IndexNameExpressionResolver getIndexNameExpressionResolver() {
        return this.indexNameExpressionResolver;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @Override
    public void parseAndSendNotification(@Nullable OpenIndexResponse response2, @Nullable Exception ex, @NotNull Consumer<ActionRespParseResult> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (ex != null) {
            callback.accept(new ActionRespParseResult(OperationResult.FAILED, ResponseParser.DefaultImpls.buildNotificationMessage$default(this, null, ex, false, 4, null), this.buildNotificationTitle(OperationResult.FAILED)));
            return;
        }
        if (response2 == null) {
            boolean $i$a$-requireNotNull-OpenIndexRespParser$parseAndSendNotification$22 = false;
            String $i$a$-requireNotNull-OpenIndexRespParser$parseAndSendNotification$22 = "OpenIndexResponse must not be null";
            throw new IllegalArgumentException($i$a$-requireNotNull-OpenIndexRespParser$parseAndSendNotification$22.toString());
        }
        boolean isAsync = this.request.getShouldStoreResult();
        TimeValue elapsedTime = this.request.ackTimeout();
        Intrinsics.checkNotNullExpressionValue((Object)elapsedTime, (String)"elapsedTime");
        this.totalWaitTime = elapsedTime;
        long leftTimeInMillis = NotificationActionListener.Companion.getMAX_WAIT_TIME().getMillis() - elapsedTime.getMillis();
        if (!response2.isShardsAcknowledged()) {
            if (!isAsync && leftTimeInMillis > 0L) {
                this.totalWaitTime = NotificationActionListener.Companion.getMAX_WAIT_TIME();
                String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(this.clusterService.state(), (IndicesRequest)this.request);
                this.activeShardsObserver.waitForActiveShards(concreteIndices, ActiveShardCount.DEFAULT, new TimeValue(leftTimeInMillis), arg_0 -> OpenIndexRespParser.parseAndSendNotification$lambda$1(callback, this, response2, arg_0), arg_0 -> OpenIndexRespParser.parseAndSendNotification$lambda$2(callback, this, response2, arg_0));
            } else {
                callback.accept(new ActionRespParseResult(OperationResult.TIMEOUT, ResponseParser.DefaultImpls.buildNotificationMessage$default(this, (ActionResponse)response2, null, true, 2, null), this.buildNotificationTitle(OperationResult.TIMEOUT)));
            }
        } else {
            callback.accept(new ActionRespParseResult(OperationResult.COMPLETE, ResponseParser.DefaultImpls.buildNotificationMessage$default(this, (ActionResponse)response2, null, false, 6, null), this.buildNotificationTitle(OperationResult.COMPLETE)));
        }
    }

    @Override
    @NotNull
    public String buildNotificationMessage(@Nullable OpenIndexResponse response2, @Nullable Exception exception, boolean isTimeout) {
        Object object;
        String indexes = this.indexNameWithCluster + (this.request.indices().length == 1 ? " has" : " have");
        if (isTimeout) {
            String string = this.totalWaitTime.toHumanReadableString(1);
            String[] stringArray = this.request.indices();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"request.indices()");
            object = "Opening the index " + indexes + " taken more than " + string + " to complete. To see the latest status, use `GET /" + ArraysKt.joinToString$default((Object[])stringArray, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "/_recovery`";
        } else if (exception != null) {
            if (exception instanceof OpenSearchException) {
                object = "index [" + ((OpenSearchException)exception).getIndex().getName() + "] " + ((OpenSearchException)exception).getMessage() + ".";
            } else {
                object = exception.getMessage();
                if (object == null) {
                    object = "";
                }
            }
        } else {
            object = indexes + " been set to open.";
        }
        return object;
    }

    @Override
    @NotNull
    public String buildNotificationTitle(@NotNull OperationResult operationResult) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)operationResult), (String)"operationResult");
        switch (WhenMappings.$EnumSwitchMapping$0[operationResult.ordinal()]) {
            case 1: {
                string = "been opened";
                break;
            }
            case 2: {
                string = "failed to open";
                break;
            }
            default: {
                string = "timed out to open";
            }
        }
        String result2 = string;
        return this.request.indices().length == 1 ? this.indexNameWithCluster + " has " + result2 : this.request.indices().length + " indexes from [" + this.clusterService.getClusterName().value() + "] have " + result2;
    }

    @Override
    @Nullable
    public String getIndexName(@NotNull ActionRequest req, @NotNull ClusterService clusterService) {
        return ResponseParser.DefaultImpls.getIndexName(this, req, clusterService);
    }

    @Override
    @NotNull
    public String getOperationResultTitleDesc(@NotNull OperationResult result2) {
        return ResponseParser.DefaultImpls.getOperationResultTitleDesc(this, result2);
    }

    private static final void parseAndSendNotification$lambda$1(Consumer $callback, OpenIndexRespParser this$0, OpenIndexResponse $response, boolean shardsAcknowledged) {
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $callback.accept(new ActionRespParseResult(shardsAcknowledged ? OperationResult.COMPLETE : OperationResult.TIMEOUT, ResponseParser.DefaultImpls.buildNotificationMessage$default(this$0, (ActionResponse)$response, null, !shardsAcknowledged, 2, null), this$0.buildNotificationTitle(shardsAcknowledged ? OperationResult.COMPLETE : OperationResult.TIMEOUT)));
    }

    private static final void parseAndSendNotification$lambda$2(Consumer $callback, OpenIndexRespParser this$0, OpenIndexResponse $response, Exception e) {
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        $callback.accept(new ActionRespParseResult(OperationResult.FAILED, ResponseParser.DefaultImpls.buildNotificationMessage$default(this$0, (ActionResponse)$response, e, false, 4, null), this$0.buildNotificationTitle(OperationResult.FAILED)));
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OperationResult.values().length];
            try {
                nArray[OperationResult.COMPLETE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OperationResult.FAILED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

