/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.binary;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.WireFormat;
import gnu.trove.list.array.TIntArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.osmand.CollatorStringMatcher;
import net.osmand.PlatformUtil;
import net.osmand.StringMatcher;
import net.osmand.binary.BinaryIndexPart;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.data.Building;
import net.osmand.data.City;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.data.Street;
import net.osmand.util.MapUtils;
import net.sf.junidecode.Junidecode;
import org.apache.commons.logging.Log;

public class BinaryMapAddressReaderAdapter {
    public static final int CITY_TOWN_TYPE = 1;
    public static final int POSTCODES_TYPE = 2;
    public static final int VILLAGES_TYPE = 3;
    public static final int STREET_TYPE = 4;
    private static final Log LOG = PlatformUtil.getLog(BinaryMapAddressReaderAdapter.class);
    private CodedInputStream codedIS;
    private final BinaryMapIndexReader map;

    protected BinaryMapAddressReaderAdapter(BinaryMapIndexReader map) {
        this.codedIS = map.codedIS;
        this.map = map;
    }

    private void skipUnknownField(int t) throws IOException {
        this.map.skipUnknownField(t);
    }

    private int readInt() throws IOException {
        return this.map.readInt();
    }

    protected void readAddressIndex(AddressRegion region) throws IOException {
        block8: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    if (region.enName == null || region.enName.length() == 0) {
                        region.enName = region.name == null ? "" : Junidecode.unidecode((String)region.name);
                    }
                    return;
                }
                case 1: {
                    region.name = this.codedIS.readString();
                    continue block8;
                }
                case 2: {
                    region.enName = this.codedIS.readString();
                    continue block8;
                }
                case 4: {
                    int length2 = this.codedIS.readRawVarint32();
                    int oldLimit = this.codedIS.pushLimit(length2);
                    region.attributeTagsTable = this.map.readStringTable();
                    this.codedIS.popLimit(oldLimit);
                    continue block8;
                }
                case 6: {
                    int tt;
                    int ttag;
                    CitiesBlock block = new CitiesBlock();
                    region.cities.add(block);
                    block.type = 1;
                    block.length = this.readInt();
                    block.filePointer = this.codedIS.getTotalBytesRead();
                    while ((ttag = WireFormat.getTagFieldNumber(tt = this.codedIS.readTag())) != 0) {
                        if (ttag == 2) {
                            block.type = this.codedIS.readUInt32();
                            break;
                        }
                        this.skipUnknownField(tt);
                    }
                    this.codedIS.seek(block.filePointer + block.length);
                    continue block8;
                }
                case 7: {
                    region.indexNameOffset = this.codedIS.getTotalBytesRead();
                    int length = this.readInt();
                    this.codedIS.seek(region.indexNameOffset + length + 4);
                    continue block8;
                }
            }
            this.skipUnknownField(t);
        }
    }

    protected void readCities(List<City> cities, BinaryMapIndexReader.SearchRequest<City> resultMatcher, StringMatcher matcher, List<String> additionalTagsTable) throws IOException {
        block4: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 5: {
                    int fp = this.codedIS.getTotalBytesRead();
                    int length = this.codedIS.readRawVarint32();
                    int oldLimit = this.codedIS.pushLimit(length);
                    City c = this.readCityHeader(matcher, fp, additionalTagsTable);
                    if (c != null && (resultMatcher == null || resultMatcher.publish(c))) {
                        cities.add(c);
                    }
                    this.codedIS.popLimit(oldLimit);
                    if (resultMatcher == null || !resultMatcher.isCancelled()) continue block4;
                    this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                    continue block4;
                }
            }
            this.skipUnknownField(t);
        }
    }

    protected void readCityStreets(BinaryMapIndexReader.SearchRequest<Street> resultMatcher, City city, List<String> attributeTagsTable) throws IOException {
        int x = MapUtils.get31TileNumberX(city.getLocation().getLongitude());
        int y = MapUtils.get31TileNumberY(city.getLocation().getLatitude());
        block5: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 12: {
                    Street s = new Street(city);
                    s.setFileOffset(this.codedIS.getTotalBytesRead());
                    int length = this.codedIS.readRawVarint32();
                    int oldLimit = this.codedIS.pushLimit(length);
                    this.readStreet(s, null, false, x >> 7, y >> 7, city.isPostcode() ? city.getName() : null, attributeTagsTable);
                    if (resultMatcher == null || resultMatcher.publish(s)) {
                        city.registerStreet(s);
                    }
                    if (resultMatcher != null && resultMatcher.isCancelled()) {
                        this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                    }
                    this.codedIS.popLimit(oldLimit);
                    continue block5;
                }
                case 10: {
                    this.skipUnknownField(t);
                }
            }
            this.skipUnknownField(t);
        }
    }

    protected City readCityHeader(StringMatcher matcher, int filePointer, List<String> additionalTagsTable) throws IOException {
        int x = 0;
        int y = 0;
        MapObject c = null;
        LinkedList<String> additionalTags = null;
        block12: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    if (matcher != null) {
                        boolean matches = matcher.matches(c.getName());
                        if (!matches) {
                            String n;
                            Iterator<String> iterator = c.getAllNames().iterator();
                            while (iterator.hasNext() && !(matches = matcher.matches(n = iterator.next()))) {
                            }
                        }
                        if (!matches) {
                            return null;
                        }
                    }
                    return c;
                }
                case 1: {
                    int type = this.codedIS.readUInt32();
                    c = new City(City.CityType.values()[type]);
                    break;
                }
                case 4: {
                    c.setId(this.codedIS.readUInt64());
                    break;
                }
                case 7: {
                    int tgid = this.codedIS.readUInt32();
                    if (additionalTags == null) {
                        additionalTags = new LinkedList<String>();
                    }
                    if (additionalTagsTable == null || tgid >= additionalTagsTable.size()) continue block12;
                    additionalTags.add(additionalTagsTable.get(tgid));
                    break;
                }
                case 8: {
                    String tg;
                    String nm = this.codedIS.readString();
                    if (additionalTags == null || additionalTags.size() <= 0 || !(tg = (String)additionalTags.pollFirst()).startsWith("name:")) continue block12;
                    c.setName(tg.substring("name:".length()), nm);
                    break;
                }
                case 3: {
                    String enName = this.codedIS.readString();
                    c.setEnName(enName);
                    break;
                }
                case 2: {
                    String name = this.codedIS.readString();
                    if (c == null) {
                        c = City.createPostcode(name);
                    }
                    c.setName(name);
                    break;
                }
                case 5: {
                    x = this.codedIS.readUInt32();
                    break;
                }
                case 6: {
                    y = this.codedIS.readUInt32();
                    c.setLocation(MapUtils.get31LatitudeY(y), MapUtils.get31LongitudeX(x));
                    break;
                }
                case 10: {
                    int offset = this.readInt();
                    c.setFileOffset(offset += filePointer);
                    break;
                }
                default: {
                    this.skipUnknownField(t);
                }
            }
        }
    }

    protected Street readStreet(Street s, BinaryMapIndexReader.SearchRequest<Building> buildingsMatcher, boolean loadBuildingsAndIntersected, int city24X, int city24Y, String postcodeFilter, List<String> additionalTagsTable) throws IOException {
        int x = 0;
        int y = 0;
        LinkedList<String> additionalTags = null;
        boolean loadLocation = city24X != 0 || city24Y != 0;
        block12: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    if (loadLocation) {
                        s.setLocation(MapUtils.getLatitudeFromTile(24.0f, y), MapUtils.getLongitudeFromTile(24.0, x));
                    }
                    return s;
                }
                case 6: {
                    s.setId(this.codedIS.readUInt64());
                    break;
                }
                case 7: {
                    int tgid = this.codedIS.readUInt32();
                    if (additionalTags == null) {
                        additionalTags = new LinkedList<String>();
                    }
                    if (additionalTagsTable == null || tgid >= additionalTagsTable.size()) continue block12;
                    additionalTags.add(additionalTagsTable.get(tgid));
                    break;
                }
                case 8: {
                    String tg;
                    String nm = this.codedIS.readString();
                    if (additionalTags == null || additionalTags.size() <= 0 || !(tg = (String)additionalTags.pollFirst()).startsWith("name:")) continue block12;
                    s.setName(tg.substring("name:".length()), nm);
                    break;
                }
                case 2: {
                    s.setEnName(this.codedIS.readString());
                    break;
                }
                case 1: {
                    s.setName(this.codedIS.readString());
                    break;
                }
                case 3: {
                    int sx = this.codedIS.readSInt32();
                    if (loadLocation) {
                        x = sx + city24X;
                        break;
                    }
                    x = (int)MapUtils.getTileNumberX(24.0f, s.getLocation().getLongitude());
                    break;
                }
                case 4: {
                    int sy = this.codedIS.readSInt32();
                    if (loadLocation) {
                        y = sy + city24Y;
                        break;
                    }
                    y = (int)MapUtils.getTileNumberY(24.0f, s.getLocation().getLatitude());
                    break;
                }
                case 5: {
                    int length = this.codedIS.readRawVarint32();
                    if (loadBuildingsAndIntersected) {
                        int oldLimit = this.codedIS.pushLimit(length);
                        Street si = this.readIntersectedStreet(s.getCity(), x, y, additionalTagsTable);
                        s.addIntersectedStreet(si);
                        this.codedIS.popLimit(oldLimit);
                        break;
                    }
                    this.codedIS.skipRawBytes(length);
                    break;
                }
                case 12: {
                    int offset = this.codedIS.getTotalBytesRead();
                    int length = this.codedIS.readRawVarint32();
                    if (loadBuildingsAndIntersected) {
                        int oldLimit = this.codedIS.pushLimit(length);
                        Building b = this.readBuilding(offset, x, y, additionalTagsTable);
                        if ((postcodeFilter == null || postcodeFilter.equalsIgnoreCase(b.getPostcode())) && (buildingsMatcher == null || buildingsMatcher.publish(b))) {
                            s.addBuilding(b);
                        }
                        this.codedIS.popLimit(oldLimit);
                        break;
                    }
                    this.codedIS.skipRawBytes(length);
                    break;
                }
                default: {
                    this.skipUnknownField(t);
                }
            }
        }
    }

    protected Street readIntersectedStreet(City c, int street24X, int street24Y, List<String> additionalTagsTable) throws IOException {
        int x = 0;
        int y = 0;
        Street s = new Street(c);
        LinkedList<String> additionalTags = null;
        block10: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    s.setLocation(MapUtils.getLatitudeFromTile(24.0f, y), MapUtils.getLongitudeFromTile(24.0, x));
                    return s;
                }
                case 13: {
                    s.setId(this.codedIS.readUInt64());
                    break;
                }
                case 3: {
                    s.setEnName(this.codedIS.readString());
                    break;
                }
                case 2: {
                    s.setName(this.codedIS.readString());
                    break;
                }
                case 7: {
                    int tgid = this.codedIS.readUInt32();
                    if (additionalTags == null) {
                        additionalTags = new LinkedList<String>();
                    }
                    if (additionalTagsTable == null || tgid >= additionalTagsTable.size()) continue block10;
                    additionalTags.add(additionalTagsTable.get(tgid));
                    break;
                }
                case 8: {
                    String tg;
                    String nm = this.codedIS.readString();
                    if (additionalTags == null || additionalTags.size() <= 0 || !(tg = (String)additionalTags.pollFirst()).startsWith("name:")) continue block10;
                    s.setName(tg.substring("name:".length()), nm);
                    break;
                }
                case 4: {
                    x = this.codedIS.readSInt32() + street24X;
                    break;
                }
                case 5: {
                    y = this.codedIS.readSInt32() + street24Y;
                    break;
                }
                default: {
                    this.skipUnknownField(t);
                }
            }
        }
    }

    protected Building readBuilding(int fileOffset, int street24X, int street24Y, List<String> additionalTagsTable) throws IOException {
        int x = 0;
        int y = 0;
        int x2 = 0;
        int y2 = 0;
        LinkedList<String> additionalTags = null;
        Building b = new Building();
        b.setFileOffset(fileOffset);
        block16: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    b.setLocation(MapUtils.getLatitudeFromTile(24.0f, y), MapUtils.getLongitudeFromTile(24.0, x));
                    if (x2 != 0 && y2 != 0) {
                        b.setLatLon2(new LatLon(MapUtils.getLatitudeFromTile(24.0f, y2), MapUtils.getLongitudeFromTile(24.0, x2)));
                    }
                    return b;
                }
                case 13: {
                    b.setId(this.codedIS.readUInt64());
                    break;
                }
                case 2: {
                    b.setEnName(this.codedIS.readString());
                    break;
                }
                case 1: {
                    b.setName(this.codedIS.readString());
                    break;
                }
                case 15: {
                    int tgid = this.codedIS.readUInt32();
                    if (additionalTags == null) {
                        additionalTags = new LinkedList<String>();
                    }
                    if (additionalTagsTable == null || tgid >= additionalTagsTable.size()) continue block16;
                    additionalTags.add(additionalTagsTable.get(tgid));
                    break;
                }
                case 16: {
                    String tg;
                    String nm = this.codedIS.readString();
                    if (additionalTags == null || additionalTags.size() <= 0 || !(tg = (String)additionalTags.pollFirst()).startsWith("name:")) continue block16;
                    b.setName(tg.substring("name:".length()), nm);
                    break;
                }
                case 4: {
                    this.codedIS.readString();
                    break;
                }
                case 3: {
                    b.setName2(this.codedIS.readString());
                    break;
                }
                case 5: {
                    int sint = this.codedIS.readSInt32();
                    if (sint > 0) {
                        b.setInterpolationInterval(sint);
                        break;
                    }
                    b.setInterpolationType(Building.BuildingInterpolation.fromValue(sint));
                    break;
                }
                case 7: {
                    x = this.codedIS.readSInt32() + street24X;
                    break;
                }
                case 9: {
                    x2 = this.codedIS.readSInt32() + street24X;
                    break;
                }
                case 8: {
                    y = this.codedIS.readSInt32() + street24Y;
                    break;
                }
                case 10: {
                    y2 = this.codedIS.readSInt32() + street24Y;
                    break;
                }
                case 14: {
                    b.setPostcode(this.codedIS.readString());
                    break;
                }
                default: {
                    this.skipUnknownField(t);
                }
            }
        }
    }

    public void searchAddressDataByName(AddressRegion reg, BinaryMapIndexReader.SearchRequest<MapObject> req, int[] typeFilter) throws IOException {
        TIntArrayList loffsets = new TIntArrayList();
        CollatorStringMatcher matcher = new CollatorStringMatcher(req.nameQuery, CollatorStringMatcher.StringMatcherMode.CHECK_STARTS_FROM_SPACE);
        long time = System.currentTimeMillis();
        int indexOffset = 0;
        block5: while (!req.isCancelled()) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 4: {
                    int length = this.readInt();
                    indexOffset = this.codedIS.getTotalBytesRead();
                    int oldLimit = this.codedIS.pushLimit(length);
                    this.map.readIndexedStringTable(matcher.getCollator(), req.nameQuery, "", loffsets, 0);
                    this.codedIS.popLimit(oldLimit);
                    continue block5;
                }
                case 7: {
                    int i;
                    loffsets.sort();
                    TIntArrayList[] refs = new TIntArrayList[5];
                    for (i = 0; i < refs.length; ++i) {
                        refs[i] = new TIntArrayList();
                    }
                    LOG.info((Object)("Searched address structure in " + (System.currentTimeMillis() - time) + "ms. Found " + loffsets.size() + " subtress"));
                    for (int j = 0; j < loffsets.size(); ++j) {
                        int fp = indexOffset + loffsets.get(j);
                        this.codedIS.seek(fp);
                        int len = this.codedIS.readRawVarint32();
                        int oldLim = this.codedIS.pushLimit(len);
                        int stag = 0;
                        do {
                            int st;
                            if ((stag = WireFormat.getTagFieldNumber(st = this.codedIS.readTag())) == 4) {
                                int slen = this.codedIS.readRawVarint32();
                                int soldLim = this.codedIS.pushLimit(slen);
                                this.readAddressNameData(req, refs, fp);
                                this.codedIS.popLimit(soldLim);
                                continue;
                            }
                            if (stag == 0) continue;
                            this.skipUnknownField(st);
                        } while (stag != 0);
                        this.codedIS.popLimit(oldLim);
                        if (!req.isCancelled()) continue;
                        return;
                    }
                    if (typeFilter == null) {
                        typeFilter = new int[]{1, 2, 3, 4};
                    }
                    for (i = 0; i < typeFilter.length && !req.isCancelled(); ++i) {
                        int j;
                        TIntArrayList list = refs[typeFilter[i]];
                        if (typeFilter[i] == 4) {
                            for (j = 0; j < list.size() && !req.isCancelled(); j += 2) {
                                City obj = null;
                                this.codedIS.seek(list.get(j + 1));
                                int len = this.codedIS.readRawVarint32();
                                int old = this.codedIS.pushLimit(len);
                                obj = this.readCityHeader(null, list.get(j + 1), null);
                                this.codedIS.popLimit(old);
                                if (obj == null) continue;
                                this.codedIS.seek(list.get(j));
                                len = this.codedIS.readRawVarint32();
                                old = this.codedIS.pushLimit(len);
                                LatLon l = obj.getLocation();
                                Street s = new Street(obj);
                                s.setFileOffset(list.get(j));
                                this.readStreet(s, null, false, MapUtils.get31TileNumberX(l.getLongitude()) >> 7, MapUtils.get31TileNumberY(l.getLatitude()) >> 7, obj.isPostcode() ? obj.getName() : null, reg.attributeTagsTable);
                                boolean matches = matcher.matches(s.getName());
                                if (!matches) {
                                    String n;
                                    Iterator<String> iterator = s.getAllNames().iterator();
                                    while (iterator.hasNext() && !(matches = matcher.matches(n = iterator.next()))) {
                                    }
                                }
                                if (matches) {
                                    req.publish(s);
                                }
                                this.codedIS.popLimit(old);
                            }
                            continue;
                        }
                        list.sort();
                        for (j = 0; j < list.size() && !req.isCancelled(); ++j) {
                            this.codedIS.seek(list.get(j));
                            int len = this.codedIS.readRawVarint32();
                            int old = this.codedIS.pushLimit(len);
                            City obj = this.readCityHeader(matcher, list.get(j), reg.attributeTagsTable);
                            if (obj != null) {
                                req.publish(obj);
                            }
                            this.codedIS.popLimit(old);
                        }
                    }
                    LOG.info((Object)("Whole address search by name is done in " + (System.currentTimeMillis() - time) + "ms. Found " + req.getSearchResults().size()));
                    return;
                }
            }
            this.skipUnknownField(t);
        }
        return;
    }

    private void readAddressNameData(BinaryMapIndexReader.SearchRequest<MapObject> req, TIntArrayList[] refs, int fp) throws IOException {
        TIntArrayList toAdd = null;
        block8: while (!req.isCancelled()) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 2: {
                    this.codedIS.readString();
                    continue block8;
                }
                case 1: {
                    this.codedIS.readString();
                    continue block8;
                }
                case 6: {
                    if (toAdd == null) continue block8;
                    toAdd.add(fp - this.codedIS.readInt32());
                    continue block8;
                }
                case 5: {
                    if (toAdd == null) continue block8;
                    toAdd.add(fp - this.codedIS.readInt32());
                    continue block8;
                }
                case 3: {
                    int type = this.codedIS.readInt32();
                    toAdd = refs[type];
                    continue block8;
                }
            }
            this.skipUnknownField(t);
        }
        return;
    }

    public static class CitiesBlock
    extends BinaryIndexPart {
        int type;
    }

    public static class AddressRegion
    extends BinaryIndexPart {
        String enName;
        int indexNameOffset = -1;
        List<String> attributeTagsTable = new ArrayList<String>();
        List<CitiesBlock> cities = new ArrayList<CitiesBlock>();
        LatLon calculatedCenter = null;

        public String getEnName() {
            return this.enName;
        }

        public List<CitiesBlock> getCities() {
            return this.cities;
        }

        public List<String> getAttributeTagsTable() {
            return this.attributeTagsTable;
        }

        public int getIndexNameOffset() {
            return this.indexNameOffset;
        }
    }
}

