# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.3.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class VideoAbuse(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'reason': 'str',
        'predefined_reasons': 'list[str]',
        'reporter_account': 'Account',
        'state': 'AbuseStateConstant',
        'moderation_comment': 'str',
        'video': 'VideoAbuseVideo',
        'created_at': 'datetime'
    }

    attribute_map = {
        'id': 'id',
        'reason': 'reason',
        'predefined_reasons': 'predefinedReasons',
        'reporter_account': 'reporterAccount',
        'state': 'state',
        'moderation_comment': 'moderationComment',
        'video': 'video',
        'created_at': 'createdAt'
    }

    def __init__(self, id=None, reason=None, predefined_reasons=None, reporter_account=None, state=None, moderation_comment=None, video=None, created_at=None, local_vars_configuration=None):  # noqa: E501
        """VideoAbuse - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._reason = None
        self._predefined_reasons = None
        self._reporter_account = None
        self._state = None
        self._moderation_comment = None
        self._video = None
        self._created_at = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if reason is not None:
            self.reason = reason
        if predefined_reasons is not None:
            self.predefined_reasons = predefined_reasons
        if reporter_account is not None:
            self.reporter_account = reporter_account
        if state is not None:
            self.state = state
        if moderation_comment is not None:
            self.moderation_comment = moderation_comment
        if video is not None:
            self.video = video
        if created_at is not None:
            self.created_at = created_at

    @property
    def id(self):
        """Gets the id of this VideoAbuse.  # noqa: E501


        :return: The id of this VideoAbuse.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VideoAbuse.


        :param id: The id of this VideoAbuse.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def reason(self):
        """Gets the reason of this VideoAbuse.  # noqa: E501


        :return: The reason of this VideoAbuse.  # noqa: E501
        :rtype: str
        """
        return self._reason

    @reason.setter
    def reason(self, reason):
        """Sets the reason of this VideoAbuse.


        :param reason: The reason of this VideoAbuse.  # noqa: E501
        :type: str
        """

        self._reason = reason

    @property
    def predefined_reasons(self):
        """Gets the predefined_reasons of this VideoAbuse.  # noqa: E501


        :return: The predefined_reasons of this VideoAbuse.  # noqa: E501
        :rtype: list[str]
        """
        return self._predefined_reasons

    @predefined_reasons.setter
    def predefined_reasons(self, predefined_reasons):
        """Sets the predefined_reasons of this VideoAbuse.


        :param predefined_reasons: The predefined_reasons of this VideoAbuse.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["violentOrAbusive", "hatefulOrAbusive", "spamOrMisleading", "privacy", "rights", "serverRules", "thumbnails", "captions"]  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                not set(predefined_reasons).issubset(set(allowed_values))):  # noqa: E501
            raise ValueError(
                "Invalid values for `predefined_reasons` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(predefined_reasons) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._predefined_reasons = predefined_reasons

    @property
    def reporter_account(self):
        """Gets the reporter_account of this VideoAbuse.  # noqa: E501


        :return: The reporter_account of this VideoAbuse.  # noqa: E501
        :rtype: Account
        """
        return self._reporter_account

    @reporter_account.setter
    def reporter_account(self, reporter_account):
        """Sets the reporter_account of this VideoAbuse.


        :param reporter_account: The reporter_account of this VideoAbuse.  # noqa: E501
        :type: Account
        """

        self._reporter_account = reporter_account

    @property
    def state(self):
        """Gets the state of this VideoAbuse.  # noqa: E501


        :return: The state of this VideoAbuse.  # noqa: E501
        :rtype: AbuseStateConstant
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this VideoAbuse.


        :param state: The state of this VideoAbuse.  # noqa: E501
        :type: AbuseStateConstant
        """

        self._state = state

    @property
    def moderation_comment(self):
        """Gets the moderation_comment of this VideoAbuse.  # noqa: E501


        :return: The moderation_comment of this VideoAbuse.  # noqa: E501
        :rtype: str
        """
        return self._moderation_comment

    @moderation_comment.setter
    def moderation_comment(self, moderation_comment):
        """Sets the moderation_comment of this VideoAbuse.


        :param moderation_comment: The moderation_comment of this VideoAbuse.  # noqa: E501
        :type: str
        """

        self._moderation_comment = moderation_comment

    @property
    def video(self):
        """Gets the video of this VideoAbuse.  # noqa: E501


        :return: The video of this VideoAbuse.  # noqa: E501
        :rtype: VideoAbuseVideo
        """
        return self._video

    @video.setter
    def video(self, video):
        """Sets the video of this VideoAbuse.


        :param video: The video of this VideoAbuse.  # noqa: E501
        :type: VideoAbuseVideo
        """

        self._video = video

    @property
    def created_at(self):
        """Gets the created_at of this VideoAbuse.  # noqa: E501


        :return: The created_at of this VideoAbuse.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this VideoAbuse.


        :param created_at: The created_at of this VideoAbuse.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VideoAbuse):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VideoAbuse):
            return True

        return self.to_dict() != other.to_dict()
