# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class User(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'username': 'str',
        'email': 'str',
        'theme': 'str',
        'email_verified': 'bool',
        'nsfw_policy': 'NSFWPolicy',
        'webtorrent_enabled': 'bool',
        'auto_play_video': 'bool',
        'role': 'UserRole',
        'role_label': 'str',
        'video_quota': 'int',
        'video_quota_daily': 'int',
        'videos_count': 'int',
        'abuses_count': 'int',
        'abuses_accepted_count': 'int',
        'abuses_created_count': 'int',
        'video_comments_count': 'int',
        'no_instance_config_warning_modal': 'bool',
        'no_welcome_modal': 'bool',
        'blocked': 'bool',
        'blocked_reason': 'str',
        'created_at': 'str',
        'account': 'Account',
        'video_channels': 'list[VideoChannel]'
    }

    attribute_map = {
        'id': 'id',
        'username': 'username',
        'email': 'email',
        'theme': 'theme',
        'email_verified': 'emailVerified',
        'nsfw_policy': 'nsfwPolicy',
        'webtorrent_enabled': 'webtorrentEnabled',
        'auto_play_video': 'autoPlayVideo',
        'role': 'role',
        'role_label': 'roleLabel',
        'video_quota': 'videoQuota',
        'video_quota_daily': 'videoQuotaDaily',
        'videos_count': 'videosCount',
        'abuses_count': 'abusesCount',
        'abuses_accepted_count': 'abusesAcceptedCount',
        'abuses_created_count': 'abusesCreatedCount',
        'video_comments_count': 'videoCommentsCount',
        'no_instance_config_warning_modal': 'noInstanceConfigWarningModal',
        'no_welcome_modal': 'noWelcomeModal',
        'blocked': 'blocked',
        'blocked_reason': 'blockedReason',
        'created_at': 'createdAt',
        'account': 'account',
        'video_channels': 'videoChannels'
    }

    def __init__(self, id=None, username=None, email=None, theme=None, email_verified=None, nsfw_policy=None, webtorrent_enabled=None, auto_play_video=None, role=None, role_label=None, video_quota=None, video_quota_daily=None, videos_count=None, abuses_count=None, abuses_accepted_count=None, abuses_created_count=None, video_comments_count=None, no_instance_config_warning_modal=None, no_welcome_modal=None, blocked=None, blocked_reason=None, created_at=None, account=None, video_channels=None, local_vars_configuration=None):  # noqa: E501
        """User - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._username = None
        self._email = None
        self._theme = None
        self._email_verified = None
        self._nsfw_policy = None
        self._webtorrent_enabled = None
        self._auto_play_video = None
        self._role = None
        self._role_label = None
        self._video_quota = None
        self._video_quota_daily = None
        self._videos_count = None
        self._abuses_count = None
        self._abuses_accepted_count = None
        self._abuses_created_count = None
        self._video_comments_count = None
        self._no_instance_config_warning_modal = None
        self._no_welcome_modal = None
        self._blocked = None
        self._blocked_reason = None
        self._created_at = None
        self._account = None
        self._video_channels = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if username is not None:
            self.username = username
        if email is not None:
            self.email = email
        if theme is not None:
            self.theme = theme
        if email_verified is not None:
            self.email_verified = email_verified
        if nsfw_policy is not None:
            self.nsfw_policy = nsfw_policy
        if webtorrent_enabled is not None:
            self.webtorrent_enabled = webtorrent_enabled
        if auto_play_video is not None:
            self.auto_play_video = auto_play_video
        if role is not None:
            self.role = role
        if role_label is not None:
            self.role_label = role_label
        if video_quota is not None:
            self.video_quota = video_quota
        if video_quota_daily is not None:
            self.video_quota_daily = video_quota_daily
        if videos_count is not None:
            self.videos_count = videos_count
        if abuses_count is not None:
            self.abuses_count = abuses_count
        if abuses_accepted_count is not None:
            self.abuses_accepted_count = abuses_accepted_count
        if abuses_created_count is not None:
            self.abuses_created_count = abuses_created_count
        if video_comments_count is not None:
            self.video_comments_count = video_comments_count
        if no_instance_config_warning_modal is not None:
            self.no_instance_config_warning_modal = no_instance_config_warning_modal
        if no_welcome_modal is not None:
            self.no_welcome_modal = no_welcome_modal
        if blocked is not None:
            self.blocked = blocked
        if blocked_reason is not None:
            self.blocked_reason = blocked_reason
        if created_at is not None:
            self.created_at = created_at
        if account is not None:
            self.account = account
        if video_channels is not None:
            self.video_channels = video_channels

    @property
    def id(self):
        """Gets the id of this User.  # noqa: E501


        :return: The id of this User.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this User.


        :param id: The id of this User.  # noqa: E501
        :type id: int
        """

        self._id = id

    @property
    def username(self):
        """Gets the username of this User.  # noqa: E501

        The user username  # noqa: E501

        :return: The username of this User.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this User.

        The user username  # noqa: E501

        :param username: The username of this User.  # noqa: E501
        :type username: str
        """
        if (self.local_vars_configuration.client_side_validation and
                username is not None and len(username) > 50):
            raise ValueError("Invalid value for `username`, length must be less than or equal to `50`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                username is not None and len(username) < 1):
            raise ValueError("Invalid value for `username`, length must be greater than or equal to `1`")  # noqa: E501

        self._username = username

    @property
    def email(self):
        """Gets the email of this User.  # noqa: E501

        The user email  # noqa: E501

        :return: The email of this User.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this User.

        The user email  # noqa: E501

        :param email: The email of this User.  # noqa: E501
        :type email: str
        """

        self._email = email

    @property
    def theme(self):
        """Gets the theme of this User.  # noqa: E501

        Theme enabled by this user  # noqa: E501

        :return: The theme of this User.  # noqa: E501
        :rtype: str
        """
        return self._theme

    @theme.setter
    def theme(self, theme):
        """Sets the theme of this User.

        Theme enabled by this user  # noqa: E501

        :param theme: The theme of this User.  # noqa: E501
        :type theme: str
        """

        self._theme = theme

    @property
    def email_verified(self):
        """Gets the email_verified of this User.  # noqa: E501

        Has the user confirmed their email address?  # noqa: E501

        :return: The email_verified of this User.  # noqa: E501
        :rtype: bool
        """
        return self._email_verified

    @email_verified.setter
    def email_verified(self, email_verified):
        """Sets the email_verified of this User.

        Has the user confirmed their email address?  # noqa: E501

        :param email_verified: The email_verified of this User.  # noqa: E501
        :type email_verified: bool
        """

        self._email_verified = email_verified

    @property
    def nsfw_policy(self):
        """Gets the nsfw_policy of this User.  # noqa: E501


        :return: The nsfw_policy of this User.  # noqa: E501
        :rtype: NSFWPolicy
        """
        return self._nsfw_policy

    @nsfw_policy.setter
    def nsfw_policy(self, nsfw_policy):
        """Sets the nsfw_policy of this User.


        :param nsfw_policy: The nsfw_policy of this User.  # noqa: E501
        :type nsfw_policy: NSFWPolicy
        """

        self._nsfw_policy = nsfw_policy

    @property
    def webtorrent_enabled(self):
        """Gets the webtorrent_enabled of this User.  # noqa: E501

        Enable P2P in the player  # noqa: E501

        :return: The webtorrent_enabled of this User.  # noqa: E501
        :rtype: bool
        """
        return self._webtorrent_enabled

    @webtorrent_enabled.setter
    def webtorrent_enabled(self, webtorrent_enabled):
        """Sets the webtorrent_enabled of this User.

        Enable P2P in the player  # noqa: E501

        :param webtorrent_enabled: The webtorrent_enabled of this User.  # noqa: E501
        :type webtorrent_enabled: bool
        """

        self._webtorrent_enabled = webtorrent_enabled

    @property
    def auto_play_video(self):
        """Gets the auto_play_video of this User.  # noqa: E501

        Automatically start playing the video on the watch page  # noqa: E501

        :return: The auto_play_video of this User.  # noqa: E501
        :rtype: bool
        """
        return self._auto_play_video

    @auto_play_video.setter
    def auto_play_video(self, auto_play_video):
        """Sets the auto_play_video of this User.

        Automatically start playing the video on the watch page  # noqa: E501

        :param auto_play_video: The auto_play_video of this User.  # noqa: E501
        :type auto_play_video: bool
        """

        self._auto_play_video = auto_play_video

    @property
    def role(self):
        """Gets the role of this User.  # noqa: E501


        :return: The role of this User.  # noqa: E501
        :rtype: UserRole
        """
        return self._role

    @role.setter
    def role(self, role):
        """Sets the role of this User.


        :param role: The role of this User.  # noqa: E501
        :type role: UserRole
        """

        self._role = role

    @property
    def role_label(self):
        """Gets the role_label of this User.  # noqa: E501


        :return: The role_label of this User.  # noqa: E501
        :rtype: str
        """
        return self._role_label

    @role_label.setter
    def role_label(self, role_label):
        """Sets the role_label of this User.


        :param role_label: The role_label of this User.  # noqa: E501
        :type role_label: str
        """
        allowed_values = ["User", "Moderator", "Administrator"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and role_label not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `role_label` ({0}), must be one of {1}"  # noqa: E501
                .format(role_label, allowed_values)
            )

        self._role_label = role_label

    @property
    def video_quota(self):
        """Gets the video_quota of this User.  # noqa: E501

        The user video quota  # noqa: E501

        :return: The video_quota of this User.  # noqa: E501
        :rtype: int
        """
        return self._video_quota

    @video_quota.setter
    def video_quota(self, video_quota):
        """Sets the video_quota of this User.

        The user video quota  # noqa: E501

        :param video_quota: The video_quota of this User.  # noqa: E501
        :type video_quota: int
        """

        self._video_quota = video_quota

    @property
    def video_quota_daily(self):
        """Gets the video_quota_daily of this User.  # noqa: E501

        The user daily video quota  # noqa: E501

        :return: The video_quota_daily of this User.  # noqa: E501
        :rtype: int
        """
        return self._video_quota_daily

    @video_quota_daily.setter
    def video_quota_daily(self, video_quota_daily):
        """Sets the video_quota_daily of this User.

        The user daily video quota  # noqa: E501

        :param video_quota_daily: The video_quota_daily of this User.  # noqa: E501
        :type video_quota_daily: int
        """

        self._video_quota_daily = video_quota_daily

    @property
    def videos_count(self):
        """Gets the videos_count of this User.  # noqa: E501


        :return: The videos_count of this User.  # noqa: E501
        :rtype: int
        """
        return self._videos_count

    @videos_count.setter
    def videos_count(self, videos_count):
        """Sets the videos_count of this User.


        :param videos_count: The videos_count of this User.  # noqa: E501
        :type videos_count: int
        """

        self._videos_count = videos_count

    @property
    def abuses_count(self):
        """Gets the abuses_count of this User.  # noqa: E501


        :return: The abuses_count of this User.  # noqa: E501
        :rtype: int
        """
        return self._abuses_count

    @abuses_count.setter
    def abuses_count(self, abuses_count):
        """Sets the abuses_count of this User.


        :param abuses_count: The abuses_count of this User.  # noqa: E501
        :type abuses_count: int
        """

        self._abuses_count = abuses_count

    @property
    def abuses_accepted_count(self):
        """Gets the abuses_accepted_count of this User.  # noqa: E501


        :return: The abuses_accepted_count of this User.  # noqa: E501
        :rtype: int
        """
        return self._abuses_accepted_count

    @abuses_accepted_count.setter
    def abuses_accepted_count(self, abuses_accepted_count):
        """Sets the abuses_accepted_count of this User.


        :param abuses_accepted_count: The abuses_accepted_count of this User.  # noqa: E501
        :type abuses_accepted_count: int
        """

        self._abuses_accepted_count = abuses_accepted_count

    @property
    def abuses_created_count(self):
        """Gets the abuses_created_count of this User.  # noqa: E501


        :return: The abuses_created_count of this User.  # noqa: E501
        :rtype: int
        """
        return self._abuses_created_count

    @abuses_created_count.setter
    def abuses_created_count(self, abuses_created_count):
        """Sets the abuses_created_count of this User.


        :param abuses_created_count: The abuses_created_count of this User.  # noqa: E501
        :type abuses_created_count: int
        """

        self._abuses_created_count = abuses_created_count

    @property
    def video_comments_count(self):
        """Gets the video_comments_count of this User.  # noqa: E501


        :return: The video_comments_count of this User.  # noqa: E501
        :rtype: int
        """
        return self._video_comments_count

    @video_comments_count.setter
    def video_comments_count(self, video_comments_count):
        """Sets the video_comments_count of this User.


        :param video_comments_count: The video_comments_count of this User.  # noqa: E501
        :type video_comments_count: int
        """

        self._video_comments_count = video_comments_count

    @property
    def no_instance_config_warning_modal(self):
        """Gets the no_instance_config_warning_modal of this User.  # noqa: E501


        :return: The no_instance_config_warning_modal of this User.  # noqa: E501
        :rtype: bool
        """
        return self._no_instance_config_warning_modal

    @no_instance_config_warning_modal.setter
    def no_instance_config_warning_modal(self, no_instance_config_warning_modal):
        """Sets the no_instance_config_warning_modal of this User.


        :param no_instance_config_warning_modal: The no_instance_config_warning_modal of this User.  # noqa: E501
        :type no_instance_config_warning_modal: bool
        """

        self._no_instance_config_warning_modal = no_instance_config_warning_modal

    @property
    def no_welcome_modal(self):
        """Gets the no_welcome_modal of this User.  # noqa: E501


        :return: The no_welcome_modal of this User.  # noqa: E501
        :rtype: bool
        """
        return self._no_welcome_modal

    @no_welcome_modal.setter
    def no_welcome_modal(self, no_welcome_modal):
        """Sets the no_welcome_modal of this User.


        :param no_welcome_modal: The no_welcome_modal of this User.  # noqa: E501
        :type no_welcome_modal: bool
        """

        self._no_welcome_modal = no_welcome_modal

    @property
    def blocked(self):
        """Gets the blocked of this User.  # noqa: E501


        :return: The blocked of this User.  # noqa: E501
        :rtype: bool
        """
        return self._blocked

    @blocked.setter
    def blocked(self, blocked):
        """Sets the blocked of this User.


        :param blocked: The blocked of this User.  # noqa: E501
        :type blocked: bool
        """

        self._blocked = blocked

    @property
    def blocked_reason(self):
        """Gets the blocked_reason of this User.  # noqa: E501


        :return: The blocked_reason of this User.  # noqa: E501
        :rtype: str
        """
        return self._blocked_reason

    @blocked_reason.setter
    def blocked_reason(self, blocked_reason):
        """Sets the blocked_reason of this User.


        :param blocked_reason: The blocked_reason of this User.  # noqa: E501
        :type blocked_reason: str
        """

        self._blocked_reason = blocked_reason

    @property
    def created_at(self):
        """Gets the created_at of this User.  # noqa: E501


        :return: The created_at of this User.  # noqa: E501
        :rtype: str
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this User.


        :param created_at: The created_at of this User.  # noqa: E501
        :type created_at: str
        """

        self._created_at = created_at

    @property
    def account(self):
        """Gets the account of this User.  # noqa: E501


        :return: The account of this User.  # noqa: E501
        :rtype: Account
        """
        return self._account

    @account.setter
    def account(self, account):
        """Sets the account of this User.


        :param account: The account of this User.  # noqa: E501
        :type account: Account
        """

        self._account = account

    @property
    def video_channels(self):
        """Gets the video_channels of this User.  # noqa: E501


        :return: The video_channels of this User.  # noqa: E501
        :rtype: list[VideoChannel]
        """
        return self._video_channels

    @video_channels.setter
    def video_channels(self, video_channels):
        """Sets the video_channels of this User.


        :param video_channels: The video_channels of this User.  # noqa: E501
        :type video_channels: list[VideoChannel]
        """

        self._video_channels = video_channels

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, User):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, User):
            return True

        return self.to_dict() != other.to_dict()
