# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class FileRedundancyInformation(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'file_url': 'str',
        'strategy': 'str',
        'size': 'int',
        'created_at': 'datetime',
        'updated_at': 'datetime',
        'expires_on': 'datetime'
    }

    attribute_map = {
        'id': 'id',
        'file_url': 'fileUrl',
        'strategy': 'strategy',
        'size': 'size',
        'created_at': 'createdAt',
        'updated_at': 'updatedAt',
        'expires_on': 'expiresOn'
    }

    def __init__(self, id=None, file_url=None, strategy=None, size=None, created_at=None, updated_at=None, expires_on=None, local_vars_configuration=None):  # noqa: E501
        """FileRedundancyInformation - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._file_url = None
        self._strategy = None
        self._size = None
        self._created_at = None
        self._updated_at = None
        self._expires_on = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if file_url is not None:
            self.file_url = file_url
        if strategy is not None:
            self.strategy = strategy
        if size is not None:
            self.size = size
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at
        if expires_on is not None:
            self.expires_on = expires_on

    @property
    def id(self):
        """Gets the id of this FileRedundancyInformation.  # noqa: E501


        :return: The id of this FileRedundancyInformation.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this FileRedundancyInformation.


        :param id: The id of this FileRedundancyInformation.  # noqa: E501
        :type id: int
        """

        self._id = id

    @property
    def file_url(self):
        """Gets the file_url of this FileRedundancyInformation.  # noqa: E501


        :return: The file_url of this FileRedundancyInformation.  # noqa: E501
        :rtype: str
        """
        return self._file_url

    @file_url.setter
    def file_url(self, file_url):
        """Sets the file_url of this FileRedundancyInformation.


        :param file_url: The file_url of this FileRedundancyInformation.  # noqa: E501
        :type file_url: str
        """

        self._file_url = file_url

    @property
    def strategy(self):
        """Gets the strategy of this FileRedundancyInformation.  # noqa: E501


        :return: The strategy of this FileRedundancyInformation.  # noqa: E501
        :rtype: str
        """
        return self._strategy

    @strategy.setter
    def strategy(self, strategy):
        """Sets the strategy of this FileRedundancyInformation.


        :param strategy: The strategy of this FileRedundancyInformation.  # noqa: E501
        :type strategy: str
        """
        allowed_values = ["manual", "most-views", "trending", "recently-added"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and strategy not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `strategy` ({0}), must be one of {1}"  # noqa: E501
                .format(strategy, allowed_values)
            )

        self._strategy = strategy

    @property
    def size(self):
        """Gets the size of this FileRedundancyInformation.  # noqa: E501


        :return: The size of this FileRedundancyInformation.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this FileRedundancyInformation.


        :param size: The size of this FileRedundancyInformation.  # noqa: E501
        :type size: int
        """

        self._size = size

    @property
    def created_at(self):
        """Gets the created_at of this FileRedundancyInformation.  # noqa: E501


        :return: The created_at of this FileRedundancyInformation.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this FileRedundancyInformation.


        :param created_at: The created_at of this FileRedundancyInformation.  # noqa: E501
        :type created_at: datetime
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this FileRedundancyInformation.  # noqa: E501


        :return: The updated_at of this FileRedundancyInformation.  # noqa: E501
        :rtype: datetime
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this FileRedundancyInformation.


        :param updated_at: The updated_at of this FileRedundancyInformation.  # noqa: E501
        :type updated_at: datetime
        """

        self._updated_at = updated_at

    @property
    def expires_on(self):
        """Gets the expires_on of this FileRedundancyInformation.  # noqa: E501


        :return: The expires_on of this FileRedundancyInformation.  # noqa: E501
        :rtype: datetime
        """
        return self._expires_on

    @expires_on.setter
    def expires_on(self, expires_on):
        """Sets the expires_on of this FileRedundancyInformation.


        :param expires_on: The expires_on of this FileRedundancyInformation.  # noqa: E501
        :type expires_on: datetime
        """

        self._expires_on = expires_on

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FileRedundancyInformation):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, FileRedundancyInformation):
            return True

        return self.to_dict() != other.to_dict()
