"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CommandError = exports.OutCommandType = exports.READ_BUFFER_MAGIC_BYTES = exports.InCommandType = exports.HEARTBEAT_EVERY_MS = exports.REDIS_IRC_CLIENT_STATE_KEY = exports.REDIS_IRC_POOL_CONNECTIONS = exports.REDIS_IRC_POOL_COMMAND_OUT_STREAM_LAST_READ = exports.REDIS_IRC_POOL_COMMAND_IN_STREAM = exports.REDIS_IRC_POOL_COMMAND_OUT_STREAM = exports.REDIS_IRC_POOL_HEARTBEAT_KEY = exports.REDIS_IRC_POOL_VERSION_KEY = exports.PROTOCOL_VERSION = void 0;
/**
 * This number states the current protocol version of the pool. This
 * should be incremented by developers when an incompatibile change is
 * made to the pool and must be restarted for safe operation.
 */
exports.PROTOCOL_VERSION = 0;
exports.REDIS_IRC_POOL_VERSION_KEY = "ircbridge.poolversion";
exports.REDIS_IRC_POOL_HEARTBEAT_KEY = "ircbridge.pool.💓";
exports.REDIS_IRC_POOL_COMMAND_OUT_STREAM = "ircbridge.stream.command.out";
exports.REDIS_IRC_POOL_COMMAND_IN_STREAM = "ircbridge.stream.command.in";
exports.REDIS_IRC_POOL_COMMAND_OUT_STREAM_LAST_READ = "ircbridge.stream.out.command.last-read";
exports.REDIS_IRC_POOL_CONNECTIONS = "ircbridge.connections";
exports.REDIS_IRC_CLIENT_STATE_KEY = `ircbridge.clientstate`; //client-id
exports.HEARTBEAT_EVERY_MS = 5000;
var InCommandType;
(function (InCommandType) {
    InCommandType["Connect"] = "connect";
    InCommandType["Destroy"] = "destroy";
    InCommandType["End"] = "end";
    InCommandType["SetTimeout"] = "set-timeout";
    InCommandType["Write"] = "write";
    InCommandType["ConnectionPing"] = "connection-ping";
    InCommandType["Ping"] = "ping";
})(InCommandType = exports.InCommandType || (exports.InCommandType = {}));
exports.READ_BUFFER_MAGIC_BYTES = Buffer.from('💾');
var OutCommandType;
(function (OutCommandType) {
    OutCommandType["Connected"] = "connected";
    OutCommandType["Error"] = "error";
    OutCommandType["Disconnected"] = "disconnected";
    OutCommandType["NotConnected"] = "not-connected";
    OutCommandType["Pong"] = "pong";
    OutCommandType["PoolClosing"] = "poolclosing";
    // Read = "read", -> This is actually sent as
    // ClientId:Buffer to prevent having to parse the buffer into JSON and back again.
})(OutCommandType = exports.OutCommandType || (exports.OutCommandType = {}));
class CommandError extends Error {
    constructor(message, commandType) {
        super(`Failed to handle command ${commandType}: ${message}`);
    }
}
exports.CommandError = CommandError;
//# sourceMappingURL=types.js.map