/*
 * Copyright (C) 2020 UBports
 *
 * This file is part of Ubuntu Weather App
 *
 * Ubuntu Weather App is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * Ubuntu Weather App is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.4
import Ubuntu.Components 1.3
import "../../components"

Item {
    id: unitsPage
    height: rainSetting.height

    ListModel {
        id: rainSpeedModel
        Component.onCompleted: initialize()
        function initialize() {
            // TRANSLATORS: millimeter, metric unit for rain/snow given as millimeter per hour, only use abbreviated
            rainSpeedModel.append({"text": i18n.tr("mm"), "value": "mm"})

            // TRANSLATORS: inch, imperial unit for rain/snow given as inch per hour, only use abbreviated
            rainSpeedModel.append({"text": i18n.tr("in"), "value": "in"})
        }
    }

    ExpandableListItem {
        id: rainSetting
        objectName: "rainSetting"

        listViewHeight: rainSpeedModel.count*units.gu(6.1)
        model: rainSpeedModel
        title.text: i18n.tr("Rain volume unit")
        subText.text: i18n.tr(settings.precipUnits)

        delegate: StandardListItem {
            title.text: model.text
            icon.name: "ok"
            icon.visible: settings.precipUnits === model.value

            onClicked: {
                settings.precipUnits = model.value
                refreshData(true);
                rainSetting.toggleExpansion();
            }
        }

    }
}
