/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.environments.remote;

import com.sun.star.lib.uno.environments.remote.IReceiver;
import com.sun.star.lib.uno.environments.remote.Message;
import com.sun.star.lib.uno.environments.remote.ThreadId;
import com.sun.star.lib.uno.typedesc.MethodDescription;
import com.sun.star.uno.Any;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XCurrentContext;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;

public class Job {
    protected IReceiver _iReceiver;
    protected Message _iMessage;
    Object _disposeId;
    protected Object _object;

    public Job(Object object, IReceiver iReceiver, Message iMessage) {
        this._object = object;
        this._iReceiver = iReceiver;
        this._iMessage = iMessage;
    }

    protected Object dispatch_queryInterface(Type type) {
        Class<?> zInterface = type.getTypeDescription().getZClass();
        Any result = null;
        Object face = UnoRuntime.queryInterface(zInterface, this._object);
        if (face != null) {
            result = new Any(type, face);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute() throws Throwable {
        if (this._iMessage.isRequest()) {
            Object result = null;
            Throwable exception = null;
            MethodDescription md = this._iMessage.getMethod();
            Object[] args = this._iMessage.getArguments();
            XCurrentContext oldCC = UnoRuntime.getCurrentContext();
            UnoRuntime.setCurrentContext(this._iMessage.getCurrentContext());
            try {
                result = md.getIndex() == 0 ? this.dispatch_queryInterface((Type)args[0]) : md.getMethod().invoke(this._object, args);
            }
            catch (InvocationTargetException e) {
                exception = e.getCause();
                if (exception == null) {
                    exception = e;
                }
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                UnoRuntime.setCurrentContext(oldCC);
            }
            if (this._iMessage.isSynchronous()) {
                if (exception == null) {
                    this._iReceiver.sendReply(false, this._iMessage.getThreadId(), result);
                } else {
                    if (!(exception instanceof com.sun.star.uno.Exception) && !(exception instanceof RuntimeException)) {
                        StringWriter writer = new StringWriter();
                        exception.printStackTrace(new PrintWriter(writer));
                        exception = new RuntimeException("Java exception: <" + writer + ">", (Object)null);
                    }
                    this._iReceiver.sendReply(true, this._iMessage.getThreadId(), exception);
                }
            }
            return null;
        }
        if (this._iMessage.isAbnormalTermination()) {
            throw this.remoteUnoRequestRaisedException(this._iMessage.getResult());
        }
        return this._iMessage.getResult();
    }

    public ThreadId getThreadId() {
        return this._iMessage.getThreadId();
    }

    public boolean isRequest() {
        return this._iMessage.isRequest();
    }

    public boolean isSynchronous() {
        return this._iMessage.isSynchronous();
    }

    public void dispose() {
    }

    private Exception remoteUnoRequestRaisedException(Object exception) {
        Exception e = (Exception)exception;
        e.fillInStackTrace();
        return e;
    }
}

