/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.psiUtil;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\r"}, d2={"MESSAGE_FOR_YIELD_BEFORE_LAMBDA", "", "getMESSAGE_FOR_YIELD_BEFORE_LAMBDA", "()Ljava/lang/String;", "checkReservedYield", "", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "sink", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "checkReservedYieldBeforeLambda", "element", "Lcom/intellij/psi/PsiElement;", "frontend"})
public final class ReservedCheckingKt {
    @NotNull
    private static final String MESSAGE_FOR_YIELD_BEFORE_LAMBDA = "Reserved yield block/lambda. Use 'yield() { ... }' or 'yield(fun...)'";

    public static final void checkReservedYield(@Nullable KtSimpleNameExpression expression2, @NotNull DiagnosticSink sink) {
        Intrinsics.checkNotNullParameter(sink, "sink");
        KtSimpleNameExpression ktSimpleNameExpression = expression2;
        if (!Intrinsics.areEqual(ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedName() : null, "yield")) {
            return;
        }
        PsiElement psiElement = expression2.getIdentifier();
        if (psiElement == null) {
            return;
        }
        PsiElement identifier = psiElement;
        if (Intrinsics.areEqual(identifier.getNode().getElementType(), KtTokens.IDENTIFIER) && Intrinsics.areEqual("yield", identifier.getText())) {
            sink.report(Errors.YIELD_IS_RESERVED.on(identifier, "Identifier 'yield' is reserved. Use backticks to call it: `yield`"));
        }
    }

    @NotNull
    public static final String getMESSAGE_FOR_YIELD_BEFORE_LAMBDA() {
        return MESSAGE_FOR_YIELD_BEFORE_LAMBDA;
    }

    public static final void checkReservedYieldBeforeLambda(@NotNull PsiElement element, @NotNull DiagnosticSink sink) {
        block0: {
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(sink, "sink");
            PsiElement psiElement = KtPsiUtil.getPreviousWord(element, "yield");
            if (psiElement == null) break block0;
            PsiElement it = psiElement;
            boolean bl = false;
            sink.report(Errors.YIELD_IS_RESERVED.on(it, MESSAGE_FOR_YIELD_BEFORE_LAMBDA));
        }
    }
}

