/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.specialized;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.me.qmx.jitescript.CodeBlock;
import org.jruby.me.qmx.jitescript.JDKVersion;
import org.jruby.me.qmx.jitescript.JiteClass;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.tree.LabelNode;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ClassDefiningClassLoader;
import org.jruby.util.CodegenUtils;
import org.jruby.util.OneShotClassLoader;
import org.jruby.util.cli.Options;
import org.jruby.util.collections.NonBlockingHashMapLong;

public class RubyObjectSpecializer {
    public static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final NonBlockingHashMapLong<ClassAndAllocator> SPECIALIZED_CLASSES = new NonBlockingHashMapLong();
    private static final ClassDefiningClassLoader LOADER = new OneShotClassLoader(Ruby.getClassLoader());

    private static ClassAndAllocator getClassForSize(int size2) {
        return SPECIALIZED_CLASSES.get(size2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectAllocator specializeForVariables(RubyClass klass, Set<String> foundVariables) {
        int size2 = foundVariables.size();
        size2 = Math.min(size2, Options.REIFY_VARIABLES_MAX.load());
        ClassAndAllocator cna = null;
        String className = null;
        if (Options.REIFY_VARIABLES_NAME.load().booleanValue()) {
            className = klass.getName();
            className = className.startsWith("#") ? "Anonymous" + Integer.toHexString(System.identityHashCode(klass)) : className.replace("::", "/");
        } else {
            cna = RubyObjectSpecializer.getClassForSize(size2);
            if (cna == null) {
                className = "RubyObject" + size2;
            }
        }
        if (className != null) {
            String clsPath = "org/jruby/gen/" + className;
            ClassDefiningClassLoader classDefiningClassLoader = LOADER;
            synchronized (classDefiningClassLoader) {
                Class<?> specialized;
                try {
                    specialized = LOADER.loadClass(clsPath.replace('/', '.'));
                }
                catch (ClassNotFoundException cnfe) {
                    specialized = RubyObjectSpecializer.generateInternal(size2, clsPath);
                }
                try {
                    ObjectAllocator allocator = (ObjectAllocator)specialized.getDeclaredClasses()[0].getConstructor(new Class[0]).newInstance(new Object[0]);
                    cna = new ClassAndAllocator(specialized, allocator);
                    if (!Options.REIFY_VARIABLES_NAME.load().booleanValue()) {
                        SPECIALIZED_CLASSES.put(size2, cna);
                    }
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
        }
        try {
            int offset2 = 0;
            for (String name2 : foundVariables) {
                klass.getVariableTableManager().getVariableAccessorForRubyVar(name2, LOOKUP.findGetter(cna.cls, "var" + offset2, Object.class), LOOKUP.findSetter(cna.cls, "var" + offset2, Object.class));
                if (++offset2 < size2) continue;
                break;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        klass.setReifiedClass(cna.cls);
        klass.setAllocator(cna.allocator);
        return cna.allocator;
    }

    private static Class generateInternal(final int size2, final String clsPath) {
        final String baseName = CodegenUtils.p(RubyObject.class);
        JiteClass jiteClass = new JiteClass(clsPath, baseName, new String[0]){
            {
                super(x0, x1, x2);
                int i2 = 0;
                while (i2 < size2) {
                    int offset2 = i2++;
                    this.defineField("var" + offset2, 1, CodegenUtils.ci(Object.class), null);
                }
                this.defineMethod("<init>", 1, CodegenUtils.sig(Void.TYPE, Ruby.class, RubyClass.class), new CodeBlock(){
                    {
                        this.aload(0);
                        this.aload(1);
                        this.aload(2);
                        this.invokespecial(baseName, "<init>", CodegenUtils.sig(Void.TYPE, Ruby.class, RubyClass.class));
                        this.voidreturn();
                    }
                });
                this.defineMethod("getVariable", 1, CodegenUtils.sig(Object.class, Integer.TYPE), new CodeBlock(){
                    {
                        LabelNode parentCall = new LabelNode(new Label());
                        this.line(0);
                        if (size2 > 0) {
                            RubyObjectSpecializer.genGetSwitch(clsPath, size2, this, 1);
                        }
                        this.line(1);
                        this.aload(0);
                        this.iload(1);
                        this.invokespecial(CodegenUtils.p(RubyObject.class), "getVariable", CodegenUtils.sig(Object.class, Integer.TYPE));
                        this.areturn();
                    }
                });
                this.defineMethod("setVariable", 1, CodegenUtils.sig(Void.TYPE, Integer.TYPE, Object.class), new CodeBlock(){
                    {
                        LabelNode parentCall = new LabelNode(new Label());
                        this.line(2);
                        if (size2 > 0) {
                            RubyObjectSpecializer.genPutSwitch(clsPath, size2, this, 1);
                        }
                        this.line(3);
                        this.aload(0);
                        this.iload(1);
                        this.aload(2);
                        this.invokespecial(CodegenUtils.p(RubyObject.class), "setVariable", CodegenUtils.sig(Void.TYPE, Integer.TYPE, Object.class));
                        this.voidreturn();
                    }
                });
                this.addChildClass(new JiteClass(clsPath + "Allocator", CodegenUtils.p(Object.class), Helpers.arrayOf(CodegenUtils.p(ObjectAllocator.class))){
                    {
                        super(x0, x1, x2);
                        this.defineDefaultConstructor();
                        this.defineMethod("allocate", 1, CodegenUtils.sig(IRubyObject.class, Ruby.class, RubyClass.class), new CodeBlock(){
                            {
                                this.newobj(clsPath);
                                this.dup();
                                this.aload(1);
                                this.aload(2);
                                this.invokespecial(clsPath, "<init>", CodegenUtils.sig(Void.TYPE, Ruby.class, RubyClass.class));
                                this.areturn();
                            }
                        });
                    }
                });
            }
        };
        Class specializedClass = RubyObjectSpecializer.defineClass(jiteClass);
        RubyObjectSpecializer.defineClass(jiteClass.getChildClasses().get(0));
        return specializedClass;
    }

    private static void genGetSwitch(String clsPath, int size2, CodeBlock block, int offsetVar) {
        int i2;
        LabelNode defaultError = new LabelNode(new Label());
        LabelNode[] cases = new LabelNode[size2];
        for (i2 = 0; i2 < size2; ++i2) {
            cases[i2] = new LabelNode(new Label());
        }
        block.iload(offsetVar);
        block.tableswitch(0, size2 - 1, defaultError, cases);
        for (i2 = 0; i2 < size2; ++i2) {
            block.label(cases[i2]);
            block.aload(0);
            block.getfield(clsPath, "var" + i2, CodegenUtils.ci(Object.class));
            block.areturn();
        }
        block.label(defaultError);
    }

    private static void genPutSwitch(String clsPath, int size2, CodeBlock block, int offsetVar) {
        int i2;
        LabelNode defaultError = new LabelNode(new Label());
        LabelNode[] cases = new LabelNode[size2];
        for (i2 = 0; i2 < size2; ++i2) {
            cases[i2] = new LabelNode(new Label());
        }
        block.iload(offsetVar);
        block.tableswitch(0, size2 - 1, defaultError, cases);
        for (i2 = 0; i2 < size2; ++i2) {
            block.label(cases[i2]);
            block.aload(0);
            block.aload(2);
            block.putfield(clsPath, "var" + i2, CodegenUtils.ci(Object.class));
            block.voidreturn();
        }
        block.label(defaultError);
    }

    private static Class defineClass(JiteClass jiteClass) {
        return LOADER.defineClass(RubyObjectSpecializer.classNameFromJiteClass(jiteClass), jiteClass.toBytes(JDKVersion.V1_8));
    }

    private static String classNameFromJiteClass(JiteClass jiteClass) {
        return jiteClass.getClassName().replace('/', '.');
    }

    static class ClassAndAllocator {
        final Class cls;
        final ObjectAllocator allocator;

        ClassAndAllocator(Class cls, ObjectAllocator allocator) {
            this.cls = cls;
            this.allocator = allocator;
        }
    }
}

