/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import javajs.util.BS;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.SymmetryInterface;
import org.jmol.shape.FontLineShape;
import org.jmol.util.Escape;
import org.jmol.util.Font;
import org.jmol.viewer.JC;

public class Axes
extends FontLineShape {
    public P3 axisXY = new P3();
    public float scale;
    public P3 fixedOrigin;
    public final P3 originPoint = new P3();
    public final P3[] axisPoints = new P3[6];
    public String[] labels;
    public String axisType;
    public String axes2;
    private static final float MIN_AXIS_LEN = 1.5f;
    private final P3 pt0;
    public final P3 fixedOriginUC;
    V3 corner;

    public Axes() {
        int i = 6;
        while (--i >= 0) {
            this.axisPoints[i] = new P3();
        }
        this.pt0 = new P3();
        this.fixedOriginUC = new P3();
        this.corner = new V3();
    }

    @Override
    public void setProperty(String propertyName, Object value, BS bs) {
        if ("position" == propertyName) {
            boolean doSetScale = this.axisXY.z == 0.0f && ((P3)value).z != 0.0f;
            this.axisXY = (P3)value;
            this.setScale(doSetScale ? 1.0f : this.scale);
            return;
        }
        if ("origin" == propertyName) {
            if (value == null || ((P3)value).length() == 0.0f) {
                this.fixedOrigin = null;
            } else {
                if (this.fixedOrigin == null) {
                    this.fixedOrigin = new P3();
                }
                this.fixedOrigin.setT((P3)value);
            }
            this.reinitShape();
            return;
        }
        if ("labels" == propertyName) {
            this.labels = (String[])value;
            return;
        }
        if ("labelsOn" == propertyName) {
            this.labels = null;
            return;
        }
        if ("labelsOff" == propertyName) {
            this.labels = new String[]{"", "", ""};
            return;
        }
        if ("type" == propertyName) {
            this.axisType = (String)value;
            if ("abc".equals(this.axisType)) {
                this.axisType = null;
            }
        }
        if ("axes2" == propertyName) {
            this.axes2 = value == null || value.equals("") ? null : (String)value;
            return;
        }
        this.setPropFLS(propertyName, value);
    }

    @Override
    public void initShape() {
        this.translucentAllowed = false;
        this.myType = "axes";
        this.font3d = this.vwr.gdata.getFont3D(16.0f);
        this.setPoints(this.vwr.g.axesMode);
    }

    public void setPoints(int axesMode) {
        SymmetryInterface unitcell;
        if (axesMode != 0x24000020 || this.ms.unitCells == null || (unitcell = this.vwr.getCurrentUnitCell()) == null) {
            this.originPoint.setT(this.fixedOrigin != null ? this.fixedOrigin : (axesMode == 603979809 ? this.vwr.getBoundBoxCenter() : this.pt0));
            this.setScale(this.vwr.getFloat(0x22000002) / 2.0f);
            return;
        }
        T3 fset = unitcell.getUnitCellMultiplier();
        unitcell = unitcell.getUnitCellMultiplied();
        float voffset = this.vwr.getFloat(0x22000001);
        this.fixedOriginUC.set(voffset, voffset, voffset);
        P3 offset = unitcell.getCartesianOffset();
        P3[] vertices = unitcell.getUnitCellVerticesNoOffset();
        this.originPoint.add2(offset, vertices[0]);
        if (voffset != 0.0f) {
            unitcell.toCartesian(this.fixedOriginUC, false);
        } else if (this.fixedOrigin != null) {
            this.originPoint.setT(this.fixedOrigin);
        }
        if (voffset != 0.0f) {
            this.originPoint.add(this.fixedOriginUC);
        }
        float scale = this.scale = this.vwr.getFloat(0x22000002) / 2.0f;
        if (fset != null && fset.z > 0.0f) {
            scale *= Math.abs(fset.z);
        }
        this.axisPoints[0].scaleAdd2(scale, vertices[4], this.originPoint);
        this.axisPoints[1].scaleAdd2(scale, vertices[2], this.originPoint);
        this.axisPoints[2].scaleAdd2(scale, vertices[1], this.originPoint);
    }

    public void reinitShape() {
        Font f = this.font3d;
        this.initShape();
        if (f != null) {
            this.font3d = f;
        }
    }

    public P3 getAxisPoint(int i, boolean unscaled, P3 ptTemp) {
        if (unscaled) {
            ptTemp.setT(this.axisPoints[i]);
        } else {
            ptTemp.sub2(this.axisPoints[i], this.originPoint);
            ptTemp.scale(0.5f);
        }
        return ptTemp;
    }

    @Override
    public Object getProperty(String property, int index) {
        if (property == "origin") {
            return this.fixedOrigin;
        }
        if (property == "axesTypeXY") {
            return this.axisXY.z == 0.0f ? Boolean.FALSE : Boolean.TRUE;
        }
        return null;
    }

    void setScale(float scale) {
        this.scale = scale;
        this.corner.setT(this.vwr.getBoundBoxCornerVector());
        int i = 6;
        while (--i >= 0) {
            P3 axisPoint = this.axisPoints[i];
            axisPoint.setT(JC.unitAxisVectors[i]);
            if (this.corner.x < 1.5f) {
                this.corner.x = 1.5f;
            }
            if (this.corner.y < 1.5f) {
                this.corner.y = 1.5f;
            }
            if (this.corner.z < 1.5f) {
                this.corner.z = 1.5f;
            }
            if (this.axisXY.z == 0.0f) {
                axisPoint.x *= this.corner.x * scale;
                axisPoint.y *= this.corner.y * scale;
                axisPoint.z *= this.corner.z * scale;
            }
            axisPoint.add(this.originPoint);
        }
    }

    public String getAxesState(SB sb) {
        sb.append("  axes scale ").appendF(this.vwr.getFloat(0x22000002)).append(";\n");
        if (this.fixedOrigin != null) {
            sb.append("  axes center ").append(Escape.eP(this.fixedOrigin)).append(";\n");
        }
        if (this.axisXY.z != 0.0f) {
            sb.append("  axes position [").appendI((int)this.axisXY.x).append(" ").appendI((int)this.axisXY.y).append(" ").append(this.axisXY.z < 0.0f ? " %" : "").append("]");
        }
        if (this.axes2 != null) {
            sb.append(" ").append(PT.esc(this.axes2));
        }
        sb.append(";\n");
        if (this.labels != null) {
            sb.append("  axes labels ");
            for (int i = 0; i < this.labels.length; ++i) {
                if (this.labels[i] == null) continue;
                sb.append(PT.esc(this.labels[i])).append(" ");
            }
            sb.append(";\n");
        }
        if (this.axisType != null) {
            sb.append("  axes type " + PT.esc(this.axisType));
        }
        return sb.toString();
    }
}

