/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.A4;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.CU;
import javajs.util.DF;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.modelset.BondSet;
import org.jmol.script.SV;
import org.jmol.script.ScriptException;
import org.jmol.script.ScriptExpr;
import org.jmol.script.T;
import org.jmol.util.BSUtil;
import org.jmol.util.BoxInfo;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class ScriptMathProcessor {
    public boolean wasX;
    public boolean asBitSet;
    public int oPt = -1;
    private boolean chk;
    private boolean wasSyntaxCheck;
    private boolean debugHigh;
    private ScriptExpr eval;
    private Viewer vwr;
    private T[] oStack = new T[8];
    private SV[] xStack = new SV[8];
    private char[] ifStack = new char[8];
    private int ifPt = -1;
    private int xPt = -1;
    private int parenCount;
    private int squareCount;
    private int braceCount;
    private boolean isArrayItem;
    private boolean asVector;
    private boolean haveSpaceBeforeSquare;
    private int equalCount;
    private int ptid = 0;
    private int ptx = Integer.MAX_VALUE;
    private int pto = Integer.MAX_VALUE;
    private boolean isSpecialAssignment;
    private boolean doSelections = true;
    private boolean assignLeft;
    private boolean allowUnderflow;
    private boolean isAssignment;
    private boolean skipping;
    private SV lastAssignedString;
    private static final String qMods = " w:0 x:1 y:2 z:3 normal:4 eulerzxz:5 eulerzyz:6 vector:-1 theta:-2 axisx:-3 axisy:-4 axisz:-5 axisangle:-6 matrix:-9";

    ScriptMathProcessor(ScriptExpr eval, boolean isSpecialAssignment, boolean isArrayItem, boolean asVector, boolean asBitSet, boolean allowUnderflow, String key) {
        this.eval = eval;
        this.isSpecialAssignment = this.assignLeft = isSpecialAssignment;
        this.isAssignment = isSpecialAssignment || key != null;
        this.vwr = eval.vwr;
        this.debugHigh = eval.debugHigh;
        this.chk = this.wasSyntaxCheck = eval.chk;
        this.isArrayItem = isArrayItem;
        this.asVector = asVector || isArrayItem;
        this.asBitSet = asBitSet;
        this.allowUnderflow = allowUnderflow;
        this.wasX = isArrayItem;
        if (this.debugHigh) {
            Logger.debug("initialize RPN");
        }
    }

    public boolean endAssignment() {
        this.assignLeft = false;
        this.doSelections = false;
        return false;
    }

    SV getResult() throws ScriptException {
        boolean isOK = true;
        while (isOK && this.oPt >= 0 && this.oStack[this.oPt] != null) {
            isOK = this.operate();
        }
        if (isOK) {
            if (this.asVector) {
                if (this.isAssignment && (this.xPt > 0 && this.oPt < 0 || this.oPt >= 0 && this.oStack[this.oPt] != null)) {
                    this.eval.invArg();
                }
                Lst<SV> result = new Lst<SV>();
                for (int i = 0; i <= this.xPt; ++i) {
                    result.addLast(this.isSpecialAssignment ? this.xStack[i] : SV.selectItemVar(this.xStack[i]));
                }
                if (this.lastAssignedString != null) {
                    result.removeItemAt(0);
                    result.add(0, this.lastAssignedString);
                    this.lastAssignedString.intValue = this.xStack[0].intValue;
                }
                return SV.newV(135198, result);
            }
            if (this.xPt == 0) {
                SV x = this.xStack[0];
                if (this.chk) {
                    if (this.asBitSet) {
                        return SV.newV(10, new BS());
                    }
                    return x;
                }
                if (x.tok == 10 || x.tok == 7 || x.tok == 15 || x.tok == 4 || x.tok == 11 || x.tok == 12) {
                    x = SV.selectItemVar(x);
                }
                if (this.asBitSet && x.tok == 7) {
                    x = SV.newV(10, SV.unEscapeBitSetArray((Lst)x.value, false));
                }
                return x;
            }
        }
        if (!(this.allowUnderflow || this.xPt < 0 && this.oPt < 0)) {
            this.eval.invArg();
        }
        return null;
    }

    private void putX(SV x) {
        if (this.skipping) {
            return;
        }
        if (this.wasX) {
            try {
                this.addOp(T.tokenComma);
            }
            catch (ScriptException scriptException) {
                // empty catch block
            }
        }
        if (++this.xPt == this.xStack.length) {
            this.xStack = (SV[])AU.doubleLength(this.xStack);
        }
        if (this.xPt < 0) {
            System.out.println("testing scriptemaafe");
        }
        this.xStack[this.xPt] = x;
        this.ptx = ++this.ptid;
        if (this.debugHigh) {
            Logger.debug("\nputx= " + x + " ptx=" + this.ptid);
        }
    }

    private void putOp(T op) {
        if (++this.oPt >= this.oStack.length) {
            this.oStack = (T[])AU.doubleLength(this.oStack);
        }
        this.oStack[this.oPt] = op;
        this.pto = ++this.ptid;
        if (this.debugHigh) {
            Logger.debug("\nputop=" + op + " pto=" + this.ptid);
        }
    }

    private void putIf(char c) {
        if (++this.ifPt >= this.ifStack.length) {
            this.ifStack = (char[])AU.doubleLength(this.ifStack);
        }
        this.ifStack[this.ifPt] = c;
    }

    public boolean addXCopy(SV x) {
        switch (x.tok) {
            case 2: {
                x = SV.newI(x.intValue);
                break;
            }
            case 3: {
                x = SV.newV(3, x.value);
            }
        }
        return this.addX(x);
    }

    public boolean addX(SV x) {
        this.putX(x);
        this.wasX = true;
        return true;
    }

    public boolean addXObj(Object x) {
        SV v = SV.getVariable(x);
        if (v == null) {
            return false;
        }
        this.putX(v);
        this.wasX = true;
        return true;
    }

    public boolean addXStr(String x) {
        this.putX(SV.newS(x));
        this.wasX = true;
        return true;
    }

    public boolean addXBool(boolean x) {
        this.putX(SV.getBoolean(x));
        this.wasX = true;
        return true;
    }

    public boolean addXInt(int x) {
        this.putX(SV.newI(x));
        this.wasX = true;
        return true;
    }

    public boolean addXList(Lst<?> x) {
        this.putX(SV.getVariableList(x));
        this.wasX = true;
        return true;
    }

    public boolean addXMap(Map<String, ?> x) {
        this.putX(SV.getVariableMap(x));
        this.wasX = true;
        return true;
    }

    public boolean addXM3(M3 x) {
        this.putX(SV.newV(11, x));
        this.wasX = true;
        return true;
    }

    public boolean addXM4(M4 x) {
        this.putX(SV.newV(12, x));
        this.wasX = true;
        return true;
    }

    public boolean addXFloat(float x) {
        this.putX(SV.newF(x));
        this.wasX = true;
        return true;
    }

    public boolean addXBs(BS bs) {
        this.putX(SV.newV(10, bs));
        this.wasX = true;
        return true;
    }

    public boolean addXPt(P3 pt) {
        this.putX(SV.newV(8, pt));
        this.wasX = true;
        return true;
    }

    public boolean addXPt4(P4 pt) {
        this.putX(SV.newV(9, pt));
        this.wasX = true;
        return true;
    }

    public boolean addXNum(T x) throws ScriptException {
        SV v;
        if (x instanceof SV) {
            v = (SV)x;
        } else {
            switch (x.tok) {
                case 3: {
                    float f;
                    if (this.wasX && ((f = ((Float)x.value).floatValue()) < 0.0f || f == 0.0f && 1.0f / f == Float.NEGATIVE_INFINITY)) {
                        this.addOp(T.tokenMinus);
                        v = SV.newF(-f);
                        break;
                    }
                    v = SV.newV(3, x.value);
                    break;
                }
                default: {
                    int iv = x.intValue;
                    if (this.wasX && iv < 0) {
                        this.addOp(T.tokenMinus);
                        iv = -iv;
                    }
                    v = SV.newI(iv);
                }
            }
        }
        this.putX(v);
        this.wasX = true;
        return true;
    }

    public boolean addXAV(SV[] x) {
        this.putX(SV.getVariableAV(x));
        this.wasX = true;
        return true;
    }

    public boolean addXAD(double[] x) {
        this.putX(SV.getVariableAD(x));
        this.wasX = true;
        return true;
    }

    public boolean addXAS(String[] x) {
        this.putX(SV.getVariableAS(x));
        this.wasX = true;
        return true;
    }

    public boolean addXAI(int[] x) {
        this.putX(SV.getVariableAI(x));
        this.wasX = true;
        return true;
    }

    public boolean addXAII(int[][] x) {
        this.putX(SV.getVariableAII(x));
        this.wasX = true;
        return true;
    }

    public boolean addXAF(float[] x) {
        this.putX(SV.getVariableAF(x));
        this.wasX = true;
        return true;
    }

    public boolean addXAFF(float[][] x) {
        this.putX(SV.getVariableAFF(x));
        this.wasX = true;
        return true;
    }

    private static boolean isOpFunc(T op) {
        return op != null && (T.tokAttr(op.tok, 0x8000000) && op != T.tokenArraySquare || op.tok == 0x10001A01 && T.tokAttr(op.intValue, 0x8000000));
    }

    public boolean addOp(T op) throws ScriptException {
        return this.addOpAllowMath(op, true, 0);
    }

    boolean addOpAllowMath(T op, boolean allowMathFunc, int tokNext) throws ScriptException {
        boolean isMathFunc;
        boolean isDotSelector;
        if (this.debugHigh) {
            this.dumpStacks("adding " + op + " wasx=" + this.wasX);
        }
        int tok0 = this.oPt >= 0 && this.oStack[this.oPt] != null ? this.oStack[this.oPt].tok : 0;
        boolean bl = this.skipping = this.ifPt >= 0 && (this.ifStack[this.ifPt] == 'F' || this.ifStack[this.ifPt] == 'X');
        if (this.skipping) {
            return this.checkSkip(op, tok0);
        }
        boolean bl2 = isDotSelector = op.tok == 0x10001A01;
        if (isDotSelector && !this.wasX) {
            return false;
        }
        boolean bl3 = isMathFunc = allowMathFunc && ScriptMathProcessor.isOpFunc(op);
        if (this.oPt >= 1 && op.tok != 0x10000200 && tok0 == 134217750) {
            tok0 = this.oStack[--this.oPt].tok;
        }
        T newOp = null;
        boolean isLeftOp = false;
        switch (op.tok) {
            case 1073742195: {
                this.haveSpaceBeforeSquare = true;
                return true;
            }
            case 0x10000600: {
                if (this.wasX) break;
                return false;
            }
            case 0x10001801: 
            case 268441602: {
                if (!this.wasX || op.intValue != -1 || !this.addOp(T.tokenComma)) break;
                return this.addOp(op);
            }
            case 0x10000801: {
                break;
            }
            case 0x10000201: {
                if (this.wasX || this.oPt < 1 || tok0 != 0x10000200 || ScriptMathProcessor.isOpFunc(this.oStack[this.oPt - 1])) break;
                return false;
            }
            case 0x10001400: {
                if (this.wasX) break;
                op = SV.newV(0x10001800, "-");
                break;
            }
            case 32: 
            case 64: 
            case 96: 
            case 128: 
            case 160: 
            case 192: 
            case 480: 
            case 1275068725: {
                int tok;
                int n = tok = this.oPt < 0 ? 0 : tok0;
                if (!this.wasX || tok != 0x10001A01 && tok != 1677721602 && tok != 1153433601) {
                    return false;
                }
                this.oStack[this.oPt].intValue |= op.tok;
                return true;
            }
            case 0x10000800: {
                isLeftOp = true;
                if (this.wasX && !this.haveSpaceBeforeSquare) break;
                ++this.squareCount;
                op = newOp = T.tokenArraySquare;
                this.haveSpaceBeforeSquare = false;
                break;
            }
            case 0x10000200: 
            case 0x10000E00: {
                isLeftOp = true;
            }
            default: {
                if (isMathFunc) {
                    boolean isArgument;
                    boolean bl4 = isArgument = this.oPt >= 1 && tok0 == 0x10000200;
                    if (isDotSelector ? tokNext == 0x10000200 && this.xStack[this.xPt].tok == 6 : this.wasX && !isArgument) {
                        return false;
                    }
                    newOp = op;
                    isLeftOp = true;
                    break;
                }
                if (this.wasX != isLeftOp || tok0 == 0x10001A01) break;
                if (!this.wasX || !allowMathFunc) {
                    return false;
                }
                if (!this.addOp(T.tokenComma)) break;
                return this.addOp(op);
            }
        }
        while (!(this.oPt < 0 || tok0 == 268436482 || (op.tok == 0x10001801 || op.tok == 268441602) && !this.wasX || isLeftOp && (tok0 != 0x10001A01 || op.tok != 0x10001A01 && op.tok != 0x10000800) || T.getPrecedence(tok0) < T.getPrecedence(op.tok) || tok0 == 0x10001800 && op.tok == 0x10001800)) {
            if (op.tok == 0x10000201 && tok0 == 0x10000200) {
                if (this.xPt >= 0) {
                    this.xStack[this.xPt] = SV.selectItemVar(this.xStack[this.xPt]);
                }
                this.wasX = true;
                break;
            }
            if (op.tok == 0x10000801 && tok0 == 1275068418) break;
            if (op.tok == 0x10000801 && tok0 == 0x10000800) {
                if (this.isArrayItem && this.squareCount == 1 && this.equalCount == 0) {
                    this.wasX = false;
                    this.addX(SV.newT(T.tokenArrayOpen));
                    break;
                }
                if (!this.doSelection()) {
                    return false;
                }
                this.wasX = true;
                break;
            }
            if (!this.operate()) {
                return false;
            }
            tok0 = this.oPt >= 0 && this.oStack[this.oPt] != null ? this.oStack[this.oPt].tok : 0;
        }
        if (newOp != null) {
            this.wasX = false;
            this.addX(SV.newV(268440324, newOp));
        }
        switch (op.tok) {
            case 0x10000200: {
                ++this.parenCount;
                this.wasX = false;
                break;
            }
            case 805307393: {
                boolean isFirst = this.getX().asBoolean();
                if (tok0 == 268436482) {
                    --this.ifPt;
                } else {
                    this.putOp(T.tokenColon);
                }
                this.putIf(isFirst ? (char)'T' : 'F');
                this.skipping = !isFirst;
                this.wasX = false;
                return true;
            }
            case 268436482: {
                if (tok0 != 268436482) {
                    return false;
                }
                if (this.ifPt < 0) {
                    return false;
                }
                this.ifStack[this.ifPt] = 88;
                this.wasX = false;
                this.skipping = true;
                return true;
            }
            case 0x10000201: {
                this.wasX = true;
                if (this.parenCount-- <= 0) {
                    return false;
                }
                if (tok0 == 268436482) {
                    --this.ifPt;
                    --this.oPt;
                }
                --this.oPt;
                if (this.oPt < 0) {
                    return true;
                }
                if (ScriptMathProcessor.isOpFunc(this.oStack[this.oPt])) {
                    this.wasX = false;
                    if (!this.evaluateFunction(0)) {
                        return false;
                    }
                }
                this.skipping = this.ifPt >= 0 && this.ifStack[this.ifPt] == 'X';
                return true;
            }
            case 0x10000600: {
                this.wasX = false;
                return true;
            }
            case 0x10000800: {
                ++this.squareCount;
                this.wasX = false;
                break;
            }
            case 0x10000801: {
                this.wasX = true;
                if (this.squareCount-- <= 0 || this.oPt < 0 || !this.doSelections) {
                    return !this.doSelections;
                }
                if (this.oStack[this.oPt].tok == 1275068418) {
                    return this.evaluateFunction(0x10000800);
                }
                --this.oPt;
                return true;
            }
            case 0x10001A01: {
                this.wasX = !allowMathFunc || !T.tokAttr(op.intValue, 0x8000000);
                break;
            }
            case 1073742332: {
                ++this.braceCount;
                this.wasX = false;
                break;
            }
            case 0x40000202: {
                if (this.braceCount-- <= 0) {
                    return false;
                }
                this.wasX = false;
                break;
            }
            case 0x10000A00: 
            case 0x10000C00: {
                if (!this.wasSyntaxCheck && this.xPt < 0) {
                    return false;
                }
                if (!this.wasSyntaxCheck && this.xStack[this.xPt].tok != 10 && this.xStack[this.xPt].tok != 7) {
                    boolean tf = this.getX().asBoolean();
                    this.addX(SV.getBoolean(tf));
                    if (tf == (op.tok == 0x10000A00)) {
                        this.chk = true;
                        op = op.tok == 0x10000A00 ? T.tokenOrTRUE : T.tokenAndFALSE;
                    }
                }
                this.wasX = false;
                break;
            }
            case 0x10001801: 
            case 268441602: {
                break;
            }
            case 268440324: {
                if (this.squareCount == 0) {
                    this.doSelections = true;
                    this.assignLeft = false;
                    ++this.equalCount;
                }
                this.wasX = false;
                break;
            }
            default: {
                this.wasX = false;
            }
        }
        this.putOp(op);
        switch (op.tok) {
            case 0x10001A01: {
                return (op.intValue & 0xFFFFFE1F) == 134320141 && op.intValue != 134320141 ? this.evaluateFunction(0) : true;
            }
            case 0x10001801: 
            case 268441602: {
                return this.wasX ? this.operate() : true;
            }
        }
        return true;
    }

    private boolean checkSkip(T op, int tok0) {
        switch (op.tok) {
            case 0x10000200: {
                this.putOp(op);
                break;
            }
            case 268436482: {
                if (tok0 != 268436482 || this.ifStack[this.ifPt] == 'X') break;
                this.ifStack[this.ifPt] = 84;
                this.wasX = false;
                this.skipping = false;
                break;
            }
            case 0x10000201: {
                if (tok0 == 0x10000200) {
                    --this.oPt;
                    break;
                }
                if (tok0 != 268436482) {
                    this.putOp(op);
                    break;
                }
                this.wasX = true;
                --this.ifPt;
                this.oPt -= 2;
                this.skipping = false;
            }
        }
        return true;
    }

    private boolean doSelection() {
        if (this.xPt < 0 || this.xPt == 0 && !this.isArrayItem) {
            return false;
        }
        SV var1 = this.xStack[this.xPt--];
        SV var = this.xStack[this.xPt];
        if ((var.tok == 7 || var.tok == 15) && var.intValue != Integer.MAX_VALUE && (var1.tok == 4 || this.assignLeft && this.squareCount == 1)) {
            this.xStack[this.xPt] = var = (SV)SV.selectItemTok(var, Integer.MIN_VALUE);
        }
        if (this.assignLeft && var.tok != 4) {
            this.lastAssignedString = null;
        }
        switch (var.tok) {
            case 6: 
            case 14: {
                if (this.doSelections) {
                    SV v = var.mapValue(SV.sValue(var1));
                    this.xStack[this.xPt] = v == null ? SV.newS("") : v;
                } else {
                    ++this.xPt;
                    this.putOp(null);
                }
                return true;
            }
            default: {
                var = SV.newS(SV.sValue(var));
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
        }
        if (this.doSelections || var.tok == 7 && var.intValue == Integer.MAX_VALUE) {
            this.xStack[this.xPt] = (SV)SV.selectItemTok(var, var1.asInt());
            if (this.assignLeft && var.tok == 4 && this.squareCount == 1) {
                this.lastAssignedString = var;
            }
        } else {
            ++this.xPt;
        }
        if (!this.doSelections) {
            this.putOp(null);
        }
        return true;
    }

    void dumpStacks(String message) {
        int i;
        Logger.debug("\n\n------------------\nRPN stacks: " + message + "\n");
        for (i = 0; i <= this.xPt; ++i) {
            Logger.debug("x[" + i + "]: " + this.xStack[i]);
        }
        Logger.debug("\n");
        for (i = 0; i <= this.oPt; ++i) {
            Logger.debug("o[" + i + "]: " + this.oStack[i] + " prec=" + (this.oStack[i] == null ? "--" : "" + T.getPrecedence(this.oStack[i].tok)));
        }
        Logger.debug(" ifStack = " + new String(this.ifStack).substring(0, this.ifPt + 1));
    }

    public SV getX() throws ScriptException {
        if (this.xPt < 0) {
            this.eval.error(13);
        }
        SV v = SV.selectItemVar(this.xStack[this.xPt]);
        this.xStack[this.xPt--] = null;
        this.wasX = false;
        return v;
    }

    public int getXTok() {
        return this.xPt < 0 ? 0 : this.xStack[this.xPt].tok;
    }

    private boolean evaluateFunction(int tok) throws ScriptException {
        T op = this.oStack[this.oPt--];
        if (tok == 0) {
            tok = op.tok == 0x10001A01 ? op.intValue & 0xFFFFFE1F : op.tok;
        }
        int nParamMax = T.getMaxMathParams(tok);
        int nParam = 0;
        int pt = this.xPt;
        while (pt >= 0 && this.xStack[pt--].value != op) {
            ++nParam;
        }
        if (nParamMax > 0 && nParam > nParamMax) {
            return false;
        }
        SV[] args = new SV[nParam];
        int i = nParam;
        while (--i >= 0) {
            args[i] = this.getX();
        }
        --this.xPt;
        if (!this.chk) {
            return this.eval.getMathExt().evaluate(this, op, args, tok);
        }
        if (op.tok == 0x10001A01) {
            --this.xPt;
        }
        if (this.xPt < 0) {
            this.xPt = 0;
        }
        switch (tok) {
            case 0x8000008: 
            case 134217759: 
            case 0x8000404: 
            case 134218757: 
            case 134353926: 
            case 1275203608: {
                return this.addXBs(new BS());
            }
        }
        return this.addXBool(true);
    }

    private boolean operate() throws ScriptException {
        SV x2;
        T op = this.oStack[this.oPt--];
        if (this.debugHigh) {
            this.dumpStacks("operate: " + op);
        }
        if (op.tok == 268440324 && (this.isArrayItem && this.squareCount == 0 && this.equalCount == 1 && this.oPt < 0 || this.oPt >= 0 && this.oStack[this.oPt] == null)) {
            return true;
        }
        switch (op.tok) {
            case 0x10001801: 
            case 268441602: {
                if (this.xPt >= 0 && this.xStack[this.xPt].canIncrement()) {
                    x2 = this.xStack[this.xPt--];
                    this.wasX = false;
                    break;
                }
            }
            default: {
                x2 = this.getX();
            }
        }
        if (x2 == T.tokenArrayOpen) {
            return false;
        }
        switch (op.tok) {
            case 0x10001801: 
            case 268441602: {
                SV x1 = x2;
                if (!this.chk) {
                    if (this.ptx < this.pto) {
                        x1 = SV.newS("").setv(x2);
                    }
                    if (!x2.increment(op.tok == 268441602 ? 1 : -1)) {
                        return false;
                    }
                    if (this.ptx > this.pto) {
                        x1 = SV.newS("").setv(x2);
                    }
                }
                this.wasX = false;
                this.putX(x1);
                this.wasX = true;
                return true;
            }
            case 0x10001800: {
                switch (x2.tok) {
                    case 2: {
                        return this.addXInt(-x2.asInt());
                    }
                    case 8: {
                        P3 pt = P3.newP((P3)x2.value);
                        pt.scale(-1.0f);
                        return this.addXPt(pt);
                    }
                    case 9: {
                        P4 pt4 = P4.newPt((P4)x2.value);
                        pt4.scale4(-1.0f);
                        return this.addXPt4(pt4);
                    }
                    case 11: {
                        M3 m = M3.newM3((M3)x2.value);
                        m.transpose();
                        return this.addXM3(m);
                    }
                    case 12: {
                        M4 m4 = M4.newM4((M4)x2.value);
                        m4.transpose();
                        return this.addXM4(m4);
                    }
                    case 10: {
                        return this.addXBs(BSUtil.copyInvert((BS)x2.value, x2.value instanceof BondSet ? this.vwr.ms.bondCount : this.vwr.ms.ac));
                    }
                }
                return this.addXFloat(-x2.asFloat());
            }
            case 0x10000E00: {
                if (this.chk) {
                    return this.addXBool(true);
                }
                switch (x2.tok) {
                    case 9: {
                        return this.addXPt4(Quat.newP4((P4)x2.value).inv().toPoint4f());
                    }
                    case 11: {
                        M3 m = M3.newM3((M3)x2.value);
                        m.invert();
                        return this.addXM3(m);
                    }
                    case 12: {
                        return this.addXM4(M4.newM4((M4)x2.value).invert());
                    }
                    case 10: {
                        boolean isBond = x2.value instanceof BondSet;
                        BS bs = BSUtil.copyInvert((BS)x2.value, isBond ? this.vwr.ms.bondCount : this.vwr.ms.ac);
                        return this.addXBs(isBond ? BondSet.newBS(bs) : bs);
                    }
                }
                return this.addXBool(!x2.asBoolean());
            }
            case 0x10001A01: {
                int iv;
                int n = iv = op.intValue == 805307393 ? 805307393 : op.intValue & 0xFFFFFE1F;
                if (this.chk) {
                    return this.addXObj(SV.newS(""));
                }
                if (this.vwr.allowArrayDotNotation) {
                    block23 : switch (x2.tok) {
                        case 6: 
                        case 14: {
                            switch (iv) {
                                case 0x44000006: 
                                case 0x44000008: 
                                case 1140850706: 
                                case 1275068418: {
                                    break block23;
                                }
                            }
                            SV ret = x2.mapValue((String)op.value);
                            return this.addXObj(ret == null ? SV.newS("") : ret);
                        }
                    }
                }
                switch (iv) {
                    case 1275068418: {
                        return this.addX(x2.toArray());
                    }
                    case 805307393: 
                    case 0x40000000: {
                        return x2.tok == 10 && (this.chk ? this.addXStr("") : this.getAllProperties(x2, (String)op.value));
                    }
                    case 0x44000008: {
                        return this.addXStr(ScriptMathProcessor.typeOf(x2));
                    }
                    case 1140850706: {
                        String[] keys = x2.getKeys((op.intValue & 0x1E0) == 480);
                        return keys == null ? this.addXStr("") : this.addXAS(keys);
                    }
                    case 0x44000003: {
                        if (x2.tok == 8) {
                            return this.addXFloat(((T3)x2.value).distance(SV.pt0));
                        }
                    }
                    case 0x44000006: 
                    case 1275068425: {
                        if (iv == 0x44000003 && x2.value instanceof BondSet) break;
                        return this.addXInt(SV.sizeOf(x2));
                    }
                    case 0x44000004: {
                        String s;
                        switch (x2.tok) {
                            case 11: 
                            case 12: {
                                s = SV.sValue(x2);
                                s = PT.rep(s.substring(1, s.length() - 1), "],[", "]\n[");
                                break;
                            }
                            case 4: {
                                s = (String)x2.value;
                                break;
                            }
                            default: {
                                s = SV.sValue(x2);
                            }
                        }
                        s = PT.rep(s, "\n\r", "\n").replace('\r', '\n');
                        return this.addXAS(PT.split(s, "\n"));
                    }
                    case 1765808134: {
                        switch (x2.tok) {
                            case 4: 
                            case 7: {
                                return this.addXPt(CU.colorPtFromString(SV.sValue(x2)));
                            }
                            case 2: 
                            case 3: {
                                return this.addXPt(this.vwr.getColorPointForPropertyValue(SV.fValue(x2)));
                            }
                            case 8: {
                                return this.addXStr(Escape.escapeColor(CU.colorPtToFFRGB((P3)x2.value)));
                            }
                        }
                        break;
                    }
                    case 1812599299: {
                        return this.chk ? this.addXStr("x") : this.getBoundBox(x2);
                    }
                }
                if (this.chk) {
                    return this.addXStr(SV.sValue(x2));
                }
                if (x2.tok == 4) {
                    Object v = SV.unescapePointOrBitsetAsVariable(SV.sValue(x2));
                    if (!(v instanceof SV)) {
                        return false;
                    }
                    x2 = (SV)v;
                }
                if (op.tok == x2.tok) {
                    x2 = this.getX();
                }
                return this.getPointOrBitsetOperation(op, x2);
            }
        }
        SV x1 = this.getX();
        if (this.chk) {
            if (op == T.tokenAndFALSE || op == T.tokenOrTRUE) {
                this.chk = false;
            }
            return this.addX(SV.newT(x1));
        }
        return this.binaryOp(op, x1, x2);
    }

    public boolean binaryOp(T op, SV x1, SV x2) throws ScriptException {
        switch (op.tok) {
            case 0x10000C00: 
            case 0x10001000: {
                switch (x1.tok) {
                    case 10: {
                        BS bs = (BS)x1.value;
                        switch (x2.tok) {
                            case 2: {
                                int x = x2.asInt();
                                return this.addXBool(x < 0 ? false : bs.get(x));
                            }
                            case 10: {
                                bs = BSUtil.copy(bs);
                                bs.and((BS)x2.value);
                                return this.addXBs(x1.value instanceof BondSet ? BondSet.newBS(bs) : bs);
                            }
                        }
                    }
                }
                return this.addXBool(x1.asBoolean() && x2.asBoolean());
            }
            case 0x10000A00: {
                switch (x1.tok) {
                    case 10: {
                        BS bs = null;
                        switch (x2.tok) {
                            case 10: {
                                bs = BSUtil.copy((BS)x1.value);
                                bs.or((BS)x2.value);
                                break;
                            }
                            case 2: {
                                bs = BSUtil.copy((BS)x1.value);
                                int x = x2.asInt();
                                if (x < 0) break;
                                bs.set(x);
                                break;
                            }
                            case 7: {
                                bs = BSUtil.copy((BS)x1.value);
                                Lst sv = (Lst)x2.value;
                                int i = sv.size();
                                while (--i >= 0) {
                                    int b = ((SV)sv.get(i)).asInt();
                                    if (b < 0) continue;
                                    bs.set(b);
                                }
                                break;
                            }
                        }
                        if (bs == null) break;
                        return this.addXBs(x1.value instanceof BondSet ? BondSet.newBS(bs) : bs);
                    }
                    case 7: {
                        return this.addX(SV.concatList(x1, x2, false));
                    }
                }
                return this.addXBool(x1.asBoolean() || x2.asBoolean());
            }
            case 0x10000A01: {
                if (x1.tok == 10 && x2.tok == 10) {
                    BS bs = BSUtil.copy((BS)x1.value);
                    bs.xor((BS)x2.value);
                    return this.addXBs(x1.value instanceof BondSet ? BondSet.newBS(bs) : bs);
                }
                boolean a = x1.asBoolean();
                boolean b = x2.asBoolean();
                return this.addXBool(a && !b || b && !a);
            }
            case 268438018: {
                if (x1.tok != 10 || x2.tok != 10) {
                    return false;
                }
                return this.addXBs(BSUtil.toggleInPlace(BSUtil.copy((BS)x1.value), (BS)x2.value));
            }
            case 268440322: {
                return this.addXBool(x1.tok == 2 && x2.tok == 2 ? x1.intValue <= x2.intValue : x1.isNaN() && x2.isNaN() || x1.asFloat() <= x2.asFloat());
            }
            case 0x10001301: {
                return this.addXBool(x1.tok == 2 && x2.tok == 2 ? x1.intValue >= x2.intValue : x1.isNaN() && x2.isNaN() || x1.asFloat() >= x2.asFloat());
            }
            case 0x10001300: {
                return this.addXBool(x1.tok == 2 && x2.tok == 2 ? x1.intValue > x2.intValue : x1.asFloat() > x2.asFloat());
            }
            case 0x10001303: {
                return this.addXBool(x1.tok == 2 && x2.tok == 2 ? x1.intValue < x2.intValue : x1.asFloat() < x2.asFloat());
            }
            case 268440324: {
                return this.addXBool(SV.areEqual(x1, x2));
            }
            case 268440325: {
                return this.addXBool(!SV.areEqual(x1, x2));
            }
            case 268440326: {
                return this.addXBool(SV.isLike(x1, x2));
            }
            case 0x10001401: {
                switch (x1.tok) {
                    case 6: {
                        Hashtable<String, SV> ht = new Hashtable<String, SV>((Map)x1.value);
                        Map<String, SV> map = x2.getMap();
                        if (map != null) {
                            ht.putAll(map);
                        }
                        return this.addX(SV.getVariableMap(ht));
                    }
                    case 2: {
                        if (this.isDecimal(x2)) break;
                        return this.addXInt(x1.intValue + x2.asInt());
                    }
                    case 4: {
                        return this.addX(SV.newS(SV.sValue(x1) + SV.sValue(x2)));
                    }
                    case 8: {
                        P3 pt = P3.newP((P3)x1.value);
                        switch (x2.tok) {
                            case 8: {
                                pt.add((P3)x2.value);
                                return this.addXPt(pt);
                            }
                            case 9: {
                                P4 pt4 = (P4)x2.value;
                                pt.add(P3.new3(pt4.x, pt4.y, pt4.z));
                                return this.addXPt(pt);
                            }
                        }
                        float f = x2.asFloat();
                        return this.addXPt(P3.new3(pt.x + f, pt.y + f, pt.z + f));
                    }
                    case 11: {
                        switch (x2.tok) {
                            case 11: {
                                M3 m = M3.newM3((M3)x1.value);
                                m.add((M3)x2.value);
                                return this.addXM3(m);
                            }
                            case 8: {
                                return this.addXM4(ScriptMathProcessor.getMatrix4f((M3)x1.value, (P3)x2.value));
                            }
                        }
                        break;
                    }
                    case 12: {
                        switch (x2.tok) {
                            case 8: {
                                M4 m4b = M4.newM4((M4)x1.value);
                                m4b.add((T3)x2.value);
                                return this.addXM4(m4b);
                            }
                        }
                        break;
                    }
                    case 9: {
                        Quat q1 = Quat.newP4((P4)x1.value);
                        switch (x2.tok) {
                            default: {
                                return this.addXPt4(q1.add(x2.asFloat()).toPoint4f());
                            }
                            case 9: 
                        }
                        return this.addXPt4(q1.mulQ(Quat.newP4((P4)x2.value)).toPoint4f());
                    }
                    case 7: {
                        return this.addX(SV.concatList(x1, x2, true));
                    }
                }
                return this.addXFloat(x1.asFloat() + x2.asFloat());
            }
            case 0x10001400: {
                switch (x1.tok) {
                    case 2: {
                        if (this.isDecimal(x2)) break;
                        return this.addXInt(x1.intValue - x2.asInt());
                    }
                    case 4: {
                        if (this.isDecimal(x2) || this.isDecimal(x1)) break;
                        return this.addXInt(x1.asInt() - x2.asInt());
                    }
                    case 6: {
                        Hashtable ht = new Hashtable((Map)x1.value);
                        ht.remove(SV.sValue(x2));
                        return this.addX(SV.getVariableMap(ht));
                    }
                    case 11: {
                        if (x2.tok != 11) break;
                        M3 m = M3.newM3((M3)x1.value);
                        m.sub((M3)x2.value);
                        return this.addXM3(m);
                    }
                    case 12: {
                        if (x2.tok != 12) break;
                        M4 m4 = M4.newM4((M4)x1.value);
                        m4.sub((M4)x2.value);
                        return this.addXM4(m4);
                    }
                    case 8: {
                        P3 pt = P3.newP((P3)x1.value);
                        switch (x2.tok) {
                            case 8: {
                                pt.sub((P3)x2.value);
                                return this.addXPt(pt);
                            }
                            case 9: {
                                P4 pt4 = (P4)x2.value;
                                pt.sub(P3.new3(pt4.x, pt4.y, pt4.z));
                                return this.addXPt(pt);
                            }
                        }
                        float f = x2.asFloat();
                        return this.addXPt(P3.new3(pt.x - f, pt.y - f, pt.z - f));
                    }
                    case 9: {
                        Quat q1 = Quat.newP4((P4)x1.value);
                        if (x2.tok == 9) {
                            Quat q2 = Quat.newP4((P4)x2.value);
                            return this.addXPt4(q2.mulQ(q1.inv()).toPoint4f());
                        }
                        return this.addXPt4(q1.add(-x2.asFloat()).toPoint4f());
                    }
                }
                return this.addXFloat(x1.asFloat() - x2.asFloat());
            }
            case 1275068930: {
                if (x1.tok == 8 && x2.tok == 8) {
                    P3 pt = (P3)x1.value;
                    P3 pt2 = (P3)x2.value;
                    return this.addXPt(P3.new3(pt.x * pt2.x, pt.y * pt2.y, pt.z * pt2.z));
                }
            }
            case 0x10001601: {
                P3 pt;
                switch (x1.tok) {
                    case 2: {
                        return this.isDecimal(x2) ? this.addXFloat((float)x1.intValue * x2.asFloat()) : this.addXInt(x1.intValue * x2.asInt());
                    }
                    case 4: {
                        return this.isDecimal(x2) || this.isDecimal(x1) ? this.addXFloat(x1.asFloat() * x2.asFloat()) : this.addXInt(x1.asInt() * x2.asInt());
                    }
                }
                P3 p3 = x1.tok == 11 || x1.tok == 12 ? this.ptValue(x2, null) : (pt = x2.tok == 11 ? this.ptValue(x1, null) : null);
                P4 pt4 = x1.tok == 12 ? this.eval.planeValue(x2) : (x2.tok == 12 ? this.eval.planeValue(x1) : null);
                switch (x2.tok) {
                    case 11: {
                        if (pt != null) {
                            M3 m3b = M3.newM3((M3)x2.value);
                            m3b.transpose();
                            P3 pt1 = P3.newP(pt);
                            m3b.rotate(pt1);
                            return x1.tok == 7 ? this.addX(SV.getVariableAF(new float[]{pt1.x, pt1.y, pt1.z})) : this.addXPt(pt1);
                        }
                        if (pt4 == null) break;
                        return this.addXPt4(Quat.newP4(pt4).mulQ(Quat.newM((M3)x2.value)).toPoint4f());
                    }
                    case 12: {
                        if (pt4 == null) break;
                        M4 m4b = M4.newM4((M4)x2.value);
                        m4b.transpose();
                        P4 pt41 = P4.newPt(pt4);
                        m4b.transform(pt41);
                        return x1.tok == 7 ? this.addX(SV.getVariableAF(new float[]{pt41.x, pt41.y, pt41.z, pt41.w})) : this.addXPt4(pt41);
                    }
                }
                switch (x1.tok) {
                    case 11: {
                        M3 m3 = (M3)x1.value;
                        if (pt != null) {
                            P3 pt1 = P3.newP(pt);
                            m3.rotate(pt1);
                            return x2.tok == 7 ? this.addX(SV.getVariableAF(new float[]{pt1.x, pt1.y, pt1.z})) : this.addXPt(pt1);
                        }
                        switch (x2.tok) {
                            case 11: {
                                M3 m = M3.newM3((M3)x2.value);
                                m.mul2(m3, m);
                                return this.addXM3(m);
                            }
                            case 9: {
                                return this.addXM3(Quat.newM(m3).mulQ(Quat.newP4((P4)x2.value)).getMatrix());
                            }
                            case 7: {
                                Lst<SV> l = x2.getList();
                                Lst<P3> lnew = new Lst<P3>();
                                int i = l.size();
                                while (--i >= 0) {
                                    P3 pt1 = SV.ptValue((SV)l.get(i));
                                    if (pt1 == null) {
                                        return false;
                                    }
                                    pt1 = P3.newP(pt1);
                                    m3.rotate(pt1);
                                    lnew.addLast(pt1);
                                }
                                return this.addXList(lnew);
                            }
                        }
                        float f = x2.asFloat();
                        A4 aa = new A4();
                        aa.setM(m3);
                        aa.angle *= f;
                        return this.addXM3(new M3().setAA(aa));
                    }
                    case 12: {
                        M4 m4 = (M4)x1.value;
                        if (pt != null) {
                            P3 pt1 = P3.newP(pt);
                            m4.rotTrans(pt1);
                            return x2.tok == 7 ? this.addX(SV.getVariableAF(new float[]{pt1.x, pt1.y, pt1.z})) : this.addXPt(pt1);
                        }
                        if (pt4 != null) {
                            m4.transform(pt4);
                            return x2.tok == 7 ? this.addX(SV.getVariableAF(new float[]{pt4.x, pt4.y, pt4.z, pt4.w})) : this.addXPt4(pt4);
                        }
                        switch (x2.tok) {
                            case 12: {
                                M4 m4b = M4.newM4((M4)x2.value);
                                m4b.mul2(m4, m4b);
                                return this.addXM4(m4b);
                            }
                            case 7: {
                                Lst<SV> l = x2.getList();
                                Lst<P3> lnew = new Lst<P3>();
                                int i = l.size();
                                while (--i >= 0) {
                                    P3 pt1 = P3.newP(SV.ptValue((SV)l.get(i)));
                                    m4.rotTrans(pt1);
                                    lnew.addLast(pt1);
                                }
                                return this.addXList(lnew);
                            }
                        }
                        return this.addXFloat(Float.NaN);
                    }
                    case 8: {
                        pt = P3.newP((P3)x1.value);
                        switch (x2.tok) {
                            case 8: {
                                P3 pt2 = (P3)x2.value;
                                return this.addXFloat(pt.x * pt2.x + pt.y * pt2.y + pt.z * pt2.z);
                            }
                        }
                        float f = x2.asFloat();
                        return this.addXPt(P3.new3(pt.x * f, pt.y * f, pt.z * f));
                    }
                    case 9: {
                        if (x2.tok == 9) {
                            return this.addXPt4(Quat.newP4((P4)x1.value).mulQ(Quat.newP4((P4)x2.value)).toPoint4f());
                        }
                        return this.addXPt4(Quat.newP4((P4)x1.value).mul(x2.asFloat()).toPoint4f());
                    }
                }
                return this.addXFloat(x1.asFloat() * x2.asFloat());
            }
            case 0x10001600: {
                switch (x1.tok) {
                    case 2: {
                        int n;
                        if (x2.tok == 2 && x2.intValue != 0) {
                            return this.addXInt(x1.intValue / x2.intValue);
                        }
                        int n2 = n = this.isDecimal(x2) ? 0 : x2.asInt();
                        if (n == 0) break;
                        return this.addXInt(x1.intValue / n);
                    }
                    case 4: {
                        int i2;
                        if (this.isDecimal(x1) || this.isDecimal(x2) || (i2 = x2.asInt()) == 0) break;
                        return this.addXInt(x1.asInt() / i2);
                    }
                    case 8: {
                        P3 pt = P3.newP((P3)x1.value);
                        float f2 = x2.asFloat();
                        return this.addXPt(f2 == 0.0f ? P3.new3(Float.NaN, Float.NaN, Float.NaN) : P3.new3(pt.x / f2, pt.y / f2, pt.z / f2));
                    }
                    case 9: {
                        float f2;
                        return this.addXPt4(x2.tok == 9 ? Quat.newP4((P4)x1.value).div(Quat.newP4((P4)x2.value)).toPoint4f() : ((f2 = x2.asFloat()) == 0.0f ? P4.new4(Float.NaN, Float.NaN, Float.NaN, Float.NaN) : Quat.newP4((P4)x1.value).mul(1.0f / f2).toPoint4f()));
                    }
                }
                return this.addXFloat(x1.asFloat() / x2.asFloat());
            }
            case 268441091: {
                float f = x2.asFloat();
                if (x1.tok == 9) {
                    return f == 0.0f ? this.addXPt4(P4.new4(Float.NaN, Float.NaN, Float.NaN, Float.NaN)) : (x2.tok == 9 ? this.addXPt4(Quat.newP4((P4)x1.value).divLeft(Quat.newP4((P4)x2.value)).toPoint4f()) : this.addXPt4(Quat.newP4((P4)x1.value).mul(1.0f / f).toPoint4f()));
                }
                return this.addXInt(f == 0.0f ? 0 : (int)Math.floor(x1.asFloat() / x2.asFloat()));
            }
            case 268441603: {
                float f = (float)Math.pow(x1.asFloat(), x2.asFloat());
                return x1.tok == 2 && x2.tok == 2 ? this.addXInt((int)f) : this.addXFloat(f);
            }
            case 268441090: {
                String s = null;
                int n = x2.asInt();
                switch (x1.tok) {
                    default: {
                        break;
                    }
                    case 3: {
                        float f = x1.asFloat();
                        if (n == 0) {
                            return this.addXInt(Math.round(f));
                        }
                        s = DF.formatDecimal(f, n);
                        return this.addXStr(s);
                    }
                    case 4: {
                        s = (String)x1.value;
                        return this.addXStr(n == 0 ? PT.trim(s, "\n\t ") : (n == 9999 ? s.toUpperCase() : (n == -9999 ? s.toLowerCase() : (n > 0 ? PT.formatS(s, n, n, false, false) : PT.formatS(s, n, n - 1, true, false)))));
                    }
                    case 7: {
                        String[] list = SV.strListValue(x1);
                        for (int i = 0; i < list.length; ++i) {
                            list[i] = n == 0 ? list[i].trim() : (n > 0 ? PT.formatS(list[i], n, n, true, false) : PT.formatS(s, -n, n, false, false));
                        }
                        return this.addXAS(list);
                    }
                    case 8: {
                        P3 pt = P3.newP((P3)x1.value);
                        this.vwr.toUnitCell(pt, P3.new3(n, n, n));
                        return this.addXPt(pt);
                    }
                    case 9: {
                        P4 pt4 = (P4)x1.value;
                        if (x2.tok == 8) {
                            return this.addXPt((P3)Quat.newP4(pt4).transform2((P3)x2.value, new P3()));
                        }
                        if (x2.tok == 9) {
                            P4 v4 = P4.newPt((P4)x2.value);
                            Quat.newP4(pt4).getThetaDirected(v4);
                            return this.addXPt4(v4);
                        }
                        if (n == 0 && x2.tok == 4) {
                            s = " " + x2.value.toString().trim().toLowerCase() + ":";
                            int i = qMods.indexOf(s);
                            n = i >= 0 ? PT.parseInt(qMods.substring(i + s.length())) : -99;
                        }
                        switch (n) {
                            case 0: {
                                return this.addXFloat(pt4.w);
                            }
                            case 1: {
                                return this.addXFloat(pt4.x);
                            }
                            case 2: {
                                return this.addXFloat(pt4.y);
                            }
                            case 3: {
                                return this.addXFloat(pt4.z);
                            }
                        }
                        Quat q = Quat.newP4(pt4);
                        switch (n) {
                            case 4: {
                                return this.addXPt(P3.newP(q.getNormal()));
                            }
                            case 5: {
                                return this.addXAF(q.getEulerZXZ());
                            }
                            case 6: {
                                return this.addXAF(q.getEulerZYZ());
                            }
                            case -1: {
                                return this.addXPt(P3.newP(q.getVector(-1)));
                            }
                            case -2: {
                                return this.addXFloat(q.getTheta());
                            }
                            case -3: {
                                return this.addXPt(P3.newP(q.getVector(0)));
                            }
                            case -4: {
                                return this.addXPt(P3.newP(q.getVector(1)));
                            }
                            case -5: {
                                return this.addXPt(P3.newP(q.getVector(2)));
                            }
                            case -6: {
                                A4 ax = q.toAxisAngle4f();
                                return this.addXPt4(P4.new4(ax.x, ax.y, ax.z, (float)((double)(ax.angle * 180.0f) / Math.PI)));
                            }
                            case -9: {
                                return this.addXM3(q.getMatrix());
                            }
                        }
                        return this.addXStr("NaN");
                    }
                    case 11: {
                        M3 mm = (M3)x1.value;
                        switch (n) {
                            case 1: {
                                return this.addXFloat(mm.m00 + mm.m11 + mm.m22);
                            }
                            case 2: {
                                return this.addXFloat(mm.determinant3());
                            }
                        }
                        return false;
                    }
                    case 12: {
                        M4 m4 = (M4)x1.value;
                        switch (n) {
                            case 1: {
                                M3 m3 = new M3();
                                m4.getRotationScale(m3);
                                return this.addXM3(m3);
                            }
                            case 2: {
                                V3 v3 = new V3();
                                m4.getTranslation(v3);
                                return this.addXPt(P3.newP(v3));
                            }
                        }
                        return false;
                    }
                    case 10: {
                        return this.addXBs(SV.bsSelectRange(x1, n));
                    }
                }
                return this.addXInt(n == 0 ? x1.asInt() : x1.asInt() % n);
            }
        }
        return true;
    }

    private boolean isDecimal(SV x) {
        String s;
        return x.tok == 3 || x.tok == 4 && ((s = SV.sValue(x).trim()).indexOf(".") >= 0 || s.indexOf("+") > 0 || s.lastIndexOf("-") > 0);
    }

    public P3 ptValue(SV x, BS bsRestrict) throws ScriptException {
        switch (x.tok) {
            case 8: {
                return (P3)x.value;
            }
            case 10: {
                BS bs = (BS)x.value;
                if (bs.isEmpty() || bs instanceof BondSet) break;
                if (bsRestrict != null) {
                    bs = BSUtil.copy(bs);
                    bs.and(bsRestrict);
                }
                Object o = bs.isEmpty() ? null : this.eval.getBitsetProperty(bs, null, 1145047050, null, null, x.value, null, false, Integer.MAX_VALUE, false);
                return (P3)o;
            }
            case 4: {
                Object pt = Escape.uP(SV.sValue(x));
                if (!(pt instanceof P3)) break;
                return (P3)pt;
            }
            case 7: {
                Object pt = Escape.uP("{" + SV.sValue(x).replace(']', ' ').replace('[', ' ') + "}");
                if (!(pt instanceof P3)) break;
                return (P3)pt;
            }
        }
        return null;
    }

    private static String typeOf(SV x) {
        int tok = x == null ? 0 : x.tok;
        switch (tok) {
            case 1073742334: 
            case 1073742335: {
                return "boolean";
            }
            case 10: {
                return x.value instanceof BondSet ? "bondset" : "bitset";
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                return T.astrType[tok];
            }
        }
        return "?";
    }

    private boolean getAllProperties(SV x2, String abbr) throws ScriptException {
        Lst<T> tokens;
        BS bs = (BS)x2.value;
        int n = bs.cardinality();
        if (n == 0 || !abbr.endsWith("?") || (tokens = T.getAtomPropertiesLike(abbr.substring(0, abbr.length() - 1))) == null) {
            return this.addXStr("");
        }
        Hashtable<String, SV> ht = new Hashtable<String, SV>();
        int index = n == 1 ? bs.nextSetBit(0) : Integer.MAX_VALUE;
        int i = tokens.size();
        block3: while (--i >= 0) {
            T t = (T)tokens.get(i);
            int tok = t.tok;
            switch (tok) {
                case 1094713349: 
                case 1094717448: {
                    continue block3;
                }
            }
            if (index == Integer.MAX_VALUE) {
                tok |= 0x1E0;
            }
            ht.put((String)t.value, SV.getVariable(this.eval.getBitsetProperty(bs, null, tok, null, null, null, null, false, index, true)));
        }
        return this.addXMap(ht);
    }

    public static M4 getMatrix4f(M3 matRotate, T3 vTranslate) {
        return M4.newMV(matRotate, vTranslate == null ? new V3() : V3.newV(vTranslate));
    }

    private boolean getBoundBox(SV x2) {
        if (x2.tok != 10 || x2.value instanceof BondSet) {
            return false;
        }
        BoxInfo b = this.vwr.ms.getBoxInfo((BS)x2.value, 1.0f);
        P3[] pts = b.getBoundBoxPoints(true);
        Lst<P3> list = new Lst<P3>();
        for (int i = 0; i < 4; ++i) {
            list.addLast(pts[i]);
        }
        return this.addXList(list);
    }

    private boolean getPointOrBitsetOperation(T op, SV x2) throws ScriptException {
        switch (x2.tok) {
            case 7: {
                switch (op.intValue) {
                    case 32: 
                    case 64: 
                    case 96: 
                    case 128: 
                    case 160: 
                    case 192: 
                    case 1275068725: {
                        return this.addXObj(this.eval.getMathExt().getMinMax(x2.getList(), op.intValue, true));
                    }
                    case 1275334681: {
                        return this.addX(x2.pushPop(null, null));
                    }
                    case 0x44000005: 
                    case 1275068444: {
                        return this.addX(x2.sortOrReverse(op.intValue == 0x44000005 ? Integer.MIN_VALUE : 1));
                    }
                }
                SV[] list2 = new SV[x2.getList().size()];
                for (int i = 0; i < list2.length; ++i) {
                    Object v = SV.unescapePointOrBitsetAsVariable(x2.getList().get(i));
                    if (!(v instanceof SV) || !this.getPointOrBitsetOperation(op, (SV)v)) {
                        return false;
                    }
                    list2[i] = this.xStack[this.xPt--];
                }
                return this.addXAV(list2);
            }
            case 8: {
                switch (op.intValue) {
                    case 1111492609: 
                    case 1111492629: {
                        return this.addXFloat(((P3)x2.value).x);
                    }
                    case 1111492610: 
                    case 1111492630: {
                        return this.addXFloat(((P3)x2.value).y);
                    }
                    case 1111492611: 
                    case 1111492631: {
                        return this.addXFloat(((P3)x2.value).z);
                    }
                    case 1145047050: {
                        P3 pt = P3.newP((P3)x2.value);
                        this.vwr.toCartesian(pt, false);
                        return this.addXPt(pt);
                    }
                    case 1111492612: 
                    case 1111492613: 
                    case 1111492614: 
                    case 1145047051: {
                        P3 ptf = P3.newP((P3)x2.value);
                        this.vwr.toFractional(ptf, false);
                        return op.intValue == 1145047051 ? this.addXPt(ptf) : this.addXFloat(op.intValue == 1111492612 ? ptf.x : (op.intValue == 1111492613 ? ptf.y : ptf.z));
                    }
                    case 1111492615: 
                    case 1111492616: 
                    case 1111492617: 
                    case 1145047053: {
                        P3 ptfu = P3.newP((P3)x2.value);
                        this.vwr.toFractional(ptfu, true);
                        return op.intValue == 1145047053 ? this.addXPt(ptfu) : this.addXFloat(op.intValue == 1111492615 ? ptfu.x : (op.intValue == 1111492616 ? ptfu.y : ptfu.z));
                    }
                    case 1111490577: 
                    case 1111490578: 
                    case 1111490579: 
                    case 0x4440000E: {
                        P3 ptu = P3.newP((P3)x2.value);
                        this.vwr.toUnitCell(ptu, null);
                        this.vwr.toFractional(ptu, false);
                        return op.intValue == 0x4440000E ? this.addXPt(ptu) : this.addXFloat(op.intValue == 1111490577 ? ptu.x : (op.intValue == 1111490578 ? ptu.y : ptu.z));
                    }
                }
                break;
            }
            case 9: {
                switch (op.intValue) {
                    case 1111492609: 
                    case 1111492629: {
                        return this.addXFloat(((P4)x2.value).x);
                    }
                    case 1111492610: 
                    case 1111492630: {
                        return this.addXFloat(((P4)x2.value).y);
                    }
                    case 1111492611: 
                    case 1111492631: {
                        return this.addXFloat(((P4)x2.value).z);
                    }
                    case 0x44000011: {
                        return this.addXFloat(((P4)x2.value).w);
                    }
                }
                break;
            }
            case 10: {
                boolean isAtoms;
                boolean bl = isAtoms = op.intValue != 1677721602;
                if (!isAtoms && x2.value instanceof BondSet) {
                    return this.addX(x2);
                }
                BS bs = (BS)x2.value;
                if (isAtoms && bs.cardinality() == 1 && (op.intValue & 0x1E0) == 0) {
                    op.intValue |= 0x20;
                }
                Object val = this.eval.getBitsetProperty(bs, null, op.intValue, null, null, null, op.value, false, x2.index, true);
                return isAtoms ? this.addXObj(val) : this.addXBs(BondSet.newBS((BS)val));
            }
        }
        return false;
    }
}

