/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.inchi;

import javajs.util.BS;
import javajs.util.PT;
import org.jmol.api.JmolInChI;
import org.jmol.viewer.Viewer;

public class InChIJS
implements JmolInChI {
    @Override
    public String getInchi(Viewer vwr, BS atoms, Object molData, String options) {
        if (atoms == null ? molData == null : atoms.isEmpty()) {
            return "";
        }
        String ret = "";
        try {
            boolean haveKey;
            if (options == null) {
                options = "";
            }
            if ((options = PT.rep(PT.rep(options.replace('-', ' '), "  ", " ").trim(), " ", " -").toLowerCase()).length() > 0) {
                options = "-" + options;
            }
            if (molData == null) {
                molData = vwr.getModelExtract(atoms, false, false, "MOL");
            }
            if (molData instanceof String && ((String)molData).startsWith("InChI=")) {
                return ret;
            }
            boolean bl = haveKey = options.indexOf("key") >= 0;
            if (haveKey) {
                options = options.replace("inchikey", "key");
            }
            if (options.indexOf("fixedh?") >= 0) {
                String fxd = this.getInchi(vwr, atoms, molData, options.replace('?', ' '));
                options = PT.rep(options, "-fixedh?", "");
                if (haveKey) {
                    options = PT.rep(options, "-key", "");
                }
                String inchi = this.getInchi(vwr, atoms, molData, options);
                if (fxd != null && fxd.length() > inchi.length()) {
                    inchi = fxd;
                }
                return haveKey ? this.getInchi(vwr, atoms, inchi, "-key") : inchi;
            }
        }
        catch (Throwable e) {
            System.err.println("InChIJS exception: " + e);
        }
        return ret;
    }

    static {
        String wasmPath = "/_WASM";
        String es6Path = "/_ES6";
    }
}

