/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import javajs.util.PT;
import org.jmol.api.JmolScriptEvaluator;
import org.jmol.i18n.GT;
import org.jmol.script.ScriptException;
import org.jmol.viewer.Viewer;

public abstract class ScriptError
implements JmolScriptEvaluator {
    public Viewer vwr;
    public boolean chk;
    public boolean ignoreError;
    protected boolean error;
    protected String errorMessage;
    protected String errorMessageUntranslated;
    protected String errorType;
    protected int iCommandError;
    static final int ERROR_axisExpected = 0;
    static final int ERROR_backgroundModelError = 1;
    public static final int ERROR_badArgumentCount = 2;
    static final int ERROR_badMillerIndices = 3;
    public static final int ERROR_badRGBColor = 4;
    static final int ERROR_booleanExpected = 5;
    static final int ERROR_booleanOrNumberExpected = 6;
    static final int ERROR_booleanOrWhateverExpected = 7;
    static final int ERROR_colorExpected = 8;
    static final int ERROR_colorOrPaletteRequired = 9;
    static final int ERROR_commandExpected = 10;
    static final int ERROR_coordinateOrNameOrExpressionRequired = 11;
    static final int ERROR_drawObjectNotDefined = 12;
    public static final int ERROR_endOfStatementUnexpected = 13;
    public static final int ERROR_expressionExpected = 14;
    public static final int ERROR_expressionOrIntegerExpected = 15;
    static final int ERROR_filenameExpected = 16;
    public static final int ERROR_fileNotFoundException = 17;
    public static final int ERROR_incompatibleArguments = 18;
    public static final int ERROR_insufficientArguments = 19;
    static final int ERROR_integerExpected = 20;
    static final int ERROR_integerOutOfRange = 21;
    public static final int ERROR_invalidArgument = 22;
    public static final int ERROR_invalidParameterOrder = 23;
    public static final int ERROR_keywordExpected = 24;
    public static final int ERROR_moCoefficients = 25;
    public static final int ERROR_moIndex = 26;
    public static final int ERROR_moModelError = 27;
    public static final int ERROR_moOccupancy = 28;
    public static final int ERROR_moOnlyOne = 29;
    public static final int ERROR_multipleModelsDisplayedNotOK = 30;
    public static final int ERROR_noData = 31;
    public static final int ERROR_noPartialCharges = 32;
    static final int ERROR_noUnitCell = 33;
    public static final int ERROR_numberExpected = 34;
    static final int ERROR_numberMustBe = 35;
    static final int ERROR_numberOutOfRange = 36;
    static final int ERROR_objectNameExpected = 37;
    static final int ERROR_planeExpected = 38;
    static final int ERROR_propertyNameExpected = 39;
    static final int ERROR_spaceGroupNotFound = 40;
    static final int ERROR_stringExpected = 41;
    static final int ERROR_stringOrIdentifierExpected = 42;
    static final int ERROR_tooManyPoints = 43;
    static final int ERROR_tooManyScriptLevels = 44;
    static final int ERROR_unrecognizedAtomProperty = 45;
    static final int ERROR_unrecognizedBondProperty = 46;
    static final int ERROR_unrecognizedCommand = 47;
    static final int ERROR_unrecognizedExpression = 48;
    static final int ERROR_unrecognizedObject = 49;
    static final int ERROR_unrecognizedParameter = 50;
    static final int ERROR_unrecognizedParameterWarning = 51;
    static final int ERROR_unrecognizedShowParameter = 52;
    public static final int ERROR_what = 53;
    public static final int ERROR_writeWhat = 54;
    static final int ERROR_multipleModelsNotOK = 55;
    public static final int ERROR_cannotSet = 56;
    public static final int ERROR_operationCanceled = 57;

    protected abstract void showStringPrint(String var1, boolean var2);

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getErrorMessageUntranslated() {
        return this.errorMessageUntranslated == null ? this.errorMessage : this.errorMessageUntranslated;
    }

    public void invArg() throws ScriptException {
        this.error(22);
    }

    public void bad() throws ScriptException {
        this.error(2);
    }

    public void integerOutOfRange(int min, int max) throws ScriptException {
        this.errorOrWarn(21, "" + min, "" + max, null, true);
    }

    protected void numberOutOfRange(float min, float max) throws ScriptException {
        this.errorOrWarn(36, "" + min, "" + max, null, true);
    }

    public void error(int iError) throws ScriptException {
        this.errorOrWarn(iError, null, null, null, false);
    }

    public void errorStr(int iError, String value) throws ScriptException {
        this.errorOrWarn(iError, value, null, null, false);
    }

    public void errorStr2(int iError, String value, String more) throws ScriptException {
        this.errorOrWarn(iError, value, more, null, false);
    }

    void errorMore(int iError, String value, String more, String more2) throws ScriptException {
        this.errorOrWarn(iError, value, more, more2, false);
    }

    protected void warning(int iError, String value, String more) throws ScriptException {
        this.errorOrWarn(iError, value, more, null, true);
    }

    private void errorOrWarn(int iError, String value, String more, String more2, boolean warningOnly) throws ScriptException {
        String strUntranslated;
        String strError = this.ignoreError ? null : ScriptError.errorString(iError, value, more, more2, true);
        String string = strUntranslated = this.ignoreError || !GT.getDoTranslate() ? null : ScriptError.errorString(iError, value, more, more2, false);
        if (!warningOnly) {
            this.evalError(strError, strUntranslated);
        }
        this.showStringPrint(strError, true);
    }

    public void evalError(String message, String strUntranslated) throws ScriptException {
        if (this.ignoreError) {
            throw new NullPointerException();
        }
        if (strUntranslated == null) {
            strUntranslated = message;
        }
        if (!this.chk) {
            this.setCursorWait(false);
            this.vwr.setBooleanProperty("refreshing", true);
            this.vwr.setStringProperty("_errormessage", strUntranslated);
        }
        throw new ScriptException(this, message, strUntranslated, true);
    }

    public void setCursorWait(boolean TF) {
        if (!this.chk) {
            this.vwr.setCursor(TF ? 3 : 0);
        }
    }

    static String errorString(int iError, String value, String more, String more2, boolean translated) {
        String msg;
        boolean doTranslate = false;
        if (!translated && (doTranslate = GT.getDoTranslate())) {
            GT.setDoTranslate(false);
        }
        switch (iError) {
            default: {
                msg = "Unknown error message number: " + iError;
                break;
            }
            case 0: {
                msg = GT.$("x y z axis expected");
                break;
            }
            case 1: {
                msg = GT.$("{0} not allowed with background model displayed");
                break;
            }
            case 2: {
                msg = GT.$("bad argument count");
                break;
            }
            case 3: {
                msg = GT.$("Miller indices cannot all be zero.");
                break;
            }
            case 4: {
                msg = GT.$("bad [R,G,B] color");
                break;
            }
            case 5: {
                msg = GT.$("boolean expected");
                break;
            }
            case 6: {
                msg = GT.$("boolean or number expected");
                break;
            }
            case 7: {
                msg = GT.$("boolean, number, or {0} expected");
                break;
            }
            case 56: {
                msg = GT.$("cannot set value");
                break;
            }
            case 8: {
                msg = GT.$("color expected");
                break;
            }
            case 9: {
                msg = GT.$("a color or palette name (Jmol, Rasmol) is required");
                break;
            }
            case 10: {
                msg = GT.$("command expected");
                break;
            }
            case 11: {
                msg = GT.$("{x y z} or $name or (atom expression) required");
                break;
            }
            case 12: {
                msg = GT.$("draw object not defined");
                break;
            }
            case 13: {
                msg = GT.$("unexpected end of script command");
                break;
            }
            case 14: {
                msg = GT.$("valid (atom expression) expected");
                break;
            }
            case 15: {
                msg = GT.$("(atom expression) or integer expected");
                break;
            }
            case 16: {
                msg = GT.$("filename expected");
                break;
            }
            case 17: {
                msg = GT.$("file not found");
                break;
            }
            case 18: {
                msg = GT.$("incompatible arguments");
                break;
            }
            case 19: {
                msg = GT.$("insufficient arguments");
                break;
            }
            case 20: {
                msg = GT.$("integer expected");
                break;
            }
            case 21: {
                msg = GT.$("integer out of range ({0} - {1})");
                break;
            }
            case 22: {
                msg = GT.$("invalid argument");
                break;
            }
            case 23: {
                msg = GT.$("invalid parameter order");
                break;
            }
            case 24: {
                msg = GT.$("keyword expected");
                break;
            }
            case 25: {
                msg = GT.$("no MO coefficient data available");
                break;
            }
            case 26: {
                msg = GT.$("An MO index from 1 to {0} is required");
                break;
            }
            case 27: {
                msg = GT.$("no MO basis/coefficient data available for this frame");
                break;
            }
            case 28: {
                msg = GT.$("no MO occupancy data available");
                break;
            }
            case 29: {
                msg = GT.$("Only one molecular orbital is available in this file");
                break;
            }
            case 30: {
                msg = GT.$("{0} requires that only one model be displayed");
                break;
            }
            case 55: {
                msg = GT.$("{0} requires that only one model be loaded");
                break;
            }
            case 31: {
                msg = GT.$("No data available");
                break;
            }
            case 32: {
                msg = GT.$("No partial charges were read from the file; Jmol needs these to render the MEP data.");
                break;
            }
            case 33: {
                msg = GT.$("No unit cell");
                break;
            }
            case 34: {
                msg = GT.$("number expected");
                break;
            }
            case 35: {
                msg = GT.$("number must be ({0} or {1})");
                break;
            }
            case 36: {
                msg = GT.$("decimal number out of range ({0} - {1})");
                break;
            }
            case 57: {
                msg = GT.$("operation canceled");
                break;
            }
            case 37: {
                msg = GT.$("object name expected after '$'");
                break;
            }
            case 38: {
                msg = GT.$("plane expected -- either three points or atom expressions or {0} or {1} or {2}");
                break;
            }
            case 39: {
                msg = GT.$("property name expected");
                break;
            }
            case 40: {
                msg = GT.$("space group {0} was not found.");
                break;
            }
            case 41: {
                msg = GT.$("quoted string expected");
                break;
            }
            case 42: {
                msg = GT.$("quoted string or identifier expected");
                break;
            }
            case 43: {
                msg = GT.$("too many rotation points were specified");
                break;
            }
            case 44: {
                msg = GT.$("too many script levels");
                break;
            }
            case 45: {
                msg = GT.$("unrecognized atom property");
                break;
            }
            case 46: {
                msg = GT.$("unrecognized bond property");
                break;
            }
            case 47: {
                msg = GT.$("unrecognized command");
                break;
            }
            case 48: {
                msg = GT.$("runtime unrecognized expression");
                break;
            }
            case 49: {
                msg = GT.$("unrecognized object");
                break;
            }
            case 50: {
                msg = GT.$("unrecognized {0} parameter");
                break;
            }
            case 51: {
                msg = GT.$("unrecognized {0} parameter in Jmol state script (set anyway)");
                break;
            }
            case 52: {
                msg = GT.$("unrecognized SHOW parameter --  use {0}");
                break;
            }
            case 53: {
                msg = "{0}";
                break;
            }
            case 54: {
                msg = GT.$("write what? {0} or {1} \"filename\"");
            }
        }
        if (msg.indexOf("{0}") < 0) {
            if (value != null) {
                msg = msg + ": " + value;
            }
        } else {
            if ((msg = PT.rep(msg, "{0}", value)).indexOf("{1}") >= 0) {
                msg = PT.rep(msg, "{1}", more);
            } else if (more != null) {
                msg = msg + ": " + more;
            }
            if (msg.indexOf("{2}") >= 0) {
                msg = PT.rep(msg, "{2}", more);
            }
        }
        if (doTranslate) {
            GT.setDoTranslate(true);
        }
        return msg;
    }

    public static String getErrorLineMessage(String functionName, String filename, int lineCurrent, int pcCurrent, String lineInfo) {
        String err = "\n----";
        if (filename != null || functionName != null) {
            err = err + "line " + lineCurrent + " command " + (pcCurrent + 1) + " of " + (functionName == null ? filename : (functionName.equals("try") ? "try" : "function " + functionName)) + ":";
        }
        err = err + "\n         " + lineInfo;
        return err;
    }

    protected void setErrorMessage(String err) {
        this.errorMessageUntranslated = null;
        if (err == null) {
            this.error = false;
            this.errorType = null;
            this.errorMessage = null;
            this.iCommandError = -1;
            return;
        }
        this.error = true;
        if (this.errorMessage == null) {
            this.errorMessage = GT.$("script ERROR: ");
        }
        this.errorMessage = this.errorMessage + err;
    }
}

