/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import javajs.util.BS;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.shape.Shape;
import org.jmol.util.C;
import org.jmol.util.Font;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public class Text {
    private Viewer vwr;
    public boolean doFormatText;
    public Font font;
    private int fid;
    private int ascent;
    public int descent;
    public int lineHeight;
    protected int offsetX;
    protected int offsetY;
    public int boxYoff2;
    private int[] widths;
    private int textWidth;
    private int textHeight;
    public String text;
    public String textUnformatted;
    public String[] lines;
    public Object image;
    public float imageScale = 1.0f;
    public int barPixels;
    public float barDistance;
    private float xAdj;
    private float yAdj;
    private float y0;
    public P3 pointerPt;
    public boolean isMeasure;
    public boolean isEcho;
    public P3 xyz;
    public String target;
    public String script;
    public short colix;
    public short bgcolix;
    public int pointer;
    public float fontScale;
    public int align;
    public int valign;
    public int atomX;
    public int atomY;
    public int atomZ = Integer.MAX_VALUE;
    public int movableX;
    public int movableY;
    public int movableZ;
    public int movableXPercent = Integer.MAX_VALUE;
    public int movableYPercent = Integer.MAX_VALUE;
    public int movableZPercent = Integer.MAX_VALUE;
    public int z = 1;
    public int zSlab = Integer.MIN_VALUE;
    public static final int PYMOL_LABEL_OFFSET_JMOL = -1;
    public static final int PYMOL_LABEL_OFFSET_REL = 1;
    public static final int PYMOL_LABEL_OFFSET_PIX = 2;
    public static final int PYMOL_LABEL_OFFSET_ABS_ANG = 0;
    public static final int PYMOL_LABEL_OFFSET_REL_ANG = 1;
    public static final int PYMOL_LABEL_OFFSET_ABS_PIX = 2;
    public static final int PYMOL_LABEL_OFFSET_REL_PIX = 3;
    public float[] pymolOffset;
    protected int windowWidth;
    protected int windowHeight;
    public boolean adjustForWindow;
    public float boxWidth;
    public float boxHeight;
    public float boxX;
    public float boxY;
    public int modelIndex = -1;
    public boolean visible = true;
    public boolean hidden = false;
    public float[] boxXY = new float[5];
    public float scalePixelsPerMicron;
    public int barPixelsXYZ;

    public static Text newLabel(Viewer vwr, Font font, String text, short colix, short bgcolix, int align, float scalePixelsPerMicron) {
        Text t = new Text();
        t.vwr = vwr;
        t.set(font, colix, align, scalePixelsPerMicron);
        t.setText(text);
        t.bgcolix = bgcolix;
        return t;
    }

    public static Text newMeasure(Viewer vwr, Font font, short colix) {
        Text t = new Text();
        t.vwr = vwr;
        t.set(font, colix, 0, 0.0f);
        t.isMeasure = true;
        return t;
    }

    public static Text newEcho(Viewer vwr, Font font, String target, short colix, int valign, int align, float scalePixelsPerMicron) {
        Text t = new Text();
        t.isEcho = true;
        t.vwr = vwr;
        t.set(font, colix, align, scalePixelsPerMicron);
        t.target = target;
        t.valign = valign;
        t.z = 2;
        t.zSlab = Integer.MIN_VALUE;
        return t;
    }

    private void set(Font font, short colix, int align, float scalePixelsPerMicron) {
        this.scalePixelsPerMicron = scalePixelsPerMicron;
        this.colix = colix;
        this.align = align;
        this.setFont(font, !this.isEcho);
    }

    public void setOffset(int offset) {
        this.offsetX = JC.getXOffset(offset);
        this.offsetY = JC.getYOffset(offset);
        this.pymolOffset = null;
        this.valign = 3;
    }

    private void getFontMetrics() {
        this.descent = this.font.getDescent();
        this.ascent = this.font.getAscent();
        this.lineHeight = this.ascent + this.descent;
    }

    public void setFontFromFid(int fid) {
        if (this.fid == fid) {
            return;
        }
        this.fontScale = 0.0f;
        this.setFont(Font.getFont3D(fid), true);
    }

    public void setText(String text) {
        if (this.image != null) {
            this.getFontMetrics();
            this.image = null;
        }
        this.barPixels = 0;
        if (text != null && text.length() == 0) {
            text = null;
        }
        if (this.text != null && this.text.equals(text)) {
            return;
        }
        this.text = this.textUnformatted = text;
        boolean bl = this.doFormatText = this.isEcho && text != null && (text.indexOf("%{") >= 0 || text.indexOf("@{") >= 0);
        if (!this.doFormatText) {
            this.recalc();
        }
    }

    public void setImage(Object image) {
        this.image = image;
        this.recalc();
    }

    public void setScale(float scale) {
        this.imageScale = scale;
        this.recalc();
    }

    public void setFont(Font f3d, boolean doAll) {
        this.font = f3d;
        if (this.font == null) {
            return;
        }
        this.getFontMetrics();
        if (!doAll) {
            return;
        }
        this.fid = this.font.fid;
        this.recalc();
    }

    public void setFontScale(float scale) {
        if (this.fontScale == scale) {
            return;
        }
        this.fontScale = scale;
        if (this.fontScale != 0.0f && this.font != null) {
            this.setFont(this.vwr.gdata.getFont3DScaled(this.font, scale), true);
        }
    }

    private void recalc() {
        if (this.image != null) {
            this.textHeight = 0;
            this.textWidth = 0;
            this.boxWidth = (float)this.vwr.apiPlatform.getImageWidth(this.image) * this.fontScale * this.imageScale;
            this.boxHeight = (float)this.vwr.apiPlatform.getImageHeight(this.image) * this.fontScale * this.imageScale;
            this.ascent = 0;
            return;
        }
        if (this.text == null) {
            this.text = null;
            this.lines = null;
            this.widths = null;
            return;
        }
        if (this.font == null) {
            return;
        }
        this.lines = PT.split(this.text, this.text.indexOf("\n") >= 0 ? "\n" : "|");
        this.textWidth = 0;
        this.widths = new int[this.lines.length];
        int i = this.lines.length;
        while (--i >= 0) {
            this.widths[i] = this.stringWidth(this.lines[i]);
            this.textWidth = Math.max(this.textWidth, this.widths[i]);
        }
        this.textHeight = this.lines.length * this.lineHeight;
        this.boxWidth = this.textWidth + (this.fontScale >= 2.0f ? 16 : 8);
        this.boxHeight = this.textHeight + (this.fontScale >= 2.0f ? 16 : 8);
    }

    public void setPosition(float scalePixelsPerMicron, float imageFontScaling, boolean isAbsolute, float[] boxXY) {
        if (boxXY == null) {
            boxXY = this.boxXY;
        } else {
            this.boxXY = boxXY;
        }
        this.setWindow(this.vwr.gdata.width, this.vwr.gdata.height, scalePixelsPerMicron);
        if (scalePixelsPerMicron != 0.0f && this.scalePixelsPerMicron != 0.0f) {
            this.setFontScale(scalePixelsPerMicron / this.scalePixelsPerMicron);
        } else if (this.fontScale != imageFontScaling) {
            this.setFontScale(imageFontScaling);
        }
        if (this.doFormatText) {
            this.text = this.isEcho ? this.vwr.formatText(this.textUnformatted) : this.textUnformatted;
            this.recalc();
        } else if (this.textUnformatted != null && this.textUnformatted.startsWith("%SCALE")) {
            float[] ret = new float[2];
            this.text = this.vwr.getScaleText(this.textUnformatted.substring(6).trim(), this.vwr.antialiased, this.xyz == null ? 15 : 8, ret);
            this.barPixels = (int)(ret[0] * (float)(this.vwr.antialiased ? 2 : 1));
            this.barDistance = ret[1];
            this.recalc();
        }
        float dx = (float)this.offsetX * imageFontScaling;
        float dy = (float)this.offsetY * imageFontScaling;
        this.xAdj = this.fontScale >= 2.0f ? 8 : 4;
        this.yAdj = (float)(this.ascent - this.lineHeight) + this.xAdj;
        if (!this.isEcho || this.pymolOffset != null) {
            boolean isAng;
            boxXY[0] = this.movableX;
            boxXY[1] = this.movableY;
            boolean bl = isAng = !this.isPymolOffsetPixels();
            if (this.pymolOffset != null && isAng) {
                float pixelsPerAngstrom = this.vwr.tm.scaleToScreen(this.z, 1000);
                float pz = this.pymolOffset[3];
                float dz = (float)(pz < 0.0f ? -1 : 1) * Math.max(pz == 0.0f ? 0.5f : 0.0f, Math.abs(pz) - 1.0f) * pixelsPerAngstrom;
                this.z -= (int)dz;
                pixelsPerAngstrom = this.vwr.tm.scaleToScreen(this.z, 1000);
                dx = this.xyz != null && this.barPixels > 0 ? 0.0f : this.getPymolXYOffset(this.pymolOffset[1], this.textWidth, pixelsPerAngstrom);
                int dh = this.ascent - this.descent;
                dy = -this.getPymolXYOffset(-this.pymolOffset[2], dh, pixelsPerAngstrom) - (float)((this.textHeight + dh) / 2);
                if (this.pymolOffset[0] == 1.0f) {
                    dy -= (float)this.descent;
                }
                this.xAdj = this.fontScale >= 2.0f ? 8 : 4;
                this.yAdj = -this.descent;
                boxXY[0] = (float)this.movableX - this.xAdj;
                boxXY[1] = (float)this.movableY - this.yAdj;
                isAbsolute = true;
                this.boxYoff2 = -2;
            } else {
                this.boxYoff2 = 0;
            }
            if (this.pymolOffset == null) {
                switch (this.align) {
                    case 8: {
                        dy = 0.0f;
                        dx = 0.0f;
                        break;
                    }
                    case 12: {
                        boxXY[0] = boxXY[0] - this.boxWidth;
                    }
                    case 4: {
                        dy = 0.0f;
                    }
                }
            }
            Text.setBoxXY(this.boxWidth, this.boxHeight, dx, dy, boxXY, isAbsolute);
        } else {
            this.setPos(this.fontScale);
        }
        this.boxX = boxXY[0];
        this.boxY = boxXY[1];
        if (this.adjustForWindow) {
            this.setBoxOffsetsInWindow(0.0f, this.isEcho ? 0.0f : 16.0f * this.fontScale + (float)this.lineHeight, this.boxY - (float)this.textHeight);
        }
        this.y0 = this.boxY + this.yAdj;
        if (this.isMeasure && this.align != 8) {
            this.y0 += (float)this.ascent + (float)(this.lines.length - 1) / 2.0f * (float)this.lineHeight;
        }
    }

    private float getPymolXYOffset(float x, int width, float ppa) {
        float f;
        float f2 = x < -1.0f ? -1.0f : (f = x > 1.0f ? 0.0f : (x - 1.0f) / 2.0f);
        float offset = x < -1.0f || x > 1.0f ? x + (float)(x < 0.0f ? 1 : -1) : 0.0f;
        return f * (float)width + offset * ppa;
    }

    private void setPos(float scale) {
        float xLeft;
        float xRight;
        float xCenter;
        boolean is3dEcho;
        boolean bl = is3dEcho = this.xyz != null;
        if (this.valign == 3 || this.valign == 4) {
            float x = this.movableXPercent != Integer.MAX_VALUE ? (float)(this.movableXPercent * this.windowWidth / 100) : (is3dEcho ? (float)this.movableX : (float)this.movableX * scale);
            float offsetX = (float)this.offsetX * scale;
            xRight = xCenter = x + offsetX + (float)this.barPixels;
            xLeft = xCenter;
        } else {
            xLeft = 5.0f * scale;
            xCenter = (this.windowWidth + this.barPixels) / 2;
            xRight = (float)this.windowWidth - xLeft;
            xLeft += (float)this.barPixels;
        }
        switch (this.align) {
            case 8: {
                this.boxXY[0] = xCenter - this.boxWidth / 2.0f;
                break;
            }
            case 12: {
                this.boxXY[0] = xRight - this.boxWidth;
                break;
            }
            default: {
                this.boxXY[0] = xLeft;
            }
        }
        this.boxXY[1] = 0.0f;
        switch (this.valign) {
            case 0: {
                break;
            }
            case 2: {
                this.boxXY[1] = this.windowHeight / 2;
                break;
            }
            case 1: {
                this.boxXY[1] = this.windowHeight;
                break;
            }
            default: {
                float y = this.movableYPercent != Integer.MAX_VALUE ? (float)(this.movableYPercent * this.windowHeight / 100) : (is3dEcho ? (float)this.movableY : (float)this.movableY * scale);
                this.boxXY[1] = (is3dEcho ? y : (float)this.windowHeight - y) + (float)this.offsetY * scale;
            }
        }
        if (this.align == 8) {
            this.boxXY[1] = this.boxXY[1] - (this.image != null ? this.boxHeight : (this.xyz != null ? this.boxHeight : (float)this.ascent - this.boxHeight)) / 2.0f;
        } else if (this.image != null) {
            this.boxXY[1] = this.boxXY[1] - 0.0f;
        } else if (this.xyz != null) {
            this.boxXY[1] = this.boxXY[1] - (float)(this.ascent / 2);
        }
    }

    public static void setBoxXY(float boxWidth, float boxHeight, float xOffset, float yOffset, float[] boxXY, boolean isAbsolute) {
        float xBoxOffset;
        if (xOffset > 0.0f || isAbsolute) {
            xBoxOffset = xOffset;
        } else {
            xBoxOffset = -boxWidth;
            xBoxOffset = xOffset == 0.0f ? (xBoxOffset /= 2.0f) : (xBoxOffset += xOffset);
        }
        float yBoxOffset = isAbsolute || yOffset > 0.0f ? -boxHeight - yOffset : (yOffset == 0.0f ? -boxHeight / 2.0f : -yOffset);
        boxXY[0] = boxXY[0] + xBoxOffset;
        boxXY[1] = boxXY[1] + yBoxOffset;
        boxXY[2] = boxWidth;
        boxXY[3] = boxHeight;
    }

    private int stringWidth(String str) {
        int w = 0;
        int f = 1;
        int subscale = 1;
        if (str == null) {
            return 0;
        }
        if (str.indexOf("<su") < 0 && str.indexOf("<color") < 0) {
            return this.font.stringWidth(str);
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) == '<') {
                String s;
                int i1;
                if (i + 8 <= len && (str.substring(i, i + 7).equals("<color ") || str.substring(i, i + 8).equals("</color>")) && (i1 = str.indexOf(">", i)) >= 0) {
                    i = i1;
                    continue;
                }
                if (i + 5 <= len && ((s = str.substring(i, i + 5)).equals("<sub>") || s.equals("<sup>"))) {
                    i += 4;
                    f = subscale;
                    continue;
                }
                if (i + 6 <= len && ((s = str.substring(i, i + 6)).equals("</sub>") || s.equals("</sup>"))) {
                    i += 5;
                    f = 1;
                    continue;
                }
            }
            w += this.font.stringWidth(str.substring(i, i + 1)) * f;
        }
        return w;
    }

    public void setXYA(float[] xy, int i) {
        if (i == 0) {
            xy[2] = this.boxX;
            switch (this.align) {
                case 8: {
                    xy[2] = xy[2] + this.boxWidth / 2.0f;
                    break;
                }
                case 12: {
                    xy[2] = xy[2] + (this.boxWidth - this.xAdj);
                    break;
                }
                default: {
                    xy[2] = xy[2] + this.xAdj;
                }
            }
            xy[0] = xy[2];
            xy[1] = this.y0;
        }
        switch (this.align) {
            case 8: {
                xy[0] = xy[2] - (float)(this.widths[i] / 2);
                break;
            }
            case 12: {
                xy[0] = xy[2] - (float)this.widths[i];
            }
        }
        xy[1] = xy[1] + (float)this.lineHeight;
    }

    public void appendFontCmd(SB s) {
        s.append("  " + Shape.getFontCommand("echo", this.font));
        if (this.scalePixelsPerMicron > 0.0f) {
            s.append(" " + 10000.0f / this.scalePixelsPerMicron);
        }
    }

    public void setScalePixelsPerMicron(float scalePixelsPerMicron) {
        this.fontScale = 0.0f;
        this.scalePixelsPerMicron = scalePixelsPerMicron;
    }

    public void setXYZ(P3 xyz, boolean doAdjust) {
        this.xyz = xyz;
        if (xyz == null) {
            this.zSlab = Integer.MIN_VALUE;
            this.pymolOffset = null;
        }
        if (doAdjust) {
            this.valign = xyz == null ? 3 : 4;
            this.adjustForWindow = xyz == null;
        }
    }

    public void setTranslucent(float level, boolean isBackground) {
        if (isBackground) {
            if (this.bgcolix != 0) {
                this.bgcolix = C.getColixTranslucent3(this.bgcolix, !Float.isNaN(level), level);
            }
        } else {
            this.colix = C.getColixTranslucent3(this.colix, !Float.isNaN(level), level);
        }
    }

    public void setMovableX(int x) {
        this.valign = this.valign == 4 ? 4 : 3;
        this.movableX = x;
        this.movableXPercent = Integer.MAX_VALUE;
    }

    public void setMovableY(int y) {
        this.valign = this.valign == 4 ? 4 : 3;
        this.movableY = y;
        this.movableYPercent = Integer.MAX_VALUE;
    }

    public void setMovableXPercent(int x) {
        this.valign = this.valign == 4 ? 4 : 3;
        this.movableX = Integer.MAX_VALUE;
        this.movableXPercent = x;
    }

    public void setMovableYPercent(int y) {
        this.valign = this.valign == 4 ? 4 : 3;
        this.movableY = Integer.MAX_VALUE;
        this.movableYPercent = y;
    }

    public void setMovableZPercent(int z) {
        if (this.valign != 4) {
            this.valign = 3;
        }
        this.movableZ = Integer.MAX_VALUE;
        this.movableZPercent = z;
    }

    public void setZs(int z, int zSlab) {
        this.z = z;
        this.zSlab = zSlab;
    }

    public void setXYZs(int x, int y, int z, int zSlab) {
        this.setMovableX(x);
        this.setMovableY(y);
        this.setZs(z, zSlab);
    }

    public void setScript(String script) {
        this.script = script == null || script.length() == 0 ? null : script;
    }

    public boolean setAlignmentLCR(String align) {
        if (align != null) {
            if ("left".equals(align)) {
                return this.setAlignment(4);
            }
            if ("center".equals(align)) {
                return this.setAlignment(8);
            }
            if ("right".equals(align)) {
                return this.setAlignment(12);
            }
        }
        return false;
    }

    public boolean setAlignment(int align) {
        if (this.align != align) {
            this.align = align;
            this.recalc();
        }
        return true;
    }

    public void setBoxOffsetsInWindow(float margin, float vMargin, float vTop) {
        float x = this.boxX;
        float bw = this.boxWidth + margin;
        if (x + bw > (float)this.windowWidth) {
            x = (float)this.windowWidth - bw;
        }
        if (x < margin) {
            x = margin;
        }
        this.boxX = x;
        float y = vTop;
        float bh = this.boxHeight;
        if (y + bh > (float)this.windowHeight) {
            y = (float)this.windowHeight - bh;
        }
        if (y < vMargin) {
            y = vMargin;
        }
        this.boxY = y;
    }

    public void setWindow(int width, int height, float scalePixelsPerMicron) {
        this.windowWidth = width;
        this.windowHeight = height;
        if (this.pymolOffset == null && this.scalePixelsPerMicron < 0.0f && scalePixelsPerMicron != 0.0f) {
            this.setScalePixelsPerMicron(scalePixelsPerMicron);
        }
    }

    public boolean checkObjectClicked(boolean isAntialiased, int x, int y, BS bsVisible) {
        if (this.hidden || this.script == null || this.modelIndex >= 0 && !bsVisible.get(this.modelIndex)) {
            return false;
        }
        if (isAntialiased) {
            x <<= 1;
            y <<= 1;
        }
        return (float)x >= this.boxX && (float)x <= this.boxX + this.boxWidth && (float)y >= this.boxY && (float)y <= this.boxY + this.boxHeight;
    }

    public void getPymolScreenOffset(P3 atomPt, P3i screen, int zSlab, P3 pTemp, double sppm) {
        boolean isPixel = this.isPymolOffsetPixels();
        boolean isRelative = this.isPymolOffsetRelative();
        if (atomPt != null && isRelative) {
            pTemp.setT(atomPt);
        } else {
            pTemp.set(0.0f, 0.0f, 0.0f);
        }
        pTemp.add3(this.pymolOffset[4], this.pymolOffset[5], this.pymolOffset[6]);
        this.vwr.tm.transformPtScr(pTemp, screen);
        if (isPixel) {
            screen.x = (int)((float)screen.x + this.pymolOffset[1]);
            screen.y = (int)((float)screen.y + this.pymolOffset[2]);
            screen.z = (int)((float)screen.z + this.pymolOffset[3]);
        }
        this.setXYZs(screen.x, screen.y, screen.z, zSlab);
    }

    private boolean isPymolOffsetRelative() {
        int mode = this.pymolOffset == null ? -1 : (int)this.pymolOffset[0];
        return (mode & 1) == 1;
    }

    private boolean isPymolOffsetPixels() {
        int mode = this.pymolOffset == null ? -1 : (int)this.pymolOffset[0];
        return mode != -1 && (mode & 2) == 2;
    }

    public String getStateText() {
        return this.doFormatText ? PT.rep(this.text, "@{", "\\@{") : this.text;
    }

    public String toString() {
        return this.textUnformatted;
    }
}

