/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.query.order;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.query.Query;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.util.ReflectionUtils;

public class ManualEntityOrdering {
    PersistentEntity entity;
    private static Map<String, Method> cachedReadMethods = new ConcurrentHashMap<String, Method>();

    public ManualEntityOrdering(PersistentEntity entity) {
        this.entity = entity;
    }

    public PersistentEntity getEntity() {
        return this.entity;
    }

    public List applyOrder(List results, List<Query.Order> orderDefinition) {
        if (results == null) {
            return null;
        }
        if (orderDefinition == null) {
            return results;
        }
        for (Query.Order order : orderDefinition) {
            results = this.applyOrder(results, order);
        }
        return results;
    }

    private static List reverse(List list) {
        int size = list.size();
        ArrayList answer = new ArrayList(size);
        ListIterator iter = list.listIterator(size);
        while (iter.hasPrevious()) {
            answer.add(iter.previous());
        }
        return answer;
    }

    public List applyOrder(List results, Query.Order order) {
        PersistentProperty identity;
        String name = order.getProperty();
        final PersistentEntity entity = this.getEntity();
        PersistentProperty property = entity.getPropertyByName(name);
        if (property == null && name.equals((identity = entity.getIdentity()).getName())) {
            property = identity;
        }
        if (property != null) {
            final PersistentProperty finalProperty = property;
            Collections.sort(results, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (entity.isInstance(o1) && entity.isInstance(o2)) {
                        Class<?> declaringClass;
                        BeanWrapper b;
                        PropertyDescriptor pd;
                        String propertyName = finalProperty.getName();
                        Method readMethod = cachedReadMethods.get(propertyName);
                        if (readMethod == null && (pd = (b = PropertyAccessorFactory.forBeanPropertyAccess((Object)o1)).getPropertyDescriptor(propertyName)) != null && (readMethod = pd.getReadMethod()) != null) {
                            ReflectionUtils.makeAccessible((Method)readMethod);
                            cachedReadMethods.put(propertyName, readMethod);
                        }
                        if (readMethod != null && (declaringClass = readMethod.getDeclaringClass()).isInstance(o1) && declaringClass.isInstance(o2)) {
                            Object left = ReflectionUtils.invokeMethod((Method)readMethod, (Object)o1);
                            Object right = ReflectionUtils.invokeMethod((Method)readMethod, (Object)o2);
                            if (left == null && right == null) {
                                return 0;
                            }
                            if (left != null && right == null) {
                                return 1;
                            }
                            if (left == null) {
                                return -1;
                            }
                            if (left instanceof Comparable && right instanceof Comparable) {
                                return ((Comparable)left).compareTo(right);
                            }
                        }
                    }
                    return 0;
                }
            });
        }
        if (order.getDirection() == Query.Order.Direction.DESC) {
            results = ManualEntityOrdering.reverse(results);
        }
        return results;
    }
}

