/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.ImmutableList;
import java.io.File;

public interface TransformationResult {
    public ImmutableList<File> resolveOutputsForInputArtifact(File var1);

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableList.Builder<TransformationOutput> builder = ImmutableList.builder();
        private boolean onlyProducedOutputs = true;

        public void addInputArtifact(String relativePath) {
            this.onlyProducedOutputs = false;
            this.builder.add((Object)new PartOfInputArtifact(relativePath));
        }

        public void addInputArtifact() {
            this.onlyProducedOutputs = false;
            this.builder.add((Object)EntireInputArtifact.INSTANCE);
        }

        public void addOutput(File outputLocation) {
            this.builder.add((Object)new ProducedOutput(outputLocation));
        }

        public TransformationResult build() {
            ImmutableList transformationOutputs = this.builder.build();
            return this.onlyProducedOutputs ? new AlreadyResolvedTransformationResult(Builder.convertToProducedOutputLocations((ImmutableList<TransformationOutput>)transformationOutputs)) : new ResolvingTransformationResult((ImmutableList<TransformationOutput>)transformationOutputs);
        }

        private static ImmutableList<File> convertToProducedOutputLocations(ImmutableList<TransformationOutput> transformationOutputs) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            transformationOutputs.forEach(output -> builder.add((Object)((ProducedOutput)output).getOutputLocation()));
            return builder.build();
        }

        private static class ProducedOutput
        implements TransformationOutput {
            private final File outputFile;

            public ProducedOutput(File outputFile) {
                this.outputFile = outputFile;
            }

            public File getOutputLocation() {
                return this.outputFile;
            }

            @Override
            public File resolveForInputArtifact(File inputArtifact) {
                return this.outputFile;
            }
        }

        private static class EntireInputArtifact
        implements TransformationOutput {
            public static final EntireInputArtifact INSTANCE = new EntireInputArtifact();

            private EntireInputArtifact() {
            }

            @Override
            public File resolveForInputArtifact(File inputArtifact) {
                return inputArtifact;
            }
        }

        private static class PartOfInputArtifact
        implements TransformationOutput {
            private final String relativePath;

            public PartOfInputArtifact(String relativePath) {
                this.relativePath = relativePath;
            }

            @Override
            public File resolveForInputArtifact(File inputArtifact) {
                return new File(inputArtifact, this.relativePath);
            }
        }

        private static class ResolvingTransformationResult
        implements TransformationResult {
            private final ImmutableList<TransformationOutput> transformationOutputs;

            public ResolvingTransformationResult(ImmutableList<TransformationOutput> transformationOutputs) {
                this.transformationOutputs = transformationOutputs;
            }

            @Override
            public ImmutableList<File> resolveOutputsForInputArtifact(File inputArtifact) {
                ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)this.transformationOutputs.size());
                this.transformationOutputs.forEach(output -> builder.add((Object)output.resolveForInputArtifact(inputArtifact)));
                return builder.build();
            }
        }

        private static class AlreadyResolvedTransformationResult
        implements TransformationResult {
            private final ImmutableList<File> producedOutputLocations;

            public AlreadyResolvedTransformationResult(ImmutableList<File> producedOutputLocations) {
                this.producedOutputLocations = producedOutputLocations;
            }

            @Override
            public ImmutableList<File> resolveOutputsForInputArtifact(File inputArtifact) {
                return this.producedOutputLocations;
            }
        }

        private static interface TransformationOutput {
            public File resolveForInputArtifact(File var1);
        }
    }
}

