/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DependencyArtifactsVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.specs.ExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.RootGraphNode;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveState;
import org.gradle.internal.component.model.VariantArtifactResolveState;
import org.gradle.internal.resolve.resolver.ArtifactSelector;

public class ResolvedArtifactsGraphVisitor
implements DependencyGraphVisitor {
    private int nextId;
    private final Map<Long, ArtifactsForNode> artifactsByNodeId = Maps.newHashMap();
    private final ArtifactSelector artifactSelector;
    private final DependencyArtifactsVisitor artifactResults;

    public ResolvedArtifactsGraphVisitor(DependencyArtifactsVisitor artifactsBuilder, ArtifactSelector artifactSelector) {
        this.artifactResults = artifactsBuilder;
        this.artifactSelector = artifactSelector;
    }

    @Override
    public void start(RootGraphNode root) {
        this.artifactResults.startArtifacts(root);
    }

    @Override
    public void visitNode(DependencyGraphNode node) {
        this.artifactResults.visitNode(node);
    }

    @Override
    public void visitSelector(DependencyGraphSelector selector) {
    }

    @Override
    public void visitEdges(DependencyGraphNode node) {
        for (DependencyGraphEdge dependencyGraphEdge : node.getIncomingEdges()) {
            if (!dependencyGraphEdge.contributesArtifacts()) continue;
            DependencyGraphNode parent = dependencyGraphEdge.getFrom();
            ArtifactsForNode artifacts = this.getArtifacts(dependencyGraphEdge, node);
            this.artifactResults.visitArtifacts(parent, node, artifacts.artifactSetId, artifacts.artifactSet);
        }
        for (LocalFileDependencyMetadata localFileDependencyMetadata : node.getOutgoingFileEdges()) {
            int id;
            ++this.nextId;
            this.artifactResults.visitArtifacts(node, localFileDependencyMetadata, id, this.artifactSelector.resolveArtifacts(localFileDependencyMetadata));
        }
    }

    @Override
    public void finish(DependencyGraphNode root) {
        this.artifactResults.finishArtifacts();
        this.artifactsByNodeId.clear();
    }

    private ArtifactsForNode getArtifacts(DependencyGraphEdge dependency, DependencyGraphNode toNode) {
        ComponentArtifactResolveState componentState = toNode.getOwner().getResolveState().prepareForArtifactResolution();
        VariantArtifactResolveState variantState = componentState.prepareForArtifactResolution(toNode.getMetadata());
        ImmutableAttributes overriddenAttributes = dependency.getAttributes();
        List<ComponentArtifactMetadata> artifacts = dependency.getArtifacts(variantState);
        if (!artifacts.isEmpty()) {
            int id = this.nextId++;
            ArtifactSet artifactSet = componentState.prepareForArtifactResolution(this.artifactSelector, artifacts, overriddenAttributes);
            return new ArtifactsForNode(id, artifactSet);
        }
        ArtifactsForNode configurationArtifactSet = this.artifactsByNodeId.get(toNode.getNodeId());
        if (configurationArtifactSet == null) {
            ExcludeSpec exclusions = dependency.getExclusions();
            ArtifactSet nodeArtifacts = variantState.resolveArtifacts(this.artifactSelector, exclusions, overriddenAttributes);
            int id = this.nextId++;
            configurationArtifactSet = new ArtifactsForNode(id, nodeArtifacts);
            if (!exclusions.mayExcludeArtifacts()) {
                this.artifactsByNodeId.put(toNode.getNodeId(), configurationArtifactSet);
            }
        }
        return configurationArtifactSet;
    }

    private static class ArtifactsForNode {
        private final int artifactSetId;
        private final ArtifactSet artifactSet;

        ArtifactsForNode(int artifactSetId, ArtifactSet artifactSet) {
            this.artifactSetId = artifactSetId;
            this.artifactSet = artifactSet;
        }
    }
}

