/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.Task;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;

class TasksFromProjectDependencies
extends AbstractTaskDependency {
    private final String taskName;
    private final Supplier<DependencySet> dependencies;

    public TasksFromProjectDependencies(String taskName, Supplier<DependencySet> dependencies) {
        this.taskName = taskName;
        this.dependencies = dependencies;
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        this.resolveProjectDependencies(context, (Set<ProjectDependency>)this.dependencies.get().withType(ProjectDependency.class));
    }

    void resolveProjectDependencies(TaskDependencyResolveContext context, Set<ProjectDependency> projectDependencies) {
        for (ProjectDependency projectDependency : projectDependencies) {
            ProjectInternal dependencyProject = (ProjectInternal)projectDependency.getDependencyProject();
            dependencyProject.getOwner().ensureTasksDiscovered();
            Task nextTask = (Task)projectDependency.getDependencyProject().getTasks().findByName(this.taskName);
            if (nextTask == null || context.getTask() == nextTask) continue;
            context.add((Object)nextTask);
        }
    }

    public String getTaskName() {
        return this.taskName;
    }
}

