/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.AnnotationTargetUtil;
import org.jetbrains.kotlin.com.intellij.core.JavaPsiBundle;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.psi.HierarchicalMethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnonymousClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayInitializerExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiAssignmentExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiBlockStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiCall;
import org.jetbrains.kotlin.com.intellij.psi.PsiCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiConstructorCall;
import org.jetbrains.kotlin.com.intellij.psi.PsiDiamondType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiEllipsisType;
import org.jetbrains.kotlin.com.intellij.psi.PsiEnumConstant;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFunctionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiIntersectionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpressionType;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaParameterType;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceType;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiNewExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiResolveHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiReturnStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiSuperExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiSwitchLabeledRuleStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiThisExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeCastExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiYieldStatement;
import org.jetbrains.kotlin.com.intellij.psi.ThreadLocalTypes;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.util.MethodSignatureUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiSuperMethodUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTypesUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.Consumer;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public final class LambdaUtil {
    private static final Logger LOG = Logger.getInstance(LambdaUtil.class);

    @Nullable
    public static PsiType getFunctionalInterfaceReturnType(PsiFunctionalExpression expr) {
        return LambdaUtil.getFunctionalInterfaceReturnType(expr.getFunctionalInterfaceType());
    }

    @Nullable
    public static PsiType getFunctionalInterfaceReturnType(@Nullable PsiType functionalInterfaceType) {
        MethodSignature methodSignature;
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass != null && (methodSignature = LambdaUtil.getFunction(psiClass)) != null) {
            PsiType returnType2 = LambdaUtil.getReturnType(psiClass, methodSignature);
            return resolveResult.getSubstitutor().substitute(returnType2);
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiMethod getFunctionalInterfaceMethod(@Nullable PsiType functionalInterfaceType) {
        return LambdaUtil.getFunctionalInterfaceMethod(PsiUtil.resolveGenericsClassInType(functionalInterfaceType));
    }

    public static PsiMethod getFunctionalInterfaceMethod(@Nullable PsiElement element) {
        if (element instanceof PsiFunctionalExpression) {
            PsiType samType = ((PsiFunctionalExpression)element).getFunctionalInterfaceType();
            return LambdaUtil.getFunctionalInterfaceMethod(samType);
        }
        return null;
    }

    @Nullable
    public static PsiMethod getFunctionalInterfaceMethod(@NotNull PsiClassType.ClassResolveResult result2) {
        if (result2 == null) {
            LambdaUtil.$$$reportNull$$$0(0);
        }
        return LambdaUtil.getFunctionalInterfaceMethod(result2.getElement());
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiMethod getFunctionalInterfaceMethod(PsiClass aClass) {
        MethodSignature methodSignature = LambdaUtil.getFunction(aClass);
        if (methodSignature != null) {
            return LambdaUtil.getMethod(aClass, methodSignature);
        }
        return null;
    }

    public static PsiSubstitutor getSubstitutor(@NotNull PsiMethod method, @NotNull PsiClassType.ClassResolveResult resolveResult) {
        PsiClass derivedClass;
        if (method == null) {
            LambdaUtil.$$$reportNull$$$0(1);
        }
        if (resolveResult == null) {
            LambdaUtil.$$$reportNull$$$0(2);
        }
        LOG.assertTrue((derivedClass = resolveResult.getElement()) != null);
        PsiClass methodContainingClass = method.getContainingClass();
        LOG.assertTrue(methodContainingClass != null);
        PsiSubstitutor initialSubst = resolveResult.getSubstitutor();
        PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(methodContainingClass, derivedClass, PsiSubstitutor.EMPTY);
        for (PsiTypeParameter param : superClassSubstitutor.getSubstitutionMap().keySet()) {
            initialSubst = initialSubst.put(param, initialSubst.substitute(superClassSubstitutor.substitute(param)));
        }
        return initialSubst;
    }

    public static boolean isFunctionalType(PsiType type2) {
        if (type2 instanceof PsiIntersectionType) {
            return LambdaUtil.extractFunctionalConjunct((PsiIntersectionType)type2) != null;
        }
        return LambdaUtil.isFunctionalClass(PsiUtil.resolveClassInClassTypeOnly(type2));
    }

    @Contract(value="null -> false")
    public static boolean isFunctionalClass(PsiClass aClass) {
        if (aClass != null) {
            if (aClass instanceof PsiTypeParameter) {
                return false;
            }
            return LambdaUtil.getFunction(aClass) != null;
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean isValidLambdaContext(@Nullable PsiElement context) {
        PsiSwitchBlock switchBlock;
        PsiElement parent2;
        PsiSwitchExpression switchExpression;
        if (LambdaUtil.isAssignmentOrInvocationContext(context = PsiUtil.skipParenthesizedExprUp(context)) || context instanceof PsiTypeCastExpression) {
            return true;
        }
        if (context instanceof PsiConditionalExpression) {
            PsiElement parentContext = PsiUtil.skipParenthesizedExprUp(context.getParent());
            if (LambdaUtil.isAssignmentOrInvocationContext(parentContext)) {
                return true;
            }
            if (parentContext instanceof PsiConditionalExpression) {
                return LambdaUtil.isValidLambdaContext(parentContext);
            }
        }
        if (context instanceof PsiYieldStatement && (switchExpression = ((PsiYieldStatement)context).findEnclosingExpression()) != null) {
            return LambdaUtil.isValidLambdaContext(switchExpression.getParent());
        }
        if (context instanceof PsiExpressionStatement && (parent2 = context.getParent()) instanceof PsiSwitchLabeledRuleStatement && (switchBlock = ((PsiSwitchLabeledRuleStatement)parent2).getEnclosingSwitchBlock()) != null) {
            return LambdaUtil.isValidLambdaContext(switchBlock.getParent());
        }
        return false;
    }

    @Contract(value="null -> false")
    private static boolean isAssignmentOrInvocationContext(PsiElement context) {
        return LambdaUtil.isAssignmentContext(context) || LambdaUtil.isInvocationContext(context);
    }

    private static boolean isInvocationContext(@Nullable PsiElement context) {
        return context instanceof PsiExpressionList;
    }

    private static boolean isAssignmentContext(PsiElement context) {
        return context instanceof PsiLambdaExpression || context instanceof PsiReturnStatement || context instanceof PsiAssignmentExpression || context instanceof PsiVariable && !LambdaUtil.withInferredType((PsiVariable)context) || context instanceof PsiArrayInitializerExpression;
    }

    private static boolean withInferredType(PsiVariable variable2) {
        PsiTypeElement typeElement = variable2.getTypeElement();
        return typeElement != null && typeElement.isInferredType();
    }

    @Contract(value="null -> null")
    @Nullable
    public static MethodSignature getFunction(PsiClass psiClass) {
        if (LambdaUtil.isPlainInterface(psiClass)) {
            return CachedValuesManager.getProjectPsiDependentCache(psiClass, LambdaUtil::calcFunction);
        }
        return null;
    }

    private static boolean isPlainInterface(PsiClass psiClass) {
        return psiClass != null && psiClass.isInterface() && !psiClass.isAnnotationType();
    }

    @Nullable
    private static MethodSignature calcFunction(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            LambdaUtil.$$$reportNull$$$0(3);
        }
        if (LambdaUtil.hasManyOwnAbstractMethods(psiClass) || LambdaUtil.hasManyInheritedAbstractMethods(psiClass)) {
            return null;
        }
        List<HierarchicalMethodSignature> functions2 = LambdaUtil.findFunctionCandidates(psiClass);
        return functions2 != null && functions2.size() == 1 ? (MethodSignature)functions2.get(0) : null;
    }

    private static boolean hasManyOwnAbstractMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            LambdaUtil.$$$reportNull$$$0(4);
        }
        int abstractCount = 0;
        for (PsiMethod method : psiClass.getMethods()) {
            if (!LambdaUtil.isDefinitelyAbstractInterfaceMethod(method) || ++abstractCount <= 1) continue;
            return true;
        }
        return false;
    }

    private static boolean isDefinitelyAbstractInterfaceMethod(PsiMethod method) {
        return method.hasModifierProperty("abstract") && !LambdaUtil.isPublicObjectMethod(method.getName());
    }

    private static boolean isPublicObjectMethod(String methodName) {
        return "equals".equals(methodName) || "hashCode".equals(methodName) || "toString".equals(methodName);
    }

    private static boolean hasManyInheritedAbstractMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            LambdaUtil.$$$reportNull$$$0(5);
        }
        HashSet abstractNames = new HashSet();
        HashSet defaultNames = new HashSet();
        InheritanceUtil.processSupers(psiClass, true, psiClass1 -> {
            for (PsiMethod method : psiClass1.getMethods()) {
                if (LambdaUtil.isDefinitelyAbstractInterfaceMethod(method)) {
                    abstractNames.add(method.getName());
                    continue;
                }
                if (!method.hasModifierProperty("default")) continue;
                defaultNames.add(method.getName());
            }
            return true;
        });
        abstractNames.removeAll(defaultNames);
        return abstractNames.size() > 1;
    }

    private static boolean overridesPublicObjectMethod(HierarchicalMethodSignature psiMethod) {
        PsiMethod method;
        PsiClass containingClass;
        List<HierarchicalMethodSignature> signatures2 = psiMethod.getSuperSignatures();
        if (signatures2.isEmpty() && (containingClass = (method = psiMethod.getMethod()).getContainingClass()) != null && "java.lang.Object".equals(containingClass.getQualifiedName()) && method.hasModifierProperty("public")) {
            return true;
        }
        for (HierarchicalMethodSignature superMethod : signatures2) {
            if (!LambdaUtil.overridesPublicObjectMethod(superMethod)) continue;
            return true;
        }
        return false;
    }

    private static MethodSignature getMethodSignature(PsiMethod method, PsiClass psiClass, PsiClass containingClass) {
        MethodSignature methodSignature = containingClass != null && containingClass != psiClass ? method.getSignature(TypeConversionUtil.getSuperClassSubstitutor(containingClass, psiClass, PsiSubstitutor.EMPTY)) : method.getSignature(PsiSubstitutor.EMPTY);
        return methodSignature;
    }

    @NotNull
    private static List<HierarchicalMethodSignature> hasSubSignature(List<HierarchicalMethodSignature> signatures2) {
        for (HierarchicalMethodSignature signature2 : signatures2) {
            boolean subSignature = true;
            for (HierarchicalMethodSignature methodSignature : signatures2) {
                if (signature2.equals(methodSignature) || LambdaUtil.skipMethod(signature2, methodSignature)) continue;
                subSignature = false;
                break;
            }
            if (!subSignature) continue;
            List<HierarchicalMethodSignature> list2 = Collections.singletonList(signature2);
            if (list2 == null) {
                LambdaUtil.$$$reportNull$$$0(6);
            }
            return list2;
        }
        List<HierarchicalMethodSignature> list3 = signatures2;
        if (list3 == null) {
            LambdaUtil.$$$reportNull$$$0(7);
        }
        return list3;
    }

    private static boolean skipMethod(HierarchicalMethodSignature signature2, HierarchicalMethodSignature methodSignature) {
        if (methodSignature.getTypeParameters().length == 0) {
            return false;
        }
        return signature2.getMethod().getContainingClass() != methodSignature.getMethod().getContainingClass();
    }

    @Contract(value="null -> null")
    @Nullable
    public static List<HierarchicalMethodSignature> findFunctionCandidates(@Nullable PsiClass psiClass) {
        if (!LambdaUtil.isPlainInterface(psiClass)) {
            return null;
        }
        ArrayList<HierarchicalMethodSignature> methods2 = new ArrayList<HierarchicalMethodSignature>();
        Map<MethodSignature, Set<PsiMethod>> overrideEquivalents = PsiSuperMethodUtil.collectOverrideEquivalents(psiClass);
        Collection<HierarchicalMethodSignature> visibleSignatures = psiClass.getVisibleSignatures();
        for (HierarchicalMethodSignature signature2 : visibleSignatures) {
            PsiMethod psiMethod = signature2.getMethod();
            if (!psiMethod.hasModifierProperty("abstract") || psiMethod.hasModifierProperty("static")) continue;
            Set<PsiMethod> equivalentMethods = overrideEquivalents.get(signature2);
            if (equivalentMethods != null && equivalentMethods.size() > 1) {
                boolean hasNonAbstractOverrideEquivalent = false;
                for (PsiMethod method : equivalentMethods) {
                    if (method.hasModifierProperty("abstract") || MethodSignatureUtil.isSuperMethod(method, psiMethod)) continue;
                    hasNonAbstractOverrideEquivalent = true;
                    break;
                }
                if (hasNonAbstractOverrideEquivalent) continue;
            }
            if (LambdaUtil.overridesPublicObjectMethod(signature2)) continue;
            methods2.add(signature2);
        }
        return LambdaUtil.hasSubSignature(methods2);
    }

    @Nullable
    private static PsiType getReturnType(PsiClass psiClass, MethodSignature methodSignature) {
        PsiMethod method = LambdaUtil.getMethod(psiClass, methodSignature);
        if (method != null) {
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return null;
            }
            return TypeConversionUtil.getSuperClassSubstitutor(containingClass, psiClass, PsiSubstitutor.EMPTY).substitute(method.getReturnType());
        }
        return null;
    }

    @Nullable
    private static PsiMethod getMethod(PsiClass psiClass, MethodSignature methodSignature) {
        PsiMethod[] methodsByName;
        if (methodSignature instanceof MethodSignatureBackedByPsiMethod) {
            return ((MethodSignatureBackedByPsiMethod)methodSignature).getMethod();
        }
        for (PsiMethod psiMethod : methodsByName = psiClass.findMethodsByName(methodSignature.getName(), true)) {
            if (!MethodSignatureUtil.areSignaturesEqual(LambdaUtil.getMethodSignature(psiMethod, psiClass, psiMethod.getContainingClass()), methodSignature)) continue;
            return psiMethod;
        }
        return null;
    }

    public static int getLambdaIdx(PsiExpressionList expressionList, PsiElement element) {
        PsiExpression[] expressions = expressionList.getExpressions();
        for (int i = 0; i < expressions.length; ++i) {
            PsiExpression expression2 = expressions[i];
            if (!PsiTreeUtil.isAncestor(expression2, element, false)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public static PsiType getFunctionalInterfaceType(PsiElement expression2, boolean tryToSubstitute) {
        PsiSwitchExpression switchExpression;
        PsiElement parent2 = expression2.getParent();
        PsiElement element = expression2;
        while (parent2 instanceof PsiParenthesizedExpression || parent2 instanceof PsiConditionalExpression) {
            if (parent2 instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent2).getCondition() == element) {
                return PsiType.BOOLEAN;
            }
            element = parent2;
            parent2 = parent2.getParent();
        }
        PsiType type2 = ThreadLocalTypes.getElementType(expression2);
        if (type2 == null) {
            type2 = ThreadLocalTypes.getElementType(element);
        }
        if (type2 != null) {
            return type2;
        }
        if (parent2 instanceof PsiArrayInitializerExpression) {
            PsiType psiType2 = ((PsiArrayInitializerExpression)parent2).getType();
            if (psiType2 instanceof PsiArrayType) {
                return ((PsiArrayType)psiType2).getComponentType();
            }
        } else {
            if (parent2 instanceof PsiTypeCastExpression) {
                PsiType conjunct;
                PsiType castType2;
                PsiTypeElement castTypeElement = ((PsiTypeCastExpression)parent2).getCastType();
                PsiType psiType3 = castType2 = castTypeElement != null ? castTypeElement.getType() : null;
                if (castType2 instanceof PsiIntersectionType && (conjunct = LambdaUtil.extractFunctionalConjunct((PsiIntersectionType)castType2)) != null) {
                    return conjunct;
                }
                return castType2;
            }
            if (parent2 instanceof PsiVariable) {
                return ((PsiVariable)parent2).getType();
            }
            if (parent2 instanceof PsiAssignmentExpression && expression2 instanceof PsiExpression && !PsiUtil.isOnAssignmentLeftHand((PsiExpression)expression2)) {
                PsiExpression lExpression = ((PsiAssignmentExpression)parent2).getLExpression();
                return lExpression.getType();
            }
            if (parent2 instanceof PsiExpressionList) {
                PsiExpressionList expressionList = (PsiExpressionList)parent2;
                int lambdaIdx = LambdaUtil.getLambdaIdx(expressionList, expression2);
                if (lambdaIdx >= 0) {
                    PsiElement gParent = expressionList.getParent();
                    if (gParent instanceof PsiAnonymousClass) {
                        gParent = gParent.getParent();
                    }
                    if (gParent instanceof PsiCall) {
                        PsiCall contextCall = (PsiCall)gParent;
                        JavaResolveResult resolveResult = PsiDiamondType.getDiamondsAwareResolveResult(contextCall);
                        PsiElement resultElement = resolveResult.getElement();
                        LOG.assertTrue(!MethodCandidateInfo.isOverloadCheck(contextCall.getArgumentList()) || !(resultElement instanceof PsiMethod) || !((PsiMethod)resultElement).hasTypeParameters());
                        return LambdaUtil.getSubstitutedType(expression2, tryToSubstitute, lambdaIdx, resolveResult);
                    }
                }
            } else {
                if (parent2 instanceof PsiReturnStatement) {
                    return PsiTypesUtil.getMethodReturnType(parent2);
                }
                if (parent2 instanceof PsiLambdaExpression) {
                    return LambdaUtil.getFunctionalInterfaceTypeByContainingLambda((PsiLambdaExpression)parent2);
                }
            }
        }
        if ((switchExpression = PsiTreeUtil.getParentOfType(element, PsiSwitchExpression.class)) != null && PsiUtil.getSwitchResultExpressions(switchExpression).contains(element)) {
            return LambdaUtil.getFunctionalInterfaceType(switchExpression, tryToSubstitute);
        }
        return null;
    }

    @Nullable
    private static PsiType getSubstitutedType(PsiElement expression2, boolean tryToSubstitute, int lambdaIdx, JavaResolveResult resolveResult) {
        PsiParameter[] parameters2;
        int finalLambdaIdx;
        PsiElement resolve2 = resolveResult.getElement();
        if (resolve2 instanceof PsiMethod && (finalLambdaIdx = LambdaUtil.adjustLambdaIdx(lambdaIdx, (PsiMethod)resolve2, parameters2 = ((PsiMethod)resolve2).getParameterList().getParameters())) < parameters2.length) {
            if (!tryToSubstitute) {
                return LambdaUtil.getNormalizedType(parameters2[finalLambdaIdx]);
            }
            return PsiResolveHelper.ourGraphGuard.doPreventingRecursion(expression2, !MethodCandidateInfo.isOverloadCheck(), () -> {
                PsiType normalizedType = LambdaUtil.getNormalizedType(parameters2[finalLambdaIdx]);
                if (resolveResult instanceof MethodCandidateInfo && ((MethodCandidateInfo)resolveResult).isRawSubstitution()) {
                    return TypeConversionUtil.erasure(normalizedType);
                }
                return resolveResult.getSubstitutor().substitute(normalizedType);
            });
        }
        return null;
    }

    public static boolean processParentOverloads(PsiFunctionalExpression functionalExpression, Consumer<? super PsiType> overloadProcessor) {
        PsiExpressionList expressionList;
        int lambdaIdx;
        LOG.assertTrue(PsiTypesUtil.getExpectedTypeByParent(functionalExpression) == null);
        PsiElement parent2 = functionalExpression.getParent();
        PsiElement expr = functionalExpression;
        while (!(!(parent2 instanceof PsiParenthesizedExpression) && !(parent2 instanceof PsiConditionalExpression) || parent2 instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent2).getThenExpression() != expr && ((PsiConditionalExpression)parent2).getElseExpression() != expr)) {
            expr = parent2;
            parent2 = parent2.getParent();
        }
        if (parent2 instanceof PsiExpressionList && (lambdaIdx = LambdaUtil.getLambdaIdx(expressionList = (PsiExpressionList)parent2, functionalExpression)) > -1) {
            PsiElement gParent = expressionList.getParent();
            if (gParent instanceof PsiAnonymousClass) {
                gParent = gParent.getParent();
            }
            JavaResolveResult[] results = null;
            if (gParent instanceof PsiMethodCallExpression) {
                results = ((PsiMethodCallExpression)gParent).getMethodExpression().multiResolve(true);
            } else if (gParent instanceof PsiConstructorCall) {
                results = LambdaUtil.getConstructorCandidates((PsiConstructorCall)gParent);
            }
            if (results != null) {
                HashSet<PsiType> types2 = new HashSet<PsiType>();
                for (JavaResolveResult result2 : results) {
                    PsiType functionalExpressionType = MethodCandidateInfo.ourOverloadGuard.doPreventingRecursion(functionalExpression, false, () -> LambdaUtil.getSubstitutedType(functionalExpression, true, lambdaIdx, result2));
                    if (functionalExpressionType == null || !types2.add(functionalExpressionType)) continue;
                    overloadProcessor.consume(functionalExpressionType);
                }
                return true;
            }
        }
        return false;
    }

    private static JavaResolveResult @Nullable [] getConstructorCandidates(PsiConstructorCall parentCall) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance(parentCall.getProject());
        PsiExpressionList argumentList2 = parentCall.getArgumentList();
        if (argumentList2 != null) {
            PsiClassType classType = null;
            if (parentCall instanceof PsiNewExpression) {
                PsiJavaCodeReferenceElement ref = ((PsiNewExpression)parentCall).getClassReference();
                classType = ref != null ? facade.getElementFactory().createType(ref) : null;
            } else if (parentCall instanceof PsiEnumConstant) {
                PsiClass containingClass = ((PsiEnumConstant)parentCall).getContainingClass();
                PsiClassType psiClassType = classType = containingClass != null ? facade.getElementFactory().createType(containingClass) : null;
            }
            if (classType != null) {
                return facade.getResolveHelper().multiResolveConstructor(classType, argumentList2, parentCall);
            }
        }
        return null;
    }

    @Nullable
    private static PsiType extractFunctionalConjunct(PsiIntersectionType type2) {
        PsiType conjunct = null;
        MethodSignature commonSignature = null;
        for (PsiType psiType2 : type2.getConjuncts()) {
            MethodSignature signature2;
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly(psiType2);
            if (aClass instanceof PsiTypeParameter || (signature2 = LambdaUtil.getFunction(aClass)) == null) continue;
            if (commonSignature == null) {
                commonSignature = signature2;
            } else if (!MethodSignatureUtil.areSignaturesEqual(commonSignature, signature2)) {
                return null;
            }
            conjunct = psiType2;
        }
        return conjunct;
    }

    private static PsiType getFunctionalInterfaceTypeByContainingLambda(@NotNull PsiLambdaExpression parentLambda) {
        PsiType parentInterfaceType;
        if (parentLambda == null) {
            LambdaUtil.$$$reportNull$$$0(8);
        }
        return (parentInterfaceType = parentLambda.getFunctionalInterfaceType()) != null ? LambdaUtil.getFunctionalInterfaceReturnType(parentInterfaceType) : null;
    }

    private static int adjustLambdaIdx(int lambdaIdx, PsiMethod resolve2, PsiParameter[] parameters2) {
        int finalLambdaIdx = resolve2.isVarArgs() && lambdaIdx >= parameters2.length ? parameters2.length - 1 : lambdaIdx;
        return finalLambdaIdx;
    }

    private static PsiType getNormalizedType(PsiParameter parameter) {
        PsiType type2 = parameter.getType();
        if (type2 instanceof PsiEllipsisType) {
            return ((PsiEllipsisType)type2).getComponentType();
        }
        return type2;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean notInferredType(PsiType typeByExpression) {
        return typeByExpression instanceof PsiMethodReferenceType || typeByExpression instanceof PsiLambdaExpressionType || typeByExpression instanceof PsiLambdaParameterType;
    }

    public static PsiReturnStatement @NotNull [] getReturnStatements(PsiLambdaExpression lambdaExpression) {
        PsiElement body2 = lambdaExpression.getBody();
        PsiReturnStatement[] psiReturnStatementArray = body2 instanceof PsiCodeBlock ? PsiUtil.findReturnStatements((PsiCodeBlock)body2) : PsiReturnStatement.EMPTY_ARRAY;
        if (psiReturnStatementArray == null) {
            LambdaUtil.$$$reportNull$$$0(9);
        }
        return psiReturnStatementArray;
    }

    public static List<PsiExpression> getReturnExpressions(PsiLambdaExpression lambdaExpression) {
        PsiElement body2 = lambdaExpression.getBody();
        if (body2 instanceof PsiExpression) {
            return Collections.singletonList((PsiExpression)body2);
        }
        ArrayList<PsiExpression> result2 = new ArrayList<PsiExpression>();
        for (PsiReturnStatement returnStatement : LambdaUtil.getReturnStatements(lambdaExpression)) {
            PsiExpression returnValue = returnStatement.getReturnValue();
            if (returnValue == null) continue;
            result2.add(returnValue);
        }
        return result2;
    }

    @Contract(value="null -> false")
    public static boolean isExpressionStatementExpression(PsiElement body2) {
        return body2 instanceof PsiAssignmentExpression || PsiUtil.isIncrementDecrementOperation(body2) || body2 instanceof PsiMethodCallExpression || body2 instanceof PsiNewExpression && !((PsiNewExpression)body2).isArrayCreation() || body2 instanceof PsiReferenceExpression && !body2.isPhysical();
    }

    public static PsiExpression extractSingleExpressionFromBody(PsiElement body2) {
        PsiExpression expression2 = null;
        if (body2 instanceof PsiExpression) {
            expression2 = (PsiExpression)body2;
        } else if (body2 instanceof PsiCodeBlock) {
            PsiStatement[] statements = ((PsiCodeBlock)body2).getStatements();
            if (statements.length == 1) {
                if (statements[0] instanceof PsiReturnStatement) {
                    expression2 = ((PsiReturnStatement)statements[0]).getReturnValue();
                } else if (statements[0] instanceof PsiExpressionStatement) {
                    expression2 = ((PsiExpressionStatement)statements[0]).getExpression();
                } else if (statements[0] instanceof PsiBlockStatement) {
                    return LambdaUtil.extractSingleExpressionFromBody(((PsiBlockStatement)statements[0]).getCodeBlock());
                }
            }
        } else {
            if (body2 instanceof PsiBlockStatement) {
                return LambdaUtil.extractSingleExpressionFromBody(((PsiBlockStatement)body2).getCodeBlock());
            }
            if (body2 instanceof PsiExpressionStatement) {
                expression2 = ((PsiExpressionStatement)body2).getExpression();
            }
        }
        return expression2;
    }

    public static boolean isPotentiallyCompatibleWithTypeParameter(PsiFunctionalExpression expression2, PsiExpressionList argsList, PsiMethod method) {
        PsiParameter[] parameters2;
        PsiParameter lambdaParameter;
        PsiClass paramClass;
        PsiCallExpression callExpression;
        if (!(Registry.is("JDK8042508.bug.fixed", false) || (callExpression = PsiTreeUtil.getParentOfType((PsiElement)argsList, PsiCallExpression.class)) != null && callExpression.getTypeArguments().length <= 0)) {
            return false;
        }
        int lambdaIdx = LambdaUtil.getLambdaIdx(argsList, expression2);
        return lambdaIdx >= 0 && (paramClass = PsiUtil.resolveClassInType((lambdaParameter = (parameters2 = method.getParameterList().getParameters())[Math.min(lambdaIdx, parameters2.length - 1)]).getType())) instanceof PsiTypeParameter && ((PsiTypeParameter)paramClass).getOwner() == method;
    }

    public static Map<PsiElement, @Nls String> checkReturnTypeCompatible(PsiLambdaExpression lambdaExpression, PsiType functionalInterfaceReturnType) {
        LinkedHashMap<PsiElement, String> errors;
        block15: {
            errors = new LinkedHashMap<PsiElement, String>();
            if (PsiType.VOID.equals(functionalInterfaceReturnType)) {
                PsiElement body2 = lambdaExpression.getBody();
                if (body2 instanceof PsiCodeBlock) {
                    for (PsiExpression expression2 : LambdaUtil.getReturnExpressions(lambdaExpression)) {
                        errors.put(expression2, JavaPsiBundle.message("unexpected.return.value", new Object[0]));
                    }
                } else if (body2 instanceof PsiExpression) {
                    try {
                        if (PsiUtil.isStatement(JavaPsiFacade.getElementFactory(body2.getProject()).createStatementFromText(body2.getText(), body2))) break block15;
                        PsiType type2 = ((PsiExpression)body2).getType();
                        if (PsiType.VOID.equals(type2)) {
                            errors.put(body2, JavaPsiBundle.message("lambda.body.must.be.a.statement.expression", new Object[0]));
                            break block15;
                        }
                        errors.put(body2, JavaPsiBundle.message("bad.return.type.in.lambda.expression1", type2 == PsiType.NULL || type2 == null ? "<null>" : type2.getPresentableText()));
                    }
                    catch (IncorrectOperationException type2) {}
                }
            } else if (functionalInterfaceReturnType != null) {
                List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions(lambdaExpression);
                for (PsiExpression expression3 : returnExpressions) {
                    PsiType expressionType = PsiResolveHelper.ourGraphGuard.doPreventingRecursion(expression3, true, expression3::getType);
                    if (expressionType == null || functionalInterfaceReturnType.isAssignableFrom(expressionType)) continue;
                    errors.put(expression3, JavaPsiBundle.message("bad.return.type.in.lambda.expression", expressionType.getPresentableText(), functionalInterfaceReturnType.getPresentableText()));
                }
                PsiReturnStatement[] returnStatements = LambdaUtil.getReturnStatements(lambdaExpression);
                if (returnStatements.length > returnExpressions.size()) {
                    for (PsiReturnStatement statement2 : returnStatements) {
                        PsiExpression value2 = statement2.getReturnValue();
                        if (value2 != null) continue;
                        errors.put(statement2, JavaPsiBundle.message("missing.return.value.lambda", new Object[0]));
                    }
                } else if (returnExpressions.isEmpty() && !lambdaExpression.isVoidCompatible()) {
                    errors.put(lambdaExpression, JavaPsiBundle.message("missing.return.value.lambda", new Object[0]));
                }
            }
        }
        return errors.isEmpty() ? null : errors;
    }

    @Nullable
    public static PsiType getLambdaParameterFromType(PsiType functionalInterfaceType, int parameterIndex) {
        PsiParameter[] parameters2;
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod(functionalInterfaceType);
        if (method != null && parameterIndex < (parameters2 = method.getParameterList().getParameters()).length) {
            return LambdaUtil.getSubstitutor(method, resolveResult).substitute(parameters2[parameterIndex].getType());
        }
        return null;
    }

    @Nullable
    public static PsiCall treeWalkUp(PsiElement context) {
        PsiCall top = null;
        Object parent2 = PsiTreeUtil.getParentOfType(context, PsiExpressionList.class, PsiLambdaExpression.class, PsiConditionalExpression.class, PsiSwitchExpression.class, PsiAssignmentExpression.class, PsiCodeBlock.class, PsiCall.class);
        while (!(parent2 instanceof PsiCall) && !(parent2 instanceof PsiAssignmentExpression)) {
            PsiCall psiCall;
            PsiLambdaExpression lambdaExpression = PsiTreeUtil.getParentOfType(parent2, PsiLambdaExpression.class);
            if (parent2 instanceof PsiCodeBlock) {
                if (lambdaExpression == null) break;
                boolean inReturnExpressions = false;
                for (PsiExpression expression2 : LambdaUtil.getReturnExpressions(lambdaExpression)) {
                    inReturnExpressions |= PsiTreeUtil.isAncestor(expression2, context, false);
                }
                if (!inReturnExpressions || ThreadLocalTypes.hasBindingFor(lambdaExpression)) break;
            }
            if ((parent2 instanceof PsiConditionalExpression || parent2 instanceof PsiSwitchExpression) && !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)parent2) || parent2 instanceof PsiLambdaExpression && ThreadLocalTypes.hasBindingFor(parent2) || (psiCall = PsiTreeUtil.getParentOfType(parent2, PsiCall.class, false, new Class[]{PsiMember.class, PsiVariable.class, PsiAssignmentExpression.class, PsiTypeCastExpression.class})) == null || MethodCandidateInfo.isOverloadCheck(psiCall.getArgumentList()) || lambdaExpression != null && ThreadLocalTypes.hasBindingFor(lambdaExpression) || !((top = psiCall) instanceof PsiExpression) || !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)((Object)top))) break;
            parent2 = PsiTreeUtil.getParentOfType(parent2.getParent(), PsiExpressionList.class, PsiLambdaExpression.class, PsiAssignmentExpression.class, PsiCodeBlock.class);
        }
        if (top == null) {
            return null;
        }
        PsiExpressionList argumentList2 = top.getArgumentList();
        if (argumentList2 == null) {
            return null;
        }
        LOG.assertTrue(!MethodCandidateInfo.isOverloadCheck(argumentList2));
        return top;
    }

    public static PsiCall copyTopLevelCall(@NotNull PsiCall call2) {
        PsiElement parent2;
        if (call2 == null) {
            LambdaUtil.$$$reportNull$$$0(10);
        }
        if (call2 instanceof PsiEnumConstant) {
            PsiClass containingClass = ((PsiEnumConstant)call2).getContainingClass();
            if (containingClass == null) {
                return null;
            }
            String enumName = containingClass.getName();
            if (enumName == null) {
                return null;
            }
            PsiMethod resolveMethod = call2.resolveMethod();
            if (resolveMethod == null) {
                return null;
            }
            PsiElement contextFile = call2.getContainingFile().copy();
            PsiClass anEnum = (PsiClass)contextFile.add(JavaPsiFacade.getElementFactory(call2.getProject()).createEnum(enumName));
            anEnum.add(resolveMethod);
            return (PsiCall)anEnum.add(call2);
        }
        PsiElement expressionForType = call2;
        while ((parent2 = PsiUtil.skipParenthesizedExprUp(expressionForType.getParent())) instanceof PsiConditionalExpression && !PsiTreeUtil.isAncestor(((PsiConditionalExpression)parent2).getCondition(), expressionForType, false)) {
            expressionForType = parent2;
        }
        PsiType type2 = PsiTypesUtil.getExpectedTypeByParent(expressionForType);
        if (PsiTypesUtil.isDenotableType(type2, call2)) {
            return (PsiCall)LambdaUtil.copyWithExpectedType(call2, type2);
        }
        return (PsiCall)call2.copy();
    }

    public static <T> T performWithSubstitutedParameterBounds(PsiTypeParameter[] typeParameters2, PsiSubstitutor substitutor2, Supplier<? extends T> producer) {
        return (T)ThreadLocalTypes.performWithTypes(map -> {
            for (PsiTypeParameter parameter : typeParameters2) {
                PsiClassType[] types2 = parameter.getExtendsListTypes();
                if (types2.length <= 0) continue;
                List<PsiType> conjuncts = ContainerUtil.map(types2, substitutor2::substitute);
                PsiType upperBound = PsiIntersectionType.createIntersection(false, conjuncts.toArray(PsiType.EMPTY_ARRAY));
                map.forceType(parameter, upperBound);
            }
            return producer.get();
        });
    }

    public static <T> T performWithTargetType(@NotNull PsiElement element, @NotNull PsiType targetType, @NotNull Supplier<? extends T> producer) {
        if (element == null) {
            LambdaUtil.$$$reportNull$$$0(11);
        }
        if (targetType == null) {
            LambdaUtil.$$$reportNull$$$0(12);
        }
        if (producer == null) {
            LambdaUtil.$$$reportNull$$$0(13);
        }
        return (T)ThreadLocalTypes.performWithTypes(types2 -> {
            types2.forceType(element, targetType);
            return producer.get();
        });
    }

    public static String createLambda(@NotNull PsiVariable variable2, @NotNull PsiExpression expression2) {
        if (variable2 == null) {
            LambdaUtil.$$$reportNull$$$0(14);
        }
        if (expression2 == null) {
            LambdaUtil.$$$reportNull$$$0(15);
        }
        return variable2.getName() + " -> " + expression2.getText();
    }

    public static boolean isIdentityLambda(PsiLambdaExpression lambda2) {
        PsiParameterList parameters2 = lambda2.getParameterList();
        if (parameters2.getParametersCount() != 1) {
            return false;
        }
        PsiExpression expression2 = PsiUtil.skipParenthesizedExprDown(LambdaUtil.extractSingleExpressionFromBody(lambda2.getBody()));
        return expression2 instanceof PsiReferenceExpression && ((PsiReferenceExpression)expression2).isReferenceTo(parameters2.getParameters()[0]);
    }

    private static boolean isSafeLambdaReplacement(@NotNull PsiLambdaExpression lambda2, @NotNull Function<? super PsiLambdaExpression, ? extends PsiExpression> replacer) {
        JavaResolveResult result2;
        PsiElement oldTarget;
        PsiElement body2;
        if (lambda2 == null) {
            LambdaUtil.$$$reportNull$$$0(16);
        }
        if (replacer == null) {
            LambdaUtil.$$$reportNull$$$0(17);
        }
        if ((body2 = lambda2.getBody()) == null) {
            return false;
        }
        PsiCall call2 = LambdaUtil.treeWalkUp(body2);
        if (call2 != null && (oldTarget = (result2 = call2.resolveMethodGenerics()).getElement()) != null) {
            PsiExpression expressionFromBody;
            String copyMessage;
            String origErrorMessage = result2 instanceof MethodCandidateInfo ? ((MethodCandidateInfo)result2).getInferenceErrorMessage() : null;
            Object marker = new Object();
            PsiTreeUtil.mark(lambda2, marker);
            PsiType origType = call2 instanceof PsiExpression ? ((PsiExpression)((Object)call2)).getType() : null;
            PsiCall copyCall = LambdaUtil.copyTopLevelCall(call2);
            if (copyCall == null) {
                return false;
            }
            PsiLambdaExpression lambdaCopy = ObjectUtils.tryCast(PsiTreeUtil.releaseMark(copyCall, marker), PsiLambdaExpression.class);
            if (lambdaCopy == null) {
                return false;
            }
            PsiExpression function2 = replacer.apply(lambdaCopy);
            if (function2 == null) {
                return false;
            }
            JavaResolveResult resultCopy = copyCall.resolveMethodGenerics();
            if (resultCopy.getElement() != oldTarget) {
                return false;
            }
            String string2 = copyMessage = resultCopy instanceof MethodCandidateInfo ? ((MethodCandidateInfo)resultCopy).getInferenceErrorMessage() : null;
            if (!Objects.equals(origErrorMessage, copyMessage)) {
                return false;
            }
            if (function2 instanceof PsiFunctionalExpression && ((PsiFunctionalExpression)function2).getFunctionalInterfaceType() == null) {
                return false;
            }
            if (origType instanceof PsiClassType && !((PsiClassType)origType).isRaw() && !lambda2.hasFormalParameterTypes() && (expressionFromBody = LambdaUtil.extractSingleExpressionFromBody(body2)) instanceof PsiMethodCallExpression && PsiTypesUtil.isUncheckedCall(((PsiMethodCallExpression)expressionFromBody).resolveMethodGenerics())) {
                return false;
            }
        }
        return true;
    }

    public static boolean isSafeLambdaReplacement(@NotNull PsiLambdaExpression lambda2, @NotNull Supplier<? extends PsiExpression> newFunctionSupplier) {
        if (lambda2 == null) {
            LambdaUtil.$$$reportNull$$$0(18);
        }
        if (newFunctionSupplier == null) {
            LambdaUtil.$$$reportNull$$$0(19);
        }
        return LambdaUtil.isSafeLambdaReplacement(lambda2, (? super PsiLambdaExpression l) -> {
            PsiExpression replacement = (PsiExpression)newFunctionSupplier.get();
            return replacement == null ? null : (PsiExpression)l.replace(replacement);
        });
    }

    public static boolean isSafeLambdaReplacement(@NotNull PsiLambdaExpression lambda2, @NotNull String replacementText) {
        if (lambda2 == null) {
            LambdaUtil.$$$reportNull$$$0(20);
        }
        if (replacementText == null) {
            LambdaUtil.$$$reportNull$$$0(21);
        }
        return LambdaUtil.isSafeLambdaReplacement(lambda2, () -> JavaPsiFacade.getElementFactory(lambda2.getProject()).createExpressionFromText(replacementText, lambda2.getParent()));
    }

    public static boolean isSafeLambdaBodyReplacement(@NotNull PsiLambdaExpression lambda2, @NotNull Supplier<? extends PsiElement> newBodySupplier) {
        if (lambda2 == null) {
            LambdaUtil.$$$reportNull$$$0(22);
        }
        if (newBodySupplier == null) {
            LambdaUtil.$$$reportNull$$$0(23);
        }
        return LambdaUtil.isSafeLambdaReplacement(lambda2, (? super PsiLambdaExpression l) -> {
            PsiElement oldBody = l.getBody();
            PsiElement newBody = (PsiElement)newBodySupplier.get();
            if (oldBody == null || newBody == null) {
                return null;
            }
            oldBody.replace(newBody);
            return l;
        });
    }

    public static boolean isSafeLambdaReturnValueReplacement(@NotNull PsiExpression lambdaReturnExpression, @NotNull PsiExpression replacement) {
        PsiLambdaExpression lambdaExpression;
        if (lambdaReturnExpression == null) {
            LambdaUtil.$$$reportNull$$$0(24);
        }
        if (replacement == null) {
            LambdaUtil.$$$reportNull$$$0(25);
        }
        return !(lambdaReturnExpression.getParent() instanceof PsiReturnStatement) && !(lambdaReturnExpression.getParent() instanceof PsiLambdaExpression) || (lambdaExpression = PsiTreeUtil.getParentOfType((PsiElement)lambdaReturnExpression, PsiLambdaExpression.class, true, PsiMethod.class)) == null || LambdaUtil.isSafeLambdaBodyReplacement(lambdaExpression, () -> {
            PsiLambdaExpression lambdaExpression1 = PsiTreeUtil.getParentOfType((PsiElement)lambdaReturnExpression, PsiLambdaExpression.class);
            if (lambdaExpression1 == null) {
                return null;
            }
            PsiElement body2 = lambdaExpression1.getBody();
            if (body2 == null) {
                return null;
            }
            Object marker = new Object();
            PsiTreeUtil.mark(lambdaReturnExpression, marker);
            PsiElement copy2 = body2.copy();
            PsiElement exprInReturn = PsiTreeUtil.releaseMark(copy2, marker);
            if (exprInReturn == null) {
                return null;
            }
            if (exprInReturn == copy2) {
                return exprInReturn.replace(replacement);
            }
            exprInReturn.replace(replacement);
            return copy2;
        });
    }

    @NotNull
    public static PsiElement copyWithExpectedType(PsiElement expression2, PsiType type2) {
        String canonicalText = type2.getCanonicalText();
        if (!PsiUtil.isLanguageLevel8OrHigher(expression2)) {
            String arrayInitializer = "new " + canonicalText + "[]{0}";
            PsiNewExpression newExpr = (PsiNewExpression)LambdaUtil.createExpressionFromText(arrayInitializer, expression2);
            PsiArrayInitializerExpression initializer2 = newExpr.getArrayInitializer();
            LOG.assertTrue(initializer2 != null);
            PsiElement psiElement = initializer2.getInitializers()[0].replace(expression2);
            if (psiElement == null) {
                LambdaUtil.$$$reportNull$$$0(26);
            }
            return psiElement;
        }
        String callableWithExpectedType = "(java.util.concurrent.Callable<" + canonicalText + ">)() -> x";
        PsiTypeCastExpression typeCastExpr = (PsiTypeCastExpression)LambdaUtil.createExpressionFromText(callableWithExpectedType, expression2);
        PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)typeCastExpr.getOperand();
        LOG.assertTrue(lambdaExpression != null);
        PsiElement body2 = lambdaExpression.getBody();
        LOG.assertTrue(body2 instanceof PsiExpression);
        PsiElement psiElement = body2.replace(expression2);
        if (psiElement == null) {
            LambdaUtil.$$$reportNull$$$0(27);
        }
        return psiElement;
    }

    private static PsiExpression createExpressionFromText(String exprText, PsiElement context) {
        PsiExpression expr = JavaPsiFacade.getElementFactory(context.getProject()).createExpressionFromText(exprText, context);
        return (PsiExpression)JavaCodeStyleManager.getInstance(context.getProject()).shortenClassReferences(expr);
    }

    public static boolean isCapturingLambda(PsiLambdaExpression lambda2) {
        PsiElement body2 = lambda2.getBody();
        if (body2 == null) {
            return false;
        }
        class CapturingLambdaVisitor
        extends JavaRecursiveElementWalkingVisitor {
            boolean capturing;
            final /* synthetic */ PsiLambdaExpression val$lambda;

            CapturingLambdaVisitor(PsiLambdaExpression psiLambdaExpression) {
                this.val$lambda = psiLambdaExpression;
            }

            @Override
            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                super.visitReferenceExpression(expression2);
                if (expression2 instanceof PsiMethodReferenceExpression) {
                    return;
                }
                if (expression2.getParent() instanceof PsiMethodCallExpression && expression2.getQualifierExpression() != null) {
                    return;
                }
                PsiElement target = expression2.resolve();
                if (target instanceof PsiModifierListOwner && !((PsiModifierListOwner)target).hasModifierProperty("static") && !PsiTreeUtil.isAncestor(this.val$lambda, target, true)) {
                    if (target instanceof PsiClass && ((PsiClass)target).getContainingClass() == null) {
                        return;
                    }
                    this.capturing = true;
                    this.stopWalking();
                }
            }

            @Override
            public void visitSuperExpression(PsiSuperExpression expression2) {
                this.capturing = true;
                this.stopWalking();
            }

            @Override
            public void visitThisExpression(PsiThisExpression expression2) {
                this.capturing = true;
                this.stopWalking();
            }
        }
        CapturingLambdaVisitor visitor2 = new CapturingLambdaVisitor(lambda2);
        body2.accept(visitor2);
        return visitor2.capturing;
    }

    @Nullable
    public static PsiClass resolveFunctionalInterfaceClass(@NotNull PsiFunctionalExpression expression2) {
        PsiType type2;
        PsiClass actualClass;
        if (expression2 == null) {
            LambdaUtil.$$$reportNull$$$0(28);
        }
        if ((actualClass = PsiUtil.resolveClassInClassTypeOnly(type2 = expression2.getGroundTargetType(LambdaUtil.getFunctionalInterfaceType(expression2, false)))) instanceof PsiTypeParameter) {
            return PsiUtil.resolveClassInClassTypeOnly(expression2.getFunctionalInterfaceType());
        }
        return actualClass;
    }

    @Nullable
    public static String createLambdaParameterListWithFormalTypes(PsiType functionalInterfaceType, PsiLambdaExpression lambdaExpression, boolean checkApplicability) {
        PsiParameter[] lambdaParameters;
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(functionalInterfaceType);
        if (interfaceMethod == null) {
            return null;
        }
        PsiParameter[] parameters2 = interfaceMethod.getParameterList().getParameters();
        if (parameters2.length != (lambdaParameters = lambdaExpression.getParameterList().getParameters()).length) {
            return null;
        }
        PsiSubstitutor substitutor2 = LambdaUtil.getSubstitutor(interfaceMethod, resolveResult);
        for (int i = 0; i < parameters2.length; ++i) {
            PsiAnnotation[] annotations2;
            PsiType psiType2;
            PsiParameter lambdaParameter = lambdaParameters[i];
            PsiTypeElement origTypeElement = lambdaParameter.getTypeElement();
            if (origTypeElement != null && !origTypeElement.isInferredType()) {
                psiType2 = origTypeElement.getType();
            } else {
                psiType2 = substitutor2.substitute(parameters2[i].getType());
                if (!PsiTypesUtil.isDenotableType(psiType2, lambdaExpression)) {
                    return null;
                }
            }
            for (PsiAnnotation annotation2 : annotations2 = lambdaParameter.getAnnotations()) {
                if (AnnotationTargetUtil.isTypeAnnotation(annotation2)) continue;
                buf.append(annotation2.getText()).append(' ');
            }
            buf.append(checkApplicability ? psiType2.getPresentableText(true) : psiType2.getCanonicalText(true)).append(" ").append(lambdaParameter.getName());
            if (i >= parameters2.length - 1) continue;
            buf.append(", ");
        }
        buf.append(")");
        return buf.toString();
    }

    @Nullable
    public static PsiParameterList specifyLambdaParameterTypes(PsiLambdaExpression lambdaExpression) {
        return LambdaUtil.specifyLambdaParameterTypes(lambdaExpression.getFunctionalInterfaceType(), lambdaExpression);
    }

    @Nullable
    public static PsiParameterList specifyLambdaParameterTypes(PsiType functionalInterfaceType, @NotNull PsiLambdaExpression lambdaExpression) {
        String typedParamList;
        if (lambdaExpression == null) {
            LambdaUtil.$$$reportNull$$$0(29);
        }
        if ((typedParamList = LambdaUtil.createLambdaParameterListWithFormalTypes(functionalInterfaceType, lambdaExpression, false)) != null) {
            PsiParameterList paramListWithFormalTypes = JavaPsiFacade.getElementFactory(lambdaExpression.getProject()).createMethodFromText("void foo" + typedParamList, lambdaExpression).getParameterList();
            return (PsiParameterList)JavaCodeStyleManager.getInstance(lambdaExpression.getProject()).shortenClassReferences(lambdaExpression.getParameterList().replace(paramListWithFormalTypes));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 26: 
            case 27: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/LambdaUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentLambda";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 15: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambda";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacer";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFunctionSupplier";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacementText";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newBodySupplier";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaReturnExpression";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/LambdaUtil";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "hasSubSignature";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnStatements";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithExpectedType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionalInterfaceMethod";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calcFunction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasManyOwnAbstractMethods";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasManyInheritedAbstractMethods";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 26: 
            case 27: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionalInterfaceTypeByContainingLambda";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyTopLevelCall";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "performWithTargetType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createLambda";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isSafeLambdaReplacement";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isSafeLambdaBodyReplacement";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isSafeLambdaReturnValueReplacement";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "resolveFunctionalInterfaceClass";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "specifyLambdaParameterTypes";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

