/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.internal.file.archive.AbstractArchiveFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.provider.Provider;
import org.gradle.internal.file.Chmod;
import org.gradle.internal.hash.FileHasher;
import org.gradle.util.internal.PathTraversalChecker;

public class ZipFileTree
extends AbstractArchiveFileTree {
    private final Provider<File> fileProvider;
    private final File tmpDir;
    private final Chmod chmod;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final FileHasher fileHasher;

    public ZipFileTree(Provider<File> zipFile, File tmpDir, Chmod chmod, DirectoryFileTreeFactory directoryFileTreeFactory, FileHasher fileHasher) {
        this.fileProvider = zipFile;
        this.tmpDir = tmpDir;
        this.chmod = chmod;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.fileHasher = fileHasher;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return String.format("ZIP '%s'", this.fileProvider.getOrNull());
    }

    public DirectoryFileTree getMirror() {
        return this.directoryFileTreeFactory.create(this.getExpandedDir());
    }

    public void visit(FileVisitor visitor) {
        File zipFile = (File)this.fileProvider.get();
        if (!zipFile.exists()) {
            throw new InvalidUserDataException(String.format("Cannot expand %s as it does not exist.", this.getDisplayName()));
        }
        if (!zipFile.isFile()) {
            throw new InvalidUserDataException(String.format("Cannot expand %s as it is not a file.", this.getDisplayName()));
        }
        AtomicBoolean stopFlag = new AtomicBoolean();
        File expandedDir = this.getExpandedDir();
        try (ZipFile zip = new ZipFile(zipFile);){
            Iterator<ZipEntry> sortedEntries = this.entriesSortedByName(zip);
            while (!stopFlag.get() && sortedEntries.hasNext()) {
                ZipEntry entry = sortedEntries.next();
                DetailsImpl details = new DetailsImpl(zipFile, expandedDir, entry, zip, stopFlag, this.chmod);
                if (entry.isDirectory()) {
                    visitor.visitDir((FileVisitDetails)details);
                    continue;
                }
                visitor.visitFile((FileVisitDetails)details);
            }
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not expand %s.", this.getDisplayName()), (Throwable)e);
        }
    }

    private Iterator<ZipEntry> entriesSortedByName(ZipFile zip) {
        TreeMap<String, ZipEntry> entriesByName = new TreeMap<String, ZipEntry>();
        Enumeration entries = zip.getEntries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)entries.nextElement();
            entriesByName.put(entry.getName(), entry);
        }
        return entriesByName.values().iterator();
    }

    @Override
    public Provider<File> getBackingFileProvider() {
        return this.fileProvider;
    }

    private File getExpandedDir() {
        File zipFile = (File)this.fileProvider.get();
        String expandedDirName = zipFile.getName() + "_" + this.fileHasher.hash(zipFile);
        return new File(this.tmpDir, expandedDirName);
    }

    private static class DetailsImpl
    extends AbstractFileTreeElement
    implements FileVisitDetails {
        private final File originalFile;
        private final File expandedDir;
        private final ZipEntry entry;
        private final ZipFile zip;
        private final AtomicBoolean stopFlag;
        private File file;

        public DetailsImpl(File originalFile, File expandedDir, ZipEntry entry, ZipFile zip, AtomicBoolean stopFlag, Chmod chmod) {
            super(chmod);
            this.originalFile = originalFile;
            this.expandedDir = expandedDir;
            this.entry = entry;
            this.zip = zip;
            this.stopFlag = stopFlag;
        }

        public String getDisplayName() {
            return String.format("zip entry %s!%s", this.originalFile, this.entry.getName());
        }

        public void stopVisiting() {
            this.stopFlag.set(true);
        }

        public File getFile() {
            if (this.file == null) {
                this.file = new File(this.expandedDir, this.safeEntryName());
                if (!this.file.exists()) {
                    this.copyTo(this.file);
                }
            }
            return this.file;
        }

        private String safeEntryName() {
            return PathTraversalChecker.safePathName((String)this.entry.getName());
        }

        public long getLastModified() {
            return this.entry.getTime();
        }

        public boolean isDirectory() {
            return this.entry.isDirectory();
        }

        public long getSize() {
            return this.entry.getSize();
        }

        public InputStream open() {
            try {
                return this.zip.getInputStream(this.entry);
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }

        public RelativePath getRelativePath() {
            return new RelativePath(!this.entry.isDirectory(), this.safeEntryName().split("/"));
        }

        public int getMode() {
            int unixMode = this.entry.getUnixMode() & 0x1FF;
            if (unixMode != 0) {
                return unixMode;
            }
            return this.isDirectory() ? 493 : 420;
        }
    }
}

