/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.plugins;

import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Rule;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.execution.BuildOutputCleanupRegistry;
import org.gradle.language.base.internal.plugins.CleanRule;

public class LifecycleBasePlugin
implements Plugin<Project> {
    public static final String CLEAN_TASK_NAME = "clean";
    public static final String ASSEMBLE_TASK_NAME = "assemble";
    public static final String CHECK_TASK_NAME = "check";
    public static final String BUILD_TASK_NAME = "build";
    public static final String BUILD_GROUP = "build";
    public static final String VERIFICATION_GROUP = "verification";

    public void apply(Project project) {
        ProjectInternal projectInternal = (ProjectInternal)project;
        this.addClean(projectInternal);
        this.addCleanRule(project);
        this.addAssemble(project);
        this.addCheck(project);
        this.addBuild(project);
    }

    private void addClean(ProjectInternal project) {
        DirectoryProperty buildDir = project.getLayout().getBuildDirectory();
        BuildOutputCleanupRegistry buildOutputCleanupRegistry = (BuildOutputCleanupRegistry)project.getServices().get(BuildOutputCleanupRegistry.class);
        buildOutputCleanupRegistry.registerOutputs((Object)buildDir);
        TaskProvider clean = project.getTasks().register(CLEAN_TASK_NAME, Delete.class, arg_0 -> LifecycleBasePlugin.lambda$addClean$0((Provider)buildDir, arg_0));
        buildOutputCleanupRegistry.registerOutputs((Object)clean.map(cl -> cl.getTargetFiles()));
    }

    private void addCleanRule(Project project) {
        project.getTasks().addRule((Rule)new CleanRule(project.getTasks()));
    }

    private void addAssemble(Project project) {
        project.getTasks().register(ASSEMBLE_TASK_NAME, assembleTask -> {
            assembleTask.setDescription("Assembles the outputs of this project.");
            assembleTask.setGroup("build");
        });
    }

    private void addCheck(Project project) {
        project.getTasks().register(CHECK_TASK_NAME, checkTask -> {
            checkTask.setDescription("Runs all checks.");
            checkTask.setGroup(VERIFICATION_GROUP);
        });
    }

    private void addBuild(Project project) {
        project.getTasks().register("build", buildTask -> {
            buildTask.setDescription("Assembles and tests this project.");
            buildTask.setGroup("build");
            buildTask.dependsOn(new Object[]{ASSEMBLE_TASK_NAME});
            buildTask.dependsOn(new Object[]{CHECK_TASK_NAME});
        });
    }

    private static /* synthetic */ void lambda$addClean$0(Provider buildDir, Delete cleanTask) {
        cleanTask.setDescription("Deletes the build directory.");
        cleanTask.setGroup("build");
        cleanTask.delete(new Object[]{buildDir});
    }
}

