/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.test;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.lang.Rational;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifDirectory;
import com.drew.metadata.exif.NikonType1MakernoteDirectory;
import java.io.File;
import junit.framework.TestCase;

public class NikonType1MakernoteTest
extends TestCase {
    private NikonType1MakernoteDirectory _nikonDirectory;
    private ExifDirectory _exifDirectory;

    public NikonType1MakernoteTest(String s) {
        super(s);
    }

    protected void setUp() throws Exception {
        File nikonJpeg = new File("src/com/drew/metadata/exif/test/nikonMakernoteType1.jpg");
        Metadata metadata = JpegMetadataReader.readMetadata(nikonJpeg);
        this._nikonDirectory = (NikonType1MakernoteDirectory)metadata.getDirectory(NikonType1MakernoteDirectory.class);
        this._exifDirectory = (ExifDirectory)metadata.getDirectory(ExifDirectory.class);
    }

    public void testNikonMakernote_MatchesKnownValues() throws Exception {
        NikonType1MakernoteTest.assertTrue((this._nikonDirectory.getTagCount() > 0 ? 1 : 0) != 0);
        NikonType1MakernoteTest.assertEquals((double)8.0, (double)this._nikonDirectory.getDouble(2), (double)1.0E-4);
        NikonType1MakernoteTest.assertEquals((int)12, (int)this._nikonDirectory.getInt(3));
        NikonType1MakernoteTest.assertEquals((int)1, (int)this._nikonDirectory.getInt(4));
        NikonType1MakernoteTest.assertEquals((int)3, (int)this._nikonDirectory.getInt(5));
        NikonType1MakernoteTest.assertEquals((int)0, (int)this._nikonDirectory.getInt(6));
        NikonType1MakernoteTest.assertEquals((int)0, (int)this._nikonDirectory.getInt(7));
        NikonType1MakernoteTest.assertEquals((int)0, (int)this._nikonDirectory.getInt(8));
        NikonType1MakernoteTest.assertEquals((String)"", (String)this._nikonDirectory.getString(9));
        NikonType1MakernoteTest.assertEquals((double)0.0, (double)this._nikonDirectory.getDouble(10), (double)1.0E-4);
        NikonType1MakernoteTest.assertEquals((int)0, (int)this._nikonDirectory.getInt(11));
        int[] unknown3 = this._nikonDirectory.getIntArray(3840);
        int[] nArray = new int[30];
        nArray[2] = 0x1000000;
        nArray[4] = -1609193200;
        nArray[6] = 34833;
        nArray[7] = 6931;
        nArray[8] = 16178;
        nArray[9] = 4372;
        nArray[10] = 4372;
        nArray[11] = -972290529;
        nArray[12] = -921882880;
        nArray[13] = 15112;
        nArray[16] = 1151495;
        nArray[17] = 252903424;
        nArray[18] = 17;
        nArray[21] = 844038208;
        nArray[22] = 55184128;
        nArray[23] = 218129428;
        nArray[24] = 1476410198;
        nArray[25] = 0x16160016;
        nArray[26] = -250604010;
        nArray[27] = 16711749;
        nArray[28] = 204629079;
        nArray[29] = 1729;
        int[] expected = nArray;
        NikonType1MakernoteTest.assertEquals((int)expected.length, (int)unknown3.length);
        int i = 0;
        while (i < expected.length) {
            NikonType1MakernoteTest.assertEquals((int)expected[i], (int)unknown3[i]);
            ++i;
        }
    }

    public void testExifDirectory_MatchesKnownValues() throws Exception {
        NikonType1MakernoteTest.assertEquals((String)"          ", (String)this._exifDirectory.getString(270));
        NikonType1MakernoteTest.assertEquals((String)"NIKON", (String)this._exifDirectory.getString(271));
        NikonType1MakernoteTest.assertEquals((String)"E950", (String)this._exifDirectory.getString(272));
        NikonType1MakernoteTest.assertEquals((int)1, (int)this._exifDirectory.getInt(274));
        NikonType1MakernoteTest.assertEquals((double)300.0, (double)this._exifDirectory.getDouble(282), (double)0.001);
        NikonType1MakernoteTest.assertEquals((double)300.0, (double)this._exifDirectory.getDouble(283), (double)0.001);
        NikonType1MakernoteTest.assertEquals((int)2, (int)this._exifDirectory.getInt(296));
        NikonType1MakernoteTest.assertEquals((String)"v981-79", (String)this._exifDirectory.getString(305));
        NikonType1MakernoteTest.assertEquals((String)"2001:04:06 11:51:40", (String)this._exifDirectory.getString(306));
        NikonType1MakernoteTest.assertEquals((int)2, (int)this._exifDirectory.getInt(531));
        NikonType1MakernoteTest.assertEquals((Object)new Rational(1, 77), (Object)this._exifDirectory.getRational(33434));
        NikonType1MakernoteTest.assertEquals((double)5.5, (double)this._exifDirectory.getDouble(33437), (double)0.001);
        NikonType1MakernoteTest.assertEquals((int)2, (int)this._exifDirectory.getInt(34850));
        NikonType1MakernoteTest.assertEquals((int)80, (int)this._exifDirectory.getInt(34855));
        NikonType1MakernoteTest.assertEquals((String)"48 50 49 48", (String)this._exifDirectory.getString(36864));
        NikonType1MakernoteTest.assertEquals((String)"2001:04:06 11:51:40", (String)this._exifDirectory.getString(36868));
        NikonType1MakernoteTest.assertEquals((String)"2001:04:06 11:51:40", (String)this._exifDirectory.getString(36867));
        NikonType1MakernoteTest.assertEquals((String)"1 2 3 0", (String)this._exifDirectory.getString(37121));
        NikonType1MakernoteTest.assertEquals((int)4, (int)this._exifDirectory.getInt(37122));
        NikonType1MakernoteTest.assertEquals((int)0, (int)this._exifDirectory.getInt(37380));
        NikonType1MakernoteTest.assertEquals((double)2.6, (double)this._exifDirectory.getDouble(37381), (double)0.001);
        NikonType1MakernoteTest.assertEquals((int)5, (int)this._exifDirectory.getInt(37383));
        NikonType1MakernoteTest.assertEquals((int)0, (int)this._exifDirectory.getInt(37384));
        NikonType1MakernoteTest.assertEquals((int)0, (int)this._exifDirectory.getInt(37385));
        NikonType1MakernoteTest.assertEquals((double)12.8, (double)this._exifDirectory.getDouble(37386), (double)0.001);
        NikonType1MakernoteTest.assertEquals((String)"0 0 0 0 0 0 0 0 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32", (String)this._exifDirectory.getString(37510));
        NikonType1MakernoteTest.assertEquals((String)"48 49 48 48", (String)this._exifDirectory.getString(40960));
        NikonType1MakernoteTest.assertEquals((int)1, (int)this._exifDirectory.getInt(40961));
        NikonType1MakernoteTest.assertEquals((int)1600, (int)this._exifDirectory.getInt(40962));
        NikonType1MakernoteTest.assertEquals((int)1200, (int)this._exifDirectory.getInt(40963));
        NikonType1MakernoteTest.assertEquals((int)3, (int)this._exifDirectory.getInt(41728));
        NikonType1MakernoteTest.assertEquals((int)1, (int)this._exifDirectory.getInt(41729));
        NikonType1MakernoteTest.assertEquals((int)6, (int)this._exifDirectory.getInt(259));
        NikonType1MakernoteTest.assertEquals((int)2036, (int)this._exifDirectory.getInt(513));
        NikonType1MakernoteTest.assertEquals((int)4662, (int)this._exifDirectory.getInt(514));
    }
}

