# gap> LoadPackage( "ToricVarieties" );
# true
# gap> C2 := Cone( [[1,0],[0,1]] );
# <A cone in |R^2>
# gap> C2 := ToricVariety( C2 );
# polymake: used package cddlib
#   Implementation of the double description method of Motzkin et al.
#   Copyright by Komei Fukuda.
#   http://www.ifor.math.ethz.ch/~fukuda/cdd_home/cdd.html
# 
# <An affine normal toric variety of dimension 2>
# gap> CoxRing( C2 );
# ----------------------------------------------------------------
# Loading  IO_ForHomalg 2011.07.25
# by Thomas Bächler (http://wwwb.math.rwth-aachen.de/~thomas/)
#    Mohamed Barakat (http://www.mathematik.uni-kl.de/~barakat/)
#    Max Neunhöffer (http://www-groups.mcs.st-and.ac.uk/~neunhoef/)
#    Daniel Robertz (http://wwwb.math.rwth-aachen.de/~daniel/)
# For help, type: ?IO_ForHomalg package 
# ----------------------------------------------------------------
# ================================================================
#                      SINGULAR                                 /
#  A Computer Algebra System for Polynomial Computations       /   version 3-1-3
#                                                            0<
#  by: W. Decker, G.-M. Greuel, G. Pfister, H. Schoenemann     \   March 2011
# FB Mathematik der Universitaet, D-67653 Kaiserslautern        \
# ================================================================
# Q[x_1,x_2]
# (weights: [ 0, 0 ])
# gap> IrrelevantIdeal( C2 );
# <A principal torsion-free (left) ideal given by a cyclic generator>
# gap> Display( last );
# 1
# (over a graded ring)
# 
# A (left) ideal generated by the entry of the above matrix
# gap> ByASmallerPresentation( last );
# <A principal (left) ideal of rank 1 on a free generator>

LoadPackage( "ToricVarieties" );
C2 := Cone( [[1,0],[0,1]] );
C2 := ToricVariety( C2 );
CoxRing( C2 );
IrrelevantIdeal( C2 );
Display( last );
ByASmallerPresentation( last );