#############################################################################
##
#A  CANFACT.g                                                   Frank Lübeck
##
##  The list CANFACT was generated by the code in generateCANFACT.g after
##  updating the list of Brent factors in GAP (pkg/FactInt*/tables/brent).
##

##  <#GAPDoc Label="CANFACT">
##  <ManSection>
##  <Var Name="CANFACT" />
##  <Description>
##  This variable contains  a list where for each prime  <M>p &lt; 10000</M>
##  the entry <C>CANFACT[p]</C> holds a  list of integers <M>i</M> such that
##  the number  <M>p^i-1</M> (the order  of the multiplicative group  of the
##  finite field <C>FF(p,i)</C>)  can be factored by &GAP; in  a short time.
##  This is based on the enormous efforts to find factors of numbers of this
##  form, see <Cite Key="BrentFactors" />.
##  <P/> 
##  For <M>p  &lt; 10</M> the range  of considered exponents is  <M>2 \leq i
##  \leq 2000</M>,  for <M>10  &lt; p &lt;  100</M> it is  <M>2 \leq  i \leq
##  500</M>, and  for <M>100 &lt;  p &lt; 10000</M> it  is <M>2 \leq  i \leq
##  100</M>.
##  <P/>
##  These  data   describe  <M>112515</M>   pairs  <C>p,  i</C>   such  that
##  <C>StandardPrimitiveRoot(FF(p,i))</C>  can  be  computed  in  reasonable
##  time.  Only  for  <M>10858</M>  of   these  cases  &GAP;  knows  or  can
##  easily   compute  the   corresponding   Conway   polynomial  (see   <Ref
##  BookName="Reference" Func="ConwayPolynomial"/>).
##  <P/>
##  The current  content of <C>CANFACT</C>  was generated with the  data in 
##  the <Package>FactInt</Package> package version 1.6.3 concerning factors 
##  of numbers of the form <M>a^n \pm 1</M>.                                
##  </Description>
##  </ManSection>
##  <#/GAPDoc>
##  
CANFACT:=[,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,
72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,
106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,
137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,
168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,
199,200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,
230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,256,257,258,259,260,
261,262,263,264,265,266,267,268,269,270,271,272,273,274,275,276,277,278,279,280,281,282,283,284,285,286,287,288,289,290,291,
292,293,294,295,296,297,298,299,300,301,302,303,304,305,306,307,308,309,310,311,312,313,314,315,316,317,318,319,320,321,322,
323,324,325,326,327,328,329,330,331,332,333,334,335,336,337,338,339,340,341,342,343,344,345,346,347,348,349,350,351,352,353,
354,355,356,357,358,359,360,361,362,363,364,365,366,367,368,369,370,371,372,373,374,375,376,377,378,379,380,381,382,383,384,
385,386,387,388,389,390,391,392,393,394,395,396,397,398,399,400,401,402,403,404,405,406,407,408,409,410,411,412,413,414,415,
416,417,418,419,420,421,422,423,424,425,426,427,428,429,430,431,432,433,434,435,436,437,438,439,440,441,442,443,444,445,446,
447,448,449,450,451,452,453,454,455,456,457,458,459,460,461,462,463,464,465,466,467,468,469,470,471,472,473,474,475,476,477,
478,479,480,481,482,483,484,485,486,487,488,489,490,491,492,493,494,495,496,497,498,499,500,501,502,503,504,505,506,507,508,
509,510,511,512,513,514,515,516,517,518,519,520,521,522,523,524,525,526,527,528,529,530,531,532,533,534,535,536,537,538,539,
540,541,542,543,544,545,546,547,548,549,550,551,552,553,554,555,556,557,558,559,560,561,562,563,564,565,566,567,568,569,570,
571,572,573,574,575,576,577,578,579,580,581,582,583,584,585,586,587,588,589,590,591,592,593,594,595,596,597,598,599,600,601,
602,603,604,605,606,607,608,609,610,611,612,613,614,615,616,617,618,619,620,621,622,623,624,625,626,627,628,629,630,631,632,
633,634,635,636,637,638,639,640,641,642,643,644,645,646,647,648,649,650,651,652,653,654,655,656,657,658,659,660,661,662,663,
664,665,666,667,668,669,670,671,672,673,674,675,676,677,678,679,680,681,682,683,684,685,686,687,688,689,690,691,692,693,694,
695,696,697,698,699,700,701,702,703,704,705,706,707,708,709,710,711,712,713,714,715,716,717,718,719,720,721,722,723,724,725,
726,727,728,729,730,731,732,733,734,735,736,737,738,739,740,741,742,743,744,745,746,747,748,749,750,751,752,753,754,755,756,
757,758,759,760,761,762,763,764,765,766,767,768,769,770,771,772,773,774,775,776,777,778,779,780,781,782,783,784,785,786,787,
788,789,790,791,792,793,794,795,796,797,798,799,800,801,802,803,804,805,806,807,808,809,810,811,812,813,814,815,816,817,818,
819,820,821,822,823,824,825,826,827,828,829,830,831,832,833,834,835,836,837,838,839,840,841,842,843,844,845,846,847,848,849,
850,851,852,853,854,855,856,857,858,859,860,861,862,863,864,865,866,867,868,869,870,871,872,873,874,875,876,877,878,879,880,
881,882,883,884,885,886,887,888,889,890,891,892,893,894,895,896,897,898,899,900,901,902,903,904,905,906,907,908,909,910,911,
912,913,914,915,916,917,918,919,920,921,922,923,924,925,926,927,928,930,931,932,933,934,935,936,937,938,939,940,941,942,943,
944,945,946,948,949,950,951,952,953,954,955,956,957,958,959,960,961,962,963,964,965,966,967,968,969,970,971,972,973,974,975,
976,977,978,979,980,981,982,983,984,985,986,987,988,989,990,992,993,994,995,996,997,998,999,1000,1001,1002,1003,1004,1005,1006,
1008,1010,1011,1012,1013,1014,1015,1016,1017,1018,1020,1021,1022,1023,1024,1025,1026,1027,1028,1029,1030,1031,1032,1033,1034,1035,
1036,1038,1039,1040,1041,1042,1043,1044,1045,1046,1047,1048,1049,1050,1052,1053,1054,1055,1056,1057,1058,1059,1060,1062,1063,1064,
1065,1066,1068,1070,1071,1072,1073,1074,1075,1076,1077,1078,1079,1080,1082,1083,1084,1085,1086,1087,1088,1089,1090,1091,1092,1094,
1095,1096,1097,1098,1099,1100,1101,1102,1103,1104,1105,1106,1107,1108,1110,1112,1113,1114,1115,1116,1118,1119,1120,1121,1122,1124,
1125,1126,1127,1128,1130,1131,1132,1133,1134,1136,1137,1138,1139,1140,1141,1142,1143,1144,1145,1146,1148,1149,1150,1152,1154,1155,
1156,1157,1158,1160,1161,1162,1163,1164,1165,1166,1167,1168,1169,1170,1172,1173,1174,1175,1176,1178,1179,1180,1181,1182,1183,1184,
1185,1186,1187,1188,1189,1190,1191,1192,1194,1195,1196,1197,1198,1200,1202,1204,1205,1206,1208,1209,1210,1211,1212,1214,1216,1218,
1220,1221,1222,1223,1224,1225,1226,1227,1228,1230,1232,1233,1234,1235,1236,1238,1240,1242,1244,1246,1248,1250,1252,1254,1256,1258,
1260,1262,1263,1264,1266,1267,1268,1270,1272,1273,1274,1275,1276,1278,1279,1280,1282,1284,1286,1288,1289,1290,1292,1294,1295,1296,
1298,1300,1302,1303,1304,1305,1306,1307,1308,1310,1312,1313,1314,1316,1318,1320,1321,1322,1324,1326,1327,1328,1330,1332,1334,1335,
1336,1337,1338,1340,1342,1344,1346,1348,1350,1352,1354,1355,1356,1358,1360,1361,1362,1363,1364,1365,1366,1368,1370,1372,1374,1375,
1376,1378,1380,1382,1384,1386,1388,1390,1392,1394,1396,1397,1398,1400,1402,1404,1405,1406,1407,1408,1410,1411,1412,1413,1414,1416,
1418,1420,1422,1424,1426,1427,1428,1430,1431,1432,1434,1435,1436,1438,1440,1442,1444,1446,1448,1449,1450,1452,1454,1455,1456,1458,
1459,1460,1461,1462,1464,1466,1468,1469,1470,1472,1473,1474,1476,1478,1480,1482,1484,1485,1486,1487,1488,1490,1492,1494,1495,1496,
1498,1500,1502,1504,1506,1508,1510,1512,1514,1516,1518,1520,1522,1524,1526,1527,1528,1530,1531,1532,1534,1535,1536,1538,1539,1540,
1542,1544,1545,1546,1547,1548,1550,1552,1553,1554,1555,1556,1557,1558,1560,1562,1564,1566,1568,1570,1572,1574,1575,1576,1578,1580,
1582,1584,1586,1588,1590,1592,1593,1594,1596,1598,1600,1602,1604,1605,1606,1608,1610,1612,1614,1616,1617,1618,1620,1622,1623,1624,
1625,1626,1628,1630,1632,1634,1636,1637,1638,1640,1642,1644,1646,1648,1650,1652,1654,1656,1658,1660,1662,1664,1666,1668,1670,1671,
1672,1673,1674,1676,1678,1680,1681,1682,1683,1684,1686,1688,1690,1692,1693,1694,1696,1698,1700,1702,1704,1706,1708,1710,1712,1713,
1714,1716,1718,1720,1722,1724,1726,1727,1728,1730,1732,1734,1736,1738,1740,1742,1744,1746,1748,1750,1752,1754,1756,1758,1760,1762,
1764,1766,1768,1770,1772,1774,1776,1778,1780,1781,1782,1783,1784,1786,1788,1790,1792,1794,1796,1797,1798,1800,1802,1804,1806,1808,
1810,1812,1814,1815,1816,1818,1820,1822,1824,1826,1828,1830,1832,1834,1836,1838,1840,1842,1844,1846,1848,1850,1852,1854,1856,1860,
1862,1864,1866,1868,1870,1872,1874,1876,1878,1880,1882,1884,1886,1888,1890,1892,1896,1898,1900,1902,1904,1906,1908,1910,1912,1914,
1916,1917,1918,1920,1924,1925,1926,1927,1928,1930,1932,1934,1935,1936,1938,1940,1942,1944,1946,1948,1950,1952,1954,1956,1958,1960,
1962,1964,1968,1970,1972,1974,1975,1976,1980,1983,1984,1986,1988,1990,1992,1994,1996,1997,1998],
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,
73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,
107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,
138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,
169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,
200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,
231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,256,257,258,259,260,261,
262,263,264,265,266,267,268,269,270,271,272,273,274,275,276,277,278,279,280,281,282,283,284,285,286,287,288,289,290,291,292,
293,294,295,296,297,298,299,300,301,302,303,304,305,306,307,308,309,310,311,312,313,314,315,316,317,318,319,320,321,322,323,
324,325,326,327,328,329,330,331,332,333,334,335,336,337,338,339,340,341,342,343,344,345,346,347,348,349,350,351,352,353,354,
355,356,357,358,359,360,361,362,363,364,365,366,367,368,369,370,371,372,373,374,375,376,377,378,379,380,381,382,383,384,385,
386,387,388,389,390,391,392,393,394,395,396,397,398,399,400,401,402,403,404,405,406,407,408,409,410,411,412,413,414,415,416,
417,418,419,420,421,422,423,424,425,426,427,428,429,430,431,432,433,434,435,436,437,438,439,440,441,442,443,444,445,446,447,
448,449,450,451,452,453,454,455,456,457,458,459,460,461,462,463,464,465,466,467,468,469,470,471,472,473,474,475,476,477,478,
479,480,481,482,483,484,485,486,487,488,489,490,491,492,493,494,495,496,497,498,499,500,501,502,503,504,505,506,507,508,509,
510,511,512,513,514,515,516,517,518,519,520,521,522,523,524,525,526,527,528,529,530,531,532,533,534,535,536,537,538,539,540,
541,542,543,544,545,546,547,548,549,550,551,552,553,554,555,556,557,558,559,560,561,562,563,564,565,566,567,568,569,570,571,
572,573,574,575,576,577,578,579,580,581,582,583,584,585,586,587,588,590,591,592,594,595,596,597,598,599,600,601,602,603,604,
605,606,607,608,609,610,611,612,614,615,616,618,620,621,622,624,626,627,628,629,630,631,632,633,634,635,636,638,639,640,641,
642,643,644,645,646,647,648,649,650,651,652,654,656,657,658,659,660,662,663,664,665,666,668,669,670,672,673,674,675,676,678,
680,682,684,685,686,687,688,690,692,693,694,695,696,698,699,700,702,704,705,706,707,708,709,710,711,712,714,716,717,718,719,
720,721,722,723,724,726,727,728,730,732,734,735,736,737,738,740,741,742,743,744,746,747,748,749,750,752,753,754,755,756,757,
758,759,760,761,762,764,765,766,767,768,770,771,772,774,776,777,778,780,781,782,784,785,786,787,788,790,792,793,794,795,796,
798,799,800,802,804,806,808,810,812,814,816,818,820,821,822,824,825,826,828,830,832,834,836,838,840,842,844,846,848,850,852,
854,856,858,860,862,863,864,866,868,870,872,873,874,875,876,878,880,882,884,886,888,890,892,894,896,898,900,902,904,906,908,
910,911,912,914,916,918,919,920,922,924,926,927,928,930,932,934,936,938,940,942,944,945,946,948,950,952,954,956,958,960,962,
964,966,968,970,972,973,974,976,978,980,981,982,984,986,987,988,990,992,994,996,998,999,1000,1002,1004,1006,1008,1010,1012,
1014,1016,1018,1020,1022,1024,1026,1028,1029,1030,1032,1034,1036,1037,1038,1040,1042,1044,1046,1048,1050,1052,1054,1056,1058,1059,
1060,1062,1064,1065,1066,1068,1069,1070,1072,1073,1074,1076,1078,1080,1082,1084,1086,1088,1090,1091,1092,1093,1094,1096,1098,1100,
1102,1104,1106,1107,1108,1110,1112,1114,1116,1118,1120,1122,1124,1126,1128,1130,1132,1134,1136,1137,1138,1140,1142,1143,1144,1146,
1148,1150,1152,1153,1154,1156,1158,1160,1162,1164,1166,1168,1170,1172,1174,1176,1179,1180,1182,1188,1190,1194,1196,1200,1202,1204,
1206,1212,1213,1218,1220,1222,1224,1228,1230,1236,1239,1240,1244,1248,1252,1254,1256,1258,1260,1266,1268,1272,1276,1277,1278,1280,
1282,1284,1288,1290,1292,1296,1298,1300,1302,1304,1308,1312,1316,1320,1326,1330,1332,1338,1340,1344,1346,1349,1350,1356,1360,1367,
1368,1370,1372,1374,1376,1380,1386,1388,1389,1390,1392,1396,1398,1399,1400,1404,1410,1416,1417,1422,1428,1434,1440,1446,1448,1452,
1453,1456,1460,1470,1472,1476,1480,1481,1482,1484,1488,1489,1494,1500,1506,1510,1512,1515,1518,1522,1524,1530,1536,1540,1542,1548,
1552,1554,1556,1560,1561,1562,1564,1572,1575,1576,1586,1590,1592,1598,1600,1609,1612,1623,1627,1650,1656,1729,1735,1750,1751,1764,
1797,1812,1821,1823,1835,1845,1863,1879,1890,1920,1936,1947,1957,1960,1974,1985,1987],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,
73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,
107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,
138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,
169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,
200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,
231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,256,257,258,259,260,261,
262,263,264,265,266,267,268,269,270,271,272,273,274,275,276,277,278,279,280,281,282,283,284,285,286,287,288,289,290,291,292,
293,294,295,296,297,298,299,300,301,302,303,304,305,306,307,308,309,310,311,312,313,314,315,316,317,318,319,320,321,322,323,
324,325,326,327,328,329,330,331,332,333,334,335,336,337,338,339,340,341,342,343,344,345,346,347,348,349,350,351,352,353,354,
355,356,357,358,359,360,361,362,363,364,365,366,367,368,369,370,371,372,373,374,375,376,377,378,379,380,381,382,383,384,385,
386,387,388,389,390,391,392,393,394,395,396,397,398,399,400,401,402,403,404,405,406,407,408,409,410,411,412,413,414,415,416,
417,418,420,421,422,423,424,425,426,427,428,429,430,432,433,434,435,436,437,438,439,440,441,442,443,444,445,446,447,448,450,
451,452,453,454,455,456,457,458,459,460,461,462,464,465,466,467,468,470,471,472,474,475,476,477,478,479,480,482,484,485,486,
487,488,489,490,492,494,495,496,498,500,502,504,505,506,507,508,510,512,514,515,516,517,518,520,522,523,524,525,526,527,528,
530,532,534,535,536,538,539,540,542,543,544,545,546,548,550,551,552,554,555,556,558,560,562,564,565,566,568,570,572,574,575,
576,578,580,581,582,584,585,586,588,590,591,592,594,595,596,598,600,602,604,605,606,608,610,612,614,615,616,618,619,620,622,
624,625,626,628,630,631,632,634,635,636,638,640,642,644,645,646,648,649,650,652,654,655,656,658,660,662,664,665,666,668,670,
672,674,675,676,678,680,682,683,684,685,686,688,690,692,694,695,696,698,700,702,704,705,706,708,710,712,714,715,716,718,720,
722,724,726,727,728,730,732,733,734,735,736,738,740,742,744,745,746,748,750,752,754,755,756,758,760,762,764,765,766,768,769,
770,772,774,776,778,780,781,782,784,785,786,787,788,790,792,794,795,796,797,798,800,804,805,806,808,810,812,814,815,816,820,
822,823,824,826,828,830,832,834,835,836,840,845,846,850,852,854,855,856,858,860,864,865,867,868,870,873,874,875,876,880,882,
884,885,888,890,894,896,897,900,911,915,924,929,936,945,948,955,960,964,969,981,985,990,992,995,996,1004,1008,1012,1019,1028,
1030,1032,1037,1050,1056,1064,1070,1072,1078,1084,1086,1092,1095,1108,1110,1140,1151,1155,1164,1168,1176,1180,1192,1200,1230,1256,
1301,1432,1476,1500,1617,1620,1664,1668,1670,1687,1770,1800,1807,1822,1919,1920,1937],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,
73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,
107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,
138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,
169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,
200,201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,
231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,256,257,258,259,260,261,
262,263,264,265,266,267,268,269,270,271,272,273,274,275,276,277,278,279,280,281,282,283,284,285,286,287,288,289,290,291,292,
293,294,295,296,297,298,299,300,301,302,303,304,305,306,307,308,309,310,311,312,313,314,315,316,317,318,319,320,321,322,323,
324,325,326,327,328,329,330,331,332,333,334,335,336,338,339,340,341,342,343,344,345,346,347,348,349,350,351,352,354,355,356,
357,358,360,362,363,364,366,368,369,370,371,372,374,375,376,377,378,380,381,382,384,385,386,387,388,390,391,392,393,394,396,
397,398,399,400,402,404,406,407,408,410,411,412,414,415,416,418,420,422,423,424,426,427,428,430,432,434,435,436,438,440,442,
444,446,448,450,452,453,454,456,458,460,461,462,464,466,468,470,471,472,474,476,478,480,482,484,486,488,490,492,494,495,496,
497,498,500,501,502,504,506,508,510,512,514,515,516,518,520,522,524,526,528,530,531,532,534,536,538,540,542,544,546,548,550,
552,554,556,558,560,562,563,564,566,568,570,572,574,576,578,580,581,582,584,586,588,590,592,594,596,598,600,602,603,604,606,
608,610,612,614,615,616,618,620,622,624,626,628,630,632,634,636,638,640,642,644,646,648,650,654,656,657,658,660,666,670,672,
676,677,678,680,682,684,686,688,690,694,696,698,700,702,704,708,714,716,720,724,726,728,732,736,738,740,742,744,747,750,754,
756,759,760,762,764,768,770,774,780,782,784,786,792,798,820,830,840,848,852,854,859,867,868,870,906,908,916,924,980,994,1000,
1002,1020,1024,1047,1048,1057,1060,1065,1071,1084,1136,1145,1162,1195,1200,1269,1289,1376,1660,1679,1696,1699,1907,1985,1988],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,
35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,
74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,
108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,
139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,
170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,
201,202,203,204,205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,
232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,256,257,258,259,260,261,262,
263,264,265,266,267,268,270,272,273,274,275,276,277,278,279,280,282,284,285,286,287,288,289,290,291,292,294,295,296,297,298,
300,302,303,304,305,306,308,310,312,314,316,318,320,321,322,324,326,328,329,330,332,333,334,336,338,340,342,344,345,346,348,
350,352,354,356,358,360,362,364,366,367,368,370,372,374,375,376,378,380,381,382,383,384,385,386,388,389,390,391,392,394,396,
398,400,402,403,404,406,408,410,411,412,414,416,417,418,420,422,424,426,428,429,430,431,432,434,436,437,438,440,442,444,445,
446,448,450,452,454,456,458,460,461,462,464,466,468,470,472,473,474,476,478,480,482,484,486,488,490,492,494,496,498,500],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,
35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,
74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,
109,110,111,112,113,114,115,116,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,
141,142,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,170,171,172,173,
174,175,176,177,178,179,180,181,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,
206,207,208,210,211,212,213,214,216,218,219,220,222,223,224,225,226,228,230,231,232,233,235,236,237,238,240,242,243,244,246,
248,249,250,252,254,256,257,258,260,262,264,265,266,267,268,270,271,272,274,276,278,279,280,282,283,284,288,290,291,292,293,
294,296,297,298,300,302,303,304,306,307,308,310,312,313,314,315,316,317,318,320,322,324,326,328,330,332,333,334,335,336,340,
341,342,344,346,348,350,352,353,354,356,357,358,360,362,366,368,370,372,374,376,378,380,382,384,386,388,390,392,396,399,400,
402,404,406,408,410,412,413,414,416,420,422,425,426,432,436,437,438,440,443,444,448,450,452,456,462,465,470,474,476,480,483,
498],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,
71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,
105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,
136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,
167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,188,189,190,191,192,193,194,195,196,197,198,
199,200,201,202,203,204,205,206,207,208,209,210,212,214,216,218,219,220,222,223,224,226,227,228,229,230,231,232,234,235,236,
238,240,241,242,244,246,248,250,252,253,254,256,258,260,261,262,264,265,266,268,269,270,272,274,275,276,278,280,282,284,285,
286,287,288,289,290,291,292,294,296,297,298,299,300,301,302,304,305,306,308,309,310,312,314,315,316,317,318,320,322,324,326,
327,328,330,332,334,336,338,340,342,344,345,346,348,350,352,354,355,359,360,362,364,366,370,372,375,376,378,380,384,385,386,
388,390,392,394,396,398,400,402,406,408,410,414,416,419,420,437,438,440,455,456,457,462,468,470,476,480,484,492,499],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,
73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,
107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,
138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,
169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,188,189,190,191,192,193,194,195,196,197,198,199,200,
201,202,204,206,207,208,210,212,213,214,216,217,218,219,220,222,224,225,226,227,228,229,230,231,232,233,234,236,238,240,241,
242,244,245,246,247,248,249,250,252,253,254,255,256,258,259,260,262,263,264,266,267,268,270,272,274,276,278,280,282,284,286,
287,288,289,290,291,292,294,295,296,298,300,302,304,306,308,310,311,312,314,316,318,320,322,324,326,328,330,332,334,336,337,
338,340,342,344,345,346,347,348,350,352,354,356,358,360,362,364,366,367,370,372,376,378,383,384,387,388,389,390,392,395,396,
398,402,411,414,420,426,434,435,436,441,444,455,462,468,472,480,488,498],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,
31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,
70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,
104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,
135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,
166,167,168,169,170,171,172,173,174,176,177,178,179,180,181,182,183,184,185,186,187,188,190,192,194,195,196,198,200,202,203,
204,206,207,208,209,210,212,214,215,216,218,219,220,222,224,226,228,230,231,232,234,236,237,238,240,242,244,245,246,248,249,
250,252,254,256,258,260,262,263,264,266,268,270,272,274,275,276,278,280,282,284,286,288,290,292,294,296,298,300,302,304,306,
308,310,312,316,318,320,324,326,328,330,334,336,338,340,342,343,344,346,348,352,354,358,360,362,364,365,366,368,370,372,380,
384,390,391,392,396,406,408,418,420,423,432,439,444,460,467,492,500],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,
30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,
69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,
103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,
134,135,136,137,138,139,140,141,142,143,144,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,
166,167,168,169,170,171,172,174,175,176,178,179,180,181,182,183,184,186,188,189,190,191,192,194,195,196,198,200,202,204,205,
206,208,210,212,214,216,217,218,220,222,224,225,226,228,229,230,232,234,235,236,238,240,242,244,245,246,248,250,252,254,256,
258,260,262,264,266,268,270,272,274,276,280,282,284,286,288,294,296,300,306,308,312,316,318,320,322,324,328,330,332,334,336,
338,340,342,348,357,360,364,366,371,372,384,388,390,392,396,404,409,419,420,434,456,480,488,492],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,
71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,
105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,
136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,
167,168,169,170,171,172,174,176,177,178,179,180,181,182,184,187,188,190,192,194,195,196,198,199,200,201,202,204,206,208,209,
210,211,212,214,216,218,219,220,222,223,224,226,228,230,231,232,234,236,237,238,240,242,244,246,248,249,250,252,254,256,258,
260,262,264,266,268,270,271,272,273,274,275,276,278,280,282,283,284,285,286,288,290,292,294,296,298,300,302,304,306,308,312,
315,320,322,324,326,330,334,336,338,340,360,372,376,383,390,396,400,402,403,404,405,408,412,420,433,438,448,473,480,496],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,
36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,
75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,
109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,
140,141,142,143,144,146,147,148,149,150,151,152,153,154,156,157,158,159,160,161,162,164,165,166,167,168,170,172,173,174,176,
178,179,180,181,182,184,186,188,190,192,194,195,196,198,200,202,203,204,206,207,208,210,212,214,216,217,218,220,222,224,226,
228,230,232,234,236,238,239,240,242,244,246,248,249,250,251,252,254,256,258,260,264,266,267,268,270,272,274,276,278,280,282,
286,288,292,294,298,300,302,306,308,309,312,314,318,320,324,330,336,346,356,358,360,362,371,372,380,384,388,390,396,400,408,
414,420,424,440,448,463,480],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,
99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,
130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,162,
164,165,166,168,170,172,174,176,178,180,181,182,184,186,187,188,190,192,194,195,196,198,200,201,202,204,206,208,210,212,214,
216,218,220,222,224,226,228,230,231,232,234,236,237,238,240,242,243,244,246,248,249,250,252,254,255,256,258,260,262,264,265,
266,268,269,270,272,273,274,276,278,280,282,284,286,288,294,295,296,300,306,308,310,312,316,330,336,339,360,364,368,374,380,
390,397,400,402,409,413,420,440,456,462,468,480,498],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,
59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,87,88,89,90,91,92,93,
94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,
126,127,128,129,130,131,132,134,135,136,138,140,141,142,144,145,146,147,148,149,150,152,153,154,156,157,158,159,160,161,162,
163,164,165,166,167,168,170,171,173,174,175,176,178,179,180,181,182,184,185,186,188,189,190,192,194,195,196,198,200,202,204,
206,208,210,212,214,216,218,219,220,222,224,226,228,230,232,234,236,238,240,242,244,246,248,250,252,254,256,260,262,264,268,
270,276,280,282,284,288,290,291,294,298,300,303,304,306,311,312,316,322,326,330,336,340,352,360,364,388,390,392,395,400,420,
432,440,457],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,
30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,
69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,
103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,
134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,152,153,154,156,158,159,160,162,163,164,165,166,168,170,
172,174,176,177,178,180,181,182,184,185,186,188,189,190,192,193,194,195,196,198,200,202,204,206,207,208,209,210,211,212,214,
216,218,220,222,224,226,228,230,232,234,236,238,240,242,244,246,250,252,254,256,258,260,264,266,268,270,271,272,274,276,277,
280,281,282,285,288,289,290,292,294,298,300,303,304,306,312,320,324,328,330,336,343,348,352,354,355,357,360,376,386,387,390,
420,421,424,448,456,475,477,492],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,
63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,
97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,
129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,146,147,148,150,151,152,153,154,155,156,158,160,162,163,164,
165,166,168,170,171,172,174,176,178,180,182,183,184,185,186,188,189,190,192,194,195,196,198,199,200,201,202,204,206,208,210,
212,214,216,218,220,222,223,224,226,227,228,229,230,234,236,238,240,242,246,248,250,252,254,258,260,264,266,268,270,272,274,
275,276,280,282,288,294,296,300,302,306,312,321,324,328,330,332,336,344,348,351,356,360,369,376,390,400,402,420,432,455,456,
480,500],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,
30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,
69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,
103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,
134,135,136,137,138,139,140,141,142,143,144,146,147,148,150,151,152,153,154,155,156,158,160,162,164,165,166,167,168,170,171,
172,174,175,176,177,178,180,182,184,186,187,188,189,190,192,193,194,195,196,198,200,201,202,204,206,208,210,212,214,216,218,
219,220,222,224,226,228,230,232,234,236,238,240,241,242,244,246,248,250,252,256,258,260,263,264,270,276,278,280,282,284,286,
288,294,300,306,310,311,312,316,320,329,330,334,336,340,360,372,378,390,408,411,416,420,429,444,459,464,479,480],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,
73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,
107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,
138,139,140,141,142,144,146,147,148,150,152,153,154,155,156,157,158,160,162,164,165,166,168,170,172,174,175,176,178,179,180,
182,184,185,186,188,190,192,194,195,196,198,199,200,202,204,205,206,207,208,210,212,214,216,218,220,221,222,224,226,228,229,
230,232,234,236,238,239,240,243,244,245,246,248,250,252,254,256,258,260,263,264,266,269,270,272,274,276,280,282,284,288,294,
300,304,306,308,312,314,315,323,330,336,360,373,380,385,389,390,396,399,401,408,414,416,419,425,472,476,478,490],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,
73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,
107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,128,129,130,131,132,133,134,135,136,138,139,
140,141,142,144,146,147,148,150,152,153,154,156,158,160,162,164,165,166,168,170,172,173,174,175,176,178,180,182,184,186,188,
190,191,192,194,195,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,238,240,244,245,246,248,
250,252,256,258,260,261,264,266,269,270,272,276,280,282,288,294,299,300,306,312,330,336,339,360,364,367,384,385,390,392,393,
396,417,420,424,455,469],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,
66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,
100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,
131,132,133,134,135,136,138,140,141,142,144,146,147,148,149,150,151,152,153,154,156,157,158,159,160,161,162,164,165,166,168,
170,172,174,175,176,177,178,180,182,184,186,188,189,190,192,194,195,196,198,200,202,204,206,207,208,210,212,213,214,216,218,
220,221,222,224,226,228,230,234,235,236,237,238,239,240,242,246,248,250,252,255,256,258,259,260,264,266,268,269,270,272,276,
280,282,288,294,300,302,306,312,318,330,336,345,349,351,352,354,356,360,364,372,381,390,404,414,420,431,480],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,
72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,
106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,128,129,130,131,132,133,134,135,136,138,
140,141,142,143,144,146,147,148,150,152,153,154,156,158,160,162,164,165,166,168,169,170,172,174,175,176,178,180,182,183,184,
186,188,190,192,194,195,196,198,200,202,204,206,207,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,
246,247,248,250,252,256,258,260,261,264,270,276,280,282,286,288,294,300,306,308,312,320,330,332,336,337,345,355,356,360,363,
372,385,390,420,433,444,463,468,479,480,487,495],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,
59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,
93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,114,115,116,117,118,119,120,121,122,123,124,125,
126,128,129,130,131,132,134,135,136,138,140,141,142,143,144,146,147,148,149,150,152,153,154,156,159,160,162,164,165,166,168,
170,171,172,174,176,177,178,180,181,182,184,185,186,188,190,192,194,195,196,198,200,202,204,205,206,208,210,211,212,214,216,
220,222,224,228,230,231,234,237,238,240,242,246,252,256,258,260,262,264,268,270,276,279,280,282,288,294,300,306,312,313,318,
320,330,331,336,344,356,360,376,384,388,497],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,
61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,
95,96,97,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,122,123,124,125,126,127,
128,129,130,131,132,134,135,136,138,140,141,142,144,145,146,147,148,149,150,152,153,154,156,157,158,160,162,163,164,165,166,
168,170,172,174,176,178,180,182,184,186,187,188,190,192,194,195,196,198,199,200,201,202,204,206,208,209,210,214,216,218,220,
222,224,226,228,230,232,234,236,238,240,241,246,248,250,252,255,258,260,262,264,269,270,276,282,288,294,300,306,312,315,330,
332,336,345,348,352,357,360,368,380,384,390,398,420,428,431,460,480,495],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,
30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,
69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,
103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,122,123,124,125,126,127,128,129,130,131,132,133,134,
135,136,137,138,140,141,142,144,146,147,148,149,150,152,153,154,155,156,157,158,160,162,164,165,166,168,170,171,172,174,175,
176,177,178,180,182,184,186,187,188,190,191,192,194,195,196,197,198,200,202,204,205,208,210,212,216,218,220,222,224,225,228,
230,232,234,238,240,245,246,247,248,250,252,254,256,257,258,260,264,266,269,270,274,276,282,285,288,294,300,306,312,314,315,
323,330,331,336,342,344,345,357,360,364,376,384,392,407,413,431,476],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,
68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,
102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,
133,134,135,136,138,139,140,141,142,144,146,147,148,150,152,153,154,156,158,160,162,163,164,165,166,168,169,170,172,174,176,
177,178,180,182,184,185,186,187,188,190,191,192,194,196,197,198,200,202,204,208,210,212,214,216,218,220,222,224,226,228,230,
232,234,236,240,242,244,246,248,250,252,254,258,260,264,268,270,273,276,280,282,288,294,300,304,306,330,332,336,340,348,352,
360,364,374,380,392,394,396,420,460],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,
63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,98,99,100],
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,
36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,
75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,98,99,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,98,99,100],
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,
38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,
76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,
66,67,68,69,70,71,72,73,74,75,76,77,78,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100],
,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,
36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,
73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,92,93,94,95,96,97,98,99,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,
28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,
67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,90,91,92,93,94,96,97,98,99,100],,,,,
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,
41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,
76,77,78,79,80,81,82,83,84,85,86,87,88,90,91,92,93,94,95,96,97,98,99,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,
30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,
69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100],,,,,
,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,
40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,
75,76,77,78,79,80,81,82,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,
30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,
69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,90,91,92,93,94,95,96,97,98,99,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,90,91,92,93,94,95,96,98,99,100],
,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,
38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,
75,76,77,78,79,80,81,82,84,85,86,87,88,90,91,92,93,94,95,96,97,98,99,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,
28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,
67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100],,
,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,
40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,
75,76,77,78,79,80,81,82,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,
30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,
69,70,71,72,73,74,75,76,77,78,79,80,81,82,84,85,86,87,88,89,90,91,92,93,94,96,97,98,99,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,
66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100],
,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,
36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,
74,75,76,77,78,79,80,81,82,84,85,86,87,88,89,90,92,93,94,95,96,97,98,99,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,
66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,84,85,86,87,88,89,90,91,92,93,94,96,97,98,99,100],,
,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,
40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,
76,77,78,79,80,81,82,83,84,85,86,87,88,90,91,92,93,94,95,96,97,98,99,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,
68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,90,91,92,93,94,95,96,97,98,99,100],,,,,
,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,
39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,
75,76,77,78,79,80,81,82,83,84,85,86,87,88,90,91,92,93,94,95,96,97,98,99,100],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,
28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,
67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100],
,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,
39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,
76,77,78,79,80,81,82,83,84,85,86,87,88,90,91,92,93,94,96,98,99,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,
28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,
67,68,69,70,71,72,73,74,75,76,77,78,80,81,82,83,84,85,86,87,88,90,92,93,94,95,96,97,98,99,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,84,85,86,87,88,89,90,92,93,94,95,96,97,98,99,100],
,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,
38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,
75,76,77,78,80,81,82,84,85,86,87,88,89,90,92,93,94,95,96,97,98,99,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,
28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,
67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,90,91,92,93,94,95,96,97,98,99,100],,
,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,
38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,74,
75,76,77,78,79,80,81,82,84,85,86,87,88,89,90,92,93,94,95,96,98,99,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,
68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,84,85,86,87,88,90,91,92,93,94,96,98,99,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100],
,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,
36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,72,74,75,76,
77,78,79,80,81,82,83,84,85,86,87,88,90,91,92,93,94,95,96,97,98,99,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,
66,67,68,69,70,71,72,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,96,97,98,99,100],,
,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,
40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,
75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,96,97,98,99,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,
30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,68,69,
70,71,72,74,75,76,77,78,80,81,82,84,85,86,87,88,89,90,91,92,93,94,95,96,98,99,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,
66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,90,91,92,93,94,96,97,98,99,100],,
,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,
38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,
74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,98,99,100],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,
28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,
67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100],
,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,
39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,
76,77,78,79,80,81,82,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,
28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,
67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100],,
,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,
40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,
76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,
28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,
67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100],
,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,
38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,74,75,
76,77,78,80,81,82,83,84,85,86,87,88,89,90,92,93,94,95,96,97,98,99,100],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,
28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,
67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,90,92,93,94,95,96,97,98,99,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,
66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100],
,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,
38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,72,74,75,76,77,
78,79,80,81,82,84,85,86,87,88,89,90,91,92,93,94,96,97,98,99,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,
66,67,68,69,70,71,72,73,74,75,76,77,78,80,81,82,83,84,85,86,87,88,89,90,92,93,94,95,96,97,98,99,100],,
,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,
39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,
75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,98,99,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,
68,69,70,71,72,73,74,75,76,77,78,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100],,,,,
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,
41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,
76,77,78,79,80,81,82,83,84,85,86,87,88,90,91,92,93,94,95,96,97,98,99,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,
30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,
69,70,71,72,74,75,76,78,80,81,82,84,85,86,87,88,90,92,93,94,96,98,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,68,69,70,71,72,73,74,75,76,78,80,81,82,83,84,85,86,87,88,90,91,92,93,94,96,98,99,100],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,73,74,75,76,77,78,80,81,82,83,84,85,86,87,88,90,91,92,93,94,95,96,97,98,99,100],
,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,
39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,74,75,76,
77,78,80,81,82,84,86,87,88,89,90,91,92,93,94,96,98,99,100],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,
66,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100],
,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,
37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,74,
75,76,77,78,80,81,82,83,84,85,86,87,88,90,91,92,93,94,95,96,98,99,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,
28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,
67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,90,92,93,94,95,96,97,98,100],,,,,,,,
,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,
41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,
76,78,80,81,82,84,85,86,87,88,90,92,93,94,95,96,98,100],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,
57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,
92,93,94,96,98,99,100],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,
67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,84,85,86,87,88,90,91,92,93,94,96,97,98,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,
66,67,68,69,70,71,72,74,75,76,77,78,80,81,82,84,85,86,87,88,89,90,91,92,93,94,95,96,98,99,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,74,75,76,77,78,80,81,82,83,84,85,86,87,88,90,91,92,93,94,95,96,98,100],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,
42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,
77,78,79,80,81,82,84,85,86,87,88,90,91,92,93,94,95,96,97,98,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,
30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,
69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,90,91,92,93,94,95,96,98,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,
66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,86,87,88,90,91,92,93,94,95,96,98,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,74,75,76,77,78,79,80,81,82,83,84,86,87,88,89,90,91,92,93,94,95,96,98,100],,,,,
,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,
39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,74,75,
76,77,78,80,81,82,83,84,85,86,88,89,90,91,92,93,94,95,96,98,99,100],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,
28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,
67,68,69,70,71,72,74,75,76,77,78,79,80,81,82,84,85,86,87,88,89,90,91,92,93,94,96,98,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,92,93,94,96,97,98,100],,
,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,
39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,
75,76,78,79,80,81,82,83,84,85,86,87,88,89,90,92,93,94,95,96,97,98,99,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,
68,69,70,72,74,75,76,77,78,80,81,82,84,85,86,87,88,89,90,91,92,93,94,96,98,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,74,75,76,77,78,80,82,84,85,86,87,88,90,91,92,93,94,95,96,98,99,100],,,,,,,,,,,
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,
42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,72,74,75,76,77,
78,79,80,81,82,83,84,85,86,88,89,90,91,92,93,94,95,96,98,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,
31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,
70,71,72,74,75,76,78,80,81,82,83,84,85,86,87,88,90,91,92,94,95,96,97,98,99,100],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,62,63,64,
65,66,67,68,69,70,71,72,74,75,76,77,78,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,96,98,99,100],,,,,
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,
41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,72,73,74,75,76,
77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,96,98,100],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,
30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,
69,70,72,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,90,91,92,94,95,96,98,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,73,74,75,76,77,78,80,81,82,83,84,85,86,87,88,89,90,92,93,94,96,98,99,100],,,,,
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,
41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,74,75,76,
78,79,80,81,82,84,86,87,88,89,90,91,92,94,95,96,97,98,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,
30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,
69,70,72,73,74,75,76,77,78,79,80,81,82,83,84,86,87,88,90,91,92,94,95,96,98,99,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,60,61,62,63,64,65,
66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,82,83,84,85,86,87,88,90,91,92,94,96,98,100],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,86,87,88,90,92,94,96,98,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,60,61,62,63,64,65,
66,68,69,70,72,74,75,76,78,80,81,82,83,84,86,87,88,89,90,91,92,94,95,96,98,99,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,62,63,64,65,
66,67,68,69,70,71,72,74,75,76,77,78,80,81,82,83,84,86,87,88,89,90,91,92,93,94,96,98,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,
66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,84,85,86,87,88,89,90,92,93,94,95,96,98,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,84,85,86,87,88,90,91,92,93,94,96,98,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,84,85,86,87,88,89,90,91,92,94,95,96,98,99,100],,
,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,
40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,
76,77,78,79,80,82,84,86,87,88,90,92,94,96,98,99,100],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,
58,59,60,62,63,64,65,66,67,68,69,70,71,72,74,75,76,77,78,80,81,82,83,84,86,87,88,89,90,91,92,93,94,95,96,97,98,100],
,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,
31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,
70,71,72,74,75,76,78,79,80,81,82,83,84,86,87,88,89,90,91,92,94,96,98,99,100],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,84,85,86,87,88,89,90,92,94,96,97,98,99,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,
66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,92,94,96,98,99,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,68,69,70,72,74,75,76,78,79,80,81,82,83,84,85,86,87,88,89,90,92,94,96,98,99,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,73,74,75,76,78,80,81,82,84,85,86,87,88,90,92,93,94,95,96,98,99,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,90,91,92,94,96,97,98,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,
66,67,68,69,70,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,90,92,94,96,98,100],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,86,88,90,91,92,93,94,96,98,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,62,63,64,65,
66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,90,92,93,94,96,98,99,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,74,75,76,77,78,80,82,83,84,85,86,87,88,90,91,92,93,94,96,98,99,100],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,68,69,70,71,72,74,75,76,78,79,80,81,82,83,84,85,86,87,88,90,91,92,94,96,97,98,100],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,72,73,74,75,76,77,78,80,81,82,83,84,85,86,87,88,89,90,92,94,96,98,99,100],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,94,96,98,100],,,,,
,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,
40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,72,74,75,76,
78,79,80,81,82,83,84,86,87,88,90,92,94,95,96,97,98,100],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,68,
69,70,72,73,74,75,76,78,79,80,82,83,84,86,87,88,89,90,92,94,95,96,98,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,72,74,75,76,77,78,79,80,81,82,84,85,86,87,88,90,92,94,96,98,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,68,69,70,71,72,73,74,75,76,77,78,79,80,82,84,85,86,87,88,90,92,94,96,98,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,73,74,75,76,78,79,80,81,82,84,86,87,88,90,92,93,94,96,98,99,100],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,73,74,75,76,77,78,80,82,83,84,86,88,89,90,91,92,94,95,96,98,99,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,88,90,92,93,94,96,98,99,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,68,69,70,72,73,74,75,76,78,79,80,81,82,84,86,87,88,90,92,94,96,98,99,100],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,73,74,75,76,78,80,82,84,86,87,88,89,90,91,92,94,96,98,99,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,86,87,88,89,90,92,94,96,97,98,100],,,,,,,,
,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,
40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,62,63,64,65,66,68,69,70,71,72,73,74,75,76,
77,78,79,80,82,83,84,85,86,87,88,90,92,93,94,96,98,100],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,
30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,
69,70,71,72,74,75,76,77,78,80,82,83,84,85,86,87,88,90,92,94,96,97,98,99,100],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,
64,65,66,67,68,69,70,71,72,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,90,92,94,96,98,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,
66,68,69,70,72,73,74,75,76,77,78,79,80,81,82,83,84,86,87,88,89,90,92,93,94,96,98,99,100],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,62,63,64,65,
66,68,69,70,71,72,73,74,75,76,77,78,80,81,82,83,84,85,86,87,88,89,90,92,93,94,96,98,99,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,
66,67,68,69,70,71,72,74,75,76,77,78,79,80,81,82,83,84,86,87,88,89,90,92,93,94,95,96,97,98,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,84,85,86,87,88,90,91,92,93,94,95,96,98,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,
66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,92,94,96,98,99,100],,,,,,,,
,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,
41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,60,61,62,63,64,65,66,67,68,69,70,72,73,74,75,76,77,
78,79,80,81,82,84,85,86,87,88,90,92,93,94,95,96,97,98,99,100],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,68,
69,70,71,72,74,75,76,77,78,79,80,81,82,84,85,86,87,88,90,92,94,96,98,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,82,84,86,87,88,90,92,93,94,96,98,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,
66,67,68,69,70,71,72,74,75,76,78,79,80,81,82,84,85,86,88,90,91,92,93,94,96,98,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,68,69,70,72,73,74,75,76,78,79,80,81,82,84,86,87,88,90,91,92,94,96,98,100],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,73,74,75,76,77,78,80,82,83,84,85,86,87,88,90,91,92,94,95,96,98,99,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,72,73,74,75,76,77,78,80,81,82,83,84,85,86,88,89,90,92,94,96,98,99,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,
66,67,68,69,70,72,73,74,75,76,77,78,79,80,81,82,84,85,86,88,90,92,94,96,97,98,99,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,84,85,86,88,89,90,92,94,96,97,98,99,100],,,,,,,,
,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,
38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,72,73,
74,75,76,78,79,80,81,82,84,85,86,88,90,92,93,94,96,98,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,
30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,68,69,
70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,88,90,92,94,96,98,100],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,62,63,64,65,
66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,86,88,90,92,94,95,96,98,100],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,72,73,74,75,76,77,78,79,80,81,82,83,84,86,87,88,89,90,92,93,94,96,98,100],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,60,61,62,63,64,65,
66,68,69,70,71,72,74,75,76,77,78,79,80,81,82,83,84,85,86,88,90,91,92,93,94,96,98,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,68,69,70,71,72,73,74,75,76,78,79,80,82,83,84,86,87,88,90,92,94,96,98,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,62,63,64,65,
66,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,88,89,90,92,94,96,98,99,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,71,72,74,75,76,78,79,80,81,82,83,84,85,86,87,88,90,92,93,94,95,96,97,98,99,100],,,,,
,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,
38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,72,73,74,
75,76,77,78,79,80,81,82,84,86,88,89,90,92,94,95,96,98,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,
68,69,70,72,73,74,75,76,77,78,79,80,81,82,83,84,86,88,90,92,93,94,96,97,98,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,60,61,62,63,64,65,
66,68,69,70,72,73,74,75,76,77,78,80,81,82,83,84,85,86,87,88,90,91,92,94,96,98,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,
65,66,67,68,69,70,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,88,89,90,91,92,93,94,96,98,99,100],,,,,
,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,
40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,72,73,74,75,76,
77,78,79,80,81,82,83,84,85,86,87,88,90,92,94,96,98,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,68,
69,70,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,88,90,92,94,96,98,99,100],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,50,51,52,53,54,56,57,58,59,60,61,62,64,66,67,
68,70,71,72,73,74,75,78,79,82,84,85,90,92,96,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,56,58,60,62,63,64,66,67,68,70,
72,73,76,78,81,82,84,86,87,88,90,93,97],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,50,52,53,54,56,58,60,62,63,
64,65,66,67,69,70,71,72,73,78,79,80,81,83,84,90,91,96,99],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,33,34,35,36,37,38,39,40,42,43,44,45,46,48,50,51,52,53,54,56,57,58,60,66,68,70,71,72,73,74,75,76,78,
84,90],,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,50,51,52,53,54,56,58,60,61,62,64,65,66,70,72,73,74,75,76,
78,79,80,84,85,87,90,94,100],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,50,52,53,54,56,57,59,60,62,63,64,66,67,68,70,
71,72,73,74,76,77,78,80,84,86,89,90,93,96],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,
18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,48,50,52,53,54,56,57,58,60,61,
62,64,66,67,68,70,71,72,74,76,78,79,80,81,82,84,87,90,92,93,97],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,50,51,52,54,56,57,58,59,60,61,62,64,66,69,70,71,
72,73,75,76,78,79,80,82,84,87,89,90,92,97,100],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,50,51,52,53,54,56,58,59,60,
62,63,66,67,68,70,72,73,75,76,78,82,84,85,86,88,90,100],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,50,52,53,54,56,59,60,63,66,68,69,70,71,72,74,75,
78,82,84,87,88,90,92,94,96,97,99,100],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,50,51,52,53,54,56,57,58,59,60,61,62,
63,64,65,66,70,72,78,79,80,84,86,87,90,93,96],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,50,51,52,53,54,56,58,59,60,62,63,64,66,67,68,70,
72,73,76,77,78,83,84,90,95,96,97,100],,,,,,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,
16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,54,55,
56,57,58,59,60,62,64,66,69,70,72,76,78,80,84,85,86,89,90,91],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,50,52,53,54,56,57,58,60,62,63,64,65,66,68,69,70,
72,74,75,78,80,82,84,86,90,92,95],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,56,58,59,60,61,62,66,
67,68,69,70,71,72,73,75,76,78,79,80,82,84,88,90,93,94,95,96,98],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,52,53,54,56,57,58,59,60,62,64,65,66,69,70,
72,76,78,84,85,87,90,93,96,98],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,54,56,60,64,66,67,68,70,
72,74,78,80,83,84,86,89,90,91,97,98],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,42,43,44,45,46,47,48,50,51,52,53,54,56,58,60,61,62,65,
66,68,70,71,72,78,81,83,84,90,96,97,100],,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,50,51,52,54,56,58,60,62,63,
64,66,68,70,71,72,74,75,76,78,80,84,88,89,90,92,95,96],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,50,52,53,54,55,56,58,59,60,61,62,63,64,66,68,70,
71,72,75,78,80,84,85,87,88,90,92,96,97,100],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,
18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,48,50,51,52,53,54,56,57,58,60,
62,63,64,65,66,67,68,70,72,74,78,80,83,84,85,86,90,91,96,100],,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,44,45,46,47,48,49,50,51,52,53,54,56,58,59,60,62,64,66,67,70,72,
73,78,79,80,84,87,90,96,97,100],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,42,44,45,46,47,48,50,52,54,56,58,60,62,64,66,67,68,70,71,72,73,75,
78,80,83,84,87,88,90,92,96,100],,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,50,52,53,54,56,60,61,62,66,68,70,
71,72,74,78,80,82,84,86,87,88,90,96],,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,50,51,52,54,56,58,60,62,64,66,
69,70,71,72,76,78,79,80,82,84,86,87,89,90,96,99,100],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,56,57,60,64,65,66,70,72,75,76,
78,80,84,88,90,94],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,44,45,46,47,48,49,50,52,54,56,57,58,60,61,62,63,64,65,66,68,69,70,
72,74,78,79,80,83,84,87,89,90,91,95,96],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,50,51,52,53,54,56,57,60,62,
63,66,68,69,70,72,75,77,78,80,84,85,86,89,90,95,97],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,42,43,44,46,47,50,51,52,53,54,58,60,61,62,64,65,66,69,70,74,75,76,79,80,
83,84,97],,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,46,47,48,49,50,52,53,54,56,59,60,63,65,66,67,68,70,71,72,76,78,
84,88,90,99],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
29,30,31,32,34,35,36,37,40,41,42,43,44,45,46,47,48,49,50,51,52,54,56,60,61,62,68,70,72,73,82,85,94,96,97],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
35,36,37,38,39,40,41,42,43,44,45,48,51,53,54,56,59,60,62,66,67,68,69,70,71,74,76,78,79,93,96],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,37,38,39,40,41,42,43,44,45,47,48,49,51,52,54,55,57,60,61,63,65,66,67,68,69,72,81,87,88,90,91,93,98],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,39,40,41,42,43,44,46,47,50,52,53,57,59,60,63,66,67,69,73,74,76,78,81,84,86,88,89],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
36,37,38,40,41,42,43,46,47,48,50,51,54,58,59,60,68,72,76,79,80,89,94],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,50,51,52,54,56,57,59,60,62,67,68,70,71,72,73,77,78,90,96,100],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,34,36,37,
38,39,40,41,42,45,47,48,50,52,53,57,58,59,60,61,62,64,68,75,77,79,82,83,84,96,100],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,33,
34,35,36,37,38,39,40,41,42,43,44,47,48,50,52,53,54,56,60,63,66,68,69,72,74,76,77,79,86,87,88,89,94,95],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
35,36,37,38,39,40,41,42,43,44,48,52,53,54,57,59,60,62,70,74,77,82,83,84,85,88],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
36,37,38,39,40,41,42,43,44,45,46,48,49,50,51,52,59,60,61,75,76,77,79,82,85,86,87,90,92,95],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,50,52,53,57,59,60,61,62,68,70,71,72,73,75,84,87,88,90,96],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,40,41,42,43,45,46,48,49,50,53,54,56,57,59,63,66,67,71,72,74,84,86,90,96],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,41,42,43,47,48,50,52,53,54,58,59,60,67,69,72,74],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,40,41,42,46,47,48,49,50,52,53,58,60,61,62,63,66,68,
70,80,82,87,95,96,99],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,
31,32,33,34,35,36,37,40,41,42,43,44,45,46,47,48,49,50,53,54,56,58,59,60,63,64,65,66,70,79,80,81,82,84,87,92],
,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,35,36,37,38,
39,40,41,42,43,44,45,47,48,52,53,54,55,60,61,64,67,70,72,73,76,78,79,80,83,86,90,91,95,96],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,
31,32,33,34,36,37,38,40,41,42,43,44,45,46,47,48,52,53,54,56,57,60,63,64,66,67,69,72,74,82,84,85,88,89,90,93],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,40,41,42,43,44,47,48,50,51,52,53,54,60,61,66,67,72,73,79,80,81,83,84,86,93],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,35,
36,37,38,39,40,41,42,43,44,45,47,48,49,53,54,56,58,59,60,62,65,67,68,70,82,88,90,91,93,97],,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,
36,37,38,39,40,41,42,43,44,47,48,49,53,54,56,58,59,60,69,72,74,75,82,84,86,88,89,93,94],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
35,36,37,39,40,41,42,44,45,46,47,48,49,52,54,55,58,60,61,66,68,70,72,73,80,92,97,98],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,40,41,42,43,48,50,51,52,54,57,58,59,60,62,63,67,68,70,72,73,75,76,83,84,87,91,97],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
35,36,37,38,40,41,42,43,45,47,48,50,52,53,60,63,66,69,70,73,76,78,79,83,84,85,90,91,93,96,100],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
36,37,38,39,40,41,42,43,44,45,48,50,51,55,58,59,60,61,64,65,66,70,71,76,77,78,82,84,86],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
35,36,37,38,39,40,41,42,43,44,46,47,48,50,52,53,57,58,59,60,66,71,72,73,77,78,80,85,92,94],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,37,38,40,41,42,43,44,45,47,48,52,53,54,60,61,62,63,64,66,71,72,76,81,87,90,96],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,35,
36,37,39,40,41,42,46,47,48,49,50,53,54,56,59,60,61,67,69,70,81,82,84,89,92,93],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,39,40,41,42,43,44,45,48,50,52,54,55,56,57,58,60,62,66,67,72,82,84,86,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
35,36,37,38,39,40,41,42,43,44,45,46,47,48,50,51,52,53,55,59,60,66,67,68,70,72,73,78,80],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
35,36,37,38,39,40,41,42,43,44,46,47,48,52,54,56,57,59,63,65,66,68,72,74,78,79,80,89,91,94],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,37,38,40,41,42,43,44,45,46,47,48,49,51,53,54,58,60,63,67,68,72,82,83,84,85,90],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,40,41,42,43,47,48,50,52,55,56,59,60,63,66,68,72,86,87,91,94],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,39,40,41,42,43,44,45,47,48,54,56,60,62,64,65,66,67,75,78,81,82,83,84,86,87,89,90,93,95,96,97],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,40,41,42,43,44,45,46,47,48,50,52,53,54,56,61,70,77,78,82,84,90,93,100],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
35,36,37,38,39,40,41,42,43,44,45,47,48,50,52,56,57,58,59,62,63,64,65,69,70,71,72,75,76,84,86,88,91,99],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,40,41,42,43,44,46,47,48,50,51,52,53,54,56,58,59,60,63,64,66,68,72,76,79,80,93,99,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
35,36,37,38,40,41,42,43,44,45,46,47,48,49,50,51,53,55,58,59,60,70,76,79,80,82,84,86,87,90,92,94,97,98],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,34,35,
36,37,38,39,40,41,42,43,44,46,47,48,50,51,53,54,60,70,72,74,75,76,78,81,82,84,87,94],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,40,41,42,43,46,47,48,49,50,51,54,60,63,64,66,69,70,80,82,83,86],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,39,40,42,43,44,48,50,51,53,54,60,63,67,71,75,78,84,96],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
35,36,37,38,39,40,41,42,43,44,46,47,48,53,54,57,60,61,62,63,64,66,67,70,72,73,76,77,86,94,95],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
35,36,37,38,40,41,42,43,44,47,48,50,52,56,58,60,61,63,69,72,80,84,87,88,89,100],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
35,36,37,38,40,41,42,44,45,46,47,49,52,56,59,60,61,64,65,66,82,87,93],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,40,41,42,43,44,45,46,48,49,50,51,53,54,56,58,60,61,62,64,66,72,84,87,91,92],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,40,41,42,43,44,46,47,48,50,52,53,54,55,60,61,62,65,66,67,71,72,76,84,89,92,96,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,34,35,
36,37,38,39,40,41,42,43,44,46,48,53,55,58,60,64,67,70,74,88,93,95],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
35,36,37,38,39,40,41,42,45,47,48,50,52,54,55,56,57,59,60,61,63,64,65,67,70,73,78,82,84,90,91,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
35,36,37,38,40,42,43,44,46,48,49,50,51,52,53,54,56,58,59,60,67,73,74,75,76,77,92,100],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,35,
36,37,38,39,40,41,42,43,44,47,48,53,54,56,58,60,63,68,69,80,85,94],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
35,36,37,38,39,40,42,43,44,46,47,48,50,52,53,54,56,58,59,71,72,75,77,78,86,87,92,93,96],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,34,36,37,
38,39,40,41,42,43,45,46,48,49,53,55,57,60,62,67,74,81,82,86,90],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,35,36,37,38,40,41,42,44,51,52,53,55,56,59,60,61,62,67,68,
70,76,79,85,87,95],,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,
28,29,30,31,32,33,34,36,37,39,40,41,42,43,45,46,47,48,51,52,53,54,57,60,61,62,67,68,69,71,72,75,78,92,95],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,
31,32,33,34,36,37,38,39,40,41,42,43,44,45,48,49,51,53,54,55,56,57,58,59,60,61,62,64,66,71,72,74,81,84,85,88,96,97],,,,,
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,35,
36,37,38,39,40,41,42,43,44,47,48,51,53,54,55,56,59,60,64,66,67,70,72,73,79,81,82,84,94],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,34,35,
36,37,38,40,41,42,43,44,45,48,49,51,52,56,57,61,62,66,67,70,76,79,85,89,98],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
36,37,38,39,40,41,42,43,44,45,48,49,50,52,54,56,58,59,60,61,62,64,69,77,78,81,84,87,89,96],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,40,42,44,46,48,50,51,54,59,62,66,68,77,84,85,89,92,93,95,97],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
35,36,37,41,42,43,44,45,46,47,48,49,51,52,53,54,55,56,57,59,60,62,63,66,67,70,72,82,84,85,87,92,98],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
36,37,38,40,41,42,43,44,45,47,48,50,53,54,56,57,58,59,60,61,62,65,72,74,77,80,83,84,86,87,90,95],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,33,34,
36,37,39,40,41,42,43,44,47,48,50,51,52,54,56,60,62,63,66,68,72,78,79,84,86,87],,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
33,34,35,36,37,38,40,41,42,43,44,47,48,50,51,52,56,58,59,60,61,63,66,68,75,80,86,96],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,40,41,42,43,44,45,47,48,51,53,54,60,61,63,68,71,76,78,80,84,93],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,33,34,35,
36,37,38,39,40,42,44,45,48,52,54,56,57,59,62,66,68,72,78,79,80,84,88,90,95,97],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,36,
37,38,40,42,45,47,48,52,53,54,55,56,57,58,59,60,61,62,63,64,76,83,87],,,,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
33,36,37,38,40,41,42,43,45,47,48,50,53,54,57,58,59,61,67,72,84,87,90,93,96],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
36,37,38,39,40,41,42,43,46,48,50,52,55,56,59,60,62,68,71,72,77,83,84,85,92,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,34,36,
37,38,39,40,41,42,43,46,48,49,55,56,58,60,62,67,69,71,72,73,74,82,84,87,92,93,96],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,39,40,41,42,44,45,47,48,54,60,63,66,71,78,88,90,94],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,39,40,41,42,43,44,46,47,50,53,54,56,60,62,65,66,68,70,71,72,80,83,84,87,95,96,99],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,33,34,35,
36,37,38,39,40,41,42,43,44,45,47,48,49,50,53,59,60,63,66,68,70,72,73,78,79,80,86,88,90,93],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,35,
36,37,38,39,40,41,42,43,44,45,46,48,49,51,53,54,56,57,60,67,69,72,73,74,84,90],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
35,36,37,38,42,44,46,47,48,49,50,52,54,55,56,57,60,62,63,64,66,67,70,71,72,73,75,84,93,98,99],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
35,36,37,38,40,41,42,43,44,46,47,48,50,52,53,54,56,60,65,67,70,72,74,75,76,79,87,91,97],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
35,36,37,38,39,40,42,45,46,47,48,52,55,56,57,58,60,61,63,65,66,68,72,73,74,87,90,96,99],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
35,36,37,38,39,40,41,42,43,44,45,46,47,48,51,54,56,57,58,60,63,64,67,71,73,74,79,92,93,96],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,40,41,42,43,44,45,46,47,48,52,56,59,60,61,64,66,67,71,72,74,75,80,81,84,86,88,92,95,96],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
35,36,37,38,40,41,42,43,44,45,47,51,52,53,54,56,57,58,59,60,62,64,66,67,70,71,72,73,77,80,83,90],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,40,41,42,43,44,48,49,51,54,56,58,60,62,66,68,71,72,73,82,85,89,95,96,98],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,40,41,42,43,44,45,46,48,49,50,52,54,58,59,60,61,67,68,70,71,72,74,75,82,90,96,98],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,36,
37,38,39,40,41,42,43,44,48,55,56,57,58,60,62,63,64,65,74,75,76,78,84,85,86,87,89,93,97],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,40,41,42,43,44,46,47,48,49,50,52,54,55,56,58,60,62,64,66,67,69,75,94],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,36,
37,38,40,42,43,44,45,46,48,49,51,52,54,55,57,59,60,64,67,69,71,76,78,84,86,88,89,90,92,98],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
35,36,37,40,41,42,43,44,46,47,50,52,53,54,56,59,60,62,64,68,70,72,74,80,82,86,92],,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,39,40,41,42,43,45,46,47,48,51,52,54,56,59,60,61,62,63,64,66,67,68,70,72,74,75,78,80,81,82,95,99],,,,,,,,,,,,,
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,35,36,
37,38,40,41,42,43,44,45,46,47,48,51,53,54,55,56,58,60,62,64,67,74,76,80,84,86,94],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
33,36,38,40,42,43,44,46,47,48,49,50,52,53,54,57,58,60,62,64,67,76,80,95],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
35,36,37,38,40,41,42,43,45,47,48,53,54,58,60,61,63,64,72,74,80,81,86,89,90,94],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
35,36,37,38,40,41,42,43,45,46,47,48,53,54,55,56,57,60,61,62,64,70,72,74,76,80,82,84,86,90],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,40,41,42,43,44,45,48,50,52,53,54,58,59,60,62,68,72,74,85,87,89],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
36,37,38,39,40,41,42,43,45,48,52,54,56,58,59,60,63,70,72,73,77,81,89,95,96],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,40,41,42,43,44,47,48,54,55,58,59,60,64,66,67,71,72,73,82,84,87,89,91,96,99],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,52,55,58,59,66,68,73,74,75,76,79,83,85,95],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,36,
37,38,39,40,41,42,43,46,48,51,53,54,56,58,60,62,63,64,71,73,76,78,92,95,96],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,34,35,
36,37,38,40,41,42,43,44,45,46,47,53,57,58,59,60,67,68,70,73,76,77,79,80,82,84,88,89,90,94],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
35,36,37,38,39,40,42,43,44,46,47,49,52,53,58,59,60,68,69,72,74,76,84,89,97],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,34,36,
37,38,39,40,41,42,43,44,45,46,47,48,51,52,53,55,56,59,60,61,62,63,68,74,82,90],,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,40,41,42,45,46,47,48,50,52,54,55,57,59,60,62,64,65,66,68,70,71,72,75,79,80,89,99],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,35,36,
37,38,40,41,42,43,44,45,47,48,49,52,53,59,63,65,71,72,73,74,77,79,96],,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,40,41,42,43,44,45,47,48,52,54,56,57,59,60,66,72,73,74,79,82,86,87,94],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
35,36,37,38,41,42,43,44,47,48,49,50,53,54,56,60,61,62,64,71,72,74,76,79,86,87,99,100],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
36,37,38,39,40,41,42,43,44,46,47,48,50,54,58,59,60,61,62,64,68,72,73,74,75,76,78,79,81,84,85,93,94,96],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
36,37,38,39,40,41,42,43,44,47,48,52,53,55,57,58,59,60,61,66,69,73,75,83,84,93],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,39,40,42,44,49,52,53,54,55,63,64,65,67,69,80],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,42,48,51,53,54,56,60,61,62,64,67,69,70,72],,
,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,35,36,37,38,42,44,45,
46,52,54,59,60,63,66,67,68,70,72,81,89,90,92],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,28,29,30,31,33,34,36,37,38,41,42,43,44,46,47,48,50,51,59,60,61,65,66,71,72,75,79,84,86,87,91,93,94,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,35,
36,37,38,40,41,42,43,44,45,46,47,48,49,52,53,58,59,60,61,62,63,67,69,70,71,73,90,94],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,36,
38,40,41,42,44,46,47,48,50,51,53,54,55,56,60,67,72,76,82,88,89,96,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,40,41,42,44,46,47,48,49,50,51,54,55,56,60,63,64,66,67,69,72,73,75,81,92,96,100],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,34,35,
36,37,39,40,41,42,43,46,48,56,59,60,62,63,67,69,70,71,72,75,84],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,41,42,43,44,45,46,47,48,50,52,54,56,57,58,60,61,63,66,70,77,79,83,84,88,89,90,93,96],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,37,38,41,42,43,44,45,48,51,52,53,54,60,69,73,76,84,86],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,25,26,28,29,30,31,32,33,34,35,36,37,39,40,41,42,45,46,48,50,61,63,64,66,68,69,70,73,77,78,82,90,92,95,100]
,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,
31,32,33,34,35,36,37,42,43,44,47,48,51,52,53,54,60,61,62,65,66,68,70,73,74,79,81,83,84,85,96,97],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,40,41,42,43,44,46,48,49,51,52,54,55,57,58,59,60,62,66,69,70,72,74,77,84],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,33,34,36,
37,38,41,42,43,44,46,47,48,50,52,56,57,60,66,67,68,69,74,79,83,84,92,95,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,40,41,42,44,45,46,48,50,51,53,54,56,58,60,65,66,68,69,71,73,74,75,79,82,84,87,88,90],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,39,40,42,47,48,49,52,54,56,58,60,62,63,64,66,68,84,89,99],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,40,42,45,46,47,48,52,54,55,56,57,58,59,60,63,64,65,67,71,72,78,80,84,89,90,93,97],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,39,40,41,42,43,44,46,47,48,50,51,54,55,60,63,67,70,71,72,74,77,81,82,86],,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,40,41,42,43,45,46,50,51,53,54,55,56,58,60,68,69,72,90,100],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,46,48,52,54,56,57,59,60,64,65,
66,70,72,74,77,80,84,87,96],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,
29,30,31,32,33,34,35,36,37,39,40,41,42,43,44,46,48,53,54,55,56,58,60,62,64,65,66,70,72,73,77,80,84,92,96],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,35,36,38,39,
40,41,42,43,46,47,48,50,53,54,56,58,59,60,61,62,65,66,70,72,76,83,87,96],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,
31,32,34,35,36,38,39,40,41,42,43,44,45,46,47,48,50,52,53,54,58,59,60,61,70,71,72,75,78,80,84,89,90,93],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,36,
37,38,40,41,42,43,44,45,46,47,49,51,52,53,54,57,59,60,64,65,68,71,72,73,76,79,80,84,88,89,91,98],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
35,36,37,39,40,41,42,43,48,49,52,58,59,60,64,66,70,71,74,75,77,80,83,87,93,96],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,39,41,42,44,47,48,51,53,56,58,60,61,63,64,71,72,73,75,77,79,96],,,,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
33,34,35,36,38,39,40,41,42,43,45,46,48,49,50,52,54,55,56,61,63,66,71,72,73,75,76,78,79,97,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,50,51,52,53,54,56,57,60,62,66,67,70,74,75,77,83,88,89,99],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,35,
36,37,38,39,40,41,42,43,44,46,47,48,50,55,56,57,58,60,65,67,69,70,74,75,80,83,87,89,92,93,97,100],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,33,34,
35,36,37,38,39,40,41,42,43,45,46,47,48,50,54,56,57,58,59,60,62,63,65,66,70,72,74,77,80,81,85,90,97,99,100],,,,,,,,,,,,,,,
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
36,38,39,40,41,42,43,46,47,48,49,50,51,52,57,59,60,61,63,64,75,76,78,90,91],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,40,41,42,43,44,45,46,47,48,53,54,59,60,61,67,74,75,77,84,86,88,89,90,91,97,99],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,37,38,39,40,41,42,43,46,51,52,53,54,55,58,60,61,65,66,72,82,83,97,99],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,37,38,40,42,43,46,48,49,51,54,55,56,59,60,64,66,68,71,73,74,93,95,96],,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,34,35,
36,37,38,40,42,43,45,46,47,48,49,52,53,55,56,59,60,61,64,73,74,93,94,96,98],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,33,34,
36,37,38,39,40,41,42,43,44,46,47,48,49,50,51,52,54,56,58,59,60,61,65,66,71,72,74,80,84,92],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,34,35,36,
37,39,40,41,42,43,44,46,48,55,56,57,58,60,61,62,63,67,69,78,80,84,88,93,96],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,41,42,43,44,46,48,50,52,59,60,61,65,66,75,82,84,87,99],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,35,
36,37,38,40,41,42,43,44,46,47,48,52,56,57,60,61,63,67,68,72,73,80,85,88,89,92,96],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,36,37,
38,40,41,42,43,44,45,46,47,48,53,56,58,59,60,62,65,67,72,74,76,77,90,96,97],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,36,
37,39,40,41,42,43,45,47,48,50,52,56,60,66,71,73,77,79,82,83,84,86,87,90,91,93,96,99,100],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
35,36,37,38,40,41,42,43,44,46,47,51,52,53,56,59,60,63,65,67,72,81,82,84,88,94],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,53,58,59,60,65,67,70,72,74,79,82,84,87,90,91,93],,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,37,38,40,41,42,43,46,47,54,55,56,57,60,61,66,68,71,74,76,80,83,84,89,91,92],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,37,38,39,40,42,43,46,47,51,53,56,59,66,67,72,80,85,86],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,25,26,27,28,29,30,31,32,34,36,37,39,41,42,43,44,45,46,47,48,50,53,56,60,62,64,65,68,69,71,72,
73,82,84,88,90,94,100],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,
31,32,34,35,36,37,40,41,42,43,44,45,46,49,50,52,56,60,67,70,74,75,83,84,86,90,97],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
29,30,31,32,34,35,36,37,38,39,41,42,43,44,45,47,48,53,56,57,58,60,61,62,63,65,67,72,74,76,86,89,90],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,40,41,42,45,46,47,48,51,52,53,54,59,60,62,66,68,69,72,74,77,82,83,85,96],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,33,34,35,
36,37,38,40,41,42,43,47,48,50,53,62,66,67,71,72,75,79,84,91],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,36,37,40,42,43,44,45,46,48,50,51,53,54,56,60,64,66,69,71,74,86,90],
,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,
35,36,37,38,40,41,42,43,44,45,46,48,50,51,54,56,57,58,59,61,66,68,70,72,73,80,82,83,90,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
34,35,36,37,38,40,41,42,43,44,45,46,48,50,51,54,56,59,60,61,62,67,74,75,82,84,86,89,93],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,39,40,42,44,45,46,48,50,54,56,58,59,60,61,62,64,66,72,74,84,88,90,95,96],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,36,
37,39,40,41,42,43,44,48,54,57,58,59,60,65,72,74,78,82,83],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,25,26,27,28,29,30,31,32,34,35,36,37,39,40,41,42,43,44,47,48,50,52,54,55,56,57,59,60,62,63,
65,69,70,71,74,79,80,84,85,94,96],,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
24,26,27,28,29,30,31,33,34,36,37,38,40,41,42,43,44,46,48,49,51,53,57,60,62,72,77,84,88,99],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,
30,31,32,33,34,35,36,37,40,41,42,43,44,47,48,53,57,58,59,60,65,67,70,71,72,84],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,36,
37,38,40,41,42,43,44,48,51,54,60,61,65,71,72,84,85],,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,26,28,29,30,31,32,33,34,36,37,38,40,42,43,44,45,46,47,48,51,52,57,60,61,74,80,84,86,88,94,97],
,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,35,36,37,38,
39,40,41,42,43,44,45,47,48,50,52,55,59,60,61,64,66,70,72,77,78,80,82,84,86,90,91,97,99],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,
30,31,33,34,35,36,37,38,40,41,42,43,44,46,48,50,53,56,58,60,61,62,69,71,72,76,85,89,92,95,97],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
35,36,37,38,39,40,41,42,43,44,45,46,47,48,50,51,52,58,60,65,66,68,71,74,76,82,84,87,88,90,93,94,96,99,100],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
35,36,37,38,40,41,42,43,44,47,48,50,51,53,54,55,57,58,59,60,61,67,68,69,72,73,76,79,80,83,84,95,97],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
36,37,38,39,40,41,42,43,44,47,48,52,58,60,64,66,68,72,84,86],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,41,42,43,46,47,48,50,51,53,54,55,57,59,61,
66,71,72,76,78,81,84,92],,,,,,,,,,,,,,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,45,46,48,52,53,58,60,61,66,67,70,72,76,78,82,84,90,92],
,,,,,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,
30,31,34,36,37,38,39,40,42,43,44,45,46,47,48,54,55,59,60,61,63,69,71,72,79,84,86,88,90,91,92,95],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,36,37,
40,41,42,43,44,45,48,50,52,53,55,57,60,63,71,74,79,84,90,93,97],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
36,37,38,39,40,41,42,43,44,48,50,52,53,54,56,59,60,61,62,66,72,73,75,83,84,86,96,97,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,38,40,41,42,43,44,46,48,51,52,54,59,62,65,72,83,85,88,99],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,27,28,29,30,31,32,34,36,37,38,39,41,42,43,47,49,50,51,53,54,56,67,69,71,76,78,83,84,86,97],
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,36,
37,38,40,41,42,43,44,46,48,50,54,57,60,65,66,67,68,71,73,80,82,93,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
32,36,37,40,41,42,43,44,46,47,48,50,52,53,54,58,59,61,62,63,64,67,71,73,80,86,89,96,97,100],,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,40,41,42,44,46,47,48,49,50,51,54,57,58,60,63,65,66,71,93,96],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
35,36,37,38,39,41,42,43,45,46,48,52,54,56,58,60,61,62,69,70,72,74,86,99],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,37,40,42,43,44,45,46,49,53,54,59,60,64,66,67,72,80,90,97],,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,40,41,42,43,44,46,48,50,52,53,54,56,58,60,70,74,75,77,79,80,82,86,96],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,40,41,42,43,44,46,47,51,55,56,57,59,62,67,68,79,80],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,38,39,40,41,42,44,46,47,48,49,51,52,53,55,56,57,61,62,63,66,81,83,92,96],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
36,37,38,40,41,42,43,46,47,48,49,50,51,52,53,57,59,60,61,63,66,67,73,80,84,93,99,100],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
35,36,37,38,39,40,41,42,43,44,45,47,51,52,53,54,56,57,58,60,63,64,65,68,69,70,72,76,78,80,88,90,93],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
35,36,37,38,40,42,43,44,46,47,48,51,54,56,58,60,62,66,67,85,87,88,92,96],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
36,37,38,39,40,41,42,43,44,47,48,49,53,54,55,63,67,69,72,73,76,78,80,81,87,96],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
35,36,37,38,39,41,42,43,44,45,48,49,50,51,52,53,54,55,56,58,59,60,61,62,67,69,70,72,75,76,78,88],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,36,
37,39,40,41,42,43,45,47,48,52,53,54,55,60,63,66,73,74,78,79,82,84,86,94],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,40,41,42,43,46,47,48,50,52,54,55,59,60,62,63,68,70,74,79,82,84,86,91],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,34,35,36,
37,39,40,41,42,43,44,47,51,53,54,59,60,67,72,74,77,80,84],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,40,41,42,44,45,46,47,48,49,50,51,54,58,60,63,66,
70,71,75,81,82,84,88,90,93,96,97,100],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,34,36,37,38,40,42,45,46,47,48,49,50,51,52,58,60,62,67,72,74,84,90,92],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,
30,31,32,33,34,35,36,37,40,41,42,44,46,48,49,52,54,55,58,60,66,70,72,83,84,88,95,96],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,34,36,
37,39,40,42,43,44,45,47,48,49,53,57,58,59,60,62,63,64,66,69,74,83,90,91,98],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,34,35,36,
38,39,40,41,42,43,46,52,54,56,58,59,60,62,63,65,67,70,72,78,97],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,27,28,29,30,31,32,36,37,38,40,41,42,43,46,47,48,49,50,52,53,54,58,60,62,69,74,80,81,83,95],
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,
36,37,38,40,41,42,44,45,48,56,57,59,60,64,66,72,74,77,79,80,90],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
33,34,35,36,37,39,40,41,42,45,47,48,50,52,53,55,56,60,61,62,63,64,65,66,67,72,90,91,96],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,34,35,
36,37,39,40,41,42,43,48,50,53,58,69,74,77,91],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,34,36,37,38,39,40,41,42,44,45,46,48,52,54,56,57,60,61,69,72,80,82,88,92],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,35,36,37,38,39,40,41,42,43,
44,46,48,51,52,53,55,58,60,63,67,80,84,88,96],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,36,37,38,39,40,41,42,44,45,48,50,51,54,59,60,61,71,74,78,83,84,90,95,96],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,35,
36,37,38,40,42,44,47,48,54,56,57,60,61,65,67,69,70,72,74,76,84,88],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,40,41,42,43,44,46,47,48,49,50,51,52,54,55,56,58,60,62,66,71,72,74,78,81,82,83],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
36,37,38,40,42,43,44,45,47,48,53,54,60,62,63,69,86,89,90,95,96],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,34,35,
36,37,38,40,41,42,43,44,45,46,48,49,50,51,52,56,57,59,60,62,72,78,79,80,85,87,96,98],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,33,34,35,
36,37,38,39,40,41,42,43,44,47,48,51,52,54,60,61,63,76,79],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,25,26,27,28,29,30,31,32,34,36,37,39,40,42,43,44,45,46,50,53,58,60,61,63,67,68,72,79,84,85,90,100],
,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,34,35,36,37,
38,39,40,41,42,43,44,45,46,47,48,51,53,56,57,59,60,61,65,67,68,70,72,73,76,78,79,84,86,93,94,95,96,99],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
32,34,36,37,38,40,41,42,43,45,46,48,50,51,53,54,56,57,58,59,60,61,65,68,72,74,76,79,82,84,86,87,90,93,96],,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,34,36,37,41,
42,44,45,46,48,49,50,56,57,58,60,61,68,71,72,74,85,96,100],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,
34,36,37,38,39,40,41,42,43,44,46,47,48,49,50,51,56,60,67,69,72,73,74,78,82,98],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
36,37,39,40,41,42,45,46,47,48,51,52,53,54,55,58,60,61,62,67,71,72,78,90,91],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,39,40,41,42,44,45,46,47,48,50,51,54,56,60,61,65,66,71,72,73,78,80,91],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,40,41,42,43,44,46,47,48,52,53,59,60,64,66,71,76,79,84,87,93],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
35,36,37,38,40,41,42,43,44,45,46,48,50,51,60,61,64,66,67,68,71,74,83,88,90],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
35,36,38,39,41,42,43,44,46,47,48,50,51,54,55,56,65,67,68,69,70,82,86,87,88,93,96],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,40,41,42,43,46,47,48,50,54,55,57,58,60,66,73,75,78,80,84,87,95],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
35,36,37,40,41,42,45,46,48,55,56,58,61,66,67,72,80,82,87,90,91,93],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,35,
36,37,40,41,42,43,44,45,46,48,49,52,54,58,59,60,64,65,67,72,80,81,84,87,90,92],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,37,39,41,42,43,44,47,48,51,53,54,57,63,64,68,72,77,84,85,94,96,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
35,36,37,38,40,42,43,44,48,50,52,54,57,60,63,68,71,72,74,83,86,89],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,38,39,40,41,42,43,44,49,50,51,54,56,58,60,68,71,75,78,80,84,99,100],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,40,41,42,43,44,46,47,48,49,50,53,56,57,60,61,65,85,88,97,100],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,39,40,41,42,43,48,50,51,53,54,56,58,60,64,66,68,69,72,74,75,76,79,85,86,89,95,96,100],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
35,36,37,38,40,42,44,46,47,48,50,52,54,56,59,60,61,62,63,64,71,72,73,75,77,84],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
35,36,37,38,39,42,43,46,48,51,52,56,58,60,63,64,65,69,72,76,84,89,96],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,39,42,43,44,45,46,48,50,51,53,54,56,57,58,60,63,64,66,69,72,78,84,85,86,93,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
35,36,37,38,39,40,41,42,43,44,46,47,48,51,52,53,54,56,58,60,62,64,65,66,67,68,78,80,82,89,91,99],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,40,41,42,43,44,45,46,48,50,54,57,58,60,76,79,84,96],,,,,,,,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,34,
35,36,37,38,40,41,42,43,44,46,51,53,56,58,59,60,61,65,66,70,71,72,76,82,86,88,97],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,33,34,36,
37,38,39,40,41,42,43,46,48,50,51,52,58,59,67,69,71,77,80,84,86,95],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,40,41,42,43,45,46,47,48,52,53,54,60,65,66,69,70,71,72,73,74,78,84,87,90,91,92,99],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
36,37,38,39,42,43,44,45,46,47,48,49,50,54,60,67,68,71,72,75,78,79,81,83,88,94,96],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,42,43,44,46,47,48,56,57,59,60,62,63,65,72,74,76,81,87,96,99],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,34,36,37,
40,41,42,43,45,46,47,49,52,56,60,61,63,73,74,80,85,86,90,92,93,98],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,40,41,42,43,45,46,47,48,51,52,54,56,58,59,60,61,68,69,71,72,74,80,81,84,85,87,93,94],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,39,40,41,42,43,46,47,48,52,53,54,60,62,64,65,69,70,71,78,82,85],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,37,38,39,40,41,42,43,44,45,47,48,49,50,54,59,60,62,63,69,78,82,84,85,90,93],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,40,41,42,43,44,45,47,48,49,50,52,53,60,64,67,72,81,83,98,100],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,39,40,42,43,45,46,48,50,52,53,54,56,58,62,63,68,71,72,73,76,84,85,90,97],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
35,36,37,40,41,42,43,44,46,47,48,50,52,56,60,66,70,72,75,79,84,86,92,94],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
35,36,37,38,39,40,42,43,46,50,51,52,53,54,56,57,62,68,69,74,75,84],,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,
34,36,37,38,39,40,41,42,43,44,45,46,47,48,49,52,54,58,60,66,67,72,78,80,86,87,90,92,94],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,39,41,42,43,44,47,48,52,53,54,58,60,61,63,64,67,68,71,72,78,84,91],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
36,37,38,40,41,42,43,44,48,53,56,58,66,69,72,82,86,88,89,95,96],,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
36,37,39,40,41,42,44,45,46,48,55,59,61,63,64,68,75,82,84,87,88],,,,,,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,
36,37,39,40,42,43,45,49,52,54,56,60,74,78,86,90,93,98],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,25,26,28,29,30,31,32,33,34,35,36,37,38,41,42,43,46,48,50,52,57,60,61,63,64,70,76,77,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
27,28,29,30,31,32,34,35,36,37,38,39,40,41,42,43,44,46,47,48,49,52,53,56,59,60,61,63,67,71,72,73,81,83,85,88,98],,,,,,,,,
,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,
34,36,37,38,40,41,42,43,45,48,49,52,53,55,57,59,60,62,63,66,72,73,74,80,82,84,90,91],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,41,42,43,44,46,47,48,49,50,51,53,54,60,62,63,66,73],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,34,35,
36,37,38,40,41,42,43,44,46,47,50,51,52,53,56,60,65,68,72,74,75,76,84,87,89,91,92,94],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,30,31,32,34,35,
36,37,38,40,42,45,47,48,50,52,53,54,56,57,63,67,68,69,71,73,74,80,90,95,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,38,39,40,41,42,43,48,53,54,55,56,59,60,61,62,63,71,78,80,83,84,97],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,35,36,
37,38,40,41,42,43,44,47,48,52,53,54,56,58,59,60,63,64,73,77,80,85,87],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,40,41,42,43,44,45,46,47,48,50,53,54,59,60,61,67,69,70,73,75,77,79,80,87,92,100],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,36,
37,38,39,40,41,42,43,44,47,48,52,54,56,58,60,61,62,63,71,72,76,77,80,84,86],,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
35,36,37,38,40,42,44,46,48,52,54,55,56,60,62,63,64,68,70,74,84,88,92,96],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
36,37,38,39,41,42,43,44,45,48,49,50,52,53,57,58,72,73,74,77,78,84,85,89,93,96,97,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,30,31,34,35,36,37,
38,39,40,41,42,43,44,48,51,52,53,54,56,60,67,70,71,72,73,80,82,84,89],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
36,37,38,40,41,42,43,44,46,48,50,52,53,57,59,60,63,64,66,74,76,80,84,92,96],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,33,34,36,
37,38,40,41,42,43,44,45,46,48,54,56,60,62,66,69,72,73,81,82,84,90,92,96],,,,,,,,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
33,34,35,36,37,40,41,42,43,46,48,51,52,53,54,58,60,63,70,71,72,78,84,86,96,99],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,35,
36,37,39,40,42,44,46,48,51,52,56,58,60,63,70,72,80,81,84,97],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,28,29,30,31,33,34,35,36,37,40,42,43,44,45,46,47,48,49,50,52,53,56,59,60,61,70,71,
73,74,80,84,88,89,90,99,100],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,
29,30,31,32,33,34,36,37,40,41,42,43,44,46,47,48,53,56,57,58,60,66,69,71,73,87,97,99],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
29,30,31,32,33,35,36,37,38,41,42,44,46,48,50,52,54,56,64,66,67,75,82,84,88,95,96,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,39,40,41,42,43,44,47,48,50,54,55,59,60,62,66,67,68,69,71,74,76,77,81,82,86,97,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
35,36,37,38,40,41,42,43,46,47,48,49,58,59,60,62,63,64,69,72,96,97],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,36,38,40,42,43,44,46,47,48,50,51,53,56,57,58,60,61,69,80,85,86,89],
,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,
36,37,39,40,41,42,43,44,45,48,52,54,55,56,60,62,64,67,68,73,74,80,83,95,97],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
33,34,35,36,37,40,42,43,44,46,47,48,49,50,58,59,60,61,64,65,67,68,69,70,84,88],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,40,41,42,43,44,46,47,48,50,52,53,54,56,61,62,67,68,72,80,83,84,85,96],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,40,41,42,43,44,45,46,47,48,53,55,56,66,75,81,84,86,100],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
35,36,37,38,40,41,42,43,44,46,47,48,51,53,57,58,59,60,63,66,68,72,73,74,77,92,96],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,33,34,
35,36,38,39,40,42,44,45,46,47,48,49,51,52,54,55,56,60,66,70,78,84,91,94,98],,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,39,40,41,42,43,44,46,47,48,50,52,53,54,55,56,60,64,66,69,71,73,80,81,83],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,34,36,
37,42,45,46,48,53,56,60,66,71,72,79,89,90],,,,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
23,24,26,27,28,29,30,31,32,36,37,38,39,41,42,43,44,47,48,52,54,56,60,64,82,83,84,86,88],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
27,28,29,30,31,32,34,36,38,40,41,42,43,44,45,46,47,48,52,54,69,73,77,84,92,94],,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
35,36,37,38,40,41,42,43,44,47,48,52,54,59,60,61,63,67,69,70,71,75,82,85,86,88,91,99],,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,40,41,42,45,47,50,51,52,54,55,60,63,66,68,72,73,75,90],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,38,40,41,42,44,48,49,51,52,56,57,60,79,91,97,98],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
23,24,26,27,28,29,30,31,32,36,37,38,39,40,41,42,43,44,45,46,47,48,49,52,53,54,64,74,78,80,81,83,84,86,91,92,96,97],
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,35,
36,40,41,42,43,44,46,47,48,50,52,54,55,60,64,70,71,72,73,77,84,94,96,97,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
33,34,36,37,38,40,41,42,43,46,48,53,54,56,57,58,62,63,66,68,72,80,82,84,92,96],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
35,36,37,38,41,42,43,44,46,47,48,50,51,53,54,56,58,59,60,61,62,71,72,82,84,90,96],,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,36,
37,38,40,41,42,45,46,47,48,49,51,52,55,59,60,63,75,76,81,84,85,92,96],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,39,40,41,42,43,44,48,51,53,54,58,60,66,69,71,77,78,79,84,88,89,93,99],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,39,40,42,43,44,45,47,48,49,50,52,55,56,58,60,62,63,68,74,75,80,84,85,90,93,97],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,34,36,37,39,
40,41,42,43,45,46,48,51,56,60,62,63,71,77,78,87,90,96],,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,26,28,29,30,31,32,33,34,36,37,38,41,42,43,44,48,49,51,53,55,57,60,64,65,66,68,69,72,76,77,82,84,91],
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,36,38,
39,40,41,42,43,44,46,47,48,49,52,56,60,61,64,65,66,68,71,72,92,96],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,
33,35,36,37,39,40,42,43,44,45,48,52,54,57,58,60,62,63,65,66,70,77,96],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,39,40,42,43,45,47,48,50,54,56,58,60,61,64,65,66,68,72,79,89,91,99],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
36,37,38,40,41,42,43,44,45,46,47,48,52,57,60,63,72,73,77,90,92],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,26,27,28,29,30,31,32,34,36,37,38,39,40,42,43,44,47,48,49,52,53,56,58,59,60,62,64,68,78,86,89],
,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
35,36,37,41,42,43,45,46,47,48,50,52,53,54,57,63,66,68,70,71,73,87,95,96],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,32,33,34,
36,42,44,45,46,47,48,56,58,60,63,68,72,75,88,96],,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,26,28,29,30,31,34,36,37,38,39,40,41,42,43,45,46,47,49,51,56,57,59,60,61,63,72,74,79,80,82,83,90,97],
,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,34,36,37,
38,39,40,42,43,44,45,46,47,48,49,51,54,56,60,67,74,83,88,96],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,26,27,28,29,30,31,34,36,37,40,42,43,44,47,48,54,56,58,60,62,67,68,81,84,85,94],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,36,37,38,41,42,43,
44,45,50,52,54,57,59,71,72,75,81,84,88,93],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,
28,29,30,31,32,33,34,35,36,37,38,42,43,44,45,46,48,50,52,56,58,60,61,62,67,68,71,72,73,76,77,84,90,91,96,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,35,
36,37,39,40,41,42,45,46,47,49,50,55,60,68,69,70,72,75,78,80,81,84,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,34,35,
36,37,39,41,42,44,46,47,48,50,52,53,56,60,62,64,68,70,82,84,91,95,96],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,30,31,32,33,34,36,
37,38,39,40,41,42,44,45,48,56,60,65,66,71,72,74,80,81],,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,25,26,28,29,30,31,32,35,36,37,40,42,43,46,47,48,50,53,55,60,74,77,84,86],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
27,28,29,30,31,32,34,36,39,40,41,42,44,46,47,48,52,54,56,59,60,62,65,67,68,78,92],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,40,41,42,43,48,52,54,56,58,60,61,63,68,72,75,76,77,80,84,87,95],,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,32,34,35,
36,37,38,39,40,41,42,43,44,47,48,50,52,53,54,56,57,60,65,69,72,74,79,82,97],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,35,
36,37,39,40,41,42,43,44,48,49,50,52,53,54,58,60,67,69,78,81,89],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,36,37,38,39,40,42,43,44,46,47,48,50,51,59,60,64,67,71,75,78],
,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,36,37,39,
40,41,42,46,48,52,54,58,60,66,67,68,69,72,78,80,81,84,91,97],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,
31,32,33,35,36,37,38,39,41,42,43,46,47,48,53,55,57,59,60,64,66,70,72,78,79,92,95,96,97],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,33,34,35,
36,37,39,40,41,42,43,45,46,47,48,56,60,66,70,71,74,77,78,79,80,85,90,92,93,94],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,41,42,43,46,47,48,49,50,52,57,60,67,84,96,97,99],,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,27,28,29,30,31,32,33,35,36,37,38,40,41,42,44,46,50,52,53,54,55,56,60,62,64,66,69,70,83,84,92,100]
,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,
31,33,34,35,36,37,38,40,41,42,43,46,47,48,51,52,54,55,56,60,62,68,73,74,80,84,86,91,95],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,34,36,37,
38,39,42,44,45,46,52,54,55,56,58,59,60,63,67,71,78],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
23,24,26,27,28,29,30,31,32,34,36,37,39,41,42,44,46,48,52,53,59,60,63,69,71,72,73,78,84,89,91,97],,,,,
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,39,40,42,
44,45,46,48,55,56,57,61,62,64,65,66,69,72,78,84,92,93,95],,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
28,29,30,31,33,34,35,36,37,38,39,40,42,44,52,53,56,58,59,60,66,69,70,74,78,91],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
36,38,39,42,43,44,48,49,50,51,52,53,59,60,62,63,64,65,66,71,76,95],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,26,27,28,29,30,31,32,33,35,36,37,38,39,41,42,43,44,45,46,47,48,49,51,52,54,56,59,60,
62,63,66,67,87,88,90,93,97],,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
28,29,30,31,32,34,35,36,37,38,39,40,41,42,43,44,45,48,50,55,57,58,59,68,73,79,83,84,86,87,88,90,91,95],,,,,,,
,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,36,37,38,
41,42,44,45,48,53,54,59,61,63,71,76,79,90],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
24,26,27,28,29,30,31,33,34,35,36,38,40,41,42,44,47,48,51,52,53,54,60,61,63,65,66,68,70,79],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,
30,31,32,34,36,38,39,40,42,43,46,48,49,50,52,53,54,56,57,58,60,72,80,84,87,89],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,36,
38,40,41,42,43,44,46,48,53,54,57,59,61,64,73,80,84,86,87,91,92],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,40,41,42,43,48,50,51,52,53,56,57,58,60,64,65,
66,70,73,82,85,95,96],,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,
30,31,32,33,34,36,37,38,39,40,41,42,44,45,47,48,52,55,60,61,72,76,77,78,79,82,84],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,
28,29,30,31,32,33,34,35,36,37,39,40,41,42,43,44,45,48,50,51,52,60,62,70,74,80,82,88,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,39,40,41,42,43,45,46,47,48,50,52,53,54,57,59,61,62,64,66,67,72,73,74,80,84,93],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,40,41,42,44,45,46,47,48,49,52,56,59,60,64,66,70,72,79,82,88,99],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,40,42,46,47,48,50,51,54,57,60,61,62,66,67,68,69,72,75,77,81,84,91,96],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
35,36,37,38,41,42,43,46,47,48,52,53,54,55,56,60,63,65,69,72,84,86,93,96],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,40,41,42,43,46,47,56,59,60,64,66,69,72,74,75,78,80,82,92],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,40,42,43,44,48,49,50,52,54,56,58,59,63,64,70,71,81,84,91],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,36,
38,39,41,42,43,44,46,47,52,54,56,58,59,69,71,72,73,78,82,84,94],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,35,36,37,38,40,41,42,45,46,47,48,50,54,60,75,76,80,84,90,93,96],
,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,35,36,
37,38,40,41,42,43,45,47,48,49,53,54,56,57,60,62,63,85,93,94,96],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,
33,34,36,37,39,40,42,43,44,46,47,52,54,55,56,58,59,60,64,66,68,74,84,86,97,99],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,33,34,
35,36,37,38,41,42,43,45,46,47,48,53,56,59,60,62,68,69,70,72,76,77,79,84,86,94],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
35,36,37,39,40,42,48,50,56,57,60,62,64,68,70,72,78,84,96],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,25,26,27,28,29,30,31,32,34,36,37,38,41,42,43,44,47,48,53,54,61,67,72,83,84,94,95],,,,,,,,,,,
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,36,37,38,42,44,45,46,47,
48,51,52,55,62,63,65,72,74,76,77,85,88,94],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,35,36,40,42,44,46,48,49,50,53,54,55,56,59,61,64,67,69,70,81,84],,,,,,,,,,,,,
,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,33,
34,36,37,38,39,40,41,42,43,48,52,54,58,59,60,65,66,68,71,73,84,89],,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
35,36,37,40,42,44,46,47,48,51,52,57,58,60,62,68,69,70,72,79,80,84,97],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,39,40,41,42,43,44,46,48,49,54,56,58,59,61,62,63,64,66,68,74,78,88,98,99],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,39,42,43,46,48,50,53,54,56,60,62,63,65,66,67,71,72,78,79,96],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,40,42,44,46,48,52,54,56,57,60,67,72,84],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
23,24,25,26,27,28,29,30,31,32,34,35,36,39,40,42,43,44,46,48,51,52,53,57,58,59,60,64,68,70,72,73,87,97],
,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,35,36,39,40,41,
42,43,45,47,48,50,51,52,56,58,59,60,61,62,64,66,68,89],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,
31,32,34,36,37,40,41,42,45,46,47,48,51,52,59,60,61,62,67,68,72,84,90,96],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,34,36,
37,38,40,41,42,43,44,46,48,52,56,57,60,62,64,66,76,84,86,91,96],,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,34,36,37,
39,41,42,43,44,48,51,52,56,57,58,60,74,78,82,83,84,85,88,89],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,25,26,28,29,30,31,32,34,36,37,38,41,42,43,44,45,46,47,48,50,51,56,58,60,62,63,64,67,68,69,82,84,88,92],
,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
35,36,37,38,39,40,42,46,47,48,52,54,56,58,60,64,68,70,83,96,97],,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
32,33,34,36,37,38,39,40,41,42,43,44,48,50,54,58,60,62,64,72,75,78,82,84,88,89,96],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,42,43,47,49,52,57,59,60,65,66,70,71,73,74,77,84,85],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,34,36,37,
38,39,40,41,42,43,44,45,46,47,48,51,53,56,57,58,59,63,64,72,80,84,90,91],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,37,39,40,42,44,45,47,48,51,52,53,54,62,64,68,71,74,84,85,88,90,94],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
35,36,37,39,40,41,42,43,44,47,48,55,56,59,60,65,68,71,72,77,78,80,84,85],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
36,37,38,40,42,45,46,48,49,54,56,57,58,60,66,75,76,77,80,81,90,99],,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,40,41,42,45,46,48,49,54,57,58,60,61,62,64,78,87,97,99],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,38,39,40,41,42,43,44,45,48,50,51,52,55,56,58,60,
63,72,78,82,83,84,90],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,
32,34,35,36,37,39,40,41,42,43,45,46,48,49,55,59,60,61,70,71,87,97,98],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,
30,31,32,34,35,36,38,40,41,42,44,45,46,48,52,60,80,84,88],,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,48,49,52,53,58,60,62,66,72,74,78,82,87,96],
,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,40,41,42,44,45,46,48,49,52,53,55,56,58,59,60,65,66,67,69,72,74,84,90,92,96],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
35,36,37,38,39,40,41,42,43,44,45,46,47,48,52,58,60,62,72,76,78,90,93],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
35,36,37,38,40,41,42,43,44,45,48,50,51,52,58,59,60,62,64,68,69,70,75,88,90],,,,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,34,
35,36,37,38,40,42,46,47,48,51,54,58,59,60,62,63,67,68,69,70,80,83,84,87,95],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,36,
37,38,40,42,44,52,53,55,60,69,77,84,85,91],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,40,42,46,47,48,52,53,55,57,60,67,72,77,81,83,84,92],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,33,34,36,37,38,40,42,43,45,46,47,50,52,53,60,62,65,66,68,69,72,73,75,81,95],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,40,42,43,48,52,53,57,60,62,64,66,67,68,70,71,74,89,99],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,36,37,40,42,43,44,45,48,50,53,54,57,66,71,73,74,81,84,90,95,96,99,100],
,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
32,33,34,36,39,41,42,43,45,46,47,50,58,60,64,68,72,75,79,82,100],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,36,37,38,41,42,43,44,45,46,47,48,52,53,54,57,60,63,64,67,69,81,82,86],
,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,
33,34,35,36,38,39,40,41,42,43,44,45,49,51,56,58,59,60,62,65,66,68,72,78,80,86,90,99],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,33,34,
35,36,37,39,40,41,42,43,44,46,48,50,52,54,57,59,60,61,62,66,74,87,88,92,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,35,36,37,38,
39,40,42,43,44,45,46,47,48,51,56,58,60,62,63,70,76,95],,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,26,27,28,29,30,31,32,33,34,36,37,38,40,41,42,46,47,48,51,52,56,58,59,60,62,65,66,68,72,80,83,87,89,92,97],
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,36,
37,38,39,40,42,45,46,48,50,51,52,53,55,59,62,64,66,68,75,76,78,87,90,92,96,97],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
34,36,37,40,41,42,43,46,48,50,52,57,58,60,68,72,84,86,95,100],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,26,27,28,29,30,31,32,34,36,38,41,42,43,44,45,48,55,56,57,58,60,63,81,96],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,49,52,54,61,62,65,66,69,70,71,73,80,85,88,91],,,,,,,,,,,,,,,,,,,,,,,,,
,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
32,33,34,35,36,37,38,40,41,42,43,44,47,48,54,55,56,58,60,62,63,66,71,72,81,99],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
35,36,37,38,40,41,42,43,45,46,52,53,55,60,66,68,73,91],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
23,24,25,26,27,28,29,30,31,32,34,35,36,37,39,40,41,42,43,44,46,47,48,50,51,52,54,55,58,60,63,67,72,74,77,84,86,97],
,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
32,33,34,35,36,37,38,39,40,42,43,45,46,47,49,54,58,60,61,65,66,70,73,74,75,78,80,83,84,92,98],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,38,39,40,42,43,44,45,46,48,54,55,56,57,59,60,66,67,68,69,73,81,84,86,87,99],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,36,
37,39,40,42,43,44,45,47,49,54,56,58,60,63,69,83,85,86],,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,25,26,27,28,29,30,31,32,34,36,37,38,40,41,42,44,47,48,51,52,54,58,59,60,68,77,79,81,83,84,96],
,,,,,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,34,36,
37,38,39,40,41,42,46,47,50,55,60,61,65,67,73,77,80,84,93,94,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,
32,33,34,36,37,39,40,42,43,48,49,55,56,60,63,65,66,67,68,72,77,84],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,32,33,34,36,
37,38,42,43,44,45,46,48,50,51,55,56,59,60,64,66,69,73,75,84,85,87,97],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,35,
36,37,38,39,40,42,43,44,45,47,48,51,60,68,69,72,76,77,78,80,88,90,91,93,95,96],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,33,34,35,36,
37,38,40,41,42,43,46,47,48,51,52,56,58,60,61,66,69,70,73,74,76,82,84,93],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
35,36,37,38,39,40,41,42,43,44,45,46,48,53,54,55,57,60,61,65,66,68,69,90,99],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,40,41,42,43,44,46,48,52,53,54,56,60,61,71,78,81,84,85,86,93],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
36,37,42,43,44,47,48,50,51,58,60,61,69,71,72,74,79,85,86,87,100],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,36,39,40,41,42,43,44,45,48,50,55,59,60,63,65,67,71,75,78,79,82,84,88,99],
,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,
33,34,35,36,38,39,40,42,43,47,49,50,51,52,60,65,68,70,77,80,95],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,34,35,
36,37,38,40,41,42,43,45,46,50,51,52,60,74,85,100],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
26,27,28,29,30,31,32,33,35,36,37,38,41,42,45,46,48,49,52,53,54,55,56,60,61,66,70,82,84,99],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,33,34,35,36,37,39,40,41,42,44,46,48,
56,63,68,69,72,77,78,80,85,89,92,93],,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,
18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,36,39,42,44,48,53,54,56,57,70,78,81],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,32,34,35,
36,38,39,40,42,43,48,50,52,54,60,61,68,72,73,84,95],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
23,24,25,26,27,28,29,30,32,33,36,37,38,40,41,42,43,44,45,46,48,49,50,52,54,55,56,57,60,71,72,81,83,84,96],
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,35,36,37,40,42,
43,44,48,50,52,55,57,59,60,62,63,67,70,72,75,86,88,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,
30,31,32,33,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,52,58,59,60,62,70,76,78,84],,,,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
35,36,37,38,40,42,43,44,45,46,48,49,54,60,62,63,72,76,77,79,89],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,27,28,29,30,33,34,36,37,38,40,42,44,45,48,50,51,54,58,61,66,74,75,81],,,,,,,,,,,
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,36,37,40,41,42,43,44,45,
48,50,53,55,56,59,60,63,66,72,75,82,83,84,90,91,93,96],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,34,36,37,39,41,42,43,44,45,46,48,50,55,56,60,67,72,73,79,82,87,90,91],,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,33,34,
36,37,38,40,41,42,43,46,48,50,52,53,54,58,59,60,61,63,66,67,68,72,80,84,86,97,99],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,36,
37,38,40,41,42,43,44,45,47,48,50,53,56,59,61,62,64,66,67,73,84,99],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,40,41,42,43,44,46,48,52,53,54,55,60,61,63,64,65,66,68,70,73,74,76,80,83,86,89,92],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
35,36,37,40,41,42,43,44,45,46,47,48,50,51,52,53,54,58,60,61,64,68,70,71,72,73,74,80,93,94,100],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
35,36,37,38,39,40,41,42,43,51,54,58,59,61,64,66,67,70,72,76,80,84,95],,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
36,37,38,40,42,44,45,48,49,56,60,62,64,65,76,90,96],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
24,25,26,27,28,29,30,31,32,33,34,36,38,40,41,42,43,44,46,48,50,54,55,60,62,63,66,67,69,71,84,87],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,36,37,38,39,41,42,43,44,46,
47,48,49,54,58,60,64,72,84,86,89,94,96],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,26,27,28,29,30,31,32,33,34,36,37,42,43,44,46,48,52,53,54,59,60,62,64,66,68,72,79,85],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
33,34,36,37,38,39,40,42,43,44,47,48,50,52,60,62,63,66,72,75,78,80,91,94,99],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,33,36,37,
40,41,42,44,46,51,53,56,60,66,73,74,79,81,87,91,95],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
23,24,25,26,28,29,30,31,32,34,36,37,41,42,43,44,45,46,47,51,52,53,56,57,58,60,72,82,84,86],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,36,37,38,41,42,43,44,45,48,
52,60,61,66,74,84,88],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
26,27,28,29,30,31,32,33,34,35,36,37,40,41,42,43,48,49,52,54,58,59,60,63,68,70,71,72],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,34,
36,37,38,39,42,44,46,47,49,56,59,60,62,63,67,68,78,79,84],,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,26,27,28,29,30,31,34,36,37,42,43,44,46,47,48,49,52,53,54,55,58,94],,,,,,,,,,,,,,,,
,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,34,35,36,37,38,39,40,41,42,43,46,47,
48,51,52,54,55,59,60,67,70,77,80,84,86],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,25,26,27,28,29,30,31,32,33,34,36,40,42,43,44,45,46,47,48,50,52,54,56,57,60,62,64,66,75,84,90,92,95,96,99,
100],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,
32,33,34,35,36,37,38,39,40,41,42,43,44,46,48,51,53,54,55,56,57,61,68,70,71,72,78,86,89,96,99],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
35,36,37,38,39,40,41,42,43,44,45,46,47,48,51,52,53,54,59,60,61,62,65,72,73,74,76,78,80,81,83,86,88,94],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,35,
36,37,41,42,43,44,45,46,51,53,58,59,60,61,81,82,84,97],,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,25,26,27,28,29,30,31,32,33,34,36,37,38,40,41,42,43,44,46,48,50,51,52,54,55,59,60,61,73,74,
76,81,82,86,89,92],,,,,,,,,,,,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
25,26,27,28,29,30,31,32,35,36,37,40,41,42,44,49,50,51,54,56,60,62,64,67,71,95,98],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,
30,31,32,33,35,36,37,39,40,41,42,45,46,47,48,50,52,54,57,63,71,75,78,80,84,87,90,93,95],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,34,36,
37,38,40,42,48,52,53,55,56,60,62,63,64,67,68,69,74,77,79,84,96],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,28,29,30,31,32,34,35,36,37,38,40,42,44,45,46,48,60,68,76,84],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
28,29,30,31,32,34,36,38,40,42,47,48,52,55,60,64,65,72,73,76,80,87,89,93,96],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,38,39,40,42,48,52,54,56,59,60,61,63,66,71,72,78,93,97],,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,35,36,37,38,39,40,42,46,48,49,50,54,58,60,70,72,73,74,76,84,85,96,98,100]
,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
33,34,35,36,37,38,39,40,42,43,44,47,48,52,54,56,59,60,66,67,69,76,80,83,84,85,89,97],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
36,37,38,39,40,41,42,45,46,55,60,64,68,71,74,75,76,78,82,84,89,90],,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
33,34,35,36,38,40,42,43,44,45,48,49,50,51,52,56,58,59,66,68,75,88,89],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
36,37,41,42,45,50,52,53,56,60,62,65,87,91,95,99],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
24,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,46,47,48,53,54,58,60,64,69,70,72,76,78,86,88,89,91,99],
,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,
33,34,36,37,38,41,42,43,44,47,48,55,58,59,61,66,74,82,84,86],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,40,42,43,44,47,48,51,52,63,66,67,72,73,74,76,78,83,84,88,89,99],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
35,36,37,38,40,41,42,43,44,45,46,47,48,52,54,56,60,61,62,64,70,80,82,86,88,90,92],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,34,36,
38,39,40,41,42,44,45,53,58,61,62,66,68,72,73,77,90,93],,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,28,29,30,31,32,33,34,36,37,38,40,42,44,46,47,48,52,53,56,57,60,61,62,66,73,77,80,83,84,87,88],
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,34,36,37,
40,41,42,43,44,45,46,47,49,52,56,59,60,61,64,67,73,79,80,83,87,88,95],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,34,
35,36,37,38,39,40,41,42,45,46,48,49,58,64,65,84,96],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
23,24,25,26,27,28,29,30,31,32,33,36,39,40,41,42,44,46,47,48,50,52,53,56,59,60,66,72,81,84,94],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,35,36,37,38,39,40,41,42,
43,45,47,48,50,53,54,60,62,63,67,78,80,90,95,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,
29,30,31,32,34,36,37,38,39,40,41,42,43,44,45,46,47,48,52,53,56,57,58,61,63,84,86,88,89,96],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,32,34,35,
36,37,39,40,42,43,44,46,47,48,50,54,56,60,64,65,68,70,74,78,79,84,86],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
35,36,37,39,40,41,42,44,45,46,48,50,52,53,60,66,71,73,74,82,84,85,88,90,91,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,37,38,40,41,42,43,46,47,48,51,54,57,58,59,60,61,64,66,68,69,80,84,93,94],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,36,
40,42,43,48,51,52,53,58,59,62,63,64,77],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
28,29,30,31,33,34,36,40,42,48,50,52,53,60,65,66,97,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
27,28,29,30,31,32,33,34,36,37,38,39,40,41,42,44,47,53,54,55,58,59,60,61,62,72,78,80,82,99],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
36,37,38,42,43,45,47,48,54,62,63,65,72,74],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
27,28,29,30,31,32,33,34,35,36,42,43,44,45,48,52,55,56,57,58,60,62,64,66,83,84,85],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,33,34,36,37,40,41,42,43,45,48,50,54,58,60,61,67,79,80,83,84,100],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,34,35,
36,37,38,40,41,42,43,44,46,48,49,52,53,54,57,58,61,62,63,68,70,76,81,83,84,85],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,40,41,42,43,44,46,48,53,54,57,60,67,73,82,84,85,86],,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
36,37,40,41,42,44,48,50,52,54,56,58,60,63,64,69,77],,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,38,42,44,48,50,53,54,57,58,59,60,62,65,66,67,69,70,72,73,76],
,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,33,34,36,37,
38,40,42,43,44,47,50,53,55,57,61,66,71,72,74,84,89,91],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,
32,36,37,38,39,40,41,42,44,46,47,48,51,52,57,63,71,72,74,76,78,79,84,88,92,94,95],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
35,36,37,38,39,40,42,43,44,48,55,56,58,62,65,66,70,72,78,80,83,86,91],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,32,33,34,
35,36,37,38,39,42,46,47,50,54,55,57,60,61,76,78,85],,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,25,26,28,29,30,31,32,34,36,37,40,41,42,43,44,45,46,47,50,51,52,55,56,62,77,80,84,88,89],
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,33,34,35,36,37,38,39,40,42,
43,44,45,47,50,51,52,54,55,56,58,60,66,69,73,75,84,86,93,99,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,
28,29,30,31,32,34,36,37,40,41,42,43,44,45,53,56,60,62,64,68,72,77,86,90],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
36,37,40,41,42,43,44,46,47,48,49,51,52,54,56,59,60,64,69,71,74,80,82,83,86,87,89,94,95],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,33,34,36,
37,40,41,42,45,46,48,50,51,52,56,60,61,62,67,68,71,84,100],,,,,,,,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
33,34,36,37,38,40,41,42,46,48,50,52,54,55,60,61,62,64,81,84],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,28,29,30,31,32,34,36,38,39,40,42,44,48,50,52,55,57,58,63,68,72,76,96],,,,,,,,,,,
,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,34,35,36,37,38,42,46,48,49,
52,56,58,60,62,63,68,71,74,84,91],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
23,24,25,26,28,29,30,31,32,34,36,37,38,39,40,41,42,43,44,46,48,50,52,53,55,56,58,59,61,64,67,69,74,75,78],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,33,35,
36,37,40,42,43,44,45,49,52,57,60,63,70,72,73,81,84,91,97],,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,28,29,30,31,32,34,35,36,37,38,39,40,42,44,46,47,48,50,51,53,55,68,69,70,74,76,77,93,96,100],
,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,33,34,
35,36,37,40,41,42,45,46,47,48,50,52,53,54,56,59,60,65,70,72,80,84,90],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
36,37,39,40,41,42,43,45,46,47,48,56,58,59,60,62,63,73,77,79,84,86,89,91,95,97],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,36,
37,38,40,41,42,44,45,47,48,51,52,53,54,56,59,60,61,63,64,66,71,73,74,80,81,90,94,96,99],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
35,36,37,38,39,40,41,42,43,44,45,46,47,48,53,54,60,62,63,67,78,80,84,85,86,90,92,96,97],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,40,41,42,43,48,49,50,51,52,56,60,62,72,74,76,80,100],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,37,40,41,42,43,45,58,60,63,64,66,74,83,86,87,89,90,95],,,,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
33,34,36,37,38,40,42,43,44,47,48,49,51,53,54,58,59,60,68,72,75,87,95,97],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,33,34,35,36,38,
40,42,43,44,46,47,49,51,56,57,60,66,72,73,84],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
26,27,28,29,30,31,32,33,34,35,36,37,40,41,42,43,45,46,48,49,51,53,54,55,59,60,61,68,70,72,82,86,93,96],
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,36,37,38,39,40,42,
45,46,48,50,53,58,60,63,66,71,78,81,100],,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,34,35,36,37,38,40,42,44,45,46,48,50,51,53,58,61,62,70,72,77,79,80,84,85,90,96],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,36,
37,38,39,41,42,43,45,47,48,51,52,56,59,60,64,67,72,78,89,90,97],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,26,27,28,29,30,31,32,33,36,37,38,40,41,42,43,46,47,48,51,52,58,60,61,62,63,72,78,91,96],
,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,
36,38,40,41,42,44,45,46,48,49,52,54,55,56,57,58,62,63,90],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,
31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,49,52,58,60,63,64,65,72,79],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
35,36,37,40,41,42,43,44,47,48,49,50,51,55,58,59,62,69,79,80,84,89,93,94],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
35,36,37,40,41,42,44,47,48,49,51,52,54,57,60,64,65,66,68,72,79,80,88,96],,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,34,
36,38,39,41,42,43,44,48,51,52,59,60,62,63,71,78,82,88],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,25,26,28,29,30,31,32,34,36,37,38,39,41,42,43,44,45,46,48,51,52,53,60,61,62,78,92,93,95],,,,,
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,36,38,40,41,42,44,45,
50,52,53,60,63,66,72,79,80,84,91,93,95],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,40,41,42,44,46,50,51,52,53,56,57,59,60,62,80,83,97,99,100],,,,
,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,34,
35,36,38,40,41,42,43,44,46,48,49,50,52,55,58,60,62,66,68,84],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,28,29,30,31,32,34,35,36,37,38,39,40,41,42,43,44,48,49,50,53,55,57,60,72,76,82,88,100],
,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,33,34,35,36,38,39,40,
41,42,45,48,51,52,56,60,66,72,73,76,78,79,80,83,93,97],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,46,47,48,50,53,54,55,57,59,60,61,64,
66,70,72,73,78,79,80,84,86,87,88,95],,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,27,28,29,30,31,32,36,37,38,39,42,43,46,48,50,53,54,56,57,58,60,62,67,73,78,84,89],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
35,36,37,38,39,40,41,42,44,46,47,48,50,54,56,58,60,63,72,74,92],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,28,29,30,31,34,36,37,40,41,42,43,44,45,46,48,49,50,51,52,57,58,59,60,75,83,84,88,90,91,92,93],
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,33,36,37,
38,39,40,41,42,43,45,46,48,52,54,58,60,62,66,72,78,82,93],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,27,28,29,30,31,33,34,35,36,39,41,42,43,44,46,47,48,50,54,56,60,61,62,63,65,66,69,70,71,72,79,88],
,,,,,,,,,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
28,29,30,31,32,33,34,36,37,40,41,42,44,45,48,50,55,56,57,60,62,64,66,67,68,74,77,82,88],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,34,36,
40,42,45,48,49,51,52,60,62,63,65,66,80,84,90,99],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
25,26,27,28,29,30,31,32,33,34,36,37,38,39,40,41,42,43,44,45,48,54,56,60,69,72,78,84,85,93],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
27,28,29,30,31,34,36,38,39,40,41,42,45,52,54,58,59,60,62,76,78,81,90,93,95],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,38,42,43,44,45,46,47,48,56,60,62,66,90,99],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
27,28,29,30,31,32,33,34,35,36,38,39,40,41,42,47,48,53,55,56,58,59,62,64,66,70,71,72,85,89,91],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,34,36,37,38,39,40,42,43,44,45,48,50,57,60,62,63,64,65,69,72,78,84,86,87,93],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,32,33,34,35,
36,38,40,42,44,46,47,48,49,52,53,60,64,66,67,69],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
25,26,27,28,29,30,31,32,33,34,36,37,38,39,40,41,42,43,46,48,56,58,60,66,69,72,73,79,83],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
27,28,29,30,31,32,33,34,36,37,38,39,41,42,44,45,46,48,51,52,58,60,64,68,71,72,78,81,82,83,84,99],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,34,36,
37,38,41,42,43,44,47,48,49,52,54,56,58,59,60,65,68,72,85,95,97],,,,,,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
34,36,38,39,41,42,44,45,46,47,51,53,58,60,63,64,81,84,93],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,26,27,28,29,30,31,32,34,36,37,40,41,42,45,46,49,51,52,53,54,56,58,60,63,65,67,72,73,77,80,85,89,97],
,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,34,36,37,
39,40,42,43,44,45,48,60,64,66,71,74,80,84,85,86],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
23,24,25,26,28,29,30,31,32,33,34,35,36,37,38,40,41,42,44,46,47,48,50,52,58,60,62,63,65,67,70,72,74,92,94,96,100],
,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,34,35,
36,37,38,40,41,42,44,47,54,56,60,63,65,72,75,77,81,82,85],,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,26,27,28,29,30,31,33,36,42,43,44,45,46,48,51,54,55,60,62,63,66,84,87],,,,,,,,,,,,,,,,
,,,,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,35,36,37,
38,40,41,42,43,46,47,48,51,52,53,56,62,67,72,76,81,87,96,99],,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
28,29,30,31,32,34,35,36,38,39,40,42,44,46,48,52,55,57,60,67,68,72,76,91],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,34,36,
37,38,42,43,45,46,48,50,51,55,58,59,60,61,67,72,83,85,87,89],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,26,28,29,30,31,32,33,35,36,37,38,39,40,41,42,46,51,56,58,61,70,74,76],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,38,39,40,41,42,48,52,54,56,57,58,60,62,66,67,68,80,81,93],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
35,36,37,38,39,42,44,48,49,50,54,60,61,67,68,70,72,77,97,100],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,26,27,28,29,30,31,32,34,36,37,38,39,40,41,42,46,51,52,55,56,57,60,69,71,74,77,78,80,84],
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,
42,43,44,45,46,47,48,49,51,53,54,58,60,65,66,68,72,73,77,78,80,84,88,96,99],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,
29,30,31,32,33,34,36,37,39,41,42,43,46,47,48,51,53,57,60,61,62,64,81,84,86,92,93,96],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,34,36,
38,40,41,42,46,48,51,57,58,60,63,64,67,72,77,80,99],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
23,24,25,26,27,28,29,30,31,32,33,34,36,37,38,40,41,42,45,46,47,48,52,56,57,58,59,60,61,62,64,66,72,74,82,84,94],
,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,35,36,
37,38,39,40,42,44,47,48,50,53,56,58,60,73,74,76,79,80],,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,41,42,43,45,46,47,48,49,50,51,54,55,56,59,60,62,
63,70,71,72,87,91],,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
29,30,32,33,36,37,38,40,42,43,48,50,52,53,56,57,60,63,66,72,74,80,84,87,89],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,
30,31,32,33,34,35,36,37,38,39,40,42,43,45,48,57,60,66,68,70,76,77,78,79,84],,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,36,37,
38,39,40,41,42,44,49,51,60,61,65,76,77,79,81,84,89,91],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,25,26,27,28,29,30,31,32,33,34,36,37,41,42,43,44,45,47,50,53,58,59,60,61,63,66,69,71,73,74,84,85,88,90],
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,
36,37,38,41,42,44,45,47,49,50,54,59,60,67,69,72,75,82,100],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,36,37,39,40,41,42,43,44,48,53,54,56,57,64,66,68,69,82,84,88,95,99],
,,,,,,,,,,,,,,,,,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,36,37,42,43,44,46,48,50,53,55,59,64,74,84,86],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
36,37,38,41,42,43,46,48,49,50,51,54,56,58,59,60,66,69,96,98],,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,26,28,29,30,31,32,34,36,37,38,39,41,42,45,47,48,49,51,53,59,60,64,69,82,84,89,90],
,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,36,37,38,40,42,43,
44,45,46,51,52,55,56,60,71,74,77,80,84,86,89,90],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,33,34,35,36,37,38,40,42,44,45,47,48,49,50,53,54,56,58,59,60,62,64,66,70,72,75,80,81,83,99],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
35,36,40,41,42,44,48,49,50,51,54,59,60,62,68,69,70,72,87,100],,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,35,36,37,39,40,41,42,43,44,46,48,49,50,51,52,56,58,60,72,
77,78,87,95,96,98],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,33,
35,36,38,41,42,43,44,46,48,52,53,56,59,60,62,66,70,72,76,83,84,85,87,95],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,36,37,38,42,43,48,64,65,67,69,72,95]
,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
33,34,35,36,37,40,41,42,44,45,46,49,53,55,58,59,60,62,70,80,90,93],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,36,38,
39,41,42,45,48,50,51,56,59,60,62,71,76,84,90,100],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
26,27,28,29,30,31,33,34,35,36,37,38,39,42,43,44,46,48,49,51,54,55,60,61,66,70,71,73,76,86,98],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,28,29,30,31,32,33,34,36,37,38,39,40,41,42,43,44,47,48,49,50,51,52,53,55,56,57,58,60,66,67,74,75,76,80,82,86,94,99],
,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,
34,36,37,39,42,44,45,46,48,51,53,54,57,58,60,62,66,67,69,72,81,87,89,90],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,32,34,36,42,
45,48,50,51,56,60,64,68,69,84],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,
31,33,34,36,37,38,40,41,42,45,46,47,48,50,51,52,53,54,57,58,62,63,66,69,72,74,76,79,80,89],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,35,36,39,40,42,44,46,48,49,53,
54,60,61,64,72,77,84,88,92,95],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
24,25,26,27,28,29,30,31,32,34,35,36,39,42,43,46,54,55,57,59,69,70,86],,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,
34,35,36,37,40,42,43,44,48,54,57,60,64,70,72,74,86,89,95],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,25,26,27,28,29,30,31,32,34,36,37,40,41,42,44,45,47,48,50,54,56,57,59,60,62,65,69,83,84,87,93,95,100],
,,,,,,,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,
31,32,34,35,36,38,39,40,41,42,43,44,46,48,51,52,54,55,56,58,60,62,63,76,82,93],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,34,36,
37,40,42,44,46,48,51,52,55,56,60,62,68,69,72,85,88],,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,25,26,27,28,29,30,31,32,34,36,37,39,40,41,42,44,48,50,52,54,57,60,63,72,80,82,84,87,100],
,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,35,36,37,
38,39,40,41,42,43,48,52,56,57,59,60,68,69,70,71,72,76,78,89,96],,,,,,,,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,34,35,36,38,39,40,41,42,43,45,47,50,57,60,63,70,76,77,78,81,86,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,39,40,41,42,44,45,46,47,48,53,54,58,60,72,78,80,83,84,88],,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,33,34,
35,36,40,41,42,43,44,45,48,51,52,53,54,60,62,68,79,82,84,88,90],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,27,28,29,30,31,33,34,36,37,38,40,41,42,43,44,48,50,54,60,69,71,72,75,76,77,79,80,86,97,100],
,,,,,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,
30,31,32,34,36,37,39,41,42,44,48,49,54,56,60,64,65,68,72,88,97],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,39,40,42,43,46,47,48,57,59,60,62,68,71,72,73,78,79,80,84,92,93,96,99],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,35,
36,37,38,39,40,41,42,43,44,46,47,51,52,54,56,57,60,63,65,68,70,73,74,76,84,86,88,92,94],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,38,39,40,42,43,46,48,52,54,58,60,62,66,68,72,85,92,93],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,40,41,42,43,44,45,48,49,51,52,54,55,56,57,58,64,
66,71,73,79,81,84,88,90],,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,36,37,38,39,40,41,42,44,46,48,51,52,56,60,64,71,75,81,84,85],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,
30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,50,51,52,60,62,79,84,88,93,96],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,34,35,36,
38,39,42,43,44,46,51,56,57,58,59,60,76,78,84],,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
24,25,26,28,30,31,32,33,34,35,36,38,40,42,43,46,47,48,49,52,56,60,62,66,68,71,84,85,86,95],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,34,36,37,39,41,42,47,48,53,54,58,60,68,69,74,78,84,95],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,40,41,42,43,45,46,47,48,54,56,60,62,68,73,91,92],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
36,37,38,40,42,44,47,52,56,59,60,64,72,75,76,77,79,84,85,91],,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,36,37,38,39,40,42,43,44,46,48,55,56,59,60,62,68,76,81,84,96],
,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,36,37,
39,40,41,42,46,48,50,51,52,54,64,69,72,73,74,90,92,97],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,27,28,29,30,31,32,33,35,36,37,40,41,42,43,44,47,50,53,54,59,60,72,74,81,85,88,95,100],,,,
,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,33,34,36,38,39,
40,42,43,46,48,52,56,60,63,66,69,77,79,83,86,89,93,100],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,
30,31,32,33,34,36,37,39,41,42,43,44,46,47,48,50,55,56,60,62,63,64,67,72,78,86,88],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,36,
37,40,41,42,44,45,46,47,48,52,54,58,60,61,65,79,80,88,97],,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,36,37,38,39,40,41,42,43,47,48,51,52,53,54,55,58,60,62,63,
66,67,80,82,84,99],,,,,,,,,,,,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
25,26,27,28,29,30,31,32,33,34,35,36,37,40,41,42,44,48,50,54,56,57,60,68,74,77,79,82,84,96],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,
32,34,36,37,38,40,42,45,47,48,56,62,67,68,71,73,80,84,90,93,96],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,26,27,28,29,30,31,32,34,35,36,37,38,40,42,44,45,46,47,48,49,52,57,59,60,66,68,71,74,80,84,90,92,94],
,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
34,36,37,38,39,41,42,43,44,48,50,53,54,56,59,60,61,63,74,84,87],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,36,37,39,41,42,43,44,48,53,54,56,60,61,62,64,65,68,72,84,93],
,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,33,34,35,36,37,38,39,42,
43,44,45,46,47,48,49,52,53,55,61,66,71,73,76,88,99],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
29,30,31,34,35,36,38,40,41,42,44,48,50,54,56,60,63,69,71,72,82,83,85,100],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,34,35,
36,37,38,39,40,41,42,44,51,53,58,60,70,72,74,76,78,84,88],,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,42,43,44,46,49,50,55,60,72,81,91],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
28,29,30,31,34,36,38,41,42,43,46,48,51,55,58,59,60,69,79,84,85,86,87,91],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,40,42,43,48,49,54,55,57,60,64,81,86,96],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,33,35,36,37,40,41,42,44,46,48,50,52,54,59,60,61,62,64,66,67,72,79,84,85,87],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,28,29,30,31,32,33,34,35,36,37,38,40,41,42,43,44,46,47,48,55,58,59,62,63,64,66,68,72,78,95],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,40,41,42,43,45,46,47,48,49,52,54,56,57,58,62,63,66,74,75,77,80,85,87,93,96],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,35,
36,37,40,42,44,48,51,53,54,55,57,61,66,72,88,93],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
26,27,28,29,30,31,32,33,34,35,36,37,40,41,42,43,44,45,46,48,53,56,57,58,60,66,68,69,70,71,77,84,90,96],
,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,36,39,40,41,
42,46,47,48,49,60,62,66,75,77,80,84,94,95],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,25,26,27,28,29,30,31,32,34,35,36,37,38,39,40,41,42,43,44,45,47,48,50,53,54,56,62,63,64,68,70,72,74,76,77,
82,84,86,96,100],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,34,35,36,37,38,39,40,41,42,43,45,47,50,54,56,57,60,72,84,97],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
35,36,39,40,41,42,46,50,52,54,55,56,60,70,72,79,84,95,97],,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,27,28,29,30,31,33,34,36,37,38,39,40,41,42,44,46,48,50,51,52,56,61,66,72,74,76,78,83,85,88,91,99],
,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,
34,35,36,37,38,39,40,41,42,43,44,48,51,53,56,58,60,62,64,68,69,72,75,84,86],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,34,36,38,39,40,
42,44,45,46,47,48,51,52,58,60,72,80,84,88,90],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
26,27,28,29,30,31,34,36,38,39,40,41,42,44,46,48,54,56,58,59,60,61,67,68,71,88,91],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
28,29,30,31,32,33,34,36,37,40,41,42,45,50,51,53,56,64,66,77,82,91],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
35,36,37,38,40,42,43,44,48,52,57,59,60,70,72,75,80,84,87,88,96],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,26,27,28,29,30,31,34,35,36,37,41,42,44,46,47,48,52,53,54,56,58,60,63,69,71,72,81,84,87,94,95],
,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,36,
37,38,39,40,41,42,44,45,46,47,48,49,52,54,55,56,67,69,82,92,96],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,33,
34,35,36,37,38,40,42,44,47,49,50,55,59,60,61,66,68,72,74,76,84,87,98,99],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,34,36,
37,38,41,42,43,46,48,50,53,55,57,60,62,63,66,86,97],,,,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
33,34,36,37,38,40,41,42,43,44,48,50,53,54,56,57,58,62,66,72,73,77,84,87,91,99],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,34,36,
37,38,39,42,46,51,56,57,60,61,63,65,67,79,85],,,,,,,,,,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,25,26,27,28,29,30,31,32,33,36,37,38,39,40,42,43,47,48,52,55,56,60,64,65,66,69,72,76,80,86],
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,34,36,37,39,40,42,44,45,
46,48,51,54,57,60,61,63,72,74,87],,,,,,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,35,36,37,38,39,40,42,46,48,52,56,58,59,60,62,63,66,68,74,80,84,89,91],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,36,37,
38,39,40,41,42,44,46,47,51,56,58,59,62,64,66,68,73,78,81,84,94,95,99],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
32,34,36,37,39,41,42,43,46,48,55,56,57,58,60,63,64,69,71,74,79,84,92,96],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,34,36,
37,38,39,40,41,42,43,45,46,49,50,51,52,56,60,61,64,72,73,74,77,78,84,86,97],,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
33,34,36,38,41,42,44,48,50,51,52,60,65,66,72,75,77,93],,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,25,26,28,29,30,31,34,35,36,37,38,39,40,41,42,44,47,48,50,52,58,60,61,62,68,70,73,79,80,87,94],
,,,,,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,33,34,36,
37,38,39,40,41,42,43,45,46,52,54,56,58,60,62,66,72,80,84,86,90,95],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,
33,34,36,37,39,41,42,43,47,48,51,52,54,56,57,58,59,68,78,86],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,48,51,52,53,54,55,56,57,58,60,63,
65,67,68,76,78,84,88],,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,
30,31,32,33,35,36,37,40,42,43,46,48,50,52,57,58,60,66,69,72,84,86,87,95],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,
29,30,31,32,33,36,37,38,39,40,42,44,46,48,52,54,55,57,58,60,66,76,77,84],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,38,39,40,42,44,46,48,50,51,52,53,57,58,60,62,63,72,73,84,88,92,93],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,38,39,40,42,43,44,48,49,50,55,56,58,60,61,63,72,86,87,88,98],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
35,36,38,40,41,42,44,45,46,47,48,55,56,57,58,60,70,76,84,85],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,35,36,37,
38,39,40,42,44,45,47,48,49,51,55,56,58,60,61,62,65,70,71,72,76,78,87,96],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,33,34,
35,36,37,39,40,41,42,44,45,46,47,48,50,52,54,67,72,80,81,84,94,100],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
36,38,39,41,42,43,44,45,46,47,48,53,54,55,59,63,64,72,73,78,84],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,35,
36,38,39,40,41,42,43,44,45,46,47,49,51,52,57,59,63,64,65,70,72,78,84,94],,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,33,34,35,36,
37,41,42,48,51,52,56,57,60,65,66,84],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,
30,31,32,33,34,36,39,40,42,44,46,48,51,52,58,59,60,62,64,66,71,72,73,78,84,85,92],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,
28,29,30,31,32,33,35,36,37,39,40,41,42,44,46,48,52,54,56,58,59,60,65,66,69,73,74,80,84,87,88,92,96],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
35,36,37,38,40,41,42,44,45,47,48,50,53,59,60,61,63,65,66,73,79,80,81,82,84,87,97,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,34,35,36,
37,38,39,40,42,44,47,48,53,55,56,57,60,64,67,68,69,72,73,79,80,83,88],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,35,36,
37,38,40,41,42,43,44,47,48,51,53,57,60,63,71,75,77,84],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
23,24,26,28,29,30,31,33,34,36,37,40,41,42,43,46,47,48,51,52,57,59,60,62,63,66,72,74,80,82,86,87,95],,
,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,34,36,38,40,41,42,43,
45,46,48,51,52,58,63,66,69,76,87,90,92],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,26,28,30,31,33,35,36,37,39,40,42,43,45,46,47,48,51,52,55,56,57,60,62,63,65,90,92,93],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,
34,36,37,38,40,42,44,45,48,51,59,60,61,62,72,77],,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
23,24,26,28,29,30,31,32,36,39,41,42,43,46,48,51,52,55,58,60,62,63,78,83,97],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,38,40,42,44,45,46,47,48,51,54,56,58,60,61,73,74,75,77,90,91,95,96,97],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,35,
36,37,38,39,40,41,42,43,48,52,53,54,56,57,59,60,62,63,64,66,70,72,76,78,81,84,95,96],,,,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,36,
40,42,43,44,46,48,54,55,60,61,62,63,65,66,67,70,93,96],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
23,24,25,26,27,28,29,30,31,32,34,36,37,38,40,42,45,46,47,48,50,53,54,55,56,57,62,63,87,90,100],,,,,,,,
,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,36,38,39,40,42,
44,48,51,52,54,55,60,66,78,80,84,99],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
23,24,26,27,28,29,30,31,32,34,35,36,37,40,41,42,43,44,47,48,53,54,55,57,58,65,70,72,88,93,97],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,
34,35,36,37,38,42,43,44,45,46,55,60,62,64,73,78,87,90,91,93],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,25,26,28,29,30,31,32,33,34,35,36,38,40,42,43,44,48,49,55,65,69,70,76,93],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
28,29,30,31,32,33,35,36,37,38,40,41,42,48,51,58,60,62,65,69,72,77,87],,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
35,36,38,40,42,45,46,52,54,59,60,68,72,81,84,87,92,95],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,25,26,28,29,30,31,32,36,38,39,40,41,42,44,46,48,55,60,64,85,93],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
27,28,29,30,31,32,33,34,35,36,37,38,40,42,43,45,46,48,52,54,56,59,60,62,69,71,76,81,87,89],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,36,
37,38,39,40,42,43,44,48,50,53,54,59,60,63,72,80,85,95,96],,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,27,28,29,30,31,32,34,36,37,38,40,42,43,44,46,47,48,50,51,54,60,64,68,84,94,100],
,,,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,34,36,40,42,
46,48,52,55,58,60,62,63,64,65,69,77,80,84],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,25,26,27,28,29,30,31,32,34,36,37,42,44,48,50,52,53,58,60,62,65,69,72,73,85,88,95,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,
31,32,33,34,36,37,40,41,42,43,44,46,48,52,53,54,56,59,60,63,66,68,73,74,75,84,86,91,92,93],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,34,36,37,
39,40,41,42,44,48,51,52,54,60,62,72,74,80,84,88],,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,26,27,28,29,30,31,32,34,36,37,38,39,40,42,43,46,48,53,54,55,60,63,65,68,69,74,78,81,84,86,92,96],
,,,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,33,34,
36,37,40,42,43,45,46,48,49,52,54,56,58,60,66,68,72,75,79,80,84,86,87,92,95,98,99],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,
31,32,33,34,36,37,40,41,42,43,44,46,54,58,60,66,82,84,99],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,26,27,28,29,30,32,34,36,37,38,39,40,41,42,43,47,49,52,53,56,59,60,65,72,86,97,98],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,34,36,37,38,39,41,42,43,45,47,48,
49,51,52,57,61,64,73,76,87,90],,,,,,,,,,,,,,,,,,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,
14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,33,34,36,38,39,40,42,43,46,47,48,49,52,53,58,60,61,66,67,68,78,79,
80,84],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,33,34,
35,36,37,38,39,40,41,42,43,48,51,53,56,57,59,60,63,66,69,72,76,77,80,87],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,32,34,36,
37,38,42,43,44,45,46,50,51,55,59,60,63,71,72,90],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
26,28,29,30,31,32,34,35,36,38,39,40,41,42,45,46,48,53,56,60,61,67,68,71,76,92],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
27,28,29,30,31,33,34,36,37,38,39,40,42,44,46,48,49,58,60,63,68,78,80,97,98],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,34,35,36,
38,39,42,43,45,46,47,49,58,64,70,72,76,77,78,86],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
24,26,27,28,30,31,33,34,35,36,38,40,41,42,47,48,51,52,54,56,60,63,70,72,84,96],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
28,29,30,31,34,35,36,37,40,41,42,45,46,48,49,52,55,56,57,60,61,63,69,72,74,85],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,39,40,42,43,47,48,51,53,54,55,58,59,60,61,76,77,78,80,84],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,33,34,
35,36,37,38,39,40,41,42,46,47,48,56,57,60,68,69,71,76,77,78,79,82,87,91,94,99],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,39,40,42,43,45,46,47,48,50,55,56,59,68,69,85,90,93,96],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
36,37,38,39,40,41,42,44,46,51,52,54,56,58,60,61,64,76,79,84],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,28,29,30,31,32,33,35,36,37,38,39,40,41,42,43,46,48,51,53,55,57,58,61,66,70,72,74,78,99],
,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,36,37,
39,40,42,46,47,48,50,51,52,54,56,58,59,60,61,72,78,84,87],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,32,
33,34,36,37,38,40,41,42,44,51,54,58,60,71,82,84,85],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
23,24,25,26,27,28,29,30,31,32,34,35,36,38,39,40,42,46,47,48,52,54,56,62,64,68,78,79,84,85],,,,,,,,,,
,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,34,36,37,38,39,40,41,42,44,
46,47,50,64,65,72,74,76,77,82,84,91],,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,36,37,40,42,47,48,49,52,53,55,57,58,60,62,65,66,68,73,74,85,96],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,
36,38,39,42,46,50,51,54,56,57,58,60,65,66,69,84,92,95],,,,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,33,
34,36,38,40,42,45,46,51,54,56,60,66,69,71,73],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
25,26,28,29,30,31,32,33,36,38,39,40,42,43,44,47,48,50,51,53,57,58,60,62,72,93,94,96],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
26,27,28,29,30,31,32,34,35,36,37,38,39,42,44,54,63,68,71,73,74,77,78,83,88,91],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,36,
37,38,40,41,42,43,44,45,46,47,48,57,58,60,61,63,69,72,80,84,86,90,93,94],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,40,42,44,46,47,48,49,50,52,54,57,60,61,65,76,77,80,96,100],,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,37,38,39,40,41,42,43,46,47,51,52,53,55,56,58,60,61,63,66,68,71,79,80,81,83,86,93],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,30,31,32,34,35,
36,38,39,40,42,44,48,50,53,54,59,60,62,64,69,70,93,96],,,,,,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,36,37,38,42,44,47,48,49,50,51,52,53,54,56,57,58,60,69,72,75,87,94],
,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,
34,35,36,37,39,40,41,42,46,47,48,51,56,58,64,66,69,78,82,93],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,36,37,38,39,40,41,42,48,49,50,54,55,60,62,68,73,81,84,89,100],
,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
36,37,38,39,40,41,42,48,50,73,78,82,84,95,96],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
23,24,25,26,27,28,29,30,31,32,34,36,38,42,43,44,47,48,52,54,57,58,62,67,73,77,78,81,84,87,94],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,
30,31,33,36,37,38,39,40,42,43,48,52,54,56,57,58,60,62,66,78,80,83,84,99],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,34,35,36,
37,38,42,43,44,47,58,60,61,62,67,71,76,83,85,89,93,94],,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,26,28,29,30,31,34,36,37,38,39,40,42,43,44,47,48,52,53,56,60,61,68,78],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,34,35,36,37,40,42,44,48,53,54,55,58,60,62,70,72],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,38,40,41,42,44,45,46,48,51,54,56,59,60,62,68,69,81,96],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,26,27,28,29,30,31,32,36,39,40,41,42,43,46,48,52,54,55,57,60,62,81,82,89,92,96],,,,
,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,35,36,37,38,40,41,42,43,
52,56,58,59,60,65,72,77,79,86],,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
26,27,28,29,30,31,32,33,34,35,36,38,40,41,42,43,45,48,51,52,56,57,59,60,62,66,67,69,72,73,81,87,96],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,36,
37,40,41,42,44,45,48,56,60,63,65,67],,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
28,30,31,32,33,34,35,36,37,38,42,45,47,48,56,59,62,64,69,70,71,72,77,90,99],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,33,34,35,36,38,39,40,41,42,43,44,45,46,47,48,51,54,55,57,58,59,60,64,71,85,86,90,93,95],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,36,
37,38,39,40,42,43,45,50,51,54,60,62,63,72,74,78,87],,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,26,27,28,29,30,31,32,33,35,36,37,38,41,42,43,44,46,47,49,51,52,56,59,60,62,64,65,66,72,77,79,84,94,98],
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,36,37,
38,39,40,41,42,43,44,48,50,51,52,54,56,57,59,60,61,64,68,69,73,74,79,80],,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,
32,33,34,36,40,42,43,44,45,46,48,52,54,56,60,61,65,69,71,72,80,84,88,90,92],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,33,34,35,
36,38,39,41,42,43,44,46,47,48,50,51,52,56,57,59,60,61,66,82,84,86,88,95],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,32,33,34,36,
37,38,39,40,41,42,45,48,49,50,52,58,60,66,69,72,78,80,84,95,96],,,,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
33,36,37,38,40,41,42,43,45,46,47,48,49,50,52,54,55,58,60,65,66,72,76,79,86,87,89,92,96],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,35,
36,37,38,40,42,43,45,46,48,51,52,53,54,58,60,69,70,71,72,79,80,86,90],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,34,35,
36,38,41,42,43,44,47,49,51,55,57,60,61,62,65,66,67,70,72,98,99],,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,32,34,35,36,
37,39,40,41,42,48,52,54,55,60,61,64,68,71,72,78,83,89],,,,,,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,26,27,28,29,30,31,33,34,36,37,38,40,41,42,43,44,47,48,54,58,59,60,62,63,72,80,87,99],
,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,38,42,
44,47,48,50,52,53,54,56,66,70,72,75,76],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
23,24,26,27,28,29,30,31,32,36,37,39,40,41,42,43,45,48,53,54,55,56,59,60,67,69,73,85,87,97],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,
30,31,32,34,35,36,37,40,41,42,44,46,48,50,51,52,54,57,60,62,65,68,72,74,79,80,84],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,33,34,36,
37,39,40,42,43,44,45,51,52,54,56,57,58,60,62,63,66,77,78,80,84,88],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,35,36,
37,39,40,42,46,48,55,60,72,74,78,80,87,91,92,97],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
25,26,28,29,30,31,32,33,34,36,37,39,41,42,43,45,46,48,53,59,60,62,63,66,69,72,74,86,93],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
27,28,29,30,31,32,34,36,38,40,42,43,45,46,48,55,60,63,68,72,80,81,84,87],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
35,36,37,38,40,41,42,44,47,48,49,51,52,57,60,62,64,72,73,76,91,96,98],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,34,36,
38,40,42,43,44,47,48,60,66,77,83,86,87,89,94,96],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
24,26,27,28,29,30,31,32,34,36,37,39,40,42,43,47,48,52,53,54,56,57,60,74,77,78,85],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
28,29,30,31,32,33,35,36,37,40,42,43,44,48,51,52,53,59,83],,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,26,27,28,29,30,31,32,33,34,35,36,37,38,40,42,43,44,46,48,54,55,60,61,62,66,70,73,74,79,85],
,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,34,35,36,37,40,41,42,
44,45,46,48,51,56,60,61,63,84,85,88,89],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
23,24,25,26,27,28,29,30,31,32,33,36,37,38,41,42,43,47,48,50,51,52,54,55,60,61,65,66,71,72,74,77,83,84,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,
32,34,35,36,37,38,40,41,42,44,45,47,48,54,57,64,68,71,78,82],,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,26,27,28,29,30,31,33,36,37,39,41,42,43,44,45,46,47,48,52,54,59,60,72,78,83,91,92,94,95],
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,36,37,38,39,41,42,
43,44,47,48,49,50,51,55,59,60,62,63,65,67,72,76,77,78,79,89,91,100],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,
29,30,31,32,34,35,36,37,40,42,43,44,45,46,48,55,58,60,61,62,64,68,70,74,88,90,92],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,34,36,
37,40,42,44,46,47,48,52,56,60,62,68,73,87,92],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
25,26,27,28,29,30,31,32,33,34,36,37,38,39,41,42,43,48,49,50,52,58,60,65,67,69,72,73,75,86,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
27,28,29,30,31,32,33,34,36,37,38,39,40,42,44,45,46,48,52,53,54,55,58,60,68,72,95,96],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
35,36,37,40,42,44,45,50,52,53,55,56,60,61,63,66,72,77,89,91,93,97],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,28,29,30,31,32,35,36,37,
38,41,42,43,44,47,49,55,57,58,60,69,71,72,82,84,98],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
23,24,25,26,27,28,29,30,31,32,33,35,36,37,38,39,40,41,42,43,44,48,50,52,54,55,58,60,63,69,70,72,78,79,86,88,96,97,100]
,,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,
30,31,32,35,36,37,41,42,44,45,46,51,54,58,60,61,67,70,72,88,90,93],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,37,39,40,41,42,43,46,48,54,57,72,74,78,80,83,84,86],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,26,27,28,29,30,31,32,33,34,36,37,38,39,40,42,45,46,48,51,54,72,92],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
28,29,30,32,34,36,37,38,39,40,42,43,44,45,52,58,68,70,76,85,90],,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,36,37,38,
40,41,42,43,47,48,49,53,54,57,58,59,60,61,65,71,72,73,80,82,84,86,94],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,34,35,36,
37,38,41,42,43,46,47,48,51,55,56,58,60,70,73,76,82,84,87,92,96],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,34,36,
37,38,40,42,43,46,47,48,51,55,58,59,61,65,69,75,81],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
23,24,25,26,27,28,29,30,31,32,34,36,37,40,42,43,44,45,46,47,48,50,51,53,54,56,58,63,67,68,71,72,74,84,90,95,100],
,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,30,31,33,34,36,37,
38,40,41,42,43,47,54,56,60,63,66,75,79,80,84,86,97],,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,26,27,28,29,30,31,32,33,35,36,37,38,39,40,41,42,45,46,48,49,51,53,54,57,58,59,63,66,67,73,74,84,89,95],
,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,40,42,43,44,45,46,47,48,51,52,54,56,59,60,61,70,72,84,86,92,96,97],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
33,34,36,37,38,41,42,43,45,46,48,50,52,53,59,60,71,72,82,85,86,91,92,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,36,37,
38,40,41,42,43,45,46,48,51,56,59,60,61,62,72,74,77,79,84,87,92],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,28,29,30,31,32,34,35,36,38,40,41,42,52,58,60,68,72,75,79],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
26,28,29,30,31,32,34,35,36,37,38,40,41,42,44,47,51,53,56,59,60,61,67,80,82,84,87],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,33,35,
36,37,41,42,43,44,47,51,52,54,58,59,60,65,66,70,85,88],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,26,27,28,29,30,31,33,34,36,38,40,42,44,46,47,48,54,57,61,71,77,80],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,36,38,40,42,46,47,48,51,54,59,60,62,64,67,73,75,84,85,94,96],,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,33,34,36,
39,40,41,42,44,47,48,51,54,56,57,60,62,83,85,89],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
24,25,26,28,29,30,31,32,33,34,36,37,39,40,41,42,43,44,45,47,48,50,56,57,58,63,64,65,66,72,75,79,88,90,95],
,,,,,,,,,,,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
32,35,36,37,38,40,41,42,43,44,45,46,47,48,60,70,74,75,82,84,88,91,94],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,
32,33,34,35,36,38,39,40,41,42,44,47,50,52,53,56,57,60,61,66,68,75,78,97],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
36,38,39,40,41,42,43,44,45,50,56,60,62,65,69,78,79,88,97],,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,26,28,29,30,31,32,33,34,36,38,39,40,41,42,44,45,46,60,63,71,72,76,88,92],,,,,,,,,,
,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,35,36,37,38,39,40,41,42,
46,47,50,51,54,56,60,64,70,73,74,78,79,80,81,84],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
27,28,29,30,31,32,36,37,38,41,42,54,60,62,67,72,76,77],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,26,27,28,29,30,31,32,34,35,36,37,38,39,40,41,42,43,47,48,54,64,69,74,80,84,96],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,33,34,35,36,39,40,42,44,47,48,51,54,58,60,62,65,67,68,69,72,78,87,95],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,38,40,42,48,50,54,55,59,60,61,62,63,75,80,85,90,96],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,28,29,30,31,33,36,37,38,39,40,42,45,47,48,50,52,53,58,60,72,83,84,100],,,,,,,,,,
,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,32,34,35,36,37,38,40,41,42,44,48,
51,57,60,63,64,67,73,84,89],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
24,26,27,28,29,30,31,33,35,36,41,42,45,54,56,57,58,60,62,66,70,84],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,34,
35,36,37,38,40,41,42,43,44,45,47,49,55,60,71,73,88,90,93,98],,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,26,27,28,29,30,31,32,34,36,37,39,40,41,42,43,44,45,47,48,52,54,58,60,62,77,78,82,83,84,85,89,93],
,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,34,36,
37,38,39,40,42,43,44,46,48,49,56,58,60,64,68,69,72,73,76,78,86,91,98],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,34,36,
37,38,40,42,44,46,48,52,53,60,65,72,77,80,95],,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
23,24,26,27,28,29,30,31,32,34,36,37,38,39,42,44,52,54,58,59,60,62,63,65,68,85],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,32,33,34,35,36,37,38,39,42,44,47,51,54,56,57,60,67,70,72,74,78,79,84,87,89,95],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,36,37,38,
40,41,42,44,47,48,51,52,57,58,59,60,69,72,73,82,87,93],,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,34,36,
38,39,40,41,42,46,47,48,52,60,71,72,73,79,80,82,83,84,85,91,94],,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,34,35,
36,40,42,43,44,48,50,54,55,57,59,60,62,63,65,70,71,72,84],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,26,27,28,29,30,31,32,33,34,35,36,37,38,40,41,42,43,44,46,47,53,54,58,61,62,64,70,77,86,89,92],
,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,36,37,38,39,
40,41,42,45,48,53,54,60,66,68,69,74,76,78,82,83,84],,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,
28,29,30,31,32,34,35,36,38,40,41,42,44,46,49,54,60,72,98],,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,36,38,39,40,42,43,48,50,52,54,60,64,65,68,72,80,81,91,95,96,100],
,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,36,
37,38,40,41,42,44,45,46,48,50,51,52,54,56,59,60,61,71,72,77,90,92,95],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
33,34,36,38,39,42,44,48,50,60,62,63,66,76,79,84,88,99],,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,26,27,28,29,30,31,32,33,34,36,38,41,42,45,46,48,53,54,56,57,61,64,66,97],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,28,29,30,33,34,36,38,40,41,42,44,48,50,51,52,60,63,72,84,95,99],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,26,28,29,30,31,32,34,35,36,37,38,39,40,42,43,46,48,51,52,53,58,74,77,78,84,87],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,33,34,36,37,38,40,41,42,44,47,48,
54,55,56,59,63,66,71,79,84,87],,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,40,41,42,43,44,45,46,47,48,49,58,60,62,63,65,69,70,74,93,94,96],,,,,
,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,
33,36,37,38,39,40,41,42,48,52,53,56,57,58,59,60,69,72,76,79,89,93,97],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,36,
37,38,40,41,42,44,45,46,48,51,53,56,59,60,63,67,69,72,74,80,84],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,27,28,29,30,31,32,36,37,38,41,42,44,45,46,48,50,56,60,72,75,76,89],,,,,,,,,,,
,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,30,31,32,33,34,35,36,37,38,39,40,
42,46,48,56,60,61,62,65,71,74,77,96,99],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,
28,29,30,31,32,34,35,36,38,40,42,43,46,48,49,51,56,57,59,60,69,73,80,81,84,85,92],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,33,34,
35,36,38,40,42,45,46,48,51,55,56,63,66,71,76,80,84],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
23,24,25,26,27,28,29,30,31,32,34,35,36,37,42,44,45,46,47,48,52,54,55,56,58,59,60,64,71,72,73,74,75,84,96],
,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,36,38,39,40,
42,44,45,46,50,52,53,57,60,64,75,77,90],,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,26,27,28,29,30,31,32,33,35,36,37,40,41,42,43,44,45,48,51,53,54,55,56,63,66,67,69,72,80,82,90,93,97,100],
,,,,,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,
30,31,32,33,34,36,37,40,41,42,46,48,50,53,59,60,62,77,83,84],,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,26,28,29,30,31,32,33,34,35,36,38,40,42,44,46,48,53,55,60,67,69,71,76,80,88,96,99],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,35,36,37,38,39,40,41,
42,43,44,46,49,50,54,63,69,75,83,95,97],,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,27,28,29,30,31,32,36,40,42,48,51,52,53,54,56,59,60,61,72,84],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,33,
36,40,41,42,43,45,47,48,54,58,63,66,72,80,82,85,90],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
23,24,26,27,28,29,30,31,32,33,34,35,36,37,39,40,41,42,44,46,47,51,60,66,74,78,82,87,88,97],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
27,28,29,30,31,33,36,37,38,39,40,41,42,43,47,48,49,51,54,58,62,65,66,81,94],,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
36,37,38,40,42,43,46,48,50,54,56,57,59,60,64,74,81,84,85,95],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,28,29,30,31,32,33,34,36,37,39,41,42,43,45,46,47,52,56,57,58,59,60,66,67,71,72,73,74,90,92,99],
,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,34,35,36,
37,40,41,42,43,45,49,51,53,55,59,62,64,82,84,85,93],,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,28,30,31,32,33,34,36,37,38,42,44,47,52,56,60,61,65,68,72,94],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
28,29,30,31,33,34,36,38,40,42,45,46,48,51,55,56,60,66,83,87,97],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,28,29,30,31,32,33,34,36,40,42,47,48,52,59,60,62,64,66,75,80,84,96],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
27,28,29,30,31,32,33,34,36,37,38,40,41,42,43,45,46,48,52,54,56,57,58,59,60,62,66,68,71,77,90,91,93,97,99],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,36,
37,38,39,40,41,42,43,44,45,48,50,53,62,67,68,69,73,80,82,90,96,97,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,37,39,42,43,44,47,48,49,51,52,54,60,63,68,71,72,77,79,84,86,88,96],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,38,40,42,45,46,48,49,51,52,54,55,56,61,62,63,66,76,84,98],,,,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,
34,35,36,37,38,42,43,44,45,46,47,48,52,60,61,62,64,68,71,74,84,86,90],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
35,36,37,38,40,41,42,44,45,48,51,54,60,61,62,64,66,70,72,74,85,87,88,90],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
35,36,37,39,40,42,44,45,46,48,56,62,64,78,84,91,96],,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,25,26,27,28,29,30,31,32,33,34,36,37,38,39,40,41,42,43,45,46,48,49,51,52,54,55,56,59,64,68,71,80,98],
,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,35,
36,37,38,42,43,44,48,50,55,58,60,63,64,69,70,71,73,74,79,83,86],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
32,33,34,35,36,37,38,40,42,43,48,50,54,62,64,72,73,83,84,87,95,100],,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,36,37,
38,39,40,41,42,43,48,50,51,52,56,60,64,72,74,84,87,93,96,97],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,26,28,29,30,31,32,34,36,38,42,45,46,47,48,51,52,55,56,57,60,67,79,83,84],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,36,37,40,42,44,47,48,52,53,60,61,66,74,77,79,84,88,89],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,35,
36,38,40,41,42,46,51,52,55,60,70,76,81,85],,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
24,25,26,27,28,29,30,31,32,33,34,36,37,38,40,41,42,43,44,45,46,47,48,50,52,53,55,56,58,60,66,72,83,86,91,92,93,99],
,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,37,39,40,42,43,44,45,46,49,52,54,55,58,65,66,78,83,84,85,88,92],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,33,34,36,38,40,41,42,48,52,56,60,76,84]
,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
32,33,34,35,36,37,38,39,40,41,42,44,46,48,50,62,72,76,78,84,88,92],,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,
34,36,40,41,42,44,46,48,49,50,51,52,53,56,60,65,73,75,84,87],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,34,36,
40,41,42,43,46,48,57,62,66,73,85],,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,
28,29,30,31,32,33,34,36,37,40,42,43,44,48,52,54,56,57,62,66,74,84,91,99],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
27,28,29,30,31,32,33,36,37,38,40,41,42,48,52,54,56,65,66,76,97],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,41,42,43,44,47,48,52,54,58,59,60,61,63,66,70,72,77,81,91,93],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,34,36,
37,38,39,40,42,43,44,45,46,48,51,52,54,57,60,64,66,67,74,84,86,87,88,90,99],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,34,36,
37,38,39,42,43,46,52,53,54,58,68,69,78,79,86,87,92,97],,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,
34,35,36,38,41,42,45,47,48,49,50,51,53,56,58,59,60,64,68,72,82,83,93,98,99],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,36,38,
40,42,48,49,51,53,54,60,62,64,76,80,96],,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
27,28,29,30,31,32,35,36,37,38,40,41,42,44,48,52,54,57,59,60,70,84,85],,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
26,27,28,29,30,32,34,36,37,38,40,41,42,48,51,53,54,55,57,59,60,64,73,81,87,96],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
35,36,37,38,40,41,42,43,44,45,48,49,50,52,53,56,57,60,64,67,68,70,73,74,80,89],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,32,33,34,
35,36,38,40,42,44,46,48,50,54,58,60,72,76,95,96],,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,26,27,28,29,30,31,36,37,38,40,41,42,43,45,46,47,48,52,53,57,60,62,72,84,86,92,94,95],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
27,28,29,30,31,32,36,37,38,40,41,42,43,45,46,47,48,54,60,65,69,71,84],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,33,34,35,
36,37,38,40,42,43,44,46,50,52,53,55,56,58,60,66,73],,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,26,28,29,30,31,32,34,36,38,39,41,42,43,44,45,46,49,51,52,53,56,59,60,71,78,86],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,34,36,37,40,41,42,43,44,45,46,47,48,50,52,54,63,64,68,79,86,88,93],,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,34,36,38,39,
40,41,42,45,46,48,49,52,53,63,68,72,78,82,92,93],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
24,26,27,28,29,30,31,32,33,36,37,38,40,41,42,43,48,51,52,53,57,63,65,66,72,76,84,93,97,100],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,38,42,43,45,47,48,50,51,54,58,60,62,65,71,72,83,84,85,86],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,32,33,34,35,
36,37,38,39,40,41,42,44,45,46,48,51,56,59,60,69,70,75,76,84,96,97],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,33,34,36,
38,40,41,42,46,48,50,52,56,58,59,60,61,66,71,75],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
24,25,26,27,28,29,30,31,32,34,36,37,38,39,40,41,42,43,45,47,50,60,61,67,72,73,74,94],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
27,28,29,30,32,33,36,40,41,42,44,47,48,51,54,64,66,72,84,85,95],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,34,36,
42,43,48,50,51,56,61,73,93,97,100],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,
30,31,32,34,36,37,38,40,42,43,45,46,48,51,52,54,60,61,72,87,89],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,28,29,30,31,32,34,35,36,37,42,44,48,49,50,53,57,59,62,67,68,70,72,93,100],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,32,34,36,
38,42,43,44,45,46,47,48,50,55,57,58,60,64,71,75,76,87,88,92],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,26,28,29,30,31,32,33,34,36,40,41,42,46,47,48,51,52,58,60,64,68,71,72,77,84,89,93,96],,
,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,30,31,32,34,36,37,40,42,43,46,48,50,
51,53,54,55,56,59,60,67,71,72,74,85,86,91,96],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,32,33,34,36,40,41,42,43,44,48,55,60,63,72,75,84,88],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,36,38,40,41,42,44,46,47,51,52,54,58,59,60,64,69,76,80,81,99],
,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,33,34,36,
37,38,39,40,41,42,43,45,47,48,52,54,60,63,69,72,74,84,86,87,94,95,97],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,
32,34,35,36,37,38,39,42,43,46,48,52,54,55,64,68,72,78,79,84,86,96],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,39,40,41,42,44,46,48,51,52,55,56,59,60,63,66,70,71,72,78,84],,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,35,36,
37,38,40,41,42,43,45,48,51,54,55,56,60,69,70,71,76,80,84,86],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,27,28,29,30,31,33,34,35,36,37,38,39,40,41,42,43,48,50,54,55,58,62,63,66,73,75,77,81,87,91,93],
,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,
32,33,34,35,36,38,39,41,42,43,44,45,48,49,50,52,56,60,62,63,66,68,71,76,78,79,81,83,86,87,88,90,96],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,33,34,
35,36,38,39,40,41,42,44,45,50,54,57,58,63,68,70,72,80,81,82,84,88,90],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,36,
41,42,43,44,45,46,48,49,52,54,57,59,60,61,62,68,77,81,84,96],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,26,27,28,29,30,31,32,33,34,36,37,38,40,42,45,48,54,59,60,61,85,90],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,
28,29,30,31,32,33,34,35,36,38,40,41,42,45,46,48,60,62,65,66,67,70,80,83,84,87,90,96],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,30,31,32,33,34,
36,38,40,42,44,46,47,48,50,53,56,64,76,77,81,93,96],,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,26,27,28,29,30,31,32,34,35,36,39,40,41,42,45,46,47,48,51,54,60,65,68,78,82,85,89],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
27,28,29,30,31,32,34,36,38,40,42,43,44,47,48,54,58,60,61,67,69,72,88,94,96],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,
36,37,38,41,42,43,45,48,50,52,54,56,58,60,61,62,65,67,69,74,76,87,90,91],,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
33,34,35,36,38,40,41,42,43,48,49,50,57,58,60,66,70,71,75,85,87,96,98],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
35,36,37,38,39,41,42,44,45,46,47,54,56,57,60,63,66,70,82],,,,,,,,,,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,35,
36,37,39,40,42,43,44,45,46,48,52,53,64,77,78,87,90,96],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,25,26,28,29,30,31,32,33,34,36,37,38,40,42,44,45,46,47,48,50,51,52,57,58,60,64,66,67,69,73,89,92],
,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,33,34,36,38,39,41,
42,43,44,46,47,48,50,51,53,55,60,62,66,68,72,82,83,93,97],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,
30,31,32,33,34,36,37,39,40,42,45,46,47,48,52,53,54,59,60,63,65,66,73,74,85,87,91,94,95],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,33,34,
36,37,39,42,43,45,46,48,50,51,54,55,57,60,65,66,67,71,72,73,74,78,87,90,91],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,37,38,40,42,44,45,46,47,51,52,55,56,57,60,62,76,85,94],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,25,26,27,28,29,30,31,33,34,35,36,37,40,41,42,44,45,48,49,53,54,60,62,66,68,70,72,74,75,88,95],
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,36,37,40,41,42,43,
46,47,48,51,52,55,57,60,61,64,67,77,82,89,96,97],,,,,,,,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,
29,30,31,32,34,35,36,37,38,39,40,41,42,44,46,48,52,53,55,67,78,80],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,26,27,28,29,30,31,32,34,35,36,37,39,40,42,45,47,49,51,52,57,60,64,65,74,85,90],,,,,
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,
41,42,43,44,48,56,59,60,62,66,68,71,75,78,88,93,96],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,
28,29,30,31,32,33,36,37,39,41,42,45,48,52,54,58,59,61,64,66,69,83,84,93,96,99],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
36,40,41,42,43,45,46,50,56,57,59,60,62,64,66,86,91,99],,,,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,39,40,41,42,44,46,48,50,51,54,55,56,58,62,66,
67,78,80,82,83,84,89],,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,
30,32,33,34,35,36,37,38,40,41,42,45,46,48,60,66,74,77,80,84,90],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,
30,31,32,33,34,36,37,38,39,40,42,46,47,49,51,52,54,59,60,62,64,74,78,99],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,33,34,36,39,
40,42,44,45,47,58,60,66,67,80,85,99],,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,
29,30,31,32,33,34,35,36,37,38,41,42,43,45,46,48,51,52,53,58,59,60,64,66,74,82,84,87,90,96],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
28,29,30,31,32,36,38,41,42,44,45,46,48,49,53,56,57,58,60,76,92,96,98],,,,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,33,34,
36,37,39,42,43,44,45,46,49,50,52,53,56,58,63,72,78,90,99],,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,28,30,31,32,33,34,36,39,42,43,50,56,57,61,63,72,78,85,86,89],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,36,40,41,42,45,46,47,48,50,54,55,56,58,72,75,81,82,84,93,96],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,
36,37,38,39,40,41,42,43,44,47,48,52,53,54,56,58,59,60,63,64,66,69,72,74,76,78,80,82,86,88,93],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,30,31,33,36,37,38,
39,40,41,42,44,45,47,51,56,60,62,63,65,78,80,82,84,88,99],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,25,26,28,29,30,32,36,40,48,50,51,58,60,64,65,72,97],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
26,27,28,29,30,31,32,36,37,41,42,43,44,45,49,52,55,58,60,65,81,84,87],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,35,
36,37,38,39,40,42,44,45,48,49,51,52,53,54,58,59,60,61,73,78,84,96],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,34,35,
36,37,40,41,42,43,44,46,48,59,62,69,74,82,84,88,97],,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,25,26,27,28,29,30,31,32,33,34,36,38,40,42,43,47,50,51,54,58,60,65,66,75,83,84,89,100],,,,
,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,36,37,38,40,41,42,
43,44,45,46,47,48,53,59,60,61,62,63,64,67,72,79,80,88,89,97],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,
30,31,32,34,36,37,38,39,40,42,44,45,47,48,56,60,62,67,68,71,89,91,94,97],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
35,36,37,39,40,42,43,44,45,46,48,60,69,70,78,80,89,92],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,25,26,27,28,30,31,32,34,36,38,39,40,41,42,44,48,50,54,60,68,78,89,100],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,35,36,37,40,42,44,45,46,48,50,51,52,54,58,60,62,64,66,68,72,73,80,84,87,88,90,92,96],,,,,,,,,
,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,33,34,35,
36,37,38,39,40,41,42,44,46,47,48,59,60,66,68,69,72,76,80,82,88],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,25,26,27,28,29,30,31,33,35,36,37,38,39,40,41,42,43,45,46,48,50,51,52,54,60,62,70,82,87,90,97],
,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,
34,35,36,38,40,42,45,47,50,52,55,58,60,62,90,94,100],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
23,24,26,28,29,30,31,32,33,34,36,37,38,40,41,42,44,45,46,47,48,53,56,60,61,62,63,66,69,71,72,82,90],,,,
,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,36,37,38,
41,42,45,47,48,52,56,57,60,68,69,73,76,90,94,97,99],,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,32,34,36,37,39,40,41,42,45,46,48,51,54,56,57,60,64,67,74,82,90,96],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,32,33,34,36,
39,40,42,48,52,53,57,58,60,65,75,78,79,84,87],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,34,36,40,42,44,47,48,50,51,52,53,58,60,64,66,67,75,80,84,85,100],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
27,28,29,30,31,32,33,34,36,37,38,40,41,42,43,44,46,54,60,64,66,67,68,73,76,79,80,81,83],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,33,34,35,
36,37,38,42,48,57,59,64,68,96],,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,
30,31,32,33,36,37,38,42,43,44,45,46,48,49,52,60,62,66,72,74,84,87,97],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
27,28,29,30,31,32,33,34,36,40,42,43,44,45,48,49,52,54,60,79,80,85,86,89,99],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,33,36,39,40,42,
44,46,47,48,53,56,60,72,84,85],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,
31,32,36,37,39,40,42,44,47,48,52,55,59,72,78,88,93,94,97],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
27,28,29,30,31,36,37,38,40,41,42,44,48,51,52,60,63,72,76,79,80,85,97],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,35,36,40,41,42,44,48,54,60,64,72,96,99],,,,,,,,,,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,25,26,28,29,30,31,34,36,38,40,42,43,44,46,47,48,50,52,60,61,67,80,84,88],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,32,35,36,38,40,42,43,44,46,48,58,60,76,89,92,96],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,30,31,32,33,34,36,
40,42,44,47,48,52,55,57,59,60,65,72,80,89],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,33,34,36,37,39,40,41,42,44,45,47,48,52,54,60,65,66,73,74,75,78,84,99],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
27,28,30,31,32,34,36,37,38,40,42,44,45,48,49,54,60,62,71,72,84,88],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,33,34,
36,37,40,41,42,43,45,46,47,50,56,58,60,61,62,65,66,68,77,94],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,28,29,30,31,32,33,34,35,36,39,40,42,46,47,50,57,60,61,64,72,78,100],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,
28,29,30,31,32,33,36,37,39,40,42,43,44,48,52,56,58,60,80,84,89,96],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,
35,36,37,38,39,40,41,42,43,45,46,47,48,51,53,55,61,63,68,74,83,84,90,91,96],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,33,35,36,
37,38,40,41,42,44,45,48,50,52,53,54,58,60,67,71,80,81,100],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,26,27,28,29,30,31,32,34,36,37,38,40,42,44,46,49,52,54,57,60,64,65,68,72,74,81],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,
26,27,28,29,30,31,32,33,36,37,38,41,42,44,46,47,48,58,60,66,72,84,94],,,,,,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,39,40,42,44,45,48,53,54,56,58,60,69,90,96],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
24,25,26,28,29,30,31,34,36,37,40,41,43,44,45,48,50,51,53,57,59,60,65,67,68,83,84,88,90,91],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
27,28,29,30,31,33,34,35,36,38,40,42,45,46,47,48,49,54,56,58,60,61,62,63,65,66,70,90,92,94],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,34,36,37,
38,39,40,41,42,43,44,46,48,54,57,60,62,63,72,74,78,79,82,84,86,92],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,32,34,36,
37,38,42,44,48,51,52,53,54,55,56,60,68,81,96],,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
23,24,25,26,28,29,30,31,32,33,34,35,36,37,39,40,42,43,44,46,47,48,50,51,52,55,56,60,61,66,69,70,72,78,79,80],
,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,35,36,37,38,40,
42,44,45,48,53,58,59,65,76,80,81,84,87,88,90],,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,26,28,29,30,31,32,33,34,36,37,40,42,44,46,48,53,57,58,60,61,63,65,68,74,80,84,91,92],,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,34,36,38,39,41,42,43,
45,48,50,52,59,60,64,68,69,72,83,87],,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,25,26,28,29,30,31,32,33,34,36,37,38,40,41,42,43,44,45,47,48,49,50,57,60,62,63,66,68,71,74,83,85,90,94,96],
,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
35,36,39,40,42,43,45,46,48,49,50,51,52,53,54,60,64,65,66,72,78,84,86,90,95],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,30,31,33,34,36,
37,40,41,42,43,44,46,48,50,52,57,60,62,66,69,80,82,92],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,
22,23,24,25,26,27,28,29,30,31,34,36,38,40,41,42,44,45,46,47,50,52,53,55,56,62,71,76,80,85],,,,,,,,,,
,,,,,,,,,,,,,,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,32,33,36,
41,42,48,49,50,52,54,58,60,64,66,67,81],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
28,29,30,31,32,35,36,37,40,42,44,45,46,48,55,56,58,63,65,67,70,72,73,74,79,84,88,90,91,92,93,96],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,34,36,38,
40,42,43,45,48,68,69,80,90,93,96],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,30,31,
33,34,36,37,40,41,42,44,46,51,52,57,60,61,72,77,80],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,27,
28,29,30,31,33,34,36,38,39,40,42,43,46,48,51,54,55,56,84,97],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,26,28,29,30,31,32,33,36,37,38,39,40,41,42,43,45,46,48,57,65,69,76,78],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,
28,29,30,31,32,35,36,37,38,39,40,41,42,44,45,46,48,52,54,55,56,59,61,67,70,71,72,74,76,84,88,89,95,96],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,34,36,37,39,
40,42,43,48,51,53,56,60,67,69,72,78,83],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,
28,29,30,31,33,34,36,37,38,39,40,42,43,44,48,49,57,58,60,62,63,65,72,80,84,98],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
25,26,27,28,29,30,31,32,35,36,37,38,40,41,42,48,53,54,70,76,80,84,85,89,96],,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,
34,36,37,39,40,42,45,48,51,57,59,60,65,66,68,72,78,84,89,90,97],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,36,38,40,41,42,44,47,48,54,55,56,59,60,61,66,67,71,84,94,96],
,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,36,37,
39,40,41,42,43,46,47,48,51,52,53,54,58,60,61,67,68,69,72,75,81,84,85,87,92,96],,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,
31,32,33,34,36,37,39,42,44,48,50,52,56,68,74],,,,,,,,,,,,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,25,26,27,28,29,30,31,32,34,36,38,40,41,42,43,48,51,52,53,54,58,60,62,64,68,69,75,76,81,89],
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,33,34,35,36,40,41,42,45,
47,48,50,61,63,68,72,73,80,84,87,91],,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,
20,21,22,23,24,26,28,29,30,31,33,35,36,37,39,40,42,45,46,47,48,53,55,57,60,70,71,72,78,79,87],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,32,34,36,
37,39,40,42,45,56,59,60,64,68,69,77,80,90],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
27,28,29,30,31,32,34,36,38,40,42,43,45,46,48,54,60,62,65,66,68,76,84,96,97],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,
28,29,30,32,33,34,36,37,38,40,41,42,43,44,45,46,51,58,59,60,66,68,82,85,90,92,95],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,34,35,
36,37,39,40,41,42,43,50,65,68,70,72,78,86],,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,
29,30,31,32,33,34,35,36,37,38,39,40,42,43,44,46,47,52,53,55,56,60,67,68,72,73,78,80,86,89],,,,,,,,,,,
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,35,36,37,38,39,40,42,45,
46,48,50,52,53,58,60,64,66,67,69,71,72,79,80,92,93,95,96],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,27,
28,29,30,31,32,34,36,38,40,42,43,46,47,49,51,58,64,68,76,79,84,85,91,92],,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,33,35,36,
37,40,41,42,47,48,54,57,58,61,62,63,66,70,84],,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,
23,24,25,26,28,29,30,31,32,33,34,35,36,37,38,39,40,42,44,45,47,48,55,57,58,59,60,66,68,72,73,96],,,,
,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,33,34,36,37,38,44,47,48,51,54,
58,60,66,68,71,74],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,
28,30,31,32,34,36,37,40,42,46,47,54,59,62,64,71,81,85],,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,
19,20,21,22,23,24,26,27,28,29,30,31,32,33,34,35,36,37,38,40,42,46,48,49,53,60,62,69,72,77,80,84,96,99],,,
,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,33,34,35,36,40,42,43,44,
47,52,54,58,60,61,63,66,84,85,87],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
24,25,26,27,28,29,30,31,32,33,34,36,37,38,42,43,44,46,48,50,52,53,54,60,62,66,71,72,83,86,87,92,95,96,97],,,,,,,,,,
,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,34,35,
36,38,39,41,42,43,45,46,47,48,50,53,54,56,57,59,60,61,62,65,67,70,81,82,84,94,96],,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,
33,34,35,36,39,40,41,42,43,44,47,48,51,53,54,56,59,61,66,67,70,73,75,78,79,86],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,29,30,31,32,34,36,
37,42,43,51,52,58,61,64,65,77,86],,,,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,
29,30,31,33,34,36,37,38,39,40,41,42,44,45,46,47,52,56,57,59,60,61,63,66,67,72,88,90,97],,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,36,38,42,43,44,45,59,61,66,
67,77,86,89,93],,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,
29,30,31,32,33,34,36,40,41,42,45,46,48,50,52,53,57,58,60,62,64,92,97,99,100],,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,30,31,32,34,36,39,
40,41,42,43,44,46,48,51,60,68,83,96],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,28,
29,30,31,32,33,34,35,36,37,38,41,42,44,46,47,48,49,50,52,53,56,60,68,69,72,73,76,84,92,97,100],,,,,,,,
,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,34,36,40,41,42,43,48,49,52,
58,61,72,77,80,83,86,87,89,91],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,
24,26,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,46,47,48,59,60,61,62,66,67,72,74,76,78,92],,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,28,29,30,31,32,35,
36,37,40,42,46,48,49,51,52,60,63,67,74,84],,,,,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,
25,26,27,28,29,30,32,33,34,35,36,37,40,41,42,44,46,48,50,51,52,54,56,60,68,72,77,80,88,89,95,97,100],,
,,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,26,27,28,29,30,31,33,34,36,40,41,42,45,46,
48,51,56,60,62,65,66,77,81,84,85,91,97],,,,,,,,,,,,,,,,,,
[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,
27,28,29,30,31,36,37,38,40,42,46,52,53,54,56,60,72,73,76],,,,,,[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,
21,22,23,24,25,26,27,28,29,30,31,32,35,36,37,38,41,42,43,44,46,50,54,56,60,70,74,81]];
