/****************************************************************************
**
*A  pq_functions.h              ANUPQ source                   Eamonn O'Brien
**
*Y  Copyright 1995-2001,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
*Y  Copyright 1995-2001,  School of Mathematical Sciences, ANU,     Australia
**
*/

/* prototypes for functions used in the p-Quotient Program */

#ifndef ANUPQ_FUNCTIONS_H
#define ANUPQ_FUNCTIONS_H

#include "pq_defs.h"
#include "pcp_vars.h"
#include "pga_vars.h"
#include "exp_vars.h"

char **allocate_char_matrix(int n, int m, int start, Logical zero);
char *allocate_char_vector(int n, int start, Logical zero);
char* find_permutation(int *b, char *c, struct pga_vars *pga);
char* GetString(char *string);
FILE *OpenFile(const char *file_name, const char *mode);
FILE *OpenFileInput(const char *file_name);
FILE *OpenFileOutput(const char *file_name);
FILE *OpenSystemFile(const char *file_name, const char *mode);
FILE *TemporaryFile(void);
int ***allocate_array(int n, int m, int r, Logical zero);
int ***invert_automorphisms(int ***auts, struct pga_vars *pga, struct pcp_vars *pcp);
int ***read_stabiliser_gens(int nmr_of_generators, int ***soluble_generators, struct pga_vars *pga, struct pcp_vars *pcp);
int ***reallocate_array(int ***a, int orig_n, int orig_m, int orig_r, int n, int m, int r, Logical zero);
int ***restore_group(Logical rewind_flag, FILE *input_file, int group_number, struct pga_vars *pga, struct pcp_vars *pcp);
int **allocate_matrix(int n, int m, int start, Logical zero);
int **commutator_matrix(struct pga_vars *pga, struct pcp_vars *pcp);
int **find_allowable_subgroup(int option, FILE *cover_tmp_file, FILE *group_tmp_file, int *bit_string, int **subset, struct pga_vars *pga, struct pcp_vars *pcp);
int *allocate_vector(int n, int start, Logical zero);
int *bitstring_to_subset(int K, struct pga_vars *pga);
int *compact_description(Logical write_to_file, struct pcp_vars *pcp);
int *reallocate_vector(int *a, int original, int new, int start, Logical zero);
int available_positions(int *K, struct pga_vars *pga);
int choose(int r, int s);
int close_subgroup(int k, int ***auts, struct pga_vars *pga, struct pcp_vars *pcp);
int construct(int call_depth, struct pga_vars *flag, int option, FILE *output_file, FILE *start_file, int k, int order_bound, int group_nmr, struct pga_vars *pga, struct pcp_vars *pcp);
int echelon(struct pcp_vars *pcp);
int echelonise_matrix(int **a, int nmr_rows, int nmr_columns, int p, int *subset, struct pga_vars *pga);
int find_definition(int generator, int pointer, int weight, struct pcp_vars *pcp);
int find_image(int label, int **auts, struct pga_vars *pga, struct pcp_vars *pcp);
int get_description(char *string, int *len, int **seq, struct pcp_vars *pcp);
int int_power(int x, int n);
int invert_modp(int x, int p);
int layer(int generator, struct pcp_vars *pcp);
int outside(int x, int y);
int pquotient(int max_class, int output, FILE *file, int format, struct pcp_vars *pcp);
int preimage(int perm, struct pga_vars *pga);
int pretty_filter(FILE *file, int *max_class, int *output, struct pcp_vars *pcp);
int queue_space(int **queue, int **long_queue, int *current_qlength, int *prev_qlength, struct pcp_vars *pcp);
int read_option(int maxoption);
int reduced_covers(FILE *descendant_file, FILE *covers_file, int k, int ***auts, struct pga_vars *pga, struct pcp_vars *pcp);
int restore_auts(FILE *ifp, int offset, int nmr_saved, int retain, int *new_index, int *head, int *list);
int runTime(void);
int string_to_int(char *s, Logical *error);
int subgroup_to_label(int **S, int K, int *subset, struct pga_vars *pga);
int valid(int option, int maxoption);
int vector_to_word(int cp, int ptr, struct pcp_vars *pcp);
int vsystem(char *string);
int* find_orbit_reps(int *a, int *b, struct pga_vars *pga);
int** label_to_subgroup(int *Index, int **subset, int label, struct pga_vars *pga);
int** multiply_matrix(int **a, int n, int m, int **b, int q, int p);
int** permute_subgroups(FILE *LINK_input, int **a, int **b, char **c, int ***auts, struct pga_vars *pga, struct pcp_vars *pcp);
int** transpose(int **a, int n, int m);
int*** central_automorphisms(struct pga_vars *pga, struct pcp_vars *pcp);
int*** determine_action(int format, int *nmr_of_auts, struct pcp_vars *pcp);
int*** immediate_descendant(FILE *descendant_file, struct pga_vars *pga, struct pcp_vars *pcp);
int*** read_auts(int option, int *nmr_of_auts, int *nmr_of_exponents, struct pcp_vars *pcp);
int*** restore_pga(FILE *ifp, struct pga_vars *pga, struct pcp_vars *pcp);
int*** stabiliser_of_rep(int **perms, int rep, int orbit_length, int *a, int *b, char *c, char *d, int ***auts, struct pga_vars *pga, struct pcp_vars *pcp);
Logical is_genlim_exceeded(struct pcp_vars *pcp);
Logical is_identity(int **a, int n, int start);
Logical is_space_exhausted(int required, struct pcp_vars *pcp);
Logical valid_matrix(int **a, int n, int p, int start);
void add_to_list(int *subset, struct pga_vars *pga);
void Allocate_WorkSpace(int work_space, struct pcp_vars *pcp);
void assemble_matrix(int **A, int t, int **auts, struct pcp_vars *pcp);
void autgp_order(struct pga_vars *pga, struct pcp_vars *pcp);
void bubble_sort(int *x, int len, struct pcp_vars *pcp);
void calculate_commutator(int format, struct pcp_vars *pcp);
void calculate_jacobi(struct pcp_vars *pcp);
void calculate_power(int exp, int ptr, int cp, struct pcp_vars *pcp);
void calculate_tails(int final_class, struct pcp_vars *pcp);
void check_input(int output, int *max_class, struct pcp_vars *pcp);
void class1_eliminate(struct pcp_vars *pcp);
void close_queue(Logical report, int list_length, int limit, int *head, int *list, int *queue, int queue_length, struct pcp_vars *pcp);
void close_relations(Logical report, int limit, int queue_type, int *head, int *list, int *queue, int length, int *long_queue, int *long_queue_length, struct pcp_vars *pcp);
void CloseFile(FILE* file);
void collect_def_comm(int ptr, int cp, struct pcp_vars *pcp);
void collect_defining_generator(int ptr, int cp, struct pcp_vars *pcp);
void collect_gen_word(int ptr, int length, int cp, struct pcp_vars *pcp);
void Collect_Image_Of_Gen(int cp, int head, int *list, struct pcp_vars *pcp);
void collect_image_of_generator(int cp, int *auts, struct pcp_vars *pcp);
void Collect_Image_Of_Str(int string, int cp, int offset, int *head, int *list, struct pcp_vars *pcp);
void collect_image_of_string(int string, int cp, int **auts, struct pcp_vars *pcp);
void collect_relations(struct pcp_vars *pcp);
void collect_word(int ptr, int cp, struct pcp_vars *pcp);
void collect(int pointer, int collected_part, struct pcp_vars *pcp);
void collectp2(int pointer, int collected_part, struct pcp_vars *pcp);
void commute_defining_generators(int format, struct pcp_vars *pcp);
void compact(struct pcp_vars *pcp);
void complete_echelon(Logical trivial, int redgen, struct pcp_vars *pcp);
void compute_degree(struct pga_vars *pga);
void compute_images(int **A, int K, int depth, int *permutation, struct pga_vars *pga);
void compute_orbits(int **a, int **b, char **c, int **perms, struct pga_vars *pga);
void compute_padic(int *powers, int x, int k, int p, int *expand);
void compute_permutation(int *permutation, int **A, struct pga_vars *pga);
void consistency_info(int *consistency_flag);
void consistency(int type, int *queue, int *queue_length, int wc, struct pcp_vars *pcp);
void copy_flags(struct pga_vars *flag, struct pga_vars *pga);
void Copy_Matrix(int **A, int **B, int nmr_of_rows, int nmr_of_bytes);
void copy(int old, int length, int new, struct pcp_vars *pcp);
void create_tail(int address, int f, int s, struct pcp_vars *pcp);
void CreateGAPLibraryFile(void);
void CreateName(char *name, int call_depth, struct pcp_vars *pcp);
void defaults_pga(int option, int *k, struct pga_vars *flag, struct pga_vars *pga, struct pcp_vars *pcp);
void delete_tables(int type, struct pcp_vars *pcp);
void down_class(int ptr, struct pcp_vars *pcp);
void eliminate(Logical middle_of_tails, struct pcp_vars *pcp);
void enforce_exponent(Logical report, struct exp_vars *exp_flag, int **head, int **list, struct pcp_vars *pcp);
void enforce_laws(struct pga_vars *flag, struct pga_vars *pga, struct pcp_vars *pcp);
void evaluate_formula(int *queue, int *queue_length, struct pcp_vars *pcp);
void evaluate_image(int *head, int *list, int offset, int ptr, int cp, struct pcp_vars *pcp);
void expand_commutator(int *s, int t);
void exponent_info(struct exp_vars *exp_flag, struct pcp_vars *pcp);
void Extend_Aut(int start, int max_length, int *list_length, int *head, int **list, int offset, int *index, struct pcp_vars *pcp);
void extend_automorphisms(int ***auts, int nmr_of_auts, struct pcp_vars *pcp);
void Extend_Auts(int **head, int **list, int start, struct pcp_vars *pcp);
void Extend_Comm(int cp1, int cp2, int u, int v, int offset, int *head, int *list, struct pcp_vars *pcp);
void extend_commutator(int cp1, int cp2, int u, int v, int **auts, struct pcp_vars *pcp);
void Extend_Pow(int cp1, int cp2, int u, int offset, int *head, int *list, struct pcp_vars *pcp);
void extend_power(int cp1, int cp2, int u, int **auts, struct pcp_vars *pcp);
void extend_tail(int address, int f, int s, struct pcp_vars *pcp);
void factor_subgroup(struct pcp_vars *pcp);
void factorise_subgroup(int **S, int index, int *subset, struct pga_vars *pga, struct pcp_vars *pcp);
void find_available_positions(int K, int **A, int **Image, int **row, int **column, int depth, struct pga_vars *pga);
void find_commutator(int cp1, int cp2, int cp3, int cp4, int result, struct pcp_vars *pcp);
void find_padic(int x, int k, int p, int *expand, struct pga_vars *pga);
void free_array(int ***a, int n, int m, int start);
void free_char_matrix(char **a, int n);
void free_char_vector(char *a, int start);
void free_matrix(int **a, int n, int start);
void free_space(Logical soluble_computation, int **perms, int *orbit_length, int *a, int *b, char *c, struct pga_vars *pga);
void free_vector(int *a, int start);
void GAP_auts(FILE *file, int ***central, int ***stabiliser, struct pga_vars *pga, struct pcp_vars *pcp);
void GAP_factorise_subgroup(FILE *GAP_input, int **S, int index, int *subset, struct pga_vars *pga, struct pcp_vars *pcp);
void GAP_presentation(FILE *file, struct pcp_vars *pcp, int aspcgroup);
void get_definition_sets(struct pga_vars *pga);
void handle_error(Logical group_present);
void image_of_generator(int generator, int pointer, int ***auts, struct pga_vars *pga, struct pcp_vars *pcp);
void image_to_word(int string, int *image, struct pcp_vars *pcp);
void initialise_exponent(struct exp_vars *exp_flag, struct pcp_vars *pcp);
void initialise_pcp(int output, struct pcp_vars *pcp);
void initialise_pga(struct pga_vars *pga, struct pcp_vars *pcp);
void insoluble_compute_orbits(int **orbit, int **backptr, char **schreier, int **perms, struct pga_vars *pga);
void insoluble_stab_gens(int rep, int orbit_length, struct pga_vars *pga, struct pcp_vars *pcp);
void interactive_pga(Logical group_present, FILE *StartFile, int group_nmr, int ***auts, struct pga_vars *pga, struct pcp_vars *pcp);
void interactive_pq(Logical group_present, int format, int output_level, int **head, int **list, struct pcp_vars *pcp);
void intermediate_stage(FILE *descendant_file, FILE *input_file, int nmr_of_covers, struct pga_vars *pga, struct pcp_vars *pcp);
void invalid_group(struct pcp_vars *pcp);
void invert_generator(int gen, int exp, int cp, struct pcp_vars *pcp);
void invert_string(int str, int cp, struct pcp_vars *pcp);
void invert_word(int ptr, int cp, struct pcp_vars *pcp);
void is_timelimit_exceeded(struct pga_vars *pga, struct pcp_vars *pcp);
void isom_options(int format, struct pcp_vars *pcp);
void iteration_information(int *subgroup_rank, struct pga_vars *flag, int *class_bound, int *order_bound, int **step_sequence, struct pga_vars *pga, struct pcp_vars *pcp);
void iteration(int call_depth, int *step_sequence, int subgroup_rank, struct pga_vars *flag, FILE *input_file, int nmr_of_descendants, int class_bound, int order_bound, struct pga_vars *pga, struct pcp_vars *pcp);
void jacobi(int c, int b, int a, int ptr, struct pcp_vars *pcp);
void last_class(struct pcp_vars *pcp);
void List_Auts(int *head, int *list, int first, int last, struct pcp_vars *pcp);
void list_commutators(int *queue, int *queue_length, struct pcp_vars *pcp);
void list_interactive_pga_menu(void);
void list_interactive_pq_menu(void);
void list_pga_menu(void);
void list_pqa_menu(void);
void map_relations(int **map, struct pga_vars *pga, struct pcp_vars *pcp);
void next_class(Logical report, int **head, int **list, struct pcp_vars *pcp);
void options(int call, int format, struct pcp_vars *pcp);
void orbit_option(int option, int **perms, int **a, int **b, char **c, int **orbit_length, struct pga_vars *pga);
void orbit_summary(int *length, struct pga_vars *pga);
void orbits(int *permutation, int *a, int *b, char *c, struct pga_vars *pga);
void output_information(int *sequence, int nmr_of_exponents, struct pcp_vars *pcp);
void permute_elements(void);
void pgroup_generation(Logical *group_present, struct pcp_vars *pcp);
void power(int exp, int cp, struct pcp_vars *pcp);
void pretty_read_generators(struct pcp_vars *pcp);
void pretty_read_relations(int output, int *max_class, struct pcp_vars *pcp);
void pretty_read_word(FILE *file, int disp, int type, struct pcp_vars *pcp);
void print_array(int *a, int first, int last);
void print_auts(int nmr_auts, int nmr_gens, int ***auts, struct pcp_vars *pcp);
void print_chars(char *a, int first, int last);
void print_group_details(struct pga_vars *pga, struct pcp_vars *pcp);
void print_level(int *output, struct pcp_vars *pcp);
void print_map(struct pcp_vars *pcp);
void print_matrix(int **a, int n, int m);
void print_message(int work_space);
void print_orbit_information(int *a, int *b, char *c, struct pga_vars *pga);
void print_pcp_relations(struct pcp_vars *pcp);
void print_presentation(Logical full, struct pcp_vars *pcp);
void print_structure(int first, int last, struct pcp_vars *pcp);
void print_word(int ptr, struct pcp_vars *pcp);
void process_identity_perm(int *a, int *b, char *c, struct pga_vars *pga);
void process_rep(int **perms, int *a, int *b, char *c, char *d, int ***auts, int rep, int orbit_length, FILE *tmp_file, FILE *descendant_file, FILE *covers_file, struct pga_vars *pga, struct pcp_vars *pcp);
void query_aut_group_information(struct pga_vars *pga);
void query_degree_aut_information(struct pga_vars *pga);
void query_exponent_law(struct pga_vars *pga);
void query_group_information(int p, struct pga_vars *pga);
void query_metabelian_law(struct pga_vars *pga);
void query_orbit_information(struct pga_vars *pga);
void query_perm_information(struct pga_vars *pga);
void query_solubility(struct pga_vars *pga);
void query_space_efficiency(struct pga_vars *pga);
void query_terminal(struct pga_vars *pga);
void read_class_bound(int *class_bound, struct pcp_vars *pcp);
void read_gen_name_array(FILE *file);
void read_line(void);
void read_matrix(int **a, int n, int m);
void read_order_bound(int *order_bound, struct pcp_vars *pcp);
void read_parameters(int format, int *max_class, int *output, struct pcp_vars *pcp);
void read_relations(struct pcp_vars *pcp);
void read_relator_file(int *queue, int *queue_length, struct pcp_vars *pcp);
void read_step_size(struct pga_vars *pga, struct pcp_vars *pcp);
void read_subgroup_rank(int *k);
void read_value(Logical newline, char *string, int *value, int lower_bound);
void read_word(FILE *file, int disp, int type, struct pcp_vars *pcp);
void reduce_matrix(int **a, int nmr_rows, int nmr_columns, int p, struct pga_vars *pga);
void report_autgp_order(struct pga_vars *pga, struct pcp_vars *pcp);
void report_error(int a, int b, int c);
void report(int nmr_of_capables, int nmr_of_descendants, int nmr_of_covers, struct pga_vars *pga, struct pcp_vars *pcp);
void restore_automorphisms(FILE *ifp, int **head, int **list, struct pcp_vars *pcp);
void restore_pcp(FILE *ifp, struct pcp_vars *pcp);
void save_auts(FILE *ofp, int *head, int *list, struct pcp_vars *pcp);
void save_pcp(FILE *ofp, struct pcp_vars *pcp);
void save_pga(FILE *ofp, int ***central, int ***stabiliser, struct pga_vars *pga, struct pcp_vars *pcp);
void set_defaults(struct pga_vars *flag);
void set_maxoccur(struct pcp_vars *pcp);
void set_values(struct pga_vars *pga, struct pcp_vars *pcp);
void Setup_Action(int **head, int **list, int ***auts, int nmr_of_exponents, struct pcp_vars *pcp);
void setup_defgen_word_to_collect(FILE *file, int format, int type, int cp, struct pcp_vars *pcp);
void setup_echelon(int *queue, int *queue_length, int cp, struct pcp_vars *pcp);
void setup_identity_perm(int *permutation, struct pga_vars *pga);
void setup_reps(int *reps, int nmr_of_reps, int *orbit_length, int **perms, int *a, int *b, char *c, int ***auts, FILE *descendant_file, FILE *covers_file, struct pga_vars *pga, struct pcp_vars *pcp);
void setup_symbols(struct pcp_vars *pcp);
void setup_to_solve_equation(int format, struct pcp_vars *pcp);
void setup_word_to_collect(FILE *file, int format, int type, int cp, struct pcp_vars *pcp);
void setup_word_to_print(char *type, int cp, int str, struct pcp_vars *pcp);
void setup(struct pcp_vars *pcp);
void solve_equation(int cp1, int cp2, int result, struct pcp_vars *pcp);
void space_for_orbits(int **a, int **b, char **c, struct pga_vars *pga);
void stabiliser_generators(int **perms, int rep, int *a, int *b, char *c, char *d, int ***auts, struct pga_vars *pga, struct pcp_vars *pcp);
void stabiliser_option(int option, int ***auts, int **perms, int *a, int *b, char *c, int *orbit_length, struct pga_vars *pga, struct pcp_vars *pcp);
void stack_overflow(void);
void start_GAP_file( FILE **GAP_input, int ***auts, struct pga_vars *pga, struct pcp_vars *pcp );
void start_group(FILE **StartFile, int ***auts, struct pga_vars *pga, struct pcp_vars *pcp);
void start_stage(FILE *descendant_file, int k, int ***auts, struct pga_vars *pga, struct pcp_vars *pcp);
void step_range(int k, int *lower_step, int *upper_step, int ***auts, struct pga_vars *pga, struct pcp_vars *pcp);
void store_definition_sets(int r, int lower_step, int upper_step, struct pga_vars *pga);
void string_to_vector(int str, int cp, struct pcp_vars *pcp);
void strip_identities(int ***auts, struct pga_vars *pga, struct pcp_vars *pcp);
void tail_info(int *tail_type);
void tails(int type, int work_class, int start_weight, int end_weight, struct pcp_vars *pcp);
void text(int message, int arg1, int arg2, int arg3, int arg4);
void trace_action(int *permutation, int j, int *a, int *b, char *c);
void trace_relation(int *sequence, int *index, int ptr, int generator, struct pcp_vars *pcp);
void traverse_list(int exponent, int head, int *list, int cp, struct pcp_vars *pcp);
void update_autgp_order(int orbit_length, struct pga_vars *pga, struct pcp_vars *pcp);
void update_generators(struct pcp_vars *pcp);
void update_image(int **A, int column, int **Image, int row, struct pga_vars *pga);
void update_name(char *string, int x, int step_size);
void update(int ptr, struct pcp_vars *pcp);
void vector_to_string(int cp, int str, struct pcp_vars *pcp);
void verify_read(int nmr_items, int required);
void visit(int k, int d, struct pga_vars *pga);
void write_GAP_library(FILE *file, struct pcp_vars *pcp);
void write_GAP_matrix(FILE *GAP_input, char *gen, int **A, int size, int start, int nr);

#if defined(GROUP)
void collect(int pointer, int collected_part, struct pcp_vars *pcp);
void extra_relations(struct exp_vars *exp_flag, struct pcp_vars *pcp);
#endif

/* standard.c */
#if defined(GROUP) && defined(STANDARD_PCP)
void standard_presentation(Logical *identity_map, int standard_output, int ***auts, struct pga_vars *pga, struct pcp_vars *pcp);
void print_aut_description(int ***central, int ***stabiliser, struct pga_vars *pga, struct pcp_vars *pcp);
int ***read_auts_from_file(FILE *file, int *nmr_of_auts, struct pcp_vars *pcp);
#endif

#endif
