/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.DoubleClickTimer;
import org.freeplane.core.ui.IMouseListener;
import org.freeplane.core.ui.components.AutoHide;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.FoldingController;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.MouseArea;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.ui.NodePopupMenuDisplayer;
import org.freeplane.view.swing.ui.NodeSelector;

public class DefaultNodeMouseMotionListener
implements IMouseListener {
    protected final NodeSelector nodeSelector;
    private static final String FOLD_ON_CLICK_INSIDE = "fold_on_click_inside";
    static final String OPEN_LINKS_ON_PLAIN_CLICKS = "openLinksOnPlainClicks";
    protected final DoubleClickTimer doubleClickTimer = new DoubleClickTimer();
    private boolean popupMenuIsShown;

    public DefaultNodeMouseMotionListener() {
        this.nodeSelector = new NodeSelector();
    }

    protected boolean isInFoldingRegion(MouseEvent e) {
        return ((MainView)e.getComponent()).isInFoldingRegion(e.getPoint());
    }

    protected boolean isInDragRegion(MouseEvent e) {
        return ((MainView)e.getComponent()).isInDragRegion(e.getPoint());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.popupMenuIsShown) {
            return;
        }
        MainView component = (MainView)e.getComponent();
        NodeView nodeView = component.getNodeView();
        if (nodeView == null) {
            return;
        }
        final NodeModel node = nodeView.getNode();
        ModeController mc = Controller.getCurrentController().getModeController();
        final MapController mapController = mc.getMapController();
        if (e.getButton() == 1 && Compat.isPlainEvent(e) && this.isInFoldingRegion(e)) {
            this.doubleClickTimer.cancel();
            mapController.toggleFoldedAndScroll(node);
            return;
        }
        boolean inside = this.nodeSelector.isInside(e);
        if (e.getButton() == 1) {
            if (Compat.isCtrlEvent(e) || Compat.isPlainEvent(e) && ResourceController.getResourceController().getBooleanProperty(OPEN_LINKS_ON_PLAIN_CLICKS)) {
                IconController iconController;
                NamedIcon uiIcon = component.getUIIconAt(e.getPoint());
                if (uiIcon != null && (iconController = mc.getExtension(IconController.class)).onIconClicked(node, uiIcon)) {
                    return;
                }
                if (component.isClickableLink(e.getX())) {
                    LinkController.getController(mc).loadURL(node, e);
                    e.consume();
                    return;
                }
                final String link = component.getLink(e.getPoint());
                if (link != null) {
                    this.doubleClickTimer.start(new Runnable(){

                        @Override
                        public void run() {
                            DefaultNodeMouseMotionListener.this.loadLink(node, link);
                        }
                    });
                    e.consume();
                    return;
                }
            } else if (Compat.isShiftEvent(e)) {
                if (component.isClickableLink(e.getX())) {
                    mapController.forceViewChange(() -> LinkController.getController(mc).loadURL(node, e));
                    e.consume();
                    return;
                }
                final String link = component.getLink(e.getPoint());
                if (link != null) {
                    this.doubleClickTimer.start(new Runnable(){

                        @Override
                        public void run() {
                            mapController.forceViewChange(() -> DefaultNodeMouseMotionListener.this.loadLink(node, link));
                        }
                    });
                    e.consume();
                    return;
                }
            }
            if (Compat.isPlainEvent(e)) {
                if (inside && (e.getClickCount() == 1 && this.foldsOnClickInside() || !mc.canEdit(node.getMap()) || !this.editsOnDoubleClick()) && !this.nodeSelector.shouldSelectOnClick(e)) {
                    this.doubleClickTimer.start(new Runnable(){

                        @Override
                        public void run() {
                            mapController.toggleFoldedAndScroll(node);
                        }
                    });
                }
            } else if (Compat.isShiftEvent(e) && this.isInFoldingRegion(e)) {
                if (!mapController.showNextChild(node)) {
                    mapController.fold(node);
                }
                e.consume();
            }
        }
        if (inside && Compat.isCtrlShiftEvent(e) && !this.nodeSelector.shouldSelectOnClick(e)) {
            this.doubleClickTimer.cancel();
            mapController.toggleFoldedAndScroll(node);
            e.consume();
            return;
        }
        if (inside && e.getButton() == 1 && !e.isAltDown()) {
            this.nodeSelector.extendSelection(e);
        }
    }

    private boolean foldsOnClickInside() {
        return ResourceController.getResourceController().getBooleanProperty(FOLD_ON_CLICK_INSIDE);
    }

    protected boolean editsOnDoubleClick() {
        return false;
    }

    private void loadLink(NodeModel node, String link) {
        try {
            LinkController.getController().loadURI(node, LinkController.createHyperlink(link));
        }
        catch (Exception ex) {
            LogUtils.warn(ex);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.nodeSelector.isInside(e)) {
            return;
        }
        this.nodeSelector.stopTimerForDelayedSelection();
        this.nodeSelector.extendSelection(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.nodeSelector.isRelevant(e)) {
            this.nodeSelector.createTimer(e);
            this.mouseMoved(e);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.nodeSelector.stopTimerForDelayedSelection();
        MainView v = (MainView)e.getSource();
        v.setMouseArea(MouseArea.OUT);
        this.nodeSelector.trackWindowForComponent(v);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Cursor requiredCursor;
        if (!this.nodeSelector.isRelevant(e)) {
            return;
        }
        MainView node = (MainView)e.getComponent();
        String link = node.getLink(e.getPoint());
        boolean followLink = link != null;
        Controller currentController = Controller.getCurrentController();
        if (!followLink && (followLink = node.isClickableLink(e.getX()))) {
            link = LinkController.getController(currentController.getModeController()).getLinkShortText(node.getNodeView().getNode());
        }
        if (followLink) {
            currentController.getViewController().out(link);
            requiredCursor = Cursor.getPredefinedCursor(12);
            node.setMouseArea(MouseArea.LINK);
        } else if (this.isInFoldingRegion(e)) {
            requiredCursor = Cursor.getPredefinedCursor(0);
            node.setMouseArea(MouseArea.FOLDING);
        } else {
            requiredCursor = Cursor.getPredefinedCursor(0);
            node.setMouseArea(MouseArea.DEFAULT);
        }
        if (node.getCursor().getType() != requiredCursor.getType() || requiredCursor.getType() == -1 && node.getCursor() != requiredCursor) {
            node.setCursor(requiredCursor);
        }
        this.nodeSelector.createTimer(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        MapView mapView = MapView.getMapView(e.getComponent());
        mapView.select();
        this.doubleClickTimer.cancel();
        this.popupMenuIsShown = false;
        if (e.isPopupTrigger()) {
            this.showPopupMenu(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.nodeSelector.stopTimerForDelayedSelection();
        if (e.isPopupTrigger()) {
            this.showPopupMenu(e);
        }
    }

    private void showPopupMenu(MouseEvent e) {
        boolean inFoldingRegion;
        this.popupMenuIsShown = true;
        boolean inside = this.nodeSelector.isInside(e);
        boolean bl = inFoldingRegion = !inside && this.isInFoldingRegion(e);
        if (inside || inFoldingRegion) {
            if (inside) {
                this.nodeSelector.stopTimerForDelayedSelection();
                new NodePopupMenuDisplayer().showNodePopupMenu(e);
            } else if (inFoldingRegion) {
                this.showFoldingPopup(e);
            }
        }
    }

    private void showFoldingPopup(MouseEvent e) {
        ModeController mc = Controller.getCurrentController().getModeController();
        FoldingController foldingController = mc.getExtension(FoldingController.class);
        if (foldingController == null) {
            return;
        }
        NodeView nodeView = this.nodeSelector.getRelatedNodeView(e);
        JPopupMenu popupmenu = foldingController.createFoldingPopupMenu(nodeView.getNode());
        AutoHide.start(popupmenu);
        new NodePopupMenuDisplayer().showMenuAndConsumeEvent(popupmenu, e);
    }
}

