/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.filepreview;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.imageio.ImageIO;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.view.swing.features.filepreview.ExternalResource;
import org.freeplane.view.swing.features.filepreview.ImageObserverCallback;
import org.freeplane.view.swing.features.filepreview.ViewerController;

public class ImageAdder {
    private final Image image;
    private MMapController mapController;
    private File mindmapFile;
    private File imageFile;
    public static final String IMAGE_FORMAT = "png";

    public ImageAdder(Image image, MMapController mapController, File mindmapFile, File imageFile) {
        this.image = image;
        this.mapController = mapController;
        this.mindmapFile = mindmapFile;
        this.imageFile = imageFile;
    }

    public void attachImageToNode(final NodeModel node) {
        final ImageObserverCallback imageObserver = new ImageObserverCallback();
        int imageWidth = this.image.getWidth(imageObserver);
        int imageHeight = this.image.getHeight(imageObserver);
        if (imageWidth != -1 && imageHeight != -1) {
            this.attachImageToNode(node, imageObserver, imageWidth, imageHeight);
        } else {
            imageObserver.onSizeAvailable(new Runnable(){

                @Override
                public void run() {
                    ImageAdder.this.attachImageToNode(node, imageObserver, imageObserver.getImageWidth(), imageObserver.getImageHeight());
                }
            });
        }
    }

    private void attachImageToNode(final NodeModel node, ImageObserverCallback imageObserver, int imageWidth, int imageHeight) {
        final BufferedImage fixedImg = new BufferedImage(imageWidth, imageHeight, 2);
        final Graphics2D fig = fixedImg.createGraphics();
        if (fig.drawImage(this.image, 0, 0, imageObserver)) {
            this.attachImageToNode(node, fixedImg, fig);
        } else {
            imageObserver.onImageRendered(new Runnable(){

                @Override
                public void run() {
                    ImageAdder.this.attachImageToNode(node, fixedImg, fig);
                }
            });
        }
    }

    private void attachImageToNode(NodeModel node, BufferedImage fixedImg, Graphics2D fig) {
        fig.dispose();
        fixedImg.flush();
        try {
            ImageIO.write((RenderedImage)fixedImg, IMAGE_FORMAT, this.imageFile);
            URI uri = LinkController.toLinkTypeDependantURI(this.mindmapFile, this.imageFile);
            ExternalResource extension = new ExternalResource(uri);
            this.mapController.getModeController().getExtension(ViewerController.class).add(node, extension);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

