/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.headlessmode;

import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.IUserInputListenerFactory;
import org.freeplane.features.attribute.AttributeController;
import org.freeplane.features.attribute.mindmapmode.MAttributeController;
import org.freeplane.features.clipboard.ClipboardControllers;
import org.freeplane.features.clipboard.mindmapmode.MClipboardControllers;
import org.freeplane.features.cloud.CloudController;
import org.freeplane.features.cloud.mindmapmode.MCloudController;
import org.freeplane.features.edge.AutomaticEdgeColorHook;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.edge.mindmapmode.MEdgeController;
import org.freeplane.features.encrypt.mindmapmode.MEncryptionController;
import org.freeplane.features.explorer.mindmapmode.MMapExplorerController;
import org.freeplane.features.export.mindmapmode.ExportController;
import org.freeplane.features.export.mindmapmode.ImportMindmanagerFiles;
import org.freeplane.features.icon.hierarchicalicons.HierarchicalIcons;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.layout.LayoutController;
import org.freeplane.features.layout.mindmapmode.MLayoutController;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.AlwaysUnfoldedNode;
import org.freeplane.features.map.FoldingController;
import org.freeplane.features.map.FreeNode;
import org.freeplane.features.map.SummaryNode;
import org.freeplane.features.map.mindmapmode.ChangeNodeLevelController;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.mapio.mindmapmode.MMapIO;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.nodelocation.LocationController;
import org.freeplane.features.nodelocation.mindmapmode.MLocationController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.nodestyle.mindmapmode.RevisionPlugin;
import org.freeplane.features.note.NoteController;
import org.freeplane.features.note.mindmapmode.MNoteController;
import org.freeplane.features.spellchecker.mindmapmode.SpellCheckerController;
import org.freeplane.features.styles.AutomaticLayoutController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyle;
import org.freeplane.features.styles.mindmapmode.MLogicalStyleController;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.features.ui.IMapViewChangeListener;
import org.freeplane.features.url.UrlManager;
import org.freeplane.features.url.mindmapmode.MFileManager;
import org.freeplane.view.swing.features.BlinkingNodeHook;
import org.freeplane.view.swing.features.filepreview.ViewerController;
import org.freeplane.view.swing.features.nodehistory.NodeHistory;
import org.freeplane.view.swing.features.progress.mindmapmode.ProgressFactory;
import org.freeplane.view.swing.map.attribute.EditAttributesAction;
import org.freeplane.view.swing.ui.UserInputListenerFactory;

public class HeadlessMModeControllerFactory {
    private static HeadlessMModeControllerFactory instance;
    private MModeController modeController;

    public static MModeController createModeController() {
        return HeadlessMModeControllerFactory.getInstance().createModeControllerImpl();
    }

    private static HeadlessMModeControllerFactory getInstance() {
        if (instance == null) {
            instance = new HeadlessMModeControllerFactory();
        }
        return instance;
    }

    private void createAddIns() {
        HierarchicalIcons.install((ModeController)this.modeController);
        new AutomaticLayoutController();
        new BlinkingNodeHook();
        SummaryNode.install();
        new AlwaysUnfoldedNode();
        FreeNode.install();
        new AutomaticEdgeColorHook();
        new ViewerController();
        MEncryptionController.install((MEncryptionController)new MEncryptionController((ModeController)this.modeController));
        new ChangeNodeLevelController(this.modeController);
        NodeHistory.install((ModeController)this.modeController);
        this.modeController.addAction((AFreeplaneAction)new ImportMindmanagerFiles());
    }

    private MModeController createModeControllerImpl() {
        this.createStandardControllers();
        this.createAddIns();
        return this.modeController;
    }

    private void createStandardControllers() {
        Controller controller = Controller.getCurrentController();
        this.modeController = new MModeController(controller);
        this.modeController.setUserInputListenerFactory((IUserInputListenerFactory)new UserInputListenerFactory((ModeController)this.modeController));
        controller.addModeController((ModeController)this.modeController);
        controller.selectModeForBuild((ModeController)this.modeController);
        ClipboardControllers.install((ClipboardControllers)new MClipboardControllers());
        new MMapController((ModeController)this.modeController);
        MFileManager fileManager = new MFileManager();
        UrlManager.install((UrlManager)fileManager);
        MMapIO.install((MModeController)this.modeController);
        controller.getMapViewManager().addMapViewChangeListener((IMapViewChangeListener)fileManager);
        new MIconController((ModeController)this.modeController).install((ModeController)this.modeController);
        new ProgressFactory().installActions((ModeController)this.modeController);
        EdgeController.install((EdgeController)new MEdgeController((ModeController)this.modeController));
        CloudController.install((CloudController)new MCloudController((ModeController)this.modeController));
        NoteController.install((NoteController)new MNoteController(this.modeController));
        MTextController textController = new MTextController((ModeController)this.modeController);
        textController.install((ModeController)this.modeController);
        MMapExplorerController.install((ModeController)this.modeController, (TextController)textController);
        LinkController.install((LinkController)new MLinkController((ModeController)this.modeController));
        NodeStyleController.install((NodeStyleController)new MNodeStyleController((ModeController)this.modeController));
        LocationController.install((LocationController)new MLocationController());
        LayoutController.install((LayoutController)new MLayoutController());
        MLogicalStyleController logicalStyleController = new MLogicalStyleController((ModeController)this.modeController);
        LogicalStyleController.install((LogicalStyleController)logicalStyleController);
        logicalStyleController.initM();
        AttributeController.install((AttributeController)new MAttributeController((ModeController)this.modeController));
        this.modeController.addAction((AFreeplaneAction)new EditAttributesAction());
        SpellCheckerController.install((ModeController)this.modeController);
        ExportController.install((ExportController)new ExportController("/xml/ExportWithXSLT.xml"));
        MapStyle.install(true);
        new RevisionPlugin();
        FoldingController.install(new FoldingController());
    }
}

