/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.menubuilders.generic;

import java.util.function.Predicate;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryPopupListener;
import org.freeplane.core.ui.menubuilders.generic.PhaseProcessor;

public class SubtreeProcessor
implements EntryPopupListener {
    private final Predicate<Entry> entryFilter;
    private PhaseProcessor processor;

    public SubtreeProcessor(Predicate<Entry> entryFilter) {
        this.entryFilter = entryFilter;
    }

    public void setProcessor(PhaseProcessor processor) {
        this.processor = processor;
    }

    @Override
    public void childEntriesWillBecomeVisible(Entry entry) {
        if (this.entryFilter.test(entry)) {
            this.buildChildren(entry);
        }
    }

    public void buildChildren(Entry entry) {
        PhaseProcessor subtreeProcessor = this.forChildren(entry);
        subtreeProcessor.buildChildren(entry);
    }

    public void rebuildEntry(Entry entry) {
        Entry parent = entry.getParent();
        PhaseProcessor subtreeProcessor = parent != null ? this.forChildren(parent) : this.processor;
        subtreeProcessor.destroy(entry);
        subtreeProcessor.build(entry);
    }

    private PhaseProcessor forChildren(Entry entry) {
        Entry root = entry.getRoot();
        PhaseProcessor subtreeProcessor = this.processor.forChildren(root, entry);
        return subtreeProcessor;
    }

    @Override
    public void childEntriesHidden(Entry entry) {
        if (this.entryFilter.test(entry)) {
            this.destroyChildren(entry);
        }
    }

    public void destroyChildren(Entry entry) {
        PhaseProcessor subtreeProcessor = this.forChildren(entry);
        for (Entry child : entry.children()) {
            subtreeProcessor.destroy(child);
        }
    }

    public void rebuildChildren(Entry entry) {
        this.destroyChildren(entry);
        this.buildChildren(entry);
    }
}

