/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.Timer;
import org.freeplane.core.ui.IMouseListener;

public class DelayedMouseListener
implements IMouseListener {
    private final IMouseListener delegate;
    private final int button;
    private int clickCounter = 0;
    private Timer timer = null;
    private static final int MAX_TIME_BETWEEN_CLICKS;
    private int maxClickNumber;

    public IMouseListener getDelegate() {
        return this.delegate;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.delegate.mouseDragged(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.delegate.mouseMoved(e);
    }

    public int getMaxClickNumber() {
        return this.maxClickNumber;
    }

    public void setMaxClickNumber(int maxClickNumber) {
        this.maxClickNumber = maxClickNumber;
    }

    @Override
    public void mouseClicked(final MouseEvent me) {
        if (me.getButton() != this.button) {
            this.delegate.mouseClicked(me);
            return;
        }
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
            ++this.clickCounter;
        } else {
            this.clickCounter = 1;
        }
        if (this.clickCounter == this.maxClickNumber) {
            this.delegate.mouseClicked(me);
            this.delegate.mouseReleased(me);
            return;
        }
        this.timer = new Timer(MAX_TIME_BETWEEN_CLICKS, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MouseEvent newMouseEvent = new MouseEvent(me.getComponent(), me.getID(), e.getWhen(), me.getModifiers(), me.getX(), me.getY(), DelayedMouseListener.this.clickCounter, me.isPopupTrigger(), DelayedMouseListener.this.button);
                DelayedMouseListener.this.delegate.mouseClicked(newMouseEvent);
                DelayedMouseListener.this.timer = null;
            }
        });
        this.timer.setRepeats(false);
        this.timer.start();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.delegate.mouseEntered(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.delegate.mouseExited(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.delegate.mousePressed(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.delegate.mouseReleased(e);
    }

    public DelayedMouseListener(IMouseListener delegate, int maxClickNumber, int button) {
        this.delegate = delegate;
        this.maxClickNumber = maxClickNumber;
        this.button = button;
    }

    static {
        Object p = Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
        MAX_TIME_BETWEEN_CLICKS = p instanceof Integer ? (Integer)p : 250;
    }
}

