/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import java.text.ParseException;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.text.NumberFormatter;

class FormatterFactoryWithPredefinedNames
extends JFormattedTextField.AbstractFormatterFactory {
    private final JFormattedTextField.AbstractFormatterFactory fallback;
    private final Map<String, Comparable> values;
    private final Map<Comparable, String> strings;

    public static void installFactory(JSpinner spinner, Map<String, Comparable> values) {
        JComponent editor = spinner.getEditor();
        if (!(editor instanceof JSpinner.NumberEditor)) {
            return;
        }
        JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)editor;
        JFormattedTextField textField = numberEditor.getTextField();
        JFormattedTextField.AbstractFormatterFactory formatterFactory = textField.getFormatterFactory();
        FormatterFactoryWithPredefinedNames factoryWithNames = new FormatterFactoryWithPredefinedNames(formatterFactory, values);
        textField.setFormatterFactory(factoryWithNames);
    }

    public FormatterFactoryWithPredefinedNames(JFormattedTextField.AbstractFormatterFactory fallback, Map<String, Comparable> values) {
        this.fallback = fallback;
        this.values = values;
        this.strings = values.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    @Override
    public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
        JFormattedTextField.AbstractFormatter formatter = this.fallback.getFormatter(tf);
        return formatter instanceof NumberFormatter ? new FormatterWithPredefinedNames((NumberFormatter)formatter, this.values, this.strings) : formatter;
    }

    static class FormatterWithPredefinedNames
    extends NumberFormatter {
        private final NumberFormatter fallback;
        private final Map<String, Comparable> values;
        private final Map<Comparable, String> strings;

        FormatterWithPredefinedNames(NumberFormatter fallback, Map<String, Comparable> values, Map<Comparable, String> strings) {
            this.fallback = fallback;
            this.values = values;
            this.strings = strings;
        }

        public void setMinimum(Comparable minimum) {
            this.fallback.setMinimum(minimum);
        }

        public Comparable getMinimum() {
            return this.fallback.getMinimum();
        }

        public void setMaximum(Comparable max) {
            this.fallback.setMaximum(max);
        }

        public Comparable getMaximum() {
            return this.fallback.getMaximum();
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            String predefinedString = this.strings.get(value);
            return predefinedString != null ? predefinedString : this.fallback.valueToString(value);
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            Comparable predefinedValue = this.values.get(text);
            return predefinedValue != null ? predefinedValue : this.fallback.stringToValue(text);
        }
    }
}

