/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.svg;

import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;
import org.freeplane.core.ui.CaseSensitiveFileNameExtensionFilter;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.export.mindmapmode.ExportController;
import org.freeplane.features.export.mindmapmode.IExportEngine;
import org.freeplane.features.mode.ModeController;
import org.freeplane.main.application.CommandLineOptions;
import org.freeplane.main.osgi.IModeControllerExtensionProvider;
import org.freeplane.plugin.svg.ExportPdf;
import org.freeplane.plugin.svg.ExportSvg;
import org.freeplane.plugin.svg.SvgViewerFactory;
import org.freeplane.view.swing.features.filepreview.IViewerFactory;
import org.freeplane.view.swing.features.filepreview.ViewerController;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    public void start(BundleContext context) throws Exception {
        this.registerMindMapModeExtension(context);
    }

    private void registerMindMapModeExtension(BundleContext context) {
        Hashtable<String, String[]> props = new Hashtable<String, String[]>();
        props.put("mode", new String[]{"MindMap"});
        context.registerService(IModeControllerExtensionProvider.class.getName(), (Object)new IModeControllerExtensionProvider(){

            public void installExtension(ModeController modeController, CommandLineOptions options) {
                ExportController exportController = ExportController.getController((ModeController)modeController);
                exportController.addMapExportEngine((FileFilter)new CaseSensitiveFileNameExtensionFilter("pdf", TextUtils.getText((String)"export_pdf_text")), (IExportEngine)new ExportPdf());
                exportController.addMapExportEngine((FileFilter)new CaseSensitiveFileNameExtensionFilter("svg", TextUtils.getText((String)"export_svg_text")), (IExportEngine)new ExportSvg());
                ViewerController extension = (ViewerController)modeController.getExtension(ViewerController.class);
                extension.addFactory((IViewerFactory)new SvgViewerFactory());
            }
        }, props);
    }

    public void stop(BundleContext context) throws Exception {
    }
}

