/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.map;

import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.properties.HasName;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.freeplane.core.extension.Configurable;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.plugin.codeexplorer.connectors.CodeLinkController;
import org.freeplane.plugin.codeexplorer.dependencies.CodeDependency;
import org.freeplane.plugin.codeexplorer.map.CodeMap;
import org.freeplane.plugin.codeexplorer.map.CodeNodeLinks;
import org.freeplane.plugin.codeexplorer.task.DependencyJudge;

public abstract class CodeNode
extends NodeModel {
    protected final int subprojectIndex;

    static String formatClassCount(long classCount) {
        return " (" + classCount + (classCount == 1L ? " class)" : " classes)");
    }

    public static JavaClass findEnclosingNamedClass(JavaClass javaClass) {
        if (javaClass.isAnonymousClass()) {
            return CodeNode.findEnclosingNamedClass((JavaClass)javaClass.getEnclosingClass().get());
        }
        if (javaClass.isArray()) {
            return javaClass.getBaseComponentType();
        }
        return javaClass;
    }

    static String idWithSubprojectIndex(String idWithoutIndex, int subprojectIndex) {
        return idWithoutIndex + "[" + subprojectIndex + "]";
    }

    static JavaClass getTargetNodeClass(Dependency dependency) {
        return CodeNode.findEnclosingNamedClass(dependency.getTargetClass());
    }

    static boolean isNamed(JavaClass jc) {
        return !jc.isAnonymousClass() && !jc.isArray();
    }

    private static boolean isTargetSourceKnown(Dependency dep) {
        return CodeNode.isClassSourceKnown(dep.getTargetClass());
    }

    private static boolean isOriginSourceKnown(Dependency dep) {
        return CodeNode.isClassSourceKnown(dep.getOriginClass());
    }

    static boolean isClassSourceKnown(JavaClass javaClass) {
        return javaClass.getSource().isPresent();
    }

    static boolean classesBelongToTheSamePackage(JavaClass first, JavaClass second) {
        return second.getPackage().equals(first.getPackage());
    }

    static boolean classesBelongToTheSamePackage(Dependency dependency) {
        return CodeNode.classesBelongToTheSamePackage(dependency.getOriginClass(), dependency.getTargetClass());
    }

    CodeNode(CodeMap map, int subprojectIndex) {
        super((MapModel)map);
        this.subprojectIndex = subprojectIndex;
    }

    public CodeMap getMap() {
        return (CodeMap)super.getMap();
    }

    public CodeNode getParentNode() {
        return (CodeNode)super.getParentNode();
    }

    String getCodeElementName() {
        return this.getCodeElement().getName();
    }

    void setIdWithIndex(String idWithoutIndex) {
        this.setID(this.idWithSubprojectIndex(idWithoutIndex));
    }

    String idWithSubprojectIndex(String idWithoutIndex) {
        return CodeNode.idWithSubprojectIndex(idWithoutIndex, this.subprojectIndex);
    }

    boolean belongsToSameSubproject(JavaClass javaClass) {
        int anotherSubprojectIndex = this.subprojectIndexOf(javaClass);
        return anotherSubprojectIndex == this.subprojectIndex;
    }

    int subprojectIndexOf(JavaClass javaClass) {
        return this.getMap().subprojectIndexOf(javaClass);
    }

    boolean belongsToOtherSubproject(JavaClass javaClass) {
        return !this.belongsToSameSubproject(javaClass);
    }

    abstract HasName getCodeElement();

    Set<CodeNode> findCyclicDependencies() {
        return Collections.emptySet();
    }

    abstract Stream<Dependency> getOutgoingDependencies();

    abstract Stream<Dependency> getIncomingDependencies();

    abstract String getUIIconName();

    Stream<Dependency> getIncomingAndOutgoingDependencies() {
        return Stream.concat(this.getIncomingDependencies(), this.getOutgoingDependencies());
    }

    public Stream<Dependency> getOutgoingDependenciesWithKnownTargets() {
        return this.getOutgoingDependencies().filter(CodeNode::isTargetSourceKnown);
    }

    public Stream<Dependency> getIncomingDependenciesWithKnownOrigins() {
        return this.getIncomingDependencies().filter(CodeNode::isOriginSourceKnown);
    }

    Stream<Dependency> getIncomingAndOutgoingDependenciesWithKnownTargets() {
        return Stream.concat(this.getIncomingDependenciesWithKnownOrigins(), this.getOutgoingDependenciesWithKnownTargets());
    }

    public List<NamedIcon> getIcons() {
        UIIcon uiIcon = IconStoreFactory.ICON_STORE.getUIIcon(this.getUIIconName());
        return Collections.singletonList(uiIcon);
    }

    public Stream<CodeDependency> outgoingCodeDependenciesWithKnownTargets() {
        MemoizedCodeDependencies extension = this.getExtension(MemoizedCodeDependencies.class);
        if (extension != null) {
            return extension.outgoing();
        }
        if (this.getParentNode() == null || this.getParentNode().getChildCount() <= 40) {
            return this.collectOutgoingCodeDependenciesWithKnownTargets();
        }
        return this.memoizeCodeDependencies().outgoing();
    }

    private Stream<CodeDependency> collectOutgoingCodeDependenciesWithKnownTargets() {
        return ((Stream)this.getOutgoingDependenciesWithKnownTargets().parallel()).map(this.getMap()::toCodeDependency);
    }

    public Stream<CodeDependency> incomingCodeDependenciesWithKnownOrigins() {
        MemoizedCodeDependencies extension = this.getExtension(MemoizedCodeDependencies.class);
        if (extension != null) {
            return extension.incoming();
        }
        if (this.getParentNode() == null || this.getParentNode().getChildCount() <= 40) {
            return this.collectIncomingCodeDependenciesWithKnownOrigins();
        }
        return this.memoizeCodeDependencies().incoming();
    }

    MemoizedCodeDependencies memoizeCodeDependencies() {
        MemoizedCodeDependencies extension = new MemoizedCodeDependencies();
        this.addExtension(extension);
        return extension;
    }

    private Stream<CodeDependency> collectIncomingCodeDependenciesWithKnownOrigins() {
        return ((Stream)this.getIncomingDependenciesWithKnownOrigins().parallel()).map(this.getMap()::toCodeDependency);
    }

    static Optional<String> classSourceLocationOf(JavaClass javaClass) {
        return javaClass.getSource().map(s -> {
            URI uri = s.getUri();
            String path = uri.getRawPath();
            String classLocation = path != null ? path : uri.getSchemeSpecificPart();
            String classSourceLocation = classLocation.substring(0, classLocation.length() - javaClass.getName().length() - ".class".length());
            return classSourceLocation;
        });
    }

    public <T extends IExtension> T getExtension(Class<T> clazz) {
        if (NodeLinks.class.equals(clazz)) {
            ModeController controller = Controller.getCurrentModeController();
            if (!controller.getModeName().equals("CodeExplorer")) {
                return null;
            }
            Configurable mapViewComponent = controller.getController().getMapViewManager().getMapViewConfiguration();
            if (mapViewComponent != null) {
                return (T)((Object)new CodeNodeLinks((CodeLinkController)controller.getExtension(LinkController.class), mapViewComponent, this));
            }
        }
        return (T)super.getExtension(clazz);
    }

    private class MemoizedCodeDependencies
    implements IExtension {
        DependencyJudge judge;
        CodeDependency[] incoming;
        CodeDependency[] outgoing;

        MemoizedCodeDependencies() {
            this.update();
        }

        private void update() {
            DependencyJudge currentJudge = CodeNode.this.getMap().getJudge();
            if (this.judge != currentJudge) {
                this.judge = currentJudge;
                this.incoming = (CodeDependency[])CodeNode.this.collectIncomingCodeDependenciesWithKnownOrigins().toArray(CodeDependency[]::new);
                this.outgoing = (CodeDependency[])CodeNode.this.collectOutgoingCodeDependenciesWithKnownTargets().toArray(CodeDependency[]::new);
            }
        }

        Stream<CodeDependency> incoming() {
            this.update();
            return (Stream)Stream.of(this.incoming).parallel();
        }

        Stream<CodeDependency> outgoing() {
            this.update();
            return (Stream)Stream.of(this.outgoing).parallel();
        }
    }
}

