/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.nodestyle.mindmapmode;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Scanner;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.FocusRequestor;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.components.UndoEnabler;
import org.freeplane.core.ui.components.html.ScaledEditorKit;
import org.freeplane.core.ui.components.html.StyleSheetConfigurer;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.IconFont;

class CssEditor {
    private static final int PREFERRED_SCROLL_PANE_HEIGHT = (int)(UITools.FONT_SCALE_FACTOR * 200.0f);
    private static final Dimension PREFERRED_SCROLL_PANE_SIZE = new Dimension(2 * PREFERRED_SCROLL_PANE_HEIGHT, PREFERRED_SCROLL_PANE_HEIGHT);
    private String newCss;
    private static final String previewHtml = CssEditor.loadPreview();
    private final JTextArea editor = new JTextArea();
    private final Box box;
    private ScaledEditorKit kit;
    private JEditorPane preview;
    private StyleSheet cssSheet;
    private StyleSheet documentSheet;

    private static String loadPreview() {
        Scanner s = new Scanner(ResourceController.getResourceController().getResourceStream("/preview/cssPreview.html"));
        try {
            s.useDelimiter("\\A");
            String string = s.hasNext() ? s.next() : "";
            s.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    s.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LogUtils.severe((Throwable)e);
                return "";
            }
        }
    }

    CssEditor(String cssByFormatting) {
        UndoEnabler.addUndoRedoFunctionality((JTextComponent)this.editor);
        FocusRequestor.requestFocus((Component)this.editor);
        this.kit = ScaledEditorKit.create();
        JScrollPane editorScrollPane = new JScrollPane(this.editor, 22, 32);
        UITools.setScrollbarIncrement((JScrollPane)editorScrollPane);
        TitledBorder editorBorder = BorderFactory.createTitledBorder(editorScrollPane.getBorder());
        editorBorder.setTitle(TextUtils.getText((String)"EditNodeCss"));
        editorScrollPane.setBorder(editorBorder);
        editorScrollPane.setPreferredSize(PREFERRED_SCROLL_PANE_SIZE);
        this.preview = new JEditorPane();
        this.preview.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.FALSE);
        this.preview.setOpaque(true);
        this.preview.setEditable(false);
        this.preview.setEditorKitForContentType("text/html", (EditorKit)this.kit);
        this.preview.setContentType("text/html");
        HTMLDocument document = (HTMLDocument)this.preview.getDocument();
        this.documentSheet = document.getStyleSheet();
        StyleSheet defaultSheet = StyleSheetConfigurer.createDefaultStyleSheet();
        defaultSheet.addRule(cssByFormatting);
        defaultSheet.addRule("p {margin-top:0;}");
        this.documentSheet.addStyleSheet(defaultSheet);
        JScrollPane previewScrollPane = new JScrollPane(this.preview, 22, 32);
        UITools.setScrollbarIncrement((JScrollPane)previewScrollPane);
        previewScrollPane.setPreferredSize(PREFERRED_SCROLL_PANE_SIZE);
        TitledBorder previewBorder = BorderFactory.createTitledBorder(previewScrollPane.getBorder());
        previewBorder.setTitle(TextUtils.getText((String)"simplyhtml.previewLabel"));
        previewScrollPane.setBorder(previewBorder);
        this.box = Box.createHorizontalBox();
        this.box.add(editorScrollPane);
        JButton previewButton = new JButton("\ue900");
        previewButton.setFont(IconFont.FONT.deriveFont(16.0f * UITools.FONT_SCALE_FACTOR));
        previewButton.setToolTipText(TextUtils.getRawText((String)"EditNodeCssRefresh.tooltip"));
        previewButton.addActionListener(x -> this.updateDocument());
        this.box.add(previewButton);
        this.box.add(previewScrollPane);
    }

    private void updateDocument() {
        if (this.cssSheet != null) {
            this.documentSheet.removeStyleSheet(this.cssSheet);
        }
        this.cssSheet = new StyleSheet();
        this.cssSheet.addRule(this.editor.getText());
        this.documentSheet.addStyleSheet(this.cssSheet);
        Rectangle visibleRect = this.preview.getVisibleRect();
        this.preview.setText(previewHtml);
        SwingUtilities.invokeLater(() -> this.preview.scrollRectToVisible(visibleRect));
    }

    int editCss(String css) {
        this.editor.setText(css);
        this.updateDocument();
        this.editor.setCaretPosition(0);
        this.preview.setCaretPosition(0);
        int result = UITools.showConfirmDialog((NodeModel)Controller.getCurrentController().getSelection().getSelected(), (Object)this.box, (String)TextUtils.getText((String)"EditNodeCss"), (int)2, (int)-1);
        this.newCss = this.editor.getText();
        return result;
    }

    public String getNewCss() {
        return this.newCss;
    }
}

