/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.core.domain.properties.HasOwner;
import com.tngtech.archunit.core.domain.properties.HasUpperBounds;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class JavaTypeVariable<OWNER extends HasDescription>
implements JavaType,
HasOwner<OWNER>,
HasUpperBounds {
    private final String name;
    private final OWNER owner;
    private List<JavaType> upperBounds = Collections.emptyList();
    private JavaClass erasure;

    JavaTypeVariable(String name, OWNER owner, JavaClass erasure) {
        this.name = name;
        this.owner = owner;
        this.erasure = erasure;
    }

    void setUpperBounds(List<JavaType> upperBounds) {
        this.upperBounds = upperBounds;
        this.erasure = upperBounds.isEmpty() ? this.erasure : upperBounds.get(0).toErasure();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public String getName() {
        return this.name;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public OWNER getGenericDeclaration() {
        return (OWNER)this.getOwner();
    }

    @Override
    public OWNER getOwner() {
        return this.owner;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public List<JavaType> getBounds() {
        return this.getUpperBounds();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public List<JavaType> getUpperBounds() {
        return this.upperBounds;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass toErasure() {
        return this.erasure;
    }

    @Override
    public Set<JavaClass> getAllInvolvedRawTypes() {
        return this.upperBounds.stream().map(JavaType::getAllInvolvedRawTypes).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public String toString() {
        String bounds = this.printExtendsClause() ? " extends " + this.joinTypeNames(this.upperBounds) : "";
        return this.getClass().getSimpleName() + '{' + this.getName() + bounds + '}';
    }

    private boolean printExtendsClause() {
        if (this.upperBounds.isEmpty()) {
            return false;
        }
        if (this.upperBounds.size() > 1) {
            return true;
        }
        return !Iterables.getOnlyElement(this.upperBounds).getName().equals(Object.class.getName());
    }

    private String joinTypeNames(List<JavaType> types) {
        return types.stream().map(HasName.Functions.GET_NAME).collect(Collectors.joining(" & "));
    }
}

