/*
 * Decompiled with CFR 0.152.
 */
package processing.app.helpers;

import java.awt.Color;
import java.awt.Font;
import processing.app.helpers.PreferencesMap;

public abstract class PreferencesHelper {
    public static void putColor(PreferencesMap prefs, String attr, Color color) {
        prefs.put(attr, "#" + String.format("%06x", color.getRGB() & 0xFFFFFF));
    }

    public static Color parseColor(String v) {
        try {
            if (v.indexOf("#") == 0) {
                v = v.substring(1);
            }
            return new Color(Integer.parseInt(v, 16));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Font getFont(PreferencesMap prefs, String key) {
        int size;
        String value = (String)prefs.get(key);
        if (value == null) {
            return null;
        }
        String[] split = value.split(",");
        if (split.length != 3) {
            return null;
        }
        String name = split[0];
        int style = 0;
        if (split[1].contains("bold")) {
            style |= 1;
        }
        if (split[1].contains("italic")) {
            style |= 2;
        }
        try {
            size = (int)Double.parseDouble(split[2]);
            if (size < 1) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            size = 12;
        }
        return new Font(name, style, size);
    }
}

