/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.Uploader;
import cc.arduino.packages.UploaderFactory;
import java.util.LinkedList;
import java.util.List;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.Sketch;
import processing.app.debug.TargetBoard;

public class UploaderUtils {
    public Uploader getUploaderByPreferences(boolean noUploadPort) {
        BoardPort boardPort = null;
        if (!noUploadPort) {
            String port = PreferencesData.get("serial.port");
            boardPort = BaseNoGui.getDiscoveryManager().find(port);
        }
        TargetBoard board = BaseNoGui.getTargetBoard();
        return new UploaderFactory().newUploader(board, boardPort, noUploadPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upload(Sketch data, Uploader uploader, String suggestedClassName, boolean usingProgrammer, boolean noUploadPort, List<String> warningsAccumulator) throws Exception {
        if (uploader == null) {
            uploader = this.getUploaderByPreferences(noUploadPort);
        }
        boolean success = false;
        if (uploader.requiresAuthorization() && !PreferencesData.has(uploader.getAuthorizationKey())) {
            BaseNoGui.showError(I18n.tr("Authorization required"), I18n.tr("No authorization data found"), null);
        }
        boolean useNewWarningsAccumulator = false;
        if (warningsAccumulator == null) {
            warningsAccumulator = new LinkedList<String>();
            useNewWarningsAccumulator = true;
        }
        try {
            success = uploader.uploadUsingPreferences(data.getFolder(), data.getBuildPath().getAbsolutePath(), suggestedClassName, usingProgrammer, warningsAccumulator);
        }
        finally {
            if (uploader.requiresAuthorization() && !success) {
                PreferencesData.remove(uploader.getAuthorizationKey());
            }
        }
        if (useNewWarningsAccumulator) {
            for (String warning : warningsAccumulator) {
                System.out.print(I18n.tr("Warning"));
                System.out.print(": ");
                System.out.println(warning);
            }
        }
        return success;
    }
}

