/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.compress.utils.IOUtils;
import processing.app.helpers.FileUtils;

public class ZipDeflater {
    private final ZipFile zipFile;
    private final File destFolder;
    private final Random random;
    private final File file;

    public ZipDeflater(File file, File destFolder) throws ZipException, IOException {
        this.file = file;
        this.destFolder = destFolder;
        this.zipFile = new ZipFile(file);
        this.random = new Random();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deflate() throws IOException {
        String tmpFolderName = this.folderNameFromZip() + this.random.nextInt(1000000);
        File tmpFolder = new File(this.destFolder, tmpFolderName);
        if (!tmpFolder.mkdir()) {
            throw new IOException("Unable to create folder " + tmpFolderName);
        }
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            this.ensureFoldersOfEntryExist(tmpFolder, entry);
            File entryFile = new File(tmpFolder, entry.getName());
            if (entry.isDirectory()) {
                entryFile.mkdir();
                continue;
            }
            FileOutputStream fos = null;
            InputStream zipInputStream = null;
            try {
                fos = new FileOutputStream(entryFile);
                zipInputStream = this.zipFile.getInputStream(entry);
                byte[] buffer = new byte[4096];
                int len = -1;
                while ((len = zipInputStream.read(buffer)) != -1) {
                    fos.write(buffer, 0, len);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                IOUtils.closeQuietly(zipInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)fos);
            IOUtils.closeQuietly((Closeable)zipInputStream);
        }
        this.deleteUndesiredFoldersAndFiles(tmpFolder);
        this.ensureOneLevelFolder(tmpFolder);
    }

    private void deleteUndesiredFoldersAndFiles(File folder) {
        for (File file : folder.listFiles()) {
            if (file.isDirectory() && "__MACOSX".equals(file.getName())) {
                FileUtils.recursiveDelete((File)file);
                continue;
            }
            if (!file.getName().startsWith(".")) continue;
            FileUtils.recursiveDelete((File)file);
        }
    }

    private void ensureFoldersOfEntryExist(File folder, ZipEntry entry) {
        String[] parts = entry.getName().split("/");
        File current = folder;
        for (int i = 0; i < parts.length - 1; ++i) {
            current = new File(current, parts[i]);
            current.mkdir();
        }
    }

    private void ensureOneLevelFolder(File folder) {
        File[] files = folder.listFiles();
        if (files.length != 1) {
            folder.renameTo(new File(folder.getParentFile(), this.folderNameFromZip()));
            return;
        }
        files[0].renameTo(new File(folder.getParentFile(), files[0].getName()));
        FileUtils.recursiveDelete((File)folder);
    }

    private String folderNameFromZip() {
        String filename = this.file.getName();
        if (filename.lastIndexOf(".") != -1) {
            filename = filename.substring(0, filename.lastIndexOf("."));
        }
        return filename;
    }
}

