/*	Copyright (C) ASCII Corporation, 1985	*/
#include "mkind.h"

#ifdef KANJI

#include	"ctable.h"

#ifndef iskanji
iskanji(c)
register short	c;
{
	c &= 0377;
#ifdef SJIS
	return ((c > 0x80 && c < 0xa0)||(c > 0xdf && c < 0xfd));
#endif

#ifdef EUC
	return(c >= 0xa1 && c <= 0xfe);
#endif
}
#endif


int getk(fp)
FILE *fp;
{
	int c;

	if ((c = getc(fp)) == EOF)
		return EOF;
	if (iskanji(c))
		return (c << 8) | getc(fp);
	else
		return c;
}

static char	*copys(s1,s2)
char	*s1,*s2;
{
	while(*s1++ = *s2++) 
			;

	return(s1);
}


int Reader(key)
char *key;
{
	char 	*p, *q,*cp;
	char	Work[STRING_MAX];
	struct	rplc	*pt;
	int		comp2();
	char	*binsearch();


	p = key;
	q = Work;

	while (*p != NULL) {

		if (iskanji(*p)) {
			if ((pt = (struct rplc *)binsearch(p,(char*)Ctbl,sizeof(Ctbl) / 
				sizeof(struct rplc),sizeof(struct rplc),comp2)) == NULL) {
					return( FALSE );
			}
			if (q != &Work[0] && index(Del_ch,*pt->dst) != NULL) {
					p += 2;
					continue;
			}
			q = copys( q,pt->dst ) - 1 ;	
			p += 2;
			continue;
		}
			if (q != &Work[0] && index(Del_ch,*p) != NULL) {
					++p;
					continue;
			}
				*q = *p++;
				if (islower(*q))
						*q = toupper(*q);
				else
				if ((cp = index(Tbl1,*q)) != NULL) 
						*q = *(Tbl2 + (cp - Tbl1));	

				++q;
	}
	*q = '\0';
	strcpy(key,Work);

	return(TRUE);

}

#endif

#define MASK	0xff

static int jstrcmp(s1, s2)
char *s1, *s2;
{
	register unsigned short c1, c2;

	for (;;) {
		c1 = *s1++&MASK;
		if (iskanji(c1))
			c1 = (*s1 == '\0')? 0: (c1<<8)|(*s1++&MASK);
		c2 = *s2++&MASK;
		if (iskanji(c2))
			c2 = (*s2 == '\0')? 0: (c2<<8)|(*s2++&MASK);
		if (c1 != c2)
			break;
		if (c1 == 0)
			return(0);
	}
	return((c1 < c2)? -1: 1);
}

#ifdef  KANJI

static char *binsearch(key, base, num, width, compare)
char       *key, *base;
unsigned    num, width;
int       (*compare)();
{
	int         value;
	unsigned    num2, mid;

	while (num > 0) {
		num2 = (1 + num) >> 1;
		mid = width * (num2 - 1);
		value = (*compare)(key, base + mid);
		if (!value) {
			return (base + mid);
		}
		if (value < 0) {
			num = num2 - 1;
		} else {
			num -= num2;
			base += mid + width;
		}
	}
	return (NULL);
}

/*
 *  strucmp - unsigned string compare
 */
static int  strucmp(s1, s2)
register char   *s1,  *s2;
{
	register int     value;

	while (*s1 && *s2) {
		if ((value = (unsigned char)*s1 - (unsigned char)*s2) != 0)
			return value;
		++s1;
		++s2;
	}
	if (*s2 == '\0') {
		return 0;
	} else {
		return value;
	}
}

static int     comp2(key, args)
char   *key;
struct rplc *args;
{
	return strucmp(key, args->src);
}

KanaConv(c,flag)
unsigned char	c;
int				flag;
{
	if (flag == 1 )
		fprintf(ind_fp,"%s", Ktbl[c-0xb1].dst2) ;
	else if (flag > 1)
		fprintf(ind_fp,"%s", Ktbl[c-0xb1].dst1) ;
}

#endif
