/* <<< Start of information >>>                                             */
/* This file is part of the xwatch package.                                 */
/* Copyright (C) 1995 Karel Kubat.  All rights reserved.                    */
/*                                                                          */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/*                                                                          */
/* You may link this software with XForms (Copyright (C) by T.C. Zhao and   */
/* Mark Overmars) and distribute the resulting binary, under the            */
/* restrictions in clause 3 of the GPL, even though the resulting binary is */
/* not, as a whole, covered by the GPL. (You still need a separate license  */
/* to do so from the owner(s) of the copyright for XForms, however).  If a  */
/* derivative no longer requires XForms, you may use the unsupplemented GPL */
/* as its license by deleting this paragraph and therefore removing this    */
/* exemption for XForms.                                                    */
/*                                                                          */
/* This program is distributed in the hope that it will be useful,          */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/* GNU General Public License for more details.                             */
/*                                                                          */
/* You should have received a copy of the GNU General Public License        */
/* along with this program; if not, write to the Free Software              */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA */
/* <<< End of information >>>                                               */

/* Header for xwatch */

#include <ctype.h>
#include <errno.h>
#include <X11/forms.h>
#include <malloc.h>
#include <signal.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/time.h>
#include "ui.h"

typedef struct				    /* scanned files: */ 
{
    char *name;				    /* name of file */
    int inode;				    /* inode, for same file check */
    int active;				    /* are we scanning it? */
    int offset;				    /* offset at which we started */
    int colorindex;			    /* color index for the file */
} Fileinfo;

typedef struct				    /* allowed values */
{
    int *var;				    /* the variable */
    int min, max;			    /* min/max value */
    char *desc;				    /* descriptive string */
} Setting;

typedef struct                              /* colorstring info */
{
    char *str;                              /* the color name */
    int colorindex;                         /* and its index */
} Colorstring;

#undef EXTERN
#define EXTERN extern
#include "data.inc"

extern void addfile (char *fname);
extern void addline (char *line, int colindex);
extern void alarmhandler (int sig);
extern void checksetting (int var, int min, int max, char *desc);
extern void error (char *fmt, ...);
extern int  getcolorindex (int r, int g, int b);
extern void init_forms (int *argcp, char **argv);
extern void init_xwatch (void);
extern void interval_slider_callback (FL_OBJECT *, long);
extern void linelen_slider_callback (FL_OBJECT *, long);
extern void lines_slider_callback (FL_OBJECT *, long);
extern void medium_font_button_callback (FL_OBJECT *, long);
extern void normal_font_button_callback (FL_OBJECT *, long);
extern void options_button_callback (FL_OBJECT *, long);
extern void ok_button_callback (FL_OBJECT *, long);
extern void parsegag (char *buf);
extern void parsegeometry (char *str, int *xp, int *yp, int *wp, int *hp);
extern int  colorname2index (char *col);
extern int  colorname2rgb(char *col, int *r, int *g, int *b);
extern void parsecolors (char *fg, char *bg);
extern void parsecolorstring (char *buf);
extern int  parseignore (char *buf, int argc, char **argv);
extern void quit_button_callback (FL_OBJECT *, long);
extern void rescan_button_callback (FL_OBJECT *, long);
extern void rescan_files (void);
extern void scanfile (int index, int dumpinfo);
extern void small_font_button_callback (FL_OBJECT *, long);
extern void tiny_font_button_callback (FL_OBJECT *, long);
extern void usage (void);
extern void warning (char *fmt, ...);
extern void *xmalloc (int sz);
extern void *xrealloc (void *mem, int newsz);
extern char *xstrdup (char *str);
