// GENERATED FILE - DO NOT EDIT.
// Generated by gen_gl_enum_utils.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// gl_enum_utils_autogen.cpp:
//   mapping of GLenum value to string.

#include "libANGLE/gl_enum_utils_autogen.h"

#include "libANGLE/gl_enum_utils.h"

namespace gl
{
namespace
{
const char *UnknownGLenumToString(unsigned int value)
{
    constexpr size_t kBufferSize = 64;
    static thread_local char sBuffer[kBufferSize];
    snprintf(sBuffer, kBufferSize, "0x%04X", value);
    return sBuffer;
}
}  // anonymous namespace

const char *GLenumToString(GLenumGroup enumGroup, unsigned int value)
{
    switch (enumGroup)
    {
        case GLenumGroup::AlphaFunction:
        {
            switch (value)
            {
                case 0x200:
                    return "GL_NEVER";
                case 0x201:
                    return "GL_LESS";
                case 0x202:
                    return "GL_EQUAL";
                case 0x203:
                    return "GL_LEQUAL";
                case 0x204:
                    return "GL_GREATER";
                case 0x205:
                    return "GL_NOTEQUAL";
                case 0x206:
                    return "GL_GEQUAL";
                case 0x207:
                    return "GL_ALWAYS";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::AtomicCounterBufferPName:
        {
            switch (value)
            {
                case 0x92C1:
                    return "GL_ATOMIC_COUNTER_BUFFER_BINDING";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::AttribMask:
        {
            switch (value)
            {
                case 0x100:
                    return "GL_DEPTH_BUFFER_BIT";
                case 0x400:
                    return "GL_STENCIL_BUFFER_BIT";
                case 0x4000:
                    return "GL_COLOR_BUFFER_BIT";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::AttributeType:
        {
            switch (value)
            {
                case 0x8B50:
                    return "GL_FLOAT_VEC2";
                case 0x8B51:
                    return "GL_FLOAT_VEC3";
                case 0x8B52:
                    return "GL_FLOAT_VEC4";
                case 0x8B53:
                    return "GL_INT_VEC2";
                case 0x8B54:
                    return "GL_INT_VEC3";
                case 0x8B55:
                    return "GL_INT_VEC4";
                case 0x8B56:
                    return "GL_BOOL";
                case 0x8B57:
                    return "GL_BOOL_VEC2";
                case 0x8B58:
                    return "GL_BOOL_VEC3";
                case 0x8B59:
                    return "GL_BOOL_VEC4";
                case 0x8B5A:
                    return "GL_FLOAT_MAT2";
                case 0x8B5B:
                    return "GL_FLOAT_MAT3";
                case 0x8B5C:
                    return "GL_FLOAT_MAT4";
                case 0x8B5E:
                    return "GL_SAMPLER_2D";
                case 0x8B5F:
                    return "GL_SAMPLER_3D";
                case 0x8B60:
                    return "GL_SAMPLER_CUBE";
                case 0x8B62:
                    return "GL_SAMPLER_2D_SHADOW";
                case 0x8B65:
                    return "GL_FLOAT_MAT2x3";
                case 0x8B66:
                    return "GL_FLOAT_MAT2x4";
                case 0x8B67:
                    return "GL_FLOAT_MAT3x2";
                case 0x8B68:
                    return "GL_FLOAT_MAT3x4";
                case 0x8B69:
                    return "GL_FLOAT_MAT4x2";
                case 0x8B6A:
                    return "GL_FLOAT_MAT4x3";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::BindTransformFeedbackTarget:
        {
            switch (value)
            {
                case 0x8E22:
                    return "GL_TRANSFORM_FEEDBACK";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::BlendEquationModeEXT:
        {
            switch (value)
            {
                case 0x8006:
                    return "GL_FUNC_ADD";
                case 0x800A:
                    return "GL_FUNC_SUBTRACT";
                case 0x800B:
                    return "GL_FUNC_REVERSE_SUBTRACT";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::BlendingFactor:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_ZERO";
                case 0x1:
                    return "GL_ONE";
                case 0x300:
                    return "GL_SRC_COLOR";
                case 0x301:
                    return "GL_ONE_MINUS_SRC_COLOR";
                case 0x302:
                    return "GL_SRC_ALPHA";
                case 0x303:
                    return "GL_ONE_MINUS_SRC_ALPHA";
                case 0x304:
                    return "GL_DST_ALPHA";
                case 0x305:
                    return "GL_ONE_MINUS_DST_ALPHA";
                case 0x306:
                    return "GL_DST_COLOR";
                case 0x307:
                    return "GL_ONE_MINUS_DST_COLOR";
                case 0x308:
                    return "GL_SRC_ALPHA_SATURATE";
                case 0x8001:
                    return "GL_CONSTANT_COLOR";
                case 0x8002:
                    return "GL_ONE_MINUS_CONSTANT_COLOR";
                case 0x8003:
                    return "GL_CONSTANT_ALPHA";
                case 0x8004:
                    return "GL_ONE_MINUS_CONSTANT_ALPHA";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::BlitFramebufferFilter:
        {
            switch (value)
            {
                case 0x2600:
                    return "GL_NEAREST";
                case 0x2601:
                    return "GL_LINEAR";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::Boolean:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_FALSE";
                case 0x1:
                    return "GL_TRUE";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::Buffer:
        {
            switch (value)
            {
                case 0x1800:
                    return "GL_COLOR";
                case 0x1801:
                    return "GL_DEPTH";
                case 0x1802:
                    return "GL_STENCIL";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::BufferAccessARB:
        {
            switch (value)
            {
                case 0x88B8:
                    return "GL_READ_ONLY";
                case 0x88B9:
                    return "GL_WRITE_ONLY";
                case 0x88BA:
                    return "GL_READ_WRITE";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::BufferAccessMask:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_MAP_READ_BIT";
                case 0x2:
                    return "GL_MAP_WRITE_BIT";
                case 0x4:
                    return "GL_MAP_INVALIDATE_RANGE_BIT";
                case 0x8:
                    return "GL_MAP_INVALIDATE_BUFFER_BIT";
                case 0x10:
                    return "GL_MAP_FLUSH_EXPLICIT_BIT";
                case 0x20:
                    return "GL_MAP_UNSYNCHRONIZED_BIT";
                case 0x40:
                    return "GL_MAP_PERSISTENT_BIT_EXT";
                case 0x80:
                    return "GL_MAP_COHERENT_BIT_EXT";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::BufferStorageTarget:
        {
            switch (value)
            {
                case 0x8892:
                    return "GL_ARRAY_BUFFER";
                case 0x8893:
                    return "GL_ELEMENT_ARRAY_BUFFER";
                case 0x88EB:
                    return "GL_PIXEL_PACK_BUFFER";
                case 0x88EC:
                    return "GL_PIXEL_UNPACK_BUFFER";
                case 0x8A11:
                    return "GL_UNIFORM_BUFFER";
                case 0x8C2A:
                    return "GL_TEXTURE_BUFFER";
                case 0x8C8E:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER";
                case 0x8F36:
                    return "GL_COPY_READ_BUFFER";
                case 0x8F37:
                    return "GL_COPY_WRITE_BUFFER";
                case 0x8F3F:
                    return "GL_DRAW_INDIRECT_BUFFER";
                case 0x90D2:
                    return "GL_SHADER_STORAGE_BUFFER";
                case 0x90EE:
                    return "GL_DISPATCH_INDIRECT_BUFFER";
                case 0x92C0:
                    return "GL_ATOMIC_COUNTER_BUFFER";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::BufferTargetARB:
        {
            switch (value)
            {
                case 0x8892:
                    return "GL_ARRAY_BUFFER";
                case 0x8893:
                    return "GL_ELEMENT_ARRAY_BUFFER";
                case 0x88EB:
                    return "GL_PIXEL_PACK_BUFFER";
                case 0x88EC:
                    return "GL_PIXEL_UNPACK_BUFFER";
                case 0x8A11:
                    return "GL_UNIFORM_BUFFER";
                case 0x8C2A:
                    return "GL_TEXTURE_BUFFER";
                case 0x8C8E:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER";
                case 0x8F36:
                    return "GL_COPY_READ_BUFFER";
                case 0x8F37:
                    return "GL_COPY_WRITE_BUFFER";
                case 0x8F3F:
                    return "GL_DRAW_INDIRECT_BUFFER";
                case 0x90D2:
                    return "GL_SHADER_STORAGE_BUFFER";
                case 0x90EE:
                    return "GL_DISPATCH_INDIRECT_BUFFER";
                case 0x92C0:
                    return "GL_ATOMIC_COUNTER_BUFFER";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::BufferUsageARB:
        {
            switch (value)
            {
                case 0x88E0:
                    return "GL_STREAM_DRAW";
                case 0x88E1:
                    return "GL_STREAM_READ";
                case 0x88E2:
                    return "GL_STREAM_COPY";
                case 0x88E4:
                    return "GL_STATIC_DRAW";
                case 0x88E5:
                    return "GL_STATIC_READ";
                case 0x88E6:
                    return "GL_STATIC_COPY";
                case 0x88E8:
                    return "GL_DYNAMIC_DRAW";
                case 0x88E9:
                    return "GL_DYNAMIC_READ";
                case 0x88EA:
                    return "GL_DYNAMIC_COPY";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::CheckFramebufferStatusTarget:
        {
            switch (value)
            {
                case 0x8CA8:
                    return "GL_READ_FRAMEBUFFER";
                case 0x8CA9:
                    return "GL_DRAW_FRAMEBUFFER";
                case 0x8D40:
                    return "GL_FRAMEBUFFER";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::ClearBufferMask:
        {
            switch (value)
            {
                case 0x100:
                    return "GL_DEPTH_BUFFER_BIT";
                case 0x400:
                    return "GL_STENCIL_BUFFER_BIT";
                case 0x4000:
                    return "GL_COLOR_BUFFER_BIT";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::ColorBuffer:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                case 0x404:
                    return "GL_FRONT";
                case 0x405:
                    return "GL_BACK";
                case 0x408:
                    return "GL_FRONT_AND_BACK";
                case 0x8CE0:
                    return "GL_COLOR_ATTACHMENT0";
                case 0x8CE1:
                    return "GL_COLOR_ATTACHMENT1";
                case 0x8CE2:
                    return "GL_COLOR_ATTACHMENT2";
                case 0x8CE3:
                    return "GL_COLOR_ATTACHMENT3";
                case 0x8CE4:
                    return "GL_COLOR_ATTACHMENT4";
                case 0x8CE5:
                    return "GL_COLOR_ATTACHMENT5";
                case 0x8CE6:
                    return "GL_COLOR_ATTACHMENT6";
                case 0x8CE7:
                    return "GL_COLOR_ATTACHMENT7";
                case 0x8CE8:
                    return "GL_COLOR_ATTACHMENT8";
                case 0x8CE9:
                    return "GL_COLOR_ATTACHMENT9";
                case 0x8CEA:
                    return "GL_COLOR_ATTACHMENT10";
                case 0x8CEB:
                    return "GL_COLOR_ATTACHMENT11";
                case 0x8CEC:
                    return "GL_COLOR_ATTACHMENT12";
                case 0x8CED:
                    return "GL_COLOR_ATTACHMENT13";
                case 0x8CEE:
                    return "GL_COLOR_ATTACHMENT14";
                case 0x8CEF:
                    return "GL_COLOR_ATTACHMENT15";
                case 0x8CF0:
                    return "GL_COLOR_ATTACHMENT16";
                case 0x8CF1:
                    return "GL_COLOR_ATTACHMENT17";
                case 0x8CF2:
                    return "GL_COLOR_ATTACHMENT18";
                case 0x8CF3:
                    return "GL_COLOR_ATTACHMENT19";
                case 0x8CF4:
                    return "GL_COLOR_ATTACHMENT20";
                case 0x8CF5:
                    return "GL_COLOR_ATTACHMENT21";
                case 0x8CF6:
                    return "GL_COLOR_ATTACHMENT22";
                case 0x8CF7:
                    return "GL_COLOR_ATTACHMENT23";
                case 0x8CF8:
                    return "GL_COLOR_ATTACHMENT24";
                case 0x8CF9:
                    return "GL_COLOR_ATTACHMENT25";
                case 0x8CFA:
                    return "GL_COLOR_ATTACHMENT26";
                case 0x8CFB:
                    return "GL_COLOR_ATTACHMENT27";
                case 0x8CFC:
                    return "GL_COLOR_ATTACHMENT28";
                case 0x8CFD:
                    return "GL_COLOR_ATTACHMENT29";
                case 0x8CFE:
                    return "GL_COLOR_ATTACHMENT30";
                case 0x8CFF:
                    return "GL_COLOR_ATTACHMENT31";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::ColorMaterialFace:
        {
            switch (value)
            {
                case 0x404:
                    return "GL_FRONT";
                case 0x405:
                    return "GL_BACK";
                case 0x408:
                    return "GL_FRONT_AND_BACK";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::ColorPointerType:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1406:
                    return "GL_FLOAT";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::ContextFlagMask:
        {
            switch (value)
            {
                case 0x2:
                    return "GL_CONTEXT_FLAG_DEBUG_BIT";
                case 0x4:
                    return "GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::CopyBufferSubDataTarget:
        {
            switch (value)
            {
                case 0x8892:
                    return "GL_ARRAY_BUFFER";
                case 0x8893:
                    return "GL_ELEMENT_ARRAY_BUFFER";
                case 0x88EB:
                    return "GL_PIXEL_PACK_BUFFER";
                case 0x88EC:
                    return "GL_PIXEL_UNPACK_BUFFER";
                case 0x8A11:
                    return "GL_UNIFORM_BUFFER";
                case 0x8C2A:
                    return "GL_TEXTURE_BUFFER";
                case 0x8C8E:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER";
                case 0x8F36:
                    return "GL_COPY_READ_BUFFER";
                case 0x8F37:
                    return "GL_COPY_WRITE_BUFFER";
                case 0x8F3F:
                    return "GL_DRAW_INDIRECT_BUFFER";
                case 0x90D2:
                    return "GL_SHADER_STORAGE_BUFFER";
                case 0x90EE:
                    return "GL_DISPATCH_INDIRECT_BUFFER";
                case 0x92C0:
                    return "GL_ATOMIC_COUNTER_BUFFER";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::CullFaceMode:
        {
            switch (value)
            {
                case 0x404:
                    return "GL_FRONT";
                case 0x405:
                    return "GL_BACK";
                case 0x408:
                    return "GL_FRONT_AND_BACK";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::DebugSeverity:
        {
            switch (value)
            {
                case 0x1100:
                    return "GL_DONT_CARE";
                case 0x9146:
                    return "GL_DEBUG_SEVERITY_HIGH";
                case 0x9147:
                    return "GL_DEBUG_SEVERITY_MEDIUM";
                case 0x9148:
                    return "GL_DEBUG_SEVERITY_LOW";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::DebugSource:
        {
            switch (value)
            {
                case 0x1100:
                    return "GL_DONT_CARE";
                case 0x8246:
                    return "GL_DEBUG_SOURCE_API";
                case 0x8247:
                    return "GL_DEBUG_SOURCE_WINDOW_SYSTEM";
                case 0x8248:
                    return "GL_DEBUG_SOURCE_SHADER_COMPILER";
                case 0x8249:
                    return "GL_DEBUG_SOURCE_THIRD_PARTY";
                case 0x824A:
                    return "GL_DEBUG_SOURCE_APPLICATION";
                case 0x824B:
                    return "GL_DEBUG_SOURCE_OTHER";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::DebugType:
        {
            switch (value)
            {
                case 0x1100:
                    return "GL_DONT_CARE";
                case 0x824C:
                    return "GL_DEBUG_TYPE_ERROR";
                case 0x824D:
                    return "GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR";
                case 0x824E:
                    return "GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR";
                case 0x824F:
                    return "GL_DEBUG_TYPE_PORTABILITY";
                case 0x8250:
                    return "GL_DEBUG_TYPE_PERFORMANCE";
                case 0x8251:
                    return "GL_DEBUG_TYPE_OTHER";
                case 0x8268:
                    return "GL_DEBUG_TYPE_MARKER";
                case 0x8269:
                    return "GL_DEBUG_TYPE_PUSH_GROUP";
                case 0x826A:
                    return "GL_DEBUG_TYPE_POP_GROUP";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::DefaultGroup:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_CREATE_SPARSE_BINDING_BIT_ANGLE";
                case 0x2:
                    return "GL_CREATE_SPARSE_RESIDENCY_BIT_ANGLE";
                case 0x4:
                    return "GL_CREATE_SPARSE_ALIASED_BIT_ANGLE";
                case 0x8:
                    return "GL_CREATE_MUTABLE_FORMAT_BIT_ANGLE";
                case 0x10:
                    return "GL_CREATE_CUBE_COMPATIBLE_BIT_ANGLE";
                case 0x16:
                    return "GL_UUID_SIZE_EXT";
                case 0x20:
                    return "GL_CREATE_2D_ARRAY_COMPATIBLE_BIT_ANGLE";
                case 0x40:
                    return "GL_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT_ANGLE";
                case 0x80:
                    return "GL_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT_ANGLE";
                case 0x100:
                    return "GL_CREATE_EXTENDED_USAGE_BIT_ANGLE";
                case 0x200:
                    return "GL_CREATE_DISJOINT_BIT_ANGLE";
                case 0x308:
                    return "GL_SRC_ALPHA_SATURATE_EXT";
                case 0x400:
                    return "GL_CREATE_ALIAS_BIT_ANGLE";
                case 0x503:
                    return "GL_STACK_OVERFLOW_KHR";
                case 0x504:
                    return "GL_STACK_UNDERFLOW_KHR";
                case 0x507:
                    return "GL_CONTEXT_LOST";
                case 0x800:
                    return "GL_CREATE_PROTECTED_BIT_ANGLE";
                case 0x1000:
                    return "GL_CREATE_SAMPLE_LOCATIONS_COMPATIBLE_DEPTH_BIT_ANGLE";
                case 0x1004:
                    return "GL_TEXTURE_BORDER_COLOR_OES";
                case 0x1901:
                    return "GL_STENCIL_INDEX_OES";
                case 0x2000:
                    return "GL_CREATE_CORNER_SAMPLED_BIT_ANGLE";
                case 0x2500:
                    return "GL_TEXTURE_GEN_MODE_OES";
                case 0x4000:
                    return "GL_CREATE_SUBSAMPLED_BIT_ANGLE";
                case 0x8005:
                    return "GL_BLEND_COLOR";
                case 0x8007:
                    return "GL_MIN";
                case 0x8008:
                    return "GL_MAX";
                case 0x8009:
                    return "GL_BLEND_EQUATION";
                case 0x803C:
                    return "GL_ALPHA8_EXT";
                case 0x8040:
                    return "GL_LUMINANCE8_EXT";
                case 0x8045:
                    return "GL_LUMINANCE8_ALPHA8_EXT";
                case 0x806A:
                    return "GL_TEXTURE_BINDING_3D_OES";
                case 0x8071:
                    return "GL_TEXTURE_DEPTH";
                case 0x8073:
                    return "GL_MAX_3D_TEXTURE_SIZE";
                case 0x8074:
                    return "GL_VERTEX_ARRAY_KHR";
                case 0x809E:
                    return "GL_SAMPLE_ALPHA_TO_COVERAGE";
                case 0x80A0:
                    return "GL_SAMPLE_COVERAGE";
                case 0x80AA:
                    return "GL_SAMPLE_COVERAGE_VALUE";
                case 0x80AB:
                    return "GL_SAMPLE_COVERAGE_INVERT";
                case 0x80C8:
                    return "GL_BLEND_DST_RGB";
                case 0x80C9:
                    return "GL_BLEND_SRC_RGB";
                case 0x80CA:
                    return "GL_BLEND_DST_ALPHA";
                case 0x80CB:
                    return "GL_BLEND_SRC_ALPHA";
                case 0x80E8:
                    return "GL_MAX_ELEMENTS_VERTICES";
                case 0x80E9:
                    return "GL_MAX_ELEMENTS_INDICES";
                case 0x812D:
                    return "GL_CLAMP_TO_BORDER_OES";
                case 0x81A6:
                    return "GL_DEPTH_COMPONENT24";
                case 0x8210:
                    return "GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT";
                case 0x8218:
                    return "GL_FRAMEBUFFER_DEFAULT";
                case 0x821A:
                    return "GL_DEPTH_STENCIL_ATTACHMENT";
                case 0x821B:
                    return "GL_MAJOR_VERSION";
                case 0x821C:
                    return "GL_MINOR_VERSION";
                case 0x821D:
                    return "GL_NUM_EXTENSIONS";
                case 0x821E:
                    return "GL_CONTEXT_FLAGS";
                case 0x821F:
                    return "GL_BUFFER_IMMUTABLE_STORAGE_EXT";
                case 0x8220:
                    return "GL_BUFFER_STORAGE_FLAGS_EXT";
                case 0x8221:
                    return "GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED";
                case 0x8228:
                    return "GL_RG_INTEGER";
                case 0x8242:
                    return "GL_DEBUG_OUTPUT_SYNCHRONOUS";
                case 0x8243:
                    return "GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH";
                case 0x8244:
                    return "GL_DEBUG_CALLBACK_FUNCTION_KHR";
                case 0x8245:
                    return "GL_DEBUG_CALLBACK_USER_PARAM_KHR";
                case 0x8246:
                    return "GL_DEBUG_SOURCE_API_KHR";
                case 0x8247:
                    return "GL_DEBUG_SOURCE_WINDOW_SYSTEM_KHR";
                case 0x8248:
                    return "GL_DEBUG_SOURCE_SHADER_COMPILER_KHR";
                case 0x8249:
                    return "GL_DEBUG_SOURCE_THIRD_PARTY_KHR";
                case 0x824A:
                    return "GL_DEBUG_SOURCE_APPLICATION_KHR";
                case 0x824B:
                    return "GL_DEBUG_SOURCE_OTHER_KHR";
                case 0x824C:
                    return "GL_DEBUG_TYPE_ERROR_KHR";
                case 0x824D:
                    return "GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_KHR";
                case 0x824E:
                    return "GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_KHR";
                case 0x824F:
                    return "GL_DEBUG_TYPE_PORTABILITY_KHR";
                case 0x8250:
                    return "GL_DEBUG_TYPE_PERFORMANCE_KHR";
                case 0x8251:
                    return "GL_DEBUG_TYPE_OTHER_KHR";
                case 0x8252:
                    return "GL_LOSE_CONTEXT_ON_RESET";
                case 0x8253:
                    return "GL_GUILTY_CONTEXT_RESET_EXT";
                case 0x8254:
                    return "GL_INNOCENT_CONTEXT_RESET_EXT";
                case 0x8255:
                    return "GL_UNKNOWN_CONTEXT_RESET_EXT";
                case 0x8256:
                    return "GL_RESET_NOTIFICATION_STRATEGY";
                case 0x825A:
                    return "GL_PROGRAM_PIPELINE_BINDING";
                case 0x825E:
                    return "GL_LAYER_PROVOKING_VERTEX";
                case 0x8260:
                    return "GL_UNDEFINED_VERTEX";
                case 0x8261:
                    return "GL_NO_RESET_NOTIFICATION";
                case 0x8262:
                    return "GL_MAX_COMPUTE_SHARED_MEMORY_SIZE";
                case 0x8263:
                    return "GL_MAX_COMPUTE_UNIFORM_COMPONENTS";
                case 0x8264:
                    return "GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS";
                case 0x8265:
                    return "GL_MAX_COMPUTE_ATOMIC_COUNTERS";
                case 0x8266:
                    return "GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS";
                case 0x8268:
                    return "GL_DEBUG_TYPE_MARKER_KHR";
                case 0x8269:
                    return "GL_DEBUG_TYPE_PUSH_GROUP_KHR";
                case 0x826A:
                    return "GL_DEBUG_TYPE_POP_GROUP_KHR";
                case 0x826B:
                    return "GL_DEBUG_SEVERITY_NOTIFICATION";
                case 0x826C:
                    return "GL_MAX_DEBUG_GROUP_STACK_DEPTH";
                case 0x826D:
                    return "GL_DEBUG_GROUP_STACK_DEPTH";
                case 0x826E:
                    return "GL_MAX_UNIFORM_LOCATIONS";
                case 0x82D4:
                    return "GL_VERTEX_ATTRIB_BINDING";
                case 0x82D6:
                    return "GL_VERTEX_BINDING_DIVISOR";
                case 0x82D7:
                    return "GL_VERTEX_BINDING_OFFSET";
                case 0x82D8:
                    return "GL_VERTEX_BINDING_STRIDE";
                case 0x82D9:
                    return "GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET";
                case 0x82DA:
                    return "GL_MAX_VERTEX_ATTRIB_BINDINGS";
                case 0x82DF:
                    return "GL_TEXTURE_IMMUTABLE_LEVELS";
                case 0x82E0:
                    return "GL_BUFFER_KHR";
                case 0x82E1:
                    return "GL_SHADER_KHR";
                case 0x82E2:
                    return "GL_PROGRAM_KHR";
                case 0x82E3:
                    return "GL_QUERY_KHR";
                case 0x82E4:
                    return "GL_PROGRAM_PIPELINE_KHR";
                case 0x82E5:
                    return "GL_MAX_VERTEX_ATTRIB_STRIDE";
                case 0x82E6:
                    return "GL_SAMPLER_KHR";
                case 0x82E7:
                    return "GL_DISPLAY_LIST";
                case 0x82E8:
                    return "GL_MAX_LABEL_LENGTH";
                case 0x8363:
                    return "GL_UNSIGNED_SHORT_5_6_5";
                case 0x8370:
                    return "GL_MIRRORED_REPEAT";
                case 0x84E0:
                    return "GL_ACTIVE_TEXTURE";
                case 0x84E8:
                    return "GL_MAX_RENDERBUFFER_SIZE";
                case 0x84F2:
                    return "GL_ALL_COMPLETED_NV";
                case 0x84F3:
                    return "GL_FENCE_STATUS_NV";
                case 0x84F4:
                    return "GL_FENCE_CONDITION_NV";
                case 0x84FA:
                    return "GL_UNSIGNED_INT_24_8";
                case 0x84FD:
                    return "GL_MAX_TEXTURE_LOD_BIAS";
                case 0x84FE:
                    return "GL_TEXTURE_MAX_ANISOTROPY_EXT";
                case 0x84FF:
                    return "GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT";
                case 0x8507:
                    return "GL_INCR_WRAP";
                case 0x8508:
                    return "GL_DECR_WRAP";
                case 0x8511:
                    return "GL_NORMAL_MAP_OES";
                case 0x8512:
                    return "GL_REFLECTION_MAP_OES";
                case 0x8513:
                    return "GL_TEXTURE_CUBE_MAP_OES";
                case 0x8514:
                    return "GL_TEXTURE_BINDING_CUBE_MAP";
                case 0x8515:
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_X_OES";
                case 0x8516:
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_X_OES";
                case 0x8517:
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_Y_OES";
                case 0x8518:
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_OES";
                case 0x8519:
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_Z_OES";
                case 0x851A:
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_OES";
                case 0x851C:
                    return "GL_MAX_CUBE_MAP_TEXTURE_SIZE";
                case 0x8589:
                    return "GL_SRC1_ALPHA_EXT";
                case 0x85B5:
                    return "GL_VERTEX_ARRAY_BINDING";
                case 0x8645:
                    return "GL_VERTEX_ATTRIB_ARRAY_POINTER";
                case 0x86A2:
                    return "GL_NUM_COMPRESSED_TEXTURE_FORMATS";
                case 0x86A3:
                    return "GL_COMPRESSED_TEXTURE_FORMATS";
                case 0x86A4:
                    return "GL_MAX_VERTEX_UNITS_OES";
                case 0x86A9:
                    return "GL_WEIGHT_ARRAY_TYPE_OES";
                case 0x86AA:
                    return "GL_WEIGHT_ARRAY_STRIDE_OES";
                case 0x86AB:
                    return "GL_WEIGHT_ARRAY_SIZE_OES";
                case 0x86AC:
                    return "GL_WEIGHT_ARRAY_POINTER_OES";
                case 0x86AD:
                    return "GL_WEIGHT_ARRAY_OES";
                case 0x8741:
                    return "GL_PROGRAM_BINARY_LENGTH_OES";
                case 0x87FE:
                    return "GL_NUM_PROGRAM_BINARY_FORMATS";
                case 0x87FF:
                    return "GL_PROGRAM_BINARY_FORMATS";
                case 0x8800:
                    return "GL_STENCIL_BACK_FUNC";
                case 0x8801:
                    return "GL_STENCIL_BACK_FAIL";
                case 0x8802:
                    return "GL_STENCIL_BACK_PASS_DEPTH_FAIL";
                case 0x8803:
                    return "GL_STENCIL_BACK_PASS_DEPTH_PASS";
                case 0x8815:
                    return "GL_RGB32F";
                case 0x8816:
                    return "GL_ALPHA32F_EXT";
                case 0x8818:
                    return "GL_LUMINANCE32F_EXT";
                case 0x8819:
                    return "GL_LUMINANCE_ALPHA32F_EXT";
                case 0x881C:
                    return "GL_ALPHA16F_EXT";
                case 0x881E:
                    return "GL_LUMINANCE16F_EXT";
                case 0x881F:
                    return "GL_LUMINANCE_ALPHA16F_EXT";
                case 0x8824:
                    return "GL_MAX_DRAW_BUFFERS";
                case 0x8825:
                    return "GL_DRAW_BUFFER0";
                case 0x8826:
                    return "GL_DRAW_BUFFER1";
                case 0x8827:
                    return "GL_DRAW_BUFFER2";
                case 0x8828:
                    return "GL_DRAW_BUFFER3";
                case 0x8829:
                    return "GL_DRAW_BUFFER4";
                case 0x882A:
                    return "GL_DRAW_BUFFER5";
                case 0x882B:
                    return "GL_DRAW_BUFFER6";
                case 0x882C:
                    return "GL_DRAW_BUFFER7";
                case 0x882D:
                    return "GL_DRAW_BUFFER8";
                case 0x882E:
                    return "GL_DRAW_BUFFER9";
                case 0x882F:
                    return "GL_DRAW_BUFFER10";
                case 0x8830:
                    return "GL_DRAW_BUFFER11";
                case 0x8831:
                    return "GL_DRAW_BUFFER12";
                case 0x8832:
                    return "GL_DRAW_BUFFER13";
                case 0x8833:
                    return "GL_DRAW_BUFFER14";
                case 0x8834:
                    return "GL_DRAW_BUFFER15";
                case 0x883D:
                    return "GL_BLEND_EQUATION_ALPHA";
                case 0x8840:
                    return "GL_MATRIX_PALETTE_OES";
                case 0x8842:
                    return "GL_MAX_PALETTE_MATRICES_OES";
                case 0x8843:
                    return "GL_CURRENT_PALETTE_MATRIX_OES";
                case 0x8844:
                    return "GL_MATRIX_INDEX_ARRAY_OES";
                case 0x8846:
                    return "GL_MATRIX_INDEX_ARRAY_SIZE_OES";
                case 0x8847:
                    return "GL_MATRIX_INDEX_ARRAY_TYPE_OES";
                case 0x8848:
                    return "GL_MATRIX_INDEX_ARRAY_STRIDE_OES";
                case 0x8849:
                    return "GL_MATRIX_INDEX_ARRAY_POINTER_OES";
                case 0x884A:
                    return "GL_TEXTURE_DEPTH_SIZE";
                case 0x884E:
                    return "GL_COMPARE_REF_TO_TEXTURE";
                case 0x8864:
                    return "GL_QUERY_COUNTER_BITS_EXT";
                case 0x8865:
                    return "GL_CURRENT_QUERY_EXT";
                case 0x8866:
                    return "GL_QUERY_RESULT_EXT";
                case 0x8867:
                    return "GL_QUERY_RESULT_AVAILABLE_EXT";
                case 0x8869:
                    return "GL_MAX_VERTEX_ATTRIBS";
                case 0x886C:
                    return "GL_MAX_TESS_CONTROL_INPUT_COMPONENTS";
                case 0x886D:
                    return "GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS";
                case 0x8872:
                    return "GL_MAX_TEXTURE_IMAGE_UNITS";
                case 0x887F:
                    return "GL_GEOMETRY_SHADER_INVOCATIONS";
                case 0x8894:
                    return "GL_ARRAY_BUFFER_BINDING";
                case 0x8895:
                    return "GL_ELEMENT_ARRAY_BUFFER_BINDING";
                case 0x889E:
                    return "GL_WEIGHT_ARRAY_BUFFER_BINDING_OES";
                case 0x88B9:
                    return "GL_WRITE_ONLY_OES";
                case 0x88BB:
                    return "GL_BUFFER_ACCESS_OES";
                case 0x88BC:
                    return "GL_BUFFER_MAPPED_OES";
                case 0x88BD:
                    return "GL_BUFFER_MAP_POINTER";
                case 0x88BF:
                    return "GL_TIME_ELAPSED_EXT";
                case 0x88ED:
                    return "GL_PIXEL_PACK_BUFFER_BINDING";
                case 0x88EF:
                    return "GL_PIXEL_UNPACK_BUFFER_BINDING";
                case 0x88F1:
                    return "GL_TEXTURE_STENCIL_SIZE";
                case 0x88F9:
                    return "GL_SRC1_COLOR_EXT";
                case 0x88FA:
                    return "GL_ONE_MINUS_SRC1_COLOR_EXT";
                case 0x88FB:
                    return "GL_ONE_MINUS_SRC1_ALPHA_EXT";
                case 0x88FC:
                    return "GL_MAX_DUAL_SOURCE_DRAW_BUFFERS_EXT";
                case 0x88FE:
                    return "GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE";
                case 0x88FF:
                    return "GL_MAX_ARRAY_TEXTURE_LAYERS";
                case 0x8904:
                    return "GL_MIN_PROGRAM_TEXEL_OFFSET";
                case 0x8905:
                    return "GL_MAX_PROGRAM_TEXEL_OFFSET";
                case 0x8916:
                    return "GL_GEOMETRY_LINKED_VERTICES_OUT_EXT";
                case 0x8917:
                    return "GL_GEOMETRY_LINKED_INPUT_TYPE_EXT";
                case 0x8918:
                    return "GL_GEOMETRY_LINKED_OUTPUT_TYPE_EXT";
                case 0x8919:
                    return "GL_SAMPLER_BINDING";
                case 0x898A:
                    return "GL_POINT_SIZE_ARRAY_TYPE_OES";
                case 0x898B:
                    return "GL_POINT_SIZE_ARRAY_STRIDE_OES";
                case 0x898C:
                    return "GL_POINT_SIZE_ARRAY_POINTER_OES";
                case 0x8A28:
                    return "GL_UNIFORM_BUFFER_BINDING";
                case 0x8A29:
                    return "GL_UNIFORM_BUFFER_START";
                case 0x8A2A:
                    return "GL_UNIFORM_BUFFER_SIZE";
                case 0x8A2B:
                    return "GL_MAX_VERTEX_UNIFORM_BLOCKS";
                case 0x8A2C:
                    return "GL_MAX_GEOMETRY_UNIFORM_BLOCKS";
                case 0x8A2D:
                    return "GL_MAX_FRAGMENT_UNIFORM_BLOCKS";
                case 0x8A2E:
                    return "GL_MAX_COMBINED_UNIFORM_BLOCKS";
                case 0x8A2F:
                    return "GL_MAX_UNIFORM_BUFFER_BINDINGS";
                case 0x8A30:
                    return "GL_MAX_UNIFORM_BLOCK_SIZE";
                case 0x8A31:
                    return "GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS";
                case 0x8A32:
                    return "GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS";
                case 0x8A33:
                    return "GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS";
                case 0x8A34:
                    return "GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT";
                case 0x8B49:
                    return "GL_MAX_FRAGMENT_UNIFORM_COMPONENTS";
                case 0x8B4A:
                    return "GL_MAX_VERTEX_UNIFORM_COMPONENTS";
                case 0x8B4B:
                    return "GL_MAX_VARYING_COMPONENTS";
                case 0x8B4C:
                    return "GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS";
                case 0x8B4D:
                    return "GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS";
                case 0x8B8D:
                    return "GL_CURRENT_PROGRAM";
                case 0x8B9C:
                    return "GL_POINT_SIZE_ARRAY_OES";
                case 0x8B9D:
                    return "GL_TEXTURE_CROP_RECT_OES";
                case 0x8B9E:
                    return "GL_MATRIX_INDEX_ARRAY_BUFFER_BINDING_OES";
                case 0x8B9F:
                    return "GL_POINT_SIZE_ARRAY_BUFFER_BINDING_OES";
                case 0x8C10:
                    return "GL_TEXTURE_RED_TYPE";
                case 0x8C11:
                    return "GL_TEXTURE_GREEN_TYPE";
                case 0x8C12:
                    return "GL_TEXTURE_BLUE_TYPE";
                case 0x8C13:
                    return "GL_TEXTURE_ALPHA_TYPE";
                case 0x8C16:
                    return "GL_TEXTURE_DEPTH_TYPE";
                case 0x8C17:
                    return "GL_UNSIGNED_NORMALIZED";
                case 0x8C1D:
                    return "GL_TEXTURE_BINDING_2D_ARRAY";
                case 0x8C29:
                    return "GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS";
                case 0x8C2A:
                    return "GL_TEXTURE_BUFFER_BINDING";
                case 0x8C2B:
                    return "GL_MAX_TEXTURE_BUFFER_SIZE";
                case 0x8C2C:
                    return "GL_TEXTURE_BINDING_BUFFER";
                case 0x8C2D:
                    return "GL_TEXTURE_BUFFER_DATA_STORE_BINDING";
                case 0x8C2F:
                    return "GL_ANY_SAMPLES_PASSED_EXT";
                case 0x8C36:
                    return "GL_SAMPLE_SHADING";
                case 0x8C37:
                    return "GL_MIN_SAMPLE_SHADING_VALUE";
                case 0x8C3E:
                    return "GL_UNSIGNED_INT_5_9_9_9_REV";
                case 0x8C3F:
                    return "GL_TEXTURE_SHARED_SIZE";
                case 0x8C80:
                    return "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS";
                case 0x8C87:
                    return "GL_PRIMITIVES_GENERATED_EXT";
                case 0x8C89:
                    return "GL_RASTERIZER_DISCARD";
                case 0x8C8A:
                    return "GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS";
                case 0x8C8B:
                    return "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS";
                case 0x8C8C:
                    return "GL_INTERLEAVED_ATTRIBS";
                case 0x8C8D:
                    return "GL_SEPARATE_ATTRIBS";
                case 0x8CA3:
                    return "GL_STENCIL_BACK_REF";
                case 0x8CA4:
                    return "GL_STENCIL_BACK_VALUE_MASK";
                case 0x8CA5:
                    return "GL_STENCIL_BACK_WRITEMASK";
                case 0x8CA6:
                    return "GL_DRAW_FRAMEBUFFER_BINDING";
                case 0x8CA7:
                    return "GL_RENDERBUFFER_BINDING";
                case 0x8CA8:
                    return "GL_READ_FRAMEBUFFER_ANGLE";
                case 0x8CA9:
                    return "GL_DRAW_FRAMEBUFFER_ANGLE";
                case 0x8CAA:
                    return "GL_READ_FRAMEBUFFER_BINDING";
                case 0x8CAB:
                    return "GL_RENDERBUFFER_SAMPLES_ANGLE";
                case 0x8CD0:
                    return "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE";
                case 0x8CD1:
                    return "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_OES";
                case 0x8CD2:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_OES";
                case 0x8CD3:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_OES";
                case 0x8CD4:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_OES";
                case 0x8CD5:
                    return "GL_FRAMEBUFFER_COMPLETE_OES";
                case 0x8CD6:
                    return "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_OES";
                case 0x8CD7:
                    return "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_OES";
                case 0x8CD9:
                    return "GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS";
                case 0x8CDA:
                    return "GL_FRAMEBUFFER_INCOMPLETE_FORMATS_OES";
                case 0x8CDD:
                    return "GL_FRAMEBUFFER_UNSUPPORTED_OES";
                case 0x8D20:
                    return "GL_STENCIL_ATTACHMENT";
                case 0x8D40:
                    return "GL_FRAMEBUFFER_OES";
                case 0x8D41:
                    return "GL_RENDERBUFFER_OES";
                case 0x8D42:
                    return "GL_RENDERBUFFER_WIDTH_OES";
                case 0x8D43:
                    return "GL_RENDERBUFFER_HEIGHT_OES";
                case 0x8D44:
                    return "GL_RENDERBUFFER_INTERNAL_FORMAT_OES";
                case 0x8D48:
                    return "GL_STENCIL_INDEX8";
                case 0x8D50:
                    return "GL_RENDERBUFFER_RED_SIZE_OES";
                case 0x8D51:
                    return "GL_RENDERBUFFER_GREEN_SIZE_OES";
                case 0x8D52:
                    return "GL_RENDERBUFFER_BLUE_SIZE_OES";
                case 0x8D53:
                    return "GL_RENDERBUFFER_ALPHA_SIZE_OES";
                case 0x8D54:
                    return "GL_RENDERBUFFER_DEPTH_SIZE_OES";
                case 0x8D55:
                    return "GL_RENDERBUFFER_STENCIL_SIZE_OES";
                case 0x8D56:
                    return "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_ANGLE";
                case 0x8D57:
                    return "GL_MAX_SAMPLES";
                case 0x8D60:
                    return "GL_TEXTURE_GEN_STR_OES";
                case 0x8D62:
                    return "GL_RGB565";
                case 0x8D69:
                    return "GL_PRIMITIVE_RESTART_FIXED_INDEX";
                case 0x8D6A:
                    return "GL_ANY_SAMPLES_PASSED_CONSERVATIVE_EXT";
                case 0x8D6B:
                    return "GL_MAX_ELEMENT_INDEX";
                case 0x8D6C:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_SAMPLES_EXT";
                case 0x8D94:
                    return "GL_RED_INTEGER";
                case 0x8D98:
                    return "GL_RGB_INTEGER";
                case 0x8D99:
                    return "GL_RGBA_INTEGER";
                case 0x8DA7:
                    return "GL_FRAMEBUFFER_ATTACHMENT_LAYERED_EXT";
                case 0x8DA8:
                    return "GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_EXT";
                case 0x8DAD:
                    return "GL_FLOAT_32_UNSIGNED_INT_24_8_REV";
                case 0x8DC1:
                    return "GL_SAMPLER_2D_ARRAY";
                case 0x8DC2:
                    return "GL_SAMPLER_BUFFER";
                case 0x8DC4:
                    return "GL_SAMPLER_2D_ARRAY_SHADOW";
                case 0x8DC5:
                    return "GL_SAMPLER_CUBE_SHADOW";
                case 0x8DC6:
                    return "GL_UNSIGNED_INT_VEC2";
                case 0x8DC7:
                    return "GL_UNSIGNED_INT_VEC3";
                case 0x8DC8:
                    return "GL_UNSIGNED_INT_VEC4";
                case 0x8DCA:
                    return "GL_INT_SAMPLER_2D";
                case 0x8DCB:
                    return "GL_INT_SAMPLER_3D";
                case 0x8DCC:
                    return "GL_INT_SAMPLER_CUBE";
                case 0x8DCF:
                    return "GL_INT_SAMPLER_2D_ARRAY";
                case 0x8DD0:
                    return "GL_INT_SAMPLER_BUFFER";
                case 0x8DD2:
                    return "GL_UNSIGNED_INT_SAMPLER_2D";
                case 0x8DD3:
                    return "GL_UNSIGNED_INT_SAMPLER_3D";
                case 0x8DD4:
                    return "GL_UNSIGNED_INT_SAMPLER_CUBE";
                case 0x8DD7:
                    return "GL_UNSIGNED_INT_SAMPLER_2D_ARRAY";
                case 0x8DD8:
                    return "GL_UNSIGNED_INT_SAMPLER_BUFFER";
                case 0x8DD9:
                    return "GL_GEOMETRY_SHADER_EXT";
                case 0x8DDF:
                    return "GL_MAX_GEOMETRY_UNIFORM_COMPONENTS";
                case 0x8DE0:
                    return "GL_MAX_GEOMETRY_OUTPUT_VERTICES";
                case 0x8DE1:
                    return "GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS";
                case 0x8DF8:
                    return "GL_SHADER_BINARY_FORMATS";
                case 0x8DF9:
                    return "GL_NUM_SHADER_BINARY_FORMATS";
                case 0x8DFA:
                    return "GL_SHADER_COMPILER";
                case 0x8DFB:
                    return "GL_MAX_VERTEX_UNIFORM_VECTORS";
                case 0x8DFC:
                    return "GL_MAX_VARYING_VECTORS";
                case 0x8DFD:
                    return "GL_MAX_FRAGMENT_UNIFORM_VECTORS";
                case 0x8E1E:
                    return "GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS";
                case 0x8E1F:
                    return "GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS";
                case 0x8E25:
                    return "GL_TRANSFORM_FEEDBACK_BINDING";
                case 0x8E28:
                    return "GL_TIMESTAMP_EXT";
                case 0x8E4D:
                    return "GL_FIRST_VERTEX_CONVENTION_EXT";
                case 0x8E4E:
                    return "GL_LAST_VERTEX_CONVENTION_EXT";
                case 0x8E4F:
                    return "GL_PROVOKING_VERTEX";
                case 0x8E50:
                    return "GL_SAMPLE_POSITION";
                case 0x8E51:
                    return "GL_SAMPLE_MASK";
                case 0x8E52:
                    return "GL_SAMPLE_MASK_VALUE";
                case 0x8E59:
                    return "GL_MAX_SAMPLE_MASK_WORDS";
                case 0x8E5A:
                    return "GL_MAX_GEOMETRY_SHADER_INVOCATIONS";
                case 0x8E5B:
                    return "GL_MIN_FRAGMENT_INTERPOLATION_OFFSET";
                case 0x8E5C:
                    return "GL_MAX_FRAGMENT_INTERPOLATION_OFFSET";
                case 0x8E5D:
                    return "GL_FRAGMENT_INTERPOLATION_OFFSET_BITS";
                case 0x8E5E:
                    return "GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET";
                case 0x8E5F:
                    return "GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET";
                case 0x8E75:
                    return "GL_TESS_CONTROL_OUTPUT_VERTICES";
                case 0x8E76:
                    return "GL_TESS_GEN_MODE";
                case 0x8E77:
                    return "GL_TESS_GEN_SPACING";
                case 0x8E78:
                    return "GL_TESS_GEN_VERTEX_ORDER";
                case 0x8E79:
                    return "GL_TESS_GEN_POINT_MODE";
                case 0x8E7A:
                    return "GL_ISOLINES";
                case 0x8E7B:
                    return "GL_FRACTIONAL_ODD";
                case 0x8E7C:
                    return "GL_FRACTIONAL_EVEN";
                case 0x8E7D:
                    return "GL_MAX_PATCH_VERTICES";
                case 0x8E7E:
                    return "GL_MAX_TESS_GEN_LEVEL";
                case 0x8E7F:
                    return "GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS";
                case 0x8E80:
                    return "GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS";
                case 0x8E81:
                    return "GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS";
                case 0x8E82:
                    return "GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS";
                case 0x8E83:
                    return "GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS";
                case 0x8E84:
                    return "GL_MAX_TESS_PATCH_COMPONENTS";
                case 0x8E85:
                    return "GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS";
                case 0x8E86:
                    return "GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS";
                case 0x8E89:
                    return "GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS";
                case 0x8E8A:
                    return "GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS";
                case 0x8F36:
                    return "GL_COPY_READ_BUFFER_BINDING";
                case 0x8F37:
                    return "GL_COPY_WRITE_BUFFER_BINDING";
                case 0x8F38:
                    return "GL_MAX_IMAGE_UNITS";
                case 0x8F39:
                    return "GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES";
                case 0x8F3A:
                    return "GL_IMAGE_BINDING_NAME";
                case 0x8F3B:
                    return "GL_IMAGE_BINDING_LEVEL";
                case 0x8F3C:
                    return "GL_IMAGE_BINDING_LAYERED";
                case 0x8F3D:
                    return "GL_IMAGE_BINDING_LAYER";
                case 0x8F3E:
                    return "GL_IMAGE_BINDING_ACCESS";
                case 0x8F43:
                    return "GL_DRAW_INDIRECT_BUFFER_BINDING";
                case 0x8F4F:
                    return "GL_VERTEX_BINDING_BUFFER";
                case 0x8F9C:
                    return "GL_SIGNED_NORMALIZED";
                case 0x8FBB:
                    return "GL_GPU_DISJOINT_EXT";
                case 0x8FBD:
                    return "GL_SR8_EXT";
                case 0x900A:
                    return "GL_TEXTURE_BINDING_CUBE_MAP_ARRAY";
                case 0x900C:
                    return "GL_SAMPLER_CUBE_MAP_ARRAY";
                case 0x900D:
                    return "GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW";
                case 0x900E:
                    return "GL_INT_SAMPLER_CUBE_MAP_ARRAY";
                case 0x900F:
                    return "GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY";
                case 0x904D:
                    return "GL_IMAGE_2D";
                case 0x904E:
                    return "GL_IMAGE_3D";
                case 0x9050:
                    return "GL_IMAGE_CUBE";
                case 0x9051:
                    return "GL_IMAGE_BUFFER";
                case 0x9053:
                    return "GL_IMAGE_2D_ARRAY";
                case 0x9054:
                    return "GL_IMAGE_CUBE_MAP_ARRAY";
                case 0x9058:
                    return "GL_INT_IMAGE_2D";
                case 0x9059:
                    return "GL_INT_IMAGE_3D";
                case 0x905B:
                    return "GL_INT_IMAGE_CUBE";
                case 0x905C:
                    return "GL_INT_IMAGE_BUFFER";
                case 0x905E:
                    return "GL_INT_IMAGE_2D_ARRAY";
                case 0x905F:
                    return "GL_INT_IMAGE_CUBE_MAP_ARRAY";
                case 0x9063:
                    return "GL_UNSIGNED_INT_IMAGE_2D";
                case 0x9064:
                    return "GL_UNSIGNED_INT_IMAGE_3D";
                case 0x9066:
                    return "GL_UNSIGNED_INT_IMAGE_CUBE";
                case 0x9067:
                    return "GL_UNSIGNED_INT_IMAGE_BUFFER";
                case 0x9069:
                    return "GL_UNSIGNED_INT_IMAGE_2D_ARRAY";
                case 0x906A:
                    return "GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY";
                case 0x906E:
                    return "GL_IMAGE_BINDING_FORMAT";
                case 0x90C8:
                    return "GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE";
                case 0x90C9:
                    return "GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS";
                case 0x90CA:
                    return "GL_MAX_VERTEX_IMAGE_UNIFORMS";
                case 0x90CB:
                    return "GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS";
                case 0x90CC:
                    return "GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS";
                case 0x90CD:
                    return "GL_MAX_GEOMETRY_IMAGE_UNIFORMS";
                case 0x90CE:
                    return "GL_MAX_FRAGMENT_IMAGE_UNIFORMS";
                case 0x90CF:
                    return "GL_MAX_COMBINED_IMAGE_UNIFORMS";
                case 0x90D3:
                    return "GL_SHADER_STORAGE_BUFFER_BINDING";
                case 0x90D4:
                    return "GL_SHADER_STORAGE_BUFFER_START";
                case 0x90D5:
                    return "GL_SHADER_STORAGE_BUFFER_SIZE";
                case 0x90D6:
                    return "GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS";
                case 0x90D7:
                    return "GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS";
                case 0x90D8:
                    return "GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS";
                case 0x90D9:
                    return "GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS";
                case 0x90DA:
                    return "GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS";
                case 0x90DB:
                    return "GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS";
                case 0x90DC:
                    return "GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS";
                case 0x90DD:
                    return "GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS";
                case 0x90DE:
                    return "GL_MAX_SHADER_STORAGE_BLOCK_SIZE";
                case 0x90DF:
                    return "GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT";
                case 0x90EB:
                    return "GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS";
                case 0x90EF:
                    return "GL_DISPATCH_INDIRECT_BUFFER_BINDING";
                case 0x90F3:
                    return "GL_CONTEXT_ROBUST_ACCESS_EXT";
                case 0x9102:
                    return "GL_TEXTURE_2D_MULTISAMPLE_ARRAY_OES";
                case 0x9104:
                    return "GL_TEXTURE_BINDING_2D_MULTISAMPLE";
                case 0x9105:
                    return "GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY";
                case 0x9106:
                    return "GL_TEXTURE_SAMPLES";
                case 0x9107:
                    return "GL_TEXTURE_FIXED_SAMPLE_LOCATIONS";
                case 0x9108:
                    return "GL_SAMPLER_2D_MULTISAMPLE";
                case 0x9109:
                    return "GL_INT_SAMPLER_2D_MULTISAMPLE";
                case 0x910A:
                    return "GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE";
                case 0x910B:
                    return "GL_SAMPLER_2D_MULTISAMPLE_ARRAY";
                case 0x910C:
                    return "GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY";
                case 0x910D:
                    return "GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY";
                case 0x910E:
                    return "GL_MAX_COLOR_TEXTURE_SAMPLES";
                case 0x910F:
                    return "GL_MAX_DEPTH_TEXTURE_SAMPLES";
                case 0x9110:
                    return "GL_MAX_INTEGER_SAMPLES";
                case 0x9111:
                    return "GL_MAX_SERVER_WAIT_TIMEOUT";
                case 0x9116:
                    return "GL_SYNC_FENCE";
                case 0x9118:
                    return "GL_UNSIGNALED";
                case 0x9119:
                    return "GL_SIGNALED";
                case 0x9122:
                    return "GL_MAX_VERTEX_OUTPUT_COMPONENTS";
                case 0x9123:
                    return "GL_MAX_GEOMETRY_INPUT_COMPONENTS";
                case 0x9124:
                    return "GL_MAX_GEOMETRY_OUTPUT_COMPONENTS";
                case 0x9125:
                    return "GL_MAX_FRAGMENT_INPUT_COMPONENTS";
                case 0x912F:
                    return "GL_TEXTURE_IMMUTABLE_FORMAT";
                case 0x9143:
                    return "GL_MAX_DEBUG_MESSAGE_LENGTH";
                case 0x9144:
                    return "GL_MAX_DEBUG_LOGGED_MESSAGES";
                case 0x9145:
                    return "GL_DEBUG_LOGGED_MESSAGES";
                case 0x9146:
                    return "GL_DEBUG_SEVERITY_HIGH_KHR";
                case 0x9147:
                    return "GL_DEBUG_SEVERITY_MEDIUM_KHR";
                case 0x9148:
                    return "GL_DEBUG_SEVERITY_LOW_KHR";
                case 0x919D:
                    return "GL_TEXTURE_BUFFER_OFFSET";
                case 0x919E:
                    return "GL_TEXTURE_BUFFER_SIZE";
                case 0x919F:
                    return "GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT";
                case 0x91B0:
                    return "GL_MAX_SHADER_COMPILER_THREADS_KHR";
                case 0x91B1:
                    return "GL_COMPLETION_STATUS_KHR";
                case 0x91BB:
                    return "GL_MAX_COMPUTE_UNIFORM_BLOCKS";
                case 0x91BC:
                    return "GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS";
                case 0x91BD:
                    return "GL_MAX_COMPUTE_IMAGE_UNIFORMS";
                case 0x91BE:
                    return "GL_MAX_COMPUTE_WORK_GROUP_COUNT";
                case 0x91BF:
                    return "GL_MAX_COMPUTE_WORK_GROUP_SIZE";
                case 0x9294:
                    return "GL_MULTIPLY";
                case 0x9295:
                    return "GL_SCREEN";
                case 0x9296:
                    return "GL_OVERLAY";
                case 0x9297:
                    return "GL_DARKEN";
                case 0x9298:
                    return "GL_LIGHTEN";
                case 0x9299:
                    return "GL_COLORDODGE";
                case 0x929A:
                    return "GL_COLORBURN";
                case 0x929B:
                    return "GL_HARDLIGHT";
                case 0x929C:
                    return "GL_SOFTLIGHT";
                case 0x929E:
                    return "GL_DIFFERENCE";
                case 0x92A0:
                    return "GL_EXCLUSION";
                case 0x92AD:
                    return "GL_HSL_HUE";
                case 0x92AE:
                    return "GL_HSL_SATURATION";
                case 0x92AF:
                    return "GL_HSL_COLOR";
                case 0x92B0:
                    return "GL_HSL_LUMINOSITY";
                case 0x92BE:
                    return "GL_PRIMITIVE_BOUNDING_BOX";
                case 0x92C2:
                    return "GL_ATOMIC_COUNTER_BUFFER_START";
                case 0x92C3:
                    return "GL_ATOMIC_COUNTER_BUFFER_SIZE";
                case 0x92CC:
                    return "GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS";
                case 0x92CD:
                    return "GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS";
                case 0x92CE:
                    return "GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS";
                case 0x92CF:
                    return "GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS";
                case 0x92D0:
                    return "GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS";
                case 0x92D1:
                    return "GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS";
                case 0x92D2:
                    return "GL_MAX_VERTEX_ATOMIC_COUNTERS";
                case 0x92D3:
                    return "GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS";
                case 0x92D4:
                    return "GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS";
                case 0x92D5:
                    return "GL_MAX_GEOMETRY_ATOMIC_COUNTERS";
                case 0x92D6:
                    return "GL_MAX_FRAGMENT_ATOMIC_COUNTERS";
                case 0x92D7:
                    return "GL_MAX_COMBINED_ATOMIC_COUNTERS";
                case 0x92D8:
                    return "GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE";
                case 0x92DB:
                    return "GL_UNSIGNED_INT_ATOMIC_COUNTER";
                case 0x92DC:
                    return "GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS";
                case 0x92E0:
                    return "GL_DEBUG_OUTPUT";
                case 0x92E7:
                    return "GL_IS_PER_PATCH";
                case 0x92F9:
                    return "GL_NAME_LENGTH";
                case 0x92FA:
                    return "GL_TYPE";
                case 0x92FB:
                    return "GL_ARRAY_SIZE";
                case 0x92FC:
                    return "GL_OFFSET";
                case 0x92FD:
                    return "GL_BLOCK_INDEX";
                case 0x92FE:
                    return "GL_ARRAY_STRIDE";
                case 0x92FF:
                    return "GL_MATRIX_STRIDE";
                case 0x9300:
                    return "GL_IS_ROW_MAJOR";
                case 0x9301:
                    return "GL_ATOMIC_COUNTER_BUFFER_INDEX";
                case 0x9302:
                    return "GL_BUFFER_BINDING";
                case 0x9303:
                    return "GL_BUFFER_DATA_SIZE";
                case 0x9304:
                    return "GL_NUM_ACTIVE_VARIABLES";
                case 0x9305:
                    return "GL_ACTIVE_VARIABLES";
                case 0x9306:
                    return "GL_REFERENCED_BY_VERTEX_SHADER";
                case 0x9307:
                    return "GL_REFERENCED_BY_TESS_CONTROL_SHADER";
                case 0x9308:
                    return "GL_REFERENCED_BY_TESS_EVALUATION_SHADER";
                case 0x9309:
                    return "GL_REFERENCED_BY_GEOMETRY_SHADER";
                case 0x930A:
                    return "GL_REFERENCED_BY_FRAGMENT_SHADER";
                case 0x930B:
                    return "GL_REFERENCED_BY_COMPUTE_SHADER";
                case 0x930C:
                    return "GL_TOP_LEVEL_ARRAY_SIZE";
                case 0x930D:
                    return "GL_TOP_LEVEL_ARRAY_STRIDE";
                case 0x930E:
                    return "GL_LOCATION";
                case 0x930F:
                    return "GL_LOCATION_INDEX_EXT";
                case 0x9312:
                    return "GL_FRAMEBUFFER_DEFAULT_LAYERS_EXT";
                case 0x9315:
                    return "GL_MAX_FRAMEBUFFER_WIDTH";
                case 0x9316:
                    return "GL_MAX_FRAMEBUFFER_HEIGHT";
                case 0x9317:
                    return "GL_MAX_FRAMEBUFFER_LAYERS";
                case 0x9318:
                    return "GL_MAX_FRAMEBUFFER_SAMPLES";
                case 0x9381:
                    return "GL_MULTISAMPLE_LINE_WIDTH_RANGE";
                case 0x9382:
                    return "GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY";
                case 0x93A0:
                    return "GL_TRANSLATED_SHADER_SOURCE_LENGTH_ANGLE";
                case 0x93A1:
                    return "GL_BGRA8_EXT";
                case 0x93A6:
                    return "GL_PROGRAM_BINARY_ANGLE";
                case 0x93AE:
                    return "GL_HANDLE_TYPE_ZIRCON_VMO_ANGLE";
                case 0x93AF:
                    return "GL_HANDLE_TYPE_ZIRCON_EVENT_ANGLE";
                case 0x93B0:
                    return "GL_COMPRESSED_RGBA_ASTC_4x4";
                case 0x93B1:
                    return "GL_COMPRESSED_RGBA_ASTC_5x4";
                case 0x93B2:
                    return "GL_COMPRESSED_RGBA_ASTC_5x5";
                case 0x93B3:
                    return "GL_COMPRESSED_RGBA_ASTC_6x5";
                case 0x93B4:
                    return "GL_COMPRESSED_RGBA_ASTC_6x6";
                case 0x93B5:
                    return "GL_COMPRESSED_RGBA_ASTC_8x5";
                case 0x93B6:
                    return "GL_COMPRESSED_RGBA_ASTC_8x6";
                case 0x93B7:
                    return "GL_COMPRESSED_RGBA_ASTC_8x8";
                case 0x93B8:
                    return "GL_COMPRESSED_RGBA_ASTC_10x5";
                case 0x93B9:
                    return "GL_COMPRESSED_RGBA_ASTC_10x6";
                case 0x93BA:
                    return "GL_COMPRESSED_RGBA_ASTC_10x8";
                case 0x93BB:
                    return "GL_COMPRESSED_RGBA_ASTC_10x10";
                case 0x93BC:
                    return "GL_COMPRESSED_RGBA_ASTC_12x10";
                case 0x93BD:
                    return "GL_COMPRESSED_RGBA_ASTC_12x12";
                case 0x93D0:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4";
                case 0x93D1:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4";
                case 0x93D2:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5";
                case 0x93D3:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5";
                case 0x93D4:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6";
                case 0x93D5:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5";
                case 0x93D6:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6";
                case 0x93D7:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8";
                case 0x93D8:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5";
                case 0x93D9:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6";
                case 0x93DA:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8";
                case 0x93DB:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10";
                case 0x93DC:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10";
                case 0x93DD:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12";
                case 0x9582:
                    return "GL_NUM_TILING_TYPES_EXT";
                case 0x9583:
                    return "GL_TILING_TYPES_EXT";
                case 0x9584:
                    return "GL_OPTIMAL_TILING_EXT";
                case 0x9585:
                    return "GL_LINEAR_TILING_EXT";
                case 0x9630:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR";
                case 0x9631:
                    return "GL_MAX_VIEWS_OVR";
                case 0x9632:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR";
                case 0x9633:
                    return "GL_FRAMEBUFFER_INCOMPLETE_VIEW_TARGETS_OVR";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::DepthFunction:
        {
            switch (value)
            {
                case 0x200:
                    return "GL_NEVER";
                case 0x201:
                    return "GL_LESS";
                case 0x202:
                    return "GL_EQUAL";
                case 0x203:
                    return "GL_LEQUAL";
                case 0x204:
                    return "GL_GREATER";
                case 0x205:
                    return "GL_NOTEQUAL";
                case 0x206:
                    return "GL_GEQUAL";
                case 0x207:
                    return "GL_ALWAYS";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::DrawBufferMode:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                case 0x404:
                    return "GL_FRONT";
                case 0x405:
                    return "GL_BACK";
                case 0x408:
                    return "GL_FRONT_AND_BACK";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::DrawElementsType:
        {
            switch (value)
            {
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::EnableCap:
        {
            switch (value)
            {
                case 0xB44:
                    return "GL_CULL_FACE";
                case 0xB71:
                    return "GL_DEPTH_TEST";
                case 0xB90:
                    return "GL_STENCIL_TEST";
                case 0xBD0:
                    return "GL_DITHER";
                case 0xBE2:
                    return "GL_BLEND";
                case 0xC11:
                    return "GL_SCISSOR_TEST";
                case 0xDE1:
                    return "GL_TEXTURE_2D";
                case 0x8037:
                    return "GL_POLYGON_OFFSET_FILL";
                case 0x8074:
                    return "GL_VERTEX_ARRAY";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::ErrorCode:
        {
            switch (value)
            {
                case 0x500:
                    return "GL_INVALID_ENUM";
                case 0x501:
                    return "GL_INVALID_VALUE";
                case 0x502:
                    return "GL_INVALID_OPERATION";
                case 0x503:
                    return "GL_STACK_OVERFLOW";
                case 0x504:
                    return "GL_STACK_UNDERFLOW";
                case 0x505:
                    return "GL_OUT_OF_MEMORY";
                case 0x506:
                    return "GL_INVALID_FRAMEBUFFER_OPERATION";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::ExternalHandleType:
        {
            switch (value)
            {
                case 0x9586:
                    return "GL_HANDLE_TYPE_OPAQUE_FD_EXT";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::FogCoordinatePointerType:
        {
            switch (value)
            {
                case 0x1406:
                    return "GL_FLOAT";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::FogMode:
        {
            switch (value)
            {
                case 0x2601:
                    return "GL_LINEAR";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::FogPointerTypeEXT:
        {
            switch (value)
            {
                case 0x1406:
                    return "GL_FLOAT";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::FogPointerTypeIBM:
        {
            switch (value)
            {
                case 0x1406:
                    return "GL_FLOAT";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::FramebufferAttachment:
        {
            switch (value)
            {
                case 0x8CDF:
                    return "GL_MAX_COLOR_ATTACHMENTS";
                case 0x8CE0:
                    return "GL_COLOR_ATTACHMENT0";
                case 0x8CE1:
                    return "GL_COLOR_ATTACHMENT1";
                case 0x8CE2:
                    return "GL_COLOR_ATTACHMENT2";
                case 0x8CE3:
                    return "GL_COLOR_ATTACHMENT3";
                case 0x8CE4:
                    return "GL_COLOR_ATTACHMENT4";
                case 0x8CE5:
                    return "GL_COLOR_ATTACHMENT5";
                case 0x8CE6:
                    return "GL_COLOR_ATTACHMENT6";
                case 0x8CE7:
                    return "GL_COLOR_ATTACHMENT7";
                case 0x8CE8:
                    return "GL_COLOR_ATTACHMENT8";
                case 0x8CE9:
                    return "GL_COLOR_ATTACHMENT9";
                case 0x8CEA:
                    return "GL_COLOR_ATTACHMENT10";
                case 0x8CEB:
                    return "GL_COLOR_ATTACHMENT11";
                case 0x8CEC:
                    return "GL_COLOR_ATTACHMENT12";
                case 0x8CED:
                    return "GL_COLOR_ATTACHMENT13";
                case 0x8CEE:
                    return "GL_COLOR_ATTACHMENT14";
                case 0x8CEF:
                    return "GL_COLOR_ATTACHMENT15";
                case 0x8CF0:
                    return "GL_COLOR_ATTACHMENT16";
                case 0x8CF1:
                    return "GL_COLOR_ATTACHMENT17";
                case 0x8CF2:
                    return "GL_COLOR_ATTACHMENT18";
                case 0x8CF3:
                    return "GL_COLOR_ATTACHMENT19";
                case 0x8CF4:
                    return "GL_COLOR_ATTACHMENT20";
                case 0x8CF5:
                    return "GL_COLOR_ATTACHMENT21";
                case 0x8CF6:
                    return "GL_COLOR_ATTACHMENT22";
                case 0x8CF7:
                    return "GL_COLOR_ATTACHMENT23";
                case 0x8CF8:
                    return "GL_COLOR_ATTACHMENT24";
                case 0x8CF9:
                    return "GL_COLOR_ATTACHMENT25";
                case 0x8CFA:
                    return "GL_COLOR_ATTACHMENT26";
                case 0x8CFB:
                    return "GL_COLOR_ATTACHMENT27";
                case 0x8CFC:
                    return "GL_COLOR_ATTACHMENT28";
                case 0x8CFD:
                    return "GL_COLOR_ATTACHMENT29";
                case 0x8CFE:
                    return "GL_COLOR_ATTACHMENT30";
                case 0x8CFF:
                    return "GL_COLOR_ATTACHMENT31";
                case 0x8D00:
                    return "GL_DEPTH_ATTACHMENT";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::FramebufferAttachmentParameterName:
        {
            switch (value)
            {
                case 0x8210:
                    return "GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING";
                case 0x8211:
                    return "GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE";
                case 0x8212:
                    return "GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE";
                case 0x8213:
                    return "GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE";
                case 0x8214:
                    return "GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE";
                case 0x8215:
                    return "GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE";
                case 0x8216:
                    return "GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE";
                case 0x8217:
                    return "GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE";
                case 0x8CD1:
                    return "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME";
                case 0x8CD2:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL";
                case 0x8CD3:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE";
                case 0x8CD4:
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER";
                case 0x8DA7:
                    return "GL_FRAMEBUFFER_ATTACHMENT_LAYERED";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::FramebufferParameterName:
        {
            switch (value)
            {
                case 0x9310:
                    return "GL_FRAMEBUFFER_DEFAULT_WIDTH";
                case 0x9311:
                    return "GL_FRAMEBUFFER_DEFAULT_HEIGHT";
                case 0x9312:
                    return "GL_FRAMEBUFFER_DEFAULT_LAYERS";
                case 0x9313:
                    return "GL_FRAMEBUFFER_DEFAULT_SAMPLES";
                case 0x9314:
                    return "GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::FramebufferStatus:
        {
            switch (value)
            {
                case 0x8219:
                    return "GL_FRAMEBUFFER_UNDEFINED";
                case 0x8CD5:
                    return "GL_FRAMEBUFFER_COMPLETE";
                case 0x8CD6:
                    return "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT";
                case 0x8CD7:
                    return "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";
                case 0x8CDD:
                    return "GL_FRAMEBUFFER_UNSUPPORTED";
                case 0x8D56:
                    return "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE";
                case 0x8DA8:
                    return "GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::FramebufferTarget:
        {
            switch (value)
            {
                case 0x8CA8:
                    return "GL_READ_FRAMEBUFFER";
                case 0x8CA9:
                    return "GL_DRAW_FRAMEBUFFER";
                case 0x8D40:
                    return "GL_FRAMEBUFFER";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::FrontFaceDirection:
        {
            switch (value)
            {
                case 0x900:
                    return "GL_CW";
                case 0x901:
                    return "GL_CCW";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::GetFramebufferParameter:
        {
            switch (value)
            {
                case 0x80A8:
                    return "GL_SAMPLE_BUFFERS";
                case 0x80A9:
                    return "GL_SAMPLES";
                case 0x8B9A:
                    return "GL_IMPLEMENTATION_COLOR_READ_TYPE";
                case 0x8B9B:
                    return "GL_IMPLEMENTATION_COLOR_READ_FORMAT";
                case 0x9310:
                    return "GL_FRAMEBUFFER_DEFAULT_WIDTH";
                case 0x9311:
                    return "GL_FRAMEBUFFER_DEFAULT_HEIGHT";
                case 0x9312:
                    return "GL_FRAMEBUFFER_DEFAULT_LAYERS";
                case 0x9313:
                    return "GL_FRAMEBUFFER_DEFAULT_SAMPLES";
                case 0x9314:
                    return "GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::GetPName:
        {
            switch (value)
            {
                case 0xB21:
                    return "GL_LINE_WIDTH";
                case 0xB44:
                    return "GL_CULL_FACE";
                case 0xB45:
                    return "GL_CULL_FACE_MODE";
                case 0xB46:
                    return "GL_FRONT_FACE";
                case 0xB70:
                    return "GL_DEPTH_RANGE";
                case 0xB71:
                    return "GL_DEPTH_TEST";
                case 0xB72:
                    return "GL_DEPTH_WRITEMASK";
                case 0xB73:
                    return "GL_DEPTH_CLEAR_VALUE";
                case 0xB74:
                    return "GL_DEPTH_FUNC";
                case 0xB90:
                    return "GL_STENCIL_TEST";
                case 0xB91:
                    return "GL_STENCIL_CLEAR_VALUE";
                case 0xB92:
                    return "GL_STENCIL_FUNC";
                case 0xB93:
                    return "GL_STENCIL_VALUE_MASK";
                case 0xB94:
                    return "GL_STENCIL_FAIL";
                case 0xB95:
                    return "GL_STENCIL_PASS_DEPTH_FAIL";
                case 0xB96:
                    return "GL_STENCIL_PASS_DEPTH_PASS";
                case 0xB97:
                    return "GL_STENCIL_REF";
                case 0xB98:
                    return "GL_STENCIL_WRITEMASK";
                case 0xBA2:
                    return "GL_VIEWPORT";
                case 0xBD0:
                    return "GL_DITHER";
                case 0xBE2:
                    return "GL_BLEND";
                case 0xC02:
                    return "GL_READ_BUFFER";
                case 0xC10:
                    return "GL_SCISSOR_BOX";
                case 0xC11:
                    return "GL_SCISSOR_TEST";
                case 0xC22:
                    return "GL_COLOR_CLEAR_VALUE";
                case 0xC23:
                    return "GL_COLOR_WRITEMASK";
                case 0xCF2:
                    return "GL_UNPACK_ROW_LENGTH";
                case 0xCF3:
                    return "GL_UNPACK_SKIP_ROWS";
                case 0xCF4:
                    return "GL_UNPACK_SKIP_PIXELS";
                case 0xCF5:
                    return "GL_UNPACK_ALIGNMENT";
                case 0xD02:
                    return "GL_PACK_ROW_LENGTH";
                case 0xD03:
                    return "GL_PACK_SKIP_ROWS";
                case 0xD04:
                    return "GL_PACK_SKIP_PIXELS";
                case 0xD05:
                    return "GL_PACK_ALIGNMENT";
                case 0xD33:
                    return "GL_MAX_TEXTURE_SIZE";
                case 0xD3A:
                    return "GL_MAX_VIEWPORT_DIMS";
                case 0xD50:
                    return "GL_SUBPIXEL_BITS";
                case 0xD52:
                    return "GL_RED_BITS";
                case 0xD53:
                    return "GL_GREEN_BITS";
                case 0xD54:
                    return "GL_BLUE_BITS";
                case 0xD55:
                    return "GL_ALPHA_BITS";
                case 0xD56:
                    return "GL_DEPTH_BITS";
                case 0xD57:
                    return "GL_STENCIL_BITS";
                case 0xDE1:
                    return "GL_TEXTURE_2D";
                case 0x2A00:
                    return "GL_POLYGON_OFFSET_UNITS";
                case 0x8037:
                    return "GL_POLYGON_OFFSET_FILL";
                case 0x8038:
                    return "GL_POLYGON_OFFSET_FACTOR";
                case 0x8069:
                    return "GL_TEXTURE_BINDING_2D";
                case 0x806A:
                    return "GL_TEXTURE_BINDING_3D";
                case 0x8074:
                    return "GL_VERTEX_ARRAY";
                case 0x846D:
                    return "GL_ALIASED_POINT_SIZE_RANGE";
                case 0x846E:
                    return "GL_ALIASED_LINE_WIDTH_RANGE";
                case 0x9596:
                    return "GL_NUM_DEVICE_UUIDS_EXT";
                case 0x9597:
                    return "GL_DEVICE_UUID_EXT";
                case 0x9598:
                    return "GL_DRIVER_UUID_EXT";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::GetPointervPName:
        {
            switch (value)
            {
                case 0x8244:
                    return "GL_DEBUG_CALLBACK_FUNCTION";
                case 0x8245:
                    return "GL_DEBUG_CALLBACK_USER_PARAM";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::GetTextureParameter:
        {
            switch (value)
            {
                case 0x1000:
                    return "GL_TEXTURE_WIDTH";
                case 0x1001:
                    return "GL_TEXTURE_HEIGHT";
                case 0x1003:
                    return "GL_TEXTURE_INTERNAL_FORMAT";
                case 0x1004:
                    return "GL_TEXTURE_BORDER_COLOR";
                case 0x2800:
                    return "GL_TEXTURE_MAG_FILTER";
                case 0x2801:
                    return "GL_TEXTURE_MIN_FILTER";
                case 0x2802:
                    return "GL_TEXTURE_WRAP_S";
                case 0x2803:
                    return "GL_TEXTURE_WRAP_T";
                case 0x805C:
                    return "GL_TEXTURE_RED_SIZE";
                case 0x805D:
                    return "GL_TEXTURE_GREEN_SIZE";
                case 0x805E:
                    return "GL_TEXTURE_BLUE_SIZE";
                case 0x805F:
                    return "GL_TEXTURE_ALPHA_SIZE";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::GraphicsResetStatus:
        {
            switch (value)
            {
                case 0x8253:
                    return "GL_GUILTY_CONTEXT_RESET";
                case 0x8254:
                    return "GL_INNOCENT_CONTEXT_RESET";
                case 0x8255:
                    return "GL_UNKNOWN_CONTEXT_RESET";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::HintMode:
        {
            switch (value)
            {
                case 0x1100:
                    return "GL_DONT_CARE";
                case 0x1101:
                    return "GL_FASTEST";
                case 0x1102:
                    return "GL_NICEST";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::HintTarget:
        {
            switch (value)
            {
                case 0x8192:
                    return "GL_GENERATE_MIPMAP_HINT";
                case 0x8257:
                    return "GL_PROGRAM_BINARY_RETRIEVABLE_HINT";
                case 0x8B8B:
                    return "GL_FRAGMENT_SHADER_DERIVATIVE_HINT";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::IndexPointerType:
        {
            switch (value)
            {
                case 0x1402:
                    return "GL_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1406:
                    return "GL_FLOAT";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::InternalFormat:
        {
            switch (value)
            {
                case 0x1802:
                    return "GL_STENCIL";
                case 0x1902:
                    return "GL_DEPTH_COMPONENT";
                case 0x1903:
                    return "GL_RED";
                case 0x1906:
                    return "GL_ALPHA";
                case 0x1907:
                    return "GL_RGB";
                case 0x1908:
                    return "GL_RGBA";
                case 0x1909:
                    return "GL_LUMINANCE";
                case 0x190A:
                    return "GL_LUMINANCE_ALPHA";
                case 0x8051:
                    return "GL_RGB8";
                case 0x8052:
                    return "GL_RGB10_EXT";
                case 0x8056:
                    return "GL_RGBA4";
                case 0x8057:
                    return "GL_RGB5_A1";
                case 0x8058:
                    return "GL_RGBA8";
                case 0x8059:
                    return "GL_RGB10_A2";
                case 0x80E1:
                    return "GL_BGRA_EXT";
                case 0x81A5:
                    return "GL_DEPTH_COMPONENT16";
                case 0x81A7:
                    return "GL_DEPTH_COMPONENT32_OES";
                case 0x8227:
                    return "GL_RG";
                case 0x8229:
                    return "GL_R8";
                case 0x822B:
                    return "GL_RG8";
                case 0x822D:
                    return "GL_R16F";
                case 0x822E:
                    return "GL_R32F";
                case 0x822F:
                    return "GL_RG16F";
                case 0x8230:
                    return "GL_RG32F";
                case 0x8231:
                    return "GL_R8I";
                case 0x8232:
                    return "GL_R8UI";
                case 0x8233:
                    return "GL_R16I";
                case 0x8234:
                    return "GL_R16UI";
                case 0x8235:
                    return "GL_R32I";
                case 0x8236:
                    return "GL_R32UI";
                case 0x8237:
                    return "GL_RG8I";
                case 0x8238:
                    return "GL_RG8UI";
                case 0x8239:
                    return "GL_RG16I";
                case 0x823A:
                    return "GL_RG16UI";
                case 0x823B:
                    return "GL_RG32I";
                case 0x823C:
                    return "GL_RG32UI";
                case 0x83F0:
                    return "GL_COMPRESSED_RGB_S3TC_DXT1_EXT";
                case 0x83F1:
                    return "GL_COMPRESSED_RGBA_S3TC_DXT1_EXT";
                case 0x83F2:
                    return "GL_COMPRESSED_RGBA_S3TC_DXT3_EXT";
                case 0x83F3:
                    return "GL_COMPRESSED_RGBA_S3TC_DXT5_EXT";
                case 0x84F9:
                    return "GL_DEPTH_STENCIL";
                case 0x8814:
                    return "GL_RGBA32F";
                case 0x881A:
                    return "GL_RGBA16F";
                case 0x881B:
                    return "GL_RGB16F";
                case 0x88F0:
                    return "GL_DEPTH24_STENCIL8";
                case 0x8C3A:
                    return "GL_R11F_G11F_B10F";
                case 0x8C3D:
                    return "GL_RGB9_E5";
                case 0x8C40:
                    return "GL_SRGB";
                case 0x8C41:
                    return "GL_SRGB8";
                case 0x8C42:
                    return "GL_SRGB_ALPHA_EXT";
                case 0x8C43:
                    return "GL_SRGB8_ALPHA8";
                case 0x8C4C:
                    return "GL_COMPRESSED_SRGB_S3TC_DXT1_EXT";
                case 0x8C4D:
                    return "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT";
                case 0x8C4E:
                    return "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT";
                case 0x8C4F:
                    return "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT";
                case 0x8CAC:
                    return "GL_DEPTH_COMPONENT32F";
                case 0x8CAD:
                    return "GL_DEPTH32F_STENCIL8";
                case 0x8D64:
                    return "GL_ETC1_RGB8_OES";
                case 0x8D70:
                    return "GL_RGBA32UI";
                case 0x8D71:
                    return "GL_RGB32UI";
                case 0x8D76:
                    return "GL_RGBA16UI";
                case 0x8D77:
                    return "GL_RGB16UI";
                case 0x8D7C:
                    return "GL_RGBA8UI";
                case 0x8D7D:
                    return "GL_RGB8UI";
                case 0x8D82:
                    return "GL_RGBA32I";
                case 0x8D83:
                    return "GL_RGB32I";
                case 0x8D88:
                    return "GL_RGBA16I";
                case 0x8D89:
                    return "GL_RGB16I";
                case 0x8D8E:
                    return "GL_RGBA8I";
                case 0x8D8F:
                    return "GL_RGB8I";
                case 0x8DBB:
                    return "GL_COMPRESSED_RED_RGTC1_EXT";
                case 0x8DBC:
                    return "GL_COMPRESSED_SIGNED_RED_RGTC1_EXT";
                case 0x8DBD:
                    return "GL_COMPRESSED_RED_GREEN_RGTC2_EXT";
                case 0x8DBE:
                    return "GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT";
                case 0x8E8C:
                    return "GL_COMPRESSED_RGBA_BPTC_UNORM_EXT";
                case 0x8E8D:
                    return "GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT";
                case 0x8E8E:
                    return "GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT";
                case 0x8E8F:
                    return "GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT";
                case 0x8F94:
                    return "GL_R8_SNORM";
                case 0x8F95:
                    return "GL_RG8_SNORM";
                case 0x8F96:
                    return "GL_RGB8_SNORM";
                case 0x8F97:
                    return "GL_RGBA8_SNORM";
                case 0x906F:
                    return "GL_RGB10_A2UI";
                case 0x9270:
                    return "GL_COMPRESSED_R11_EAC";
                case 0x9271:
                    return "GL_COMPRESSED_SIGNED_R11_EAC";
                case 0x9272:
                    return "GL_COMPRESSED_RG11_EAC";
                case 0x9273:
                    return "GL_COMPRESSED_SIGNED_RG11_EAC";
                case 0x9274:
                    return "GL_COMPRESSED_RGB8_ETC2";
                case 0x9275:
                    return "GL_COMPRESSED_SRGB8_ETC2";
                case 0x9276:
                    return "GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2";
                case 0x9277:
                    return "GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2";
                case 0x9278:
                    return "GL_COMPRESSED_RGBA8_ETC2_EAC";
                case 0x9279:
                    return "GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::InternalFormatPName:
        {
            switch (value)
            {
                case 0x80A9:
                    return "GL_SAMPLES";
                case 0x86A1:
                    return "GL_TEXTURE_COMPRESSED";
                case 0x90C7:
                    return "GL_IMAGE_FORMAT_COMPATIBILITY_TYPE";
                case 0x9380:
                    return "GL_NUM_SAMPLE_COUNTS";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::LightEnvModeSGIX:
        {
            switch (value)
            {
                case 0x1E01:
                    return "GL_REPLACE";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::ListNameType:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1406:
                    return "GL_FLOAT";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::LogicOp:
        {
            switch (value)
            {
                case 0x150A:
                    return "GL_INVERT";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::MapBufferUsageMask:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_MAP_READ_BIT";
                case 0x2:
                    return "GL_MAP_WRITE_BIT";
                case 0x4:
                    return "GL_MAP_INVALIDATE_RANGE_BIT";
                case 0x8:
                    return "GL_MAP_INVALIDATE_BUFFER_BIT";
                case 0x10:
                    return "GL_MAP_FLUSH_EXPLICIT_BIT";
                case 0x20:
                    return "GL_MAP_UNSYNCHRONIZED_BIT";
                case 0x40:
                    return "GL_MAP_PERSISTENT_BIT_EXT";
                case 0x80:
                    return "GL_MAP_COHERENT_BIT_EXT";
                case 0x100:
                    return "GL_DYNAMIC_STORAGE_BIT_EXT";
                case 0x200:
                    return "GL_CLIENT_STORAGE_BIT_EXT";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::MaterialFace:
        {
            switch (value)
            {
                case 0x404:
                    return "GL_FRONT";
                case 0x405:
                    return "GL_BACK";
                case 0x408:
                    return "GL_FRONT_AND_BACK";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::MatrixMode:
        {
            switch (value)
            {
                case 0x1702:
                    return "GL_TEXTURE";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::MemoryBarrierMask:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT";
                case 0x2:
                    return "GL_ELEMENT_ARRAY_BARRIER_BIT";
                case 0x4:
                    return "GL_UNIFORM_BARRIER_BIT";
                case 0x8:
                    return "GL_TEXTURE_FETCH_BARRIER_BIT";
                case 0x20:
                    return "GL_SHADER_IMAGE_ACCESS_BARRIER_BIT";
                case 0x40:
                    return "GL_COMMAND_BARRIER_BIT";
                case 0x80:
                    return "GL_PIXEL_BUFFER_BARRIER_BIT";
                case 0x100:
                    return "GL_TEXTURE_UPDATE_BARRIER_BIT";
                case 0x200:
                    return "GL_BUFFER_UPDATE_BARRIER_BIT";
                case 0x400:
                    return "GL_FRAMEBUFFER_BARRIER_BIT";
                case 0x800:
                    return "GL_TRANSFORM_FEEDBACK_BARRIER_BIT";
                case 0x1000:
                    return "GL_ATOMIC_COUNTER_BARRIER_BIT";
                case 0x2000:
                    return "GL_SHADER_STORAGE_BARRIER_BIT";
                case 0x4000:
                    return "GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT_EXT";
                case 0xFFFFFFFF:
                    return "GL_ALL_BARRIER_BITS";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::MemoryObjectParameterName:
        {
            switch (value)
            {
                case 0x9581:
                    return "GL_DEDICATED_MEMORY_OBJECT_EXT";
                case 0x959B:
                    return "GL_PROTECTED_MEMORY_OBJECT_EXT";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::NormalPointerType:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1406:
                    return "GL_FLOAT";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::ObjectIdentifier:
        {
            switch (value)
            {
                case 0x1702:
                    return "GL_TEXTURE";
                case 0x8074:
                    return "GL_VERTEX_ARRAY";
                case 0x82E0:
                    return "GL_BUFFER";
                case 0x82E1:
                    return "GL_SHADER";
                case 0x82E2:
                    return "GL_PROGRAM";
                case 0x82E3:
                    return "GL_QUERY";
                case 0x82E4:
                    return "GL_PROGRAM_PIPELINE";
                case 0x82E6:
                    return "GL_SAMPLER";
                case 0x8D40:
                    return "GL_FRAMEBUFFER";
                case 0x8D41:
                    return "GL_RENDERBUFFER";
                case 0x8E22:
                    return "GL_TRANSFORM_FEEDBACK";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::PatchParameterName:
        {
            switch (value)
            {
                case 0x8E72:
                    return "GL_PATCH_VERTICES";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::PathFillMode:
        {
            switch (value)
            {
                case 0x150A:
                    return "GL_INVERT";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::PathFontStyle:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::PathGenMode:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::PathTransformType:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::PipelineParameterName:
        {
            switch (value)
            {
                case 0x8259:
                    return "GL_ACTIVE_PROGRAM";
                case 0x8B30:
                    return "GL_FRAGMENT_SHADER";
                case 0x8B31:
                    return "GL_VERTEX_SHADER";
                case 0x8B84:
                    return "GL_INFO_LOG_LENGTH";
                case 0x8DD9:
                    return "GL_GEOMETRY_SHADER";
                case 0x8E87:
                    return "GL_TESS_EVALUATION_SHADER";
                case 0x8E88:
                    return "GL_TESS_CONTROL_SHADER";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::PixelCopyType:
        {
            switch (value)
            {
                case 0x1800:
                    return "GL_COLOR";
                case 0x1801:
                    return "GL_DEPTH";
                case 0x1802:
                    return "GL_STENCIL";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::PixelFormat:
        {
            switch (value)
            {
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1901:
                    return "GL_STENCIL_INDEX";
                case 0x1902:
                    return "GL_DEPTH_COMPONENT";
                case 0x1903:
                    return "GL_RED";
                case 0x1904:
                    return "GL_GREEN";
                case 0x1905:
                    return "GL_BLUE";
                case 0x1906:
                    return "GL_ALPHA";
                case 0x1907:
                    return "GL_RGB";
                case 0x1908:
                    return "GL_RGBA";
                case 0x1909:
                    return "GL_LUMINANCE";
                case 0x190A:
                    return "GL_LUMINANCE_ALPHA";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::PixelStoreParameter:
        {
            switch (value)
            {
                case 0xCF2:
                    return "GL_UNPACK_ROW_LENGTH";
                case 0xCF3:
                    return "GL_UNPACK_SKIP_ROWS";
                case 0xCF4:
                    return "GL_UNPACK_SKIP_PIXELS";
                case 0xCF5:
                    return "GL_UNPACK_ALIGNMENT";
                case 0xD02:
                    return "GL_PACK_ROW_LENGTH";
                case 0xD03:
                    return "GL_PACK_SKIP_ROWS";
                case 0xD04:
                    return "GL_PACK_SKIP_PIXELS";
                case 0xD05:
                    return "GL_PACK_ALIGNMENT";
                case 0x806D:
                    return "GL_UNPACK_SKIP_IMAGES";
                case 0x806E:
                    return "GL_UNPACK_IMAGE_HEIGHT";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::PixelTexGenMode:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_NONE";
                case 0x1907:
                    return "GL_RGB";
                case 0x1908:
                    return "GL_RGBA";
                case 0x1909:
                    return "GL_LUMINANCE";
                case 0x190A:
                    return "GL_LUMINANCE_ALPHA";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::PixelType:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140B:
                    return "GL_HALF_FLOAT";
                case 0x8033:
                    return "GL_UNSIGNED_SHORT_4_4_4_4";
                case 0x8034:
                    return "GL_UNSIGNED_SHORT_5_5_5_1";
                case 0x8365:
                    return "GL_UNSIGNED_SHORT_4_4_4_4_REV_EXT";
                case 0x8366:
                    return "GL_UNSIGNED_SHORT_1_5_5_5_REV_EXT";
                case 0x8368:
                    return "GL_UNSIGNED_INT_2_10_10_10_REV";
                case 0x8C3B:
                    return "GL_UNSIGNED_INT_10F_11F_11F_REV";
                case 0x8D61:
                    return "GL_HALF_FLOAT_OES";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::PrecisionType:
        {
            switch (value)
            {
                case 0x8DF0:
                    return "GL_LOW_FLOAT";
                case 0x8DF1:
                    return "GL_MEDIUM_FLOAT";
                case 0x8DF2:
                    return "GL_HIGH_FLOAT";
                case 0x8DF3:
                    return "GL_LOW_INT";
                case 0x8DF4:
                    return "GL_MEDIUM_INT";
                case 0x8DF5:
                    return "GL_HIGH_INT";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::PrimitiveType:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_POINTS";
                case 0x1:
                    return "GL_LINES";
                case 0x2:
                    return "GL_LINE_LOOP";
                case 0x3:
                    return "GL_LINE_STRIP";
                case 0x4:
                    return "GL_TRIANGLES";
                case 0x5:
                    return "GL_TRIANGLE_STRIP";
                case 0x6:
                    return "GL_TRIANGLE_FAN";
                case 0x7:
                    return "GL_QUADS";
                case 0xA:
                    return "GL_LINES_ADJACENCY";
                case 0xB:
                    return "GL_LINE_STRIP_ADJACENCY";
                case 0xC:
                    return "GL_TRIANGLES_ADJACENCY";
                case 0xD:
                    return "GL_TRIANGLE_STRIP_ADJACENCY";
                case 0xE:
                    return "GL_PATCHES";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::ProgramInterface:
        {
            switch (value)
            {
                case 0x8C8E:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER";
                case 0x92E1:
                    return "GL_UNIFORM";
                case 0x92E2:
                    return "GL_UNIFORM_BLOCK";
                case 0x92E3:
                    return "GL_PROGRAM_INPUT";
                case 0x92E4:
                    return "GL_PROGRAM_OUTPUT";
                case 0x92E5:
                    return "GL_BUFFER_VARIABLE";
                case 0x92E6:
                    return "GL_SHADER_STORAGE_BLOCK";
                case 0x92F4:
                    return "GL_TRANSFORM_FEEDBACK_VARYING";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::ProgramInterfacePName:
        {
            switch (value)
            {
                case 0x92F5:
                    return "GL_ACTIVE_RESOURCES";
                case 0x92F6:
                    return "GL_MAX_NAME_LENGTH";
                case 0x92F7:
                    return "GL_MAX_NUM_ACTIVE_VARIABLES";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::ProgramParameterPName:
        {
            switch (value)
            {
                case 0x8257:
                    return "GL_PROGRAM_BINARY_RETRIEVABLE_HINT";
                case 0x8258:
                    return "GL_PROGRAM_SEPARABLE";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::ProgramPropertyARB:
        {
            switch (value)
            {
                case 0x8267:
                    return "GL_COMPUTE_WORK_GROUP_SIZE";
                case 0x8741:
                    return "GL_PROGRAM_BINARY_LENGTH";
                case 0x8916:
                    return "GL_GEOMETRY_VERTICES_OUT";
                case 0x8917:
                    return "GL_GEOMETRY_INPUT_TYPE";
                case 0x8918:
                    return "GL_GEOMETRY_OUTPUT_TYPE";
                case 0x8A35:
                    return "GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH";
                case 0x8A36:
                    return "GL_ACTIVE_UNIFORM_BLOCKS";
                case 0x8B80:
                    return "GL_DELETE_STATUS";
                case 0x8B82:
                    return "GL_LINK_STATUS";
                case 0x8B83:
                    return "GL_VALIDATE_STATUS";
                case 0x8B84:
                    return "GL_INFO_LOG_LENGTH";
                case 0x8B85:
                    return "GL_ATTACHED_SHADERS";
                case 0x8B86:
                    return "GL_ACTIVE_UNIFORMS";
                case 0x8B87:
                    return "GL_ACTIVE_UNIFORM_MAX_LENGTH";
                case 0x8B89:
                    return "GL_ACTIVE_ATTRIBUTES";
                case 0x8B8A:
                    return "GL_ACTIVE_ATTRIBUTE_MAX_LENGTH";
                case 0x8C76:
                    return "GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH";
                case 0x8C7F:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_MODE";
                case 0x8C83:
                    return "GL_TRANSFORM_FEEDBACK_VARYINGS";
                case 0x92D9:
                    return "GL_ACTIVE_ATOMIC_COUNTER_BUFFERS";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::QueryObjectParameterName:
        {
            switch (value)
            {
                case 0x8866:
                    return "GL_QUERY_RESULT";
                case 0x8867:
                    return "GL_QUERY_RESULT_AVAILABLE";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::QueryParameterName:
        {
            switch (value)
            {
                case 0x8865:
                    return "GL_CURRENT_QUERY";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::QueryTarget:
        {
            switch (value)
            {
                case 0x8C2F:
                    return "GL_ANY_SAMPLES_PASSED";
                case 0x8C87:
                    return "GL_PRIMITIVES_GENERATED";
                case 0x8C88:
                    return "GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN";
                case 0x8D6A:
                    return "GL_ANY_SAMPLES_PASSED_CONSERVATIVE";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::ReadBufferMode:
        {
            switch (value)
            {
                case 0x404:
                    return "GL_FRONT";
                case 0x405:
                    return "GL_BACK";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::RenderbufferParameterName:
        {
            switch (value)
            {
                case 0x8CAB:
                    return "GL_RENDERBUFFER_SAMPLES";
                case 0x8D42:
                    return "GL_RENDERBUFFER_WIDTH";
                case 0x8D43:
                    return "GL_RENDERBUFFER_HEIGHT";
                case 0x8D44:
                    return "GL_RENDERBUFFER_INTERNAL_FORMAT";
                case 0x8D50:
                    return "GL_RENDERBUFFER_RED_SIZE";
                case 0x8D51:
                    return "GL_RENDERBUFFER_GREEN_SIZE";
                case 0x8D52:
                    return "GL_RENDERBUFFER_BLUE_SIZE";
                case 0x8D53:
                    return "GL_RENDERBUFFER_ALPHA_SIZE";
                case 0x8D54:
                    return "GL_RENDERBUFFER_DEPTH_SIZE";
                case 0x8D55:
                    return "GL_RENDERBUFFER_STENCIL_SIZE";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::RenderbufferTarget:
        {
            switch (value)
            {
                case 0x8D41:
                    return "GL_RENDERBUFFER";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::SamplerParameterName:
        {
            switch (value)
            {
                case 0x1004:
                    return "GL_TEXTURE_BORDER_COLOR";
                case 0x2800:
                    return "GL_TEXTURE_MAG_FILTER";
                case 0x2801:
                    return "GL_TEXTURE_MIN_FILTER";
                case 0x2802:
                    return "GL_TEXTURE_WRAP_S";
                case 0x2803:
                    return "GL_TEXTURE_WRAP_T";
                case 0x8072:
                    return "GL_TEXTURE_WRAP_R";
                case 0x813A:
                    return "GL_TEXTURE_MIN_LOD";
                case 0x813B:
                    return "GL_TEXTURE_MAX_LOD";
                case 0x884C:
                    return "GL_TEXTURE_COMPARE_MODE";
                case 0x884D:
                    return "GL_TEXTURE_COMPARE_FUNC";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::ShaderParameterName:
        {
            switch (value)
            {
                case 0x8B4F:
                    return "GL_SHADER_TYPE";
                case 0x8B80:
                    return "GL_DELETE_STATUS";
                case 0x8B81:
                    return "GL_COMPILE_STATUS";
                case 0x8B84:
                    return "GL_INFO_LOG_LENGTH";
                case 0x8B88:
                    return "GL_SHADER_SOURCE_LENGTH";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::ShaderType:
        {
            switch (value)
            {
                case 0x8B30:
                    return "GL_FRAGMENT_SHADER";
                case 0x8B31:
                    return "GL_VERTEX_SHADER";
                case 0x8DD9:
                    return "GL_GEOMETRY_SHADER";
                case 0x8E87:
                    return "GL_TESS_EVALUATION_SHADER";
                case 0x8E88:
                    return "GL_TESS_CONTROL_SHADER";
                case 0x91B9:
                    return "GL_COMPUTE_SHADER";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::StencilFaceDirection:
        {
            switch (value)
            {
                case 0x404:
                    return "GL_FRONT";
                case 0x405:
                    return "GL_BACK";
                case 0x408:
                    return "GL_FRONT_AND_BACK";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::StencilFunction:
        {
            switch (value)
            {
                case 0x200:
                    return "GL_NEVER";
                case 0x201:
                    return "GL_LESS";
                case 0x202:
                    return "GL_EQUAL";
                case 0x203:
                    return "GL_LEQUAL";
                case 0x204:
                    return "GL_GREATER";
                case 0x205:
                    return "GL_NOTEQUAL";
                case 0x206:
                    return "GL_GEQUAL";
                case 0x207:
                    return "GL_ALWAYS";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::StencilOp:
        {
            switch (value)
            {
                case 0x0:
                    return "GL_ZERO";
                case 0x150A:
                    return "GL_INVERT";
                case 0x1E00:
                    return "GL_KEEP";
                case 0x1E01:
                    return "GL_REPLACE";
                case 0x1E02:
                    return "GL_INCR";
                case 0x1E03:
                    return "GL_DECR";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::StringName:
        {
            switch (value)
            {
                case 0x1F00:
                    return "GL_VENDOR";
                case 0x1F01:
                    return "GL_RENDERER";
                case 0x1F02:
                    return "GL_VERSION";
                case 0x1F03:
                    return "GL_EXTENSIONS";
                case 0x8B8C:
                    return "GL_SHADING_LANGUAGE_VERSION";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::SubroutineParameterName:
        {
            switch (value)
            {
                case 0x8A38:
                    return "GL_UNIFORM_SIZE";
                case 0x8A39:
                    return "GL_UNIFORM_NAME_LENGTH";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::SyncCondition:
        {
            switch (value)
            {
                case 0x9117:
                    return "GL_SYNC_GPU_COMMANDS_COMPLETE";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::SyncObjectMask:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_SYNC_FLUSH_COMMANDS_BIT";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::SyncParameterName:
        {
            switch (value)
            {
                case 0x9112:
                    return "GL_OBJECT_TYPE";
                case 0x9113:
                    return "GL_SYNC_CONDITION";
                case 0x9114:
                    return "GL_SYNC_STATUS";
                case 0x9115:
                    return "GL_SYNC_FLAGS";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::SyncStatus:
        {
            switch (value)
            {
                case 0x911A:
                    return "GL_ALREADY_SIGNALED";
                case 0x911B:
                    return "GL_TIMEOUT_EXPIRED";
                case 0x911C:
                    return "GL_CONDITION_SATISFIED";
                case 0x911D:
                    return "GL_WAIT_FAILED";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::TexCoordPointerType:
        {
            switch (value)
            {
                case 0x1402:
                    return "GL_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1406:
                    return "GL_FLOAT";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::TextureEnvMode:
        {
            switch (value)
            {
                case 0xBE2:
                    return "GL_BLEND";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::TextureLayout:
        {
            switch (value)
            {
                case 0x9530:
                    return "GL_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_EXT";
                case 0x9531:
                    return "GL_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_EXT";
                case 0x958D:
                    return "GL_LAYOUT_GENERAL_EXT";
                case 0x958E:
                    return "GL_LAYOUT_COLOR_ATTACHMENT_EXT";
                case 0x958F:
                    return "GL_LAYOUT_DEPTH_STENCIL_ATTACHMENT_EXT";
                case 0x9590:
                    return "GL_LAYOUT_DEPTH_STENCIL_READ_ONLY_EXT";
                case 0x9591:
                    return "GL_LAYOUT_SHADER_READ_ONLY_EXT";
                case 0x9592:
                    return "GL_LAYOUT_TRANSFER_SRC_EXT";
                case 0x9593:
                    return "GL_LAYOUT_TRANSFER_DST_EXT";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::TextureMagFilter:
        {
            switch (value)
            {
                case 0x2600:
                    return "GL_NEAREST";
                case 0x2601:
                    return "GL_LINEAR";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::TextureMinFilter:
        {
            switch (value)
            {
                case 0x2600:
                    return "GL_NEAREST";
                case 0x2601:
                    return "GL_LINEAR";
                case 0x2700:
                    return "GL_NEAREST_MIPMAP_NEAREST";
                case 0x2701:
                    return "GL_LINEAR_MIPMAP_NEAREST";
                case 0x2702:
                    return "GL_NEAREST_MIPMAP_LINEAR";
                case 0x2703:
                    return "GL_LINEAR_MIPMAP_LINEAR";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::TextureParameterName:
        {
            switch (value)
            {
                case 0x1000:
                    return "GL_TEXTURE_WIDTH";
                case 0x1001:
                    return "GL_TEXTURE_HEIGHT";
                case 0x1003:
                    return "GL_TEXTURE_INTERNAL_FORMAT";
                case 0x1004:
                    return "GL_TEXTURE_BORDER_COLOR";
                case 0x2800:
                    return "GL_TEXTURE_MAG_FILTER";
                case 0x2801:
                    return "GL_TEXTURE_MIN_FILTER";
                case 0x2802:
                    return "GL_TEXTURE_WRAP_S";
                case 0x2803:
                    return "GL_TEXTURE_WRAP_T";
                case 0x805C:
                    return "GL_TEXTURE_RED_SIZE";
                case 0x805D:
                    return "GL_TEXTURE_GREEN_SIZE";
                case 0x805E:
                    return "GL_TEXTURE_BLUE_SIZE";
                case 0x805F:
                    return "GL_TEXTURE_ALPHA_SIZE";
                case 0x8072:
                    return "GL_TEXTURE_WRAP_R";
                case 0x813A:
                    return "GL_TEXTURE_MIN_LOD";
                case 0x813B:
                    return "GL_TEXTURE_MAX_LOD";
                case 0x813C:
                    return "GL_TEXTURE_BASE_LEVEL";
                case 0x813D:
                    return "GL_TEXTURE_MAX_LEVEL";
                case 0x884C:
                    return "GL_TEXTURE_COMPARE_MODE";
                case 0x884D:
                    return "GL_TEXTURE_COMPARE_FUNC";
                case 0x8E42:
                    return "GL_TEXTURE_SWIZZLE_R";
                case 0x8E43:
                    return "GL_TEXTURE_SWIZZLE_G";
                case 0x8E44:
                    return "GL_TEXTURE_SWIZZLE_B";
                case 0x8E45:
                    return "GL_TEXTURE_SWIZZLE_A";
                case 0x90EA:
                    return "GL_DEPTH_STENCIL_TEXTURE_MODE";
                case 0x9580:
                    return "GL_TEXTURE_TILING_EXT";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::TextureTarget:
        {
            switch (value)
            {
                case 0xDE1:
                    return "GL_TEXTURE_2D";
                case 0x806F:
                    return "GL_TEXTURE_3D";
                case 0x8513:
                    return "GL_TEXTURE_CUBE_MAP";
                case 0x8515:
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_X";
                case 0x8516:
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_X";
                case 0x8517:
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_Y";
                case 0x8518:
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_Y";
                case 0x8519:
                    return "GL_TEXTURE_CUBE_MAP_POSITIVE_Z";
                case 0x851A:
                    return "GL_TEXTURE_CUBE_MAP_NEGATIVE_Z";
                case 0x8C1A:
                    return "GL_TEXTURE_2D_ARRAY";
                case 0x9009:
                    return "GL_TEXTURE_CUBE_MAP_ARRAY";
                case 0x9100:
                    return "GL_TEXTURE_2D_MULTISAMPLE";
                case 0x9102:
                    return "GL_TEXTURE_2D_MULTISAMPLE_ARRAY";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::TextureUnit:
        {
            switch (value)
            {
                case 0x84C0:
                    return "GL_TEXTURE0";
                case 0x84C1:
                    return "GL_TEXTURE1";
                case 0x84C2:
                    return "GL_TEXTURE2";
                case 0x84C3:
                    return "GL_TEXTURE3";
                case 0x84C4:
                    return "GL_TEXTURE4";
                case 0x84C5:
                    return "GL_TEXTURE5";
                case 0x84C6:
                    return "GL_TEXTURE6";
                case 0x84C7:
                    return "GL_TEXTURE7";
                case 0x84C8:
                    return "GL_TEXTURE8";
                case 0x84C9:
                    return "GL_TEXTURE9";
                case 0x84CA:
                    return "GL_TEXTURE10";
                case 0x84CB:
                    return "GL_TEXTURE11";
                case 0x84CC:
                    return "GL_TEXTURE12";
                case 0x84CD:
                    return "GL_TEXTURE13";
                case 0x84CE:
                    return "GL_TEXTURE14";
                case 0x84CF:
                    return "GL_TEXTURE15";
                case 0x84D0:
                    return "GL_TEXTURE16";
                case 0x84D1:
                    return "GL_TEXTURE17";
                case 0x84D2:
                    return "GL_TEXTURE18";
                case 0x84D3:
                    return "GL_TEXTURE19";
                case 0x84D4:
                    return "GL_TEXTURE20";
                case 0x84D5:
                    return "GL_TEXTURE21";
                case 0x84D6:
                    return "GL_TEXTURE22";
                case 0x84D7:
                    return "GL_TEXTURE23";
                case 0x84D8:
                    return "GL_TEXTURE24";
                case 0x84D9:
                    return "GL_TEXTURE25";
                case 0x84DA:
                    return "GL_TEXTURE26";
                case 0x84DB:
                    return "GL_TEXTURE27";
                case 0x84DC:
                    return "GL_TEXTURE28";
                case 0x84DD:
                    return "GL_TEXTURE29";
                case 0x84DE:
                    return "GL_TEXTURE30";
                case 0x84DF:
                    return "GL_TEXTURE31";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::TextureWrapMode:
        {
            switch (value)
            {
                case 0x2901:
                    return "GL_REPEAT";
                case 0x812D:
                    return "GL_CLAMP_TO_BORDER";
                case 0x812F:
                    return "GL_CLAMP_TO_EDGE";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::TransformFeedbackPName:
        {
            switch (value)
            {
                case 0x8C84:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_START";
                case 0x8C85:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_SIZE";
                case 0x8C8F:
                    return "GL_TRANSFORM_FEEDBACK_BUFFER_BINDING";
                case 0x8E23:
                    return "GL_TRANSFORM_FEEDBACK_PAUSED";
                case 0x8E24:
                    return "GL_TRANSFORM_FEEDBACK_ACTIVE";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::UniformBlockPName:
        {
            switch (value)
            {
                case 0x8A3F:
                    return "GL_UNIFORM_BLOCK_BINDING";
                case 0x8A40:
                    return "GL_UNIFORM_BLOCK_DATA_SIZE";
                case 0x8A41:
                    return "GL_UNIFORM_BLOCK_NAME_LENGTH";
                case 0x8A42:
                    return "GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS";
                case 0x8A43:
                    return "GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES";
                case 0x8A44:
                    return "GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER";
                case 0x8A46:
                    return "GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::UniformPName:
        {
            switch (value)
            {
                case 0x8A37:
                    return "GL_UNIFORM_TYPE";
                case 0x8A38:
                    return "GL_UNIFORM_SIZE";
                case 0x8A39:
                    return "GL_UNIFORM_NAME_LENGTH";
                case 0x8A3A:
                    return "GL_UNIFORM_BLOCK_INDEX";
                case 0x8A3B:
                    return "GL_UNIFORM_OFFSET";
                case 0x8A3C:
                    return "GL_UNIFORM_ARRAY_STRIDE";
                case 0x8A3D:
                    return "GL_UNIFORM_MATRIX_STRIDE";
                case 0x8A3E:
                    return "GL_UNIFORM_IS_ROW_MAJOR";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::UseProgramStageMask:
        {
            switch (value)
            {
                case 0x1:
                    return "GL_VERTEX_SHADER_BIT";
                case 0x2:
                    return "GL_FRAGMENT_SHADER_BIT";
                case 0x4:
                    return "GL_GEOMETRY_SHADER_BIT";
                case 0x8:
                    return "GL_TESS_CONTROL_SHADER_BIT";
                case 0x10:
                    return "GL_TESS_EVALUATION_SHADER_BIT";
                case 0x20:
                    return "GL_COMPUTE_SHADER_BIT";
                case 0xFFFFFFFF:
                    return "GL_ALL_SHADER_BITS";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::VertexArrayPName:
        {
            switch (value)
            {
                case 0x82D5:
                    return "GL_VERTEX_ATTRIB_RELATIVE_OFFSET";
                case 0x8622:
                    return "GL_VERTEX_ATTRIB_ARRAY_ENABLED";
                case 0x8623:
                    return "GL_VERTEX_ATTRIB_ARRAY_SIZE";
                case 0x8624:
                    return "GL_VERTEX_ATTRIB_ARRAY_STRIDE";
                case 0x8625:
                    return "GL_VERTEX_ATTRIB_ARRAY_TYPE";
                case 0x886A:
                    return "GL_VERTEX_ATTRIB_ARRAY_NORMALIZED";
                case 0x88FD:
                    return "GL_VERTEX_ATTRIB_ARRAY_INTEGER";
                case 0x88FE:
                    return "GL_VERTEX_ATTRIB_ARRAY_DIVISOR";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::VertexAttribEnum:
        {
            switch (value)
            {
                case 0x8622:
                    return "GL_VERTEX_ATTRIB_ARRAY_ENABLED";
                case 0x8623:
                    return "GL_VERTEX_ATTRIB_ARRAY_SIZE";
                case 0x8624:
                    return "GL_VERTEX_ATTRIB_ARRAY_STRIDE";
                case 0x8625:
                    return "GL_VERTEX_ATTRIB_ARRAY_TYPE";
                case 0x8626:
                    return "GL_CURRENT_VERTEX_ATTRIB";
                case 0x886A:
                    return "GL_VERTEX_ATTRIB_ARRAY_NORMALIZED";
                case 0x889F:
                    return "GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING";
                case 0x88FD:
                    return "GL_VERTEX_ATTRIB_ARRAY_INTEGER";
                case 0x88FE:
                    return "GL_VERTEX_ATTRIB_ARRAY_DIVISOR";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::VertexAttribPointerType:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140B:
                    return "GL_HALF_FLOAT";
                case 0x140C:
                    return "GL_FIXED";
                case 0x8368:
                    return "GL_UNSIGNED_INT_2_10_10_10_REV";
                case 0x8C3B:
                    return "GL_UNSIGNED_INT_10F_11F_11F_REV";
                case 0x8D9F:
                    return "GL_INT_2_10_10_10_REV";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::VertexAttribType:
        {
            switch (value)
            {
                case 0x1400:
                    return "GL_BYTE";
                case 0x1401:
                    return "GL_UNSIGNED_BYTE";
                case 0x1402:
                    return "GL_SHORT";
                case 0x1403:
                    return "GL_UNSIGNED_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1405:
                    return "GL_UNSIGNED_INT";
                case 0x1406:
                    return "GL_FLOAT";
                case 0x140B:
                    return "GL_HALF_FLOAT";
                case 0x140C:
                    return "GL_FIXED";
                case 0x8368:
                    return "GL_UNSIGNED_INT_2_10_10_10_REV";
                case 0x8C3B:
                    return "GL_UNSIGNED_INT_10F_11F_11F_REV";
                case 0x8D9F:
                    return "GL_INT_2_10_10_10_REV";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::VertexBufferObjectParameter:
        {
            switch (value)
            {
                case 0x8764:
                    return "GL_BUFFER_SIZE";
                case 0x8765:
                    return "GL_BUFFER_USAGE";
                case 0x88BC:
                    return "GL_BUFFER_MAPPED";
                case 0x911F:
                    return "GL_BUFFER_ACCESS_FLAGS";
                case 0x9120:
                    return "GL_BUFFER_MAP_LENGTH";
                case 0x9121:
                    return "GL_BUFFER_MAP_OFFSET";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::VertexBufferObjectUsage:
        {
            switch (value)
            {
                case 0x88E0:
                    return "GL_STREAM_DRAW";
                case 0x88E1:
                    return "GL_STREAM_READ";
                case 0x88E2:
                    return "GL_STREAM_COPY";
                case 0x88E4:
                    return "GL_STATIC_DRAW";
                case 0x88E5:
                    return "GL_STATIC_READ";
                case 0x88E6:
                    return "GL_STATIC_COPY";
                case 0x88E8:
                    return "GL_DYNAMIC_DRAW";
                case 0x88E9:
                    return "GL_DYNAMIC_READ";
                case 0x88EA:
                    return "GL_DYNAMIC_COPY";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::VertexPointerType:
        {
            switch (value)
            {
                case 0x1402:
                    return "GL_SHORT";
                case 0x1404:
                    return "GL_INT";
                case 0x1406:
                    return "GL_FLOAT";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        case GLenumGroup::VertexProvokingMode:
        {
            switch (value)
            {
                case 0x8E4D:
                    return "GL_FIRST_VERTEX_CONVENTION";
                case 0x8E4E:
                    return "GL_LAST_VERTEX_CONVENTION";
                default:
                    return UnknownGLenumToString(value);
            }
        }

        default:
            return UnknownGLenumToString(value);
    }
}
}  // namespace gl
