#ifndef TC_PRIVATE_H
#define TC_PRIVATE_H

#include <stdint.h>
#include <stddef.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef uint32_t TC_RC;

typedef struct __OPAQUE_HANDLE_DATA_  HANDLE_DATA;

enum API_TYPE {
	API_NULL,
	API_START,
	API_END,
	API_CREATEPRIMARY,
	API_CREATE,
	API_LOAD,
	API_EVICTCONTROL,
	API_ENCRYPT,
	API_DECRYPT,
	API_HASH,
	API_SIGN,
	API_VERIFYSIGNATURE,
	API_NVDEFINE,
	API_NVRELEASE,
	API_NVREAD,
	API_NVWRITE,
	API_MAX,
};

typedef struct api_ctx_st {
	// 根据具体的API接口传参做转换，这里设置未非透明体
	HANDLE_DATA *data;
	enum API_TYPE cmd_code;
	TC_RC (*init)(struct api_ctx_st *api_ctx, int num, ...);
	// 负责释放api_ctx内动态分配的内存
 	TC_RC (*release)(struct api_ctx_st *api_ctx);
} API_CTX;

typedef struct _engine_ops_st {
	TC_RC (*start)(API_CTX *ctx);
	TC_RC (*end)(API_CTX *ctx);
	TC_RC (*createprimary)(API_CTX *ctx);
	TC_RC (*create)(API_CTX *ctx);
	TC_RC (*load)(API_CTX *ctx);
	TC_RC (*evictcontrol)(API_CTX *ctx);
	TC_RC (*encrypt)(API_CTX *ctx);
	TC_RC (*decrypt)(API_CTX *ctx);
	TC_RC (*hash)(API_CTX *ctx);
	TC_RC (*sign)(API_CTX *ctx);
	TC_RC (*verifysignature)(API_CTX *ctx);
	TC_RC (*nvdefine)(API_CTX *ctx);
	TC_RC (*nvrelease)(API_CTX *ctx);
	TC_RC (*nvread)(API_CTX *ctx);
	TC_RC (*nvwrite)(API_CTX *ctx);
} ENGINE_OPS;

typedef struct engine_ctx_st {
	API_CTX *api_ctx;
	TC_RC (*alloc_api_ctx)(enum API_TYPE cmd_code);
	// 负责释放本次命令执行过程中分配的所有资源
	TC_RC (*release)();
	ENGINE_OPS* ops;
} ENGINE_CTX;

/* TPM2 Engine */
extern ENGINE_CTX engine_ctx_tpm2;

typedef struct engine_ctx_table {
	const char* engine_name;
	ENGINE_CTX* engine_ctx;
} ENGINE_CTX_TABLE;

static ENGINE_CTX_TABLE engine_ctx_table[] = {
	{"/dev/tpm", &engine_ctx_tpm2},
};

#ifdef __cplusplus
}
#endif

#endif /* TC_PRIVATE_H */