#ifndef TC_TYPE_H
#define TC_TYPE_H

#include <stdint.h>
#include <stdbool.h>
#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef uint32_t TC_RC;

// 可信设备服务句柄，用来区分 TPM、TCM 等可信设备的差异；
// 同时用来实现资源的隔离，实现并行计算。
typedef void* TC_HANDLE;

// 二进制数据类型
typedef struct{
    // 数据内容
    uint8_t         *buffer;
    // 数据长度
    uint32_t         size;
} TC_BUFFER;

// 可信算法类型，数值要保持固定
typedef enum tc_alg_en {
    TC_NULL       = 0,
    TC_RSA,
    TC_SYMMETRIC,
    TC_SM2,
    TC_SHA1,
    TC_SHA256,
    TC_SM3,
    TC_SM4,
    TC_MAX
} TC_ALG;

#define NV_DEFAULT_BUFFER_SIZE 512

// Hierarchy 句柄
#define TC_TPM2_RH_OWNER       0x40000001
#define TC_TPM2_RH_ENDORSEMENT 0x4000000B
#define TC_TPM2_RH_PLATFORM    0x4000000C
#define TC_TPM2_RH_NULL        0x40000007

#ifdef __cplusplus
}
#endif

#endif /* TC_TYPE_H */