///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include <boost/numeric/ublas/matrix.hpp>
#include <boost/numeric/ublas/vector.hpp>
#include <boost/numeric/ublas/vector_proxy.hpp>
using namespace boost::numeric::ublas;

#include <iostream>
#include <string>
using std::cout;
using std::cerr;
using std::endl;
using std::string;

template <class T>
void f (T v, string name)
{
	for (size_t i = 0; i < 2; i++)
            cout << name << "(" << i << ") = " << v(i) << endl;
}
int main()
{
	matrix<double> a (2,2);
	a(0,0) = 1;
	a(0,1) = 2;
	a(1,0) = 3;
	a(1,1) = 4;
	vector<double> u;
	u.resize(4);
	u(0) = 1;
	u(1) = 2;
	u(2) = 3;
	u(3) = 4;

	// read access using matvec product
#ifndef OK
	vector_range<vector<double> > u1 (u, range(0, 2));
#else
	vector_range<vector<double> > u1;
	u1 = u [range(0, 2)];
#endif
	vector_range<vector<double> > u2 (u, range(2, 4));
	f(prod(a,u1), "v1");
	f(prod(a,u2), "v2");

	// check write access: range array refers to main array
	u2(1) = 7;
	if (u(3) != 7) {
	    cerr << "range failed" << endl;
	    exit (1);
	}
}
