// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Convert_SphereToBSplineSurface_HeaderFile
#define _Convert_SphereToBSplineSurface_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Convert_ElementarySurfaceToBSplineSurface.hxx>
#include <Standard_Real.hxx>
#include <Standard_Boolean.hxx>
class Standard_DomainError;
class gp_Sphere;



//! This algorithm converts a bounded Sphere into a rational
//! B-spline surface. The sphere is a Sphere from package gp.
//! The parametrization of the sphere is
//! P (U, V) = Loc  + Radius * Sin(V) * Zdir +
//! Radius * Cos(V) * (Cos(U)*Xdir + Sin(U)*Ydir)
//! where Loc is the center of the sphere Xdir, Ydir and Zdir are the
//! normalized directions of the local cartesian coordinate system of
//! the sphere. The parametrization range is U [0, 2PI] and
//! V [-PI/2, PI/2].
//! KeyWords :
//! Convert, Sphere, BSplineSurface.
class Convert_SphereToBSplineSurface  : public Convert_ElementarySurfaceToBSplineSurface
{
public:

  DEFINE_STANDARD_ALLOC

  

  //! The equivalent B-spline surface as the same orientation as the
  //! sphere in the U and V parametric directions.
  //!
  //! Raised if U1 = U2 or U1 = U2 + 2.0 * Pi
  //! Raised if V1 = V2.
  Standard_EXPORT Convert_SphereToBSplineSurface(const gp_Sphere& Sph, const Standard_Real U1, const Standard_Real U2, const Standard_Real V1, const Standard_Real V2);
  

  //! The equivalent B-spline surface as the same orientation
  //! as the sphere in the U and V parametric directions.
  //!
  //! Raised if UTrim = True and Param1 = Param2 or
  //! Param1 = Param2 + 2.0 * Pi
  //! Raised if UTrim = False and Param1 = Param2
  Standard_EXPORT Convert_SphereToBSplineSurface(const gp_Sphere& Sph, const Standard_Real Param1, const Standard_Real Param2, const Standard_Boolean UTrim = Standard_True);
  

  //! The equivalent B-spline surface as the same orientation
  //! as the sphere in the U and V parametric directions.
  Standard_EXPORT Convert_SphereToBSplineSurface(const gp_Sphere& Sph);




protected:





private:





};







#endif // _Convert_SphereToBSplineSurface_HeaderFile
