/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef FolderDatabase_H
#define FolderDatabase_H

#include <map>
#include <string>
#include <vector>

using namespace std;

class FolderDatabase
{
public:
	static string path(const string&);
	
protected:	
	FolderDatabase();
	
	void read();
	void write();
	string find(const string&);
	string add(const string&);
	string uniquePath();
        virtual bool isOwner(const string&)=0;

	string homePath_;
	string rootPath_;
	string dbPath_;
	string dbFile_;
	map<string,string> folders_;
	
	static vector<FolderDatabase*> db_;
};	

class InternalFolderDatabase : public FolderDatabase
{
public:
    	InternalFolderDatabase();  
	bool isOwner(const string&);
};

class ExternalFolderDatabase : public FolderDatabase
{
public:
    	ExternalFolderDatabase();  
	bool isOwner(const string&);
};


#endif
